/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.BigIntegerAccessor;
import java.math.BigInteger;

public class BinaryAsBigIntegerField
implements BigIntegerAccessor {
    private int offset;
    private int length;
    private boolean signed;
    private int scale;
    private BigInteger scaleFactor = null;

    public BinaryAsBigIntegerField(int offset, int length, boolean signed) {
        this(offset, length, 0, signed);
    }

    public BinaryAsBigIntegerField(int offset, int length, int scale, boolean signed) {
        this.offset = offset;
        this.length = length;
        this.signed = signed;
        this.scale = scale;
        if (scale > 0) {
            throw new IllegalArgumentException("scale must be <= 0");
        }
        if (scale < 0) {
            this.scaleFactor = BigInteger.valueOf(10L).pow(-scale);
        }
    }

    @Override
    public int getByteLength() {
        return this.length;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public BigInteger getBigInteger(byte[] buffer, int bufOffset) {
        byte[] bytes = new byte[this.length];
        System.arraycopy(buffer, this.offset + bufOffset, bytes, 0, this.length);
        BigInteger answer = this.signed ? new BigInteger(bytes) : new BigInteger(1, bytes);
        if (this.scaleFactor != null) {
            return answer.multiply(this.scaleFactor);
        }
        return answer;
    }

    @Override
    public BigInteger getBigInteger(byte[] buffer) {
        return this.getBigInteger(buffer, 0);
    }

    @Override
    public void putBigInteger(BigInteger value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int i;
        byte signExtension;
        if (this.scaleFactor != null) {
            value = value.divide(this.scaleFactor);
        }
        byte signum = (byte)value.signum();
        if (!this.signed && signum < 0) {
            throw new IllegalArgumentException("" + value);
        }
        byte[] bytes = value.toByteArray();
        int blen = bytes.length;
        int boff = 0;
        if (this.signed && blen > this.length) {
            throw new IllegalArgumentException("" + value);
        }
        if (!this.signed) {
            if (blen > this.length + 1) {
                throw new IllegalArgumentException("" + value);
            }
            if (blen == this.length + 1) {
                if (bytes[0] == 0) {
                    boff = 1;
                    --blen;
                } else {
                    throw new IllegalArgumentException("" + value);
                }
            }
        }
        if ((signExtension = signum) > 0) {
            signExtension = 0;
        }
        int j = i + this.length - blen;
        for (i = this.offset + bufOffset; i < j; ++i) {
            buffer[i] = signExtension;
        }
        System.arraycopy(bytes, boff, buffer, j, blen);
    }

    @Override
    public void putBigInteger(BigInteger value, byte[] buffer) throws IllegalArgumentException {
        this.putBigInteger(value, buffer, 0);
    }

    public boolean equals(BigInteger a, BigInteger b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public int getLength() {
        return this.length;
    }

    public boolean isSigned() {
        return this.signed;
    }
}

