/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.ErrnoException;
import com.ibm.jzos.JzosPermission;
import com.ibm.jzos.Messages;
import com.ibm.jzos.RcException;
import com.ibm.jzos.TranscodingPrintStream;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.os390.security.PlatformThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.time.Instant;
import java.util.Properties;

public class ZUtil {
    public static final int LOG_ERR = 0;
    public static final int LOG_WARN = 1;
    public static final int LOG_NOTICE = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    public static final int LOG_TRACE = 5;
    private static final String loggingLevels = "EWNIDT";
    public static final int SMF_HEADER_PREFIX_LEN = 24;
    public static final String JZOS_MERGE_SYSOUT_PROPERTY = "jzos.merge.sysout";
    private static String defaultPlatformEncoding;
    private static String cachedJobname;
    private static String cachedStepname;
    private static String cachedProcStepname;
    private static String cachedJobid;
    private static long cachedTsoUptAddr;
    private static String eightChar;
    private static final long TOD_EPOC_OFFSET = 9048018124800000000L;
    private static final long TOD_EPOC_OFFSET_MICROS = 2208988800000000L;
    private static final long TOD_UNITS_PER_MICRO = 4096L;
    private static final long TOD_UNITS_PER_MILLI = 4096000L;
    private static final long TOD_UNITS_PER_SEC = 4096000000L;
    private static final long ETODH_EPOC_OFFSET = 35343820800000000L;
    private static final long ETODH_UNITS_PER_MICRO = 16L;
    private static final long ETODH_UNITS_PER_MILLI = 16000L;
    private static final long ETODH_UNITS_PER_SEC = 16000000L;
    private static final String BUILD_PROPERTIES_NAME = "build_version.properties";
    private static final String BUILD_VERSION_KEY = "BUILD_VERSION";

    private ZUtil() {
    }

    public static String getDefaultPlatformEncoding() {
        return defaultPlatformEncoding;
    }

    public static void setDefaultPlatformEncoding(String encoding) throws UnsupportedEncodingException {
        " ".getBytes(encoding);
        defaultPlatformEncoding = encoding;
    }

    public static native String[] environ();

    public static Properties getEnvironment() {
        String[] environ = ZUtil.environ();
        Properties p = new Properties();
        for (int i = 0; i < environ.length; ++i) {
            String var = environ[i];
            int idx = var.indexOf(61);
            if (idx <= 0) continue;
            p.put(var.substring(0, idx), var.substring(idx + 1));
        }
        return p;
    }

    public static native String getEnv(String var0);

    public static native void setEnv(String var0, String var1) throws ErrnoException;

    public static String getCurrentJobname() {
        ZUtil.cacheJobInfo();
        return cachedJobname;
    }

    public static String getCurrentTsoPrefix() {
        ZUtil.cacheJobInfo();
        if (cachedTsoUptAddr != 0L) {
            byte[] uptPrefix = new byte[8];
            byte[] uptPref8 = new byte[8];
            ZUtil.peekOSMemory(cachedTsoUptAddr + 16L, uptPrefix);
            String tsoPrefix = new String(uptPrefix, 0, 7);
            byte plen = uptPrefix[uptPrefix.length - 1];
            if (eightChar.equals(tsoPrefix)) {
                ZUtil.peekOSMemory(cachedTsoUptAddr + 33L, uptPref8);
                byte[] uptPrf8l = new byte[1];
                ZUtil.peekOSMemory(cachedTsoUptAddr + 41L, uptPrf8l);
                plen = uptPrf8l[0];
                if (plen > 0) {
                    try {
                        return new String(uptPref8, 0, (int)plen, "IBM-1047");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                return "";
            }
            if (plen > 0) {
                try {
                    return new String(uptPrefix, 0, (int)plen, "IBM-1047");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return "";
        }
        return null;
    }

    public static String getCurrentStepname() {
        ZUtil.cacheJobInfo();
        return cachedStepname;
    }

    public static String getCurrentProcStepname() {
        ZUtil.cacheJobInfo();
        return cachedProcStepname;
    }

    public static String getCurrentJobId() {
        ZUtil.cacheJobInfo();
        return cachedJobid;
    }

    public static native long getCurrentTimeMicros();

    public static native long getCpuTimeMicros() throws RcException;

    public static long getEpochMillis(byte[] stckOrStcke) throws RcException {
        if (stckOrStcke == null) {
            throw new IllegalArgumentException("null stckOrStcke timestamp");
        }
        if (stckOrStcke.length == 8) {
            long stckLong = ByteUtil.bytesAsLong(stckOrStcke);
            return ZUtil.getEpochMilliSeconds(stckLong);
        }
        if (stckOrStcke.length == 16) {
            long stckeHigh = ByteUtil.bytesAsLong(stckOrStcke, 0, 8);
            return Math.floorDiv(stckeHigh -= 35343820800000000L, 16000L);
        }
        throw new IllegalArgumentException("argument must be either 8 or 16 bytes long");
    }

    public static long getEpochMillis(long stck) {
        return ZUtil.getEpochMilliSeconds(stck);
    }

    public static final long getEpochMilliSeconds(long stck) {
        long epoc_micros = (stck >>> 12) - 2208988800000000L;
        return Math.floorDiv(epoc_micros, 1000L);
    }

    public static final Instant toInstant(long stck) {
        long epoc_micros = (stck >>> 12) - 2208988800000000L;
        long epoc_secs = epoc_micros / 1000000L;
        long epoc_rem_micros = epoc_micros % 1000000L;
        long epoc_rem_tod = epoc_rem_micros * 4096L | stck & 0xFFFL;
        long epoc_nanos = Math.floorDiv(epoc_rem_tod * 1000L, 4096L);
        return Instant.ofEpochSecond(epoc_secs, epoc_nanos);
    }

    public static final Instant toInstant(byte[] stckOrStcke) {
        if (stckOrStcke == null) {
            throw new IllegalArgumentException("null stckOrStcke timestamp");
        }
        if (stckOrStcke.length == 8) {
            long stckLong = ByteUtil.bytesAsLong(stckOrStcke);
            return ZUtil.toInstant(stckLong);
        }
        if (stckOrStcke.length == 16) {
            long stckeHigh = ByteUtil.bytesAsLong(stckOrStcke, 0, 8);
            if (stckeHigh < 35343820800000000L) {
                return ZUtil.toInstant(ByteUtil.bytesAsLong(stckOrStcke, 1, 8));
            }
            long epoc_secs = (stckeHigh -= 35343820800000000L) / 16000000L;
            long frac_secs_tod = stckeHigh % 16000000L << 8;
            long nanos = Math.floorDiv((frac_secs_tod |= (long)(stckOrStcke[8] & 0xFF)) * 1000L, 4096L);
            return Instant.ofEpochSecond(epoc_secs, nanos);
        }
        throw new IllegalArgumentException("stckOrStcke must be either 8 or 16 bytes long");
    }

    public static String getCurrentUser() throws RcException {
        return PlatformThread.getUserName();
    }

    public static String getJavaVersionInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(Messages.getString("ZUtil.JavaVersion"));
        sb.append(" \"");
        sb.append(System.getProperty("java.version"));
        sb.append("\"\n");
        sb.append(System.getProperty("java.runtime.name"));
        sb.append(" (");
        sb.append(Messages.getString("ZUtil.Build"));
        sb.append(" ");
        sb.append(System.getProperty("java.runtime.version"));
        sb.append(")\n");
        sb.append(System.getProperty("java.vm.name"));
        sb.append(" (");
        sb.append(Messages.getString("ZUtil.Build"));
        sb.append(" ");
        sb.append(System.getProperty("java.vm.version"));
        sb.append(", ");
        sb.append(System.getProperty("java.vm.info"));
        sb.append(")");
        return sb.toString();
    }

    public static String getJzosJarVersion() {
        String build_version = null;
        InputStream is = ZUtil.class.getResourceAsStream(BUILD_PROPERTIES_NAME);
        if (is != null) {
            try {
                Properties props = new Properties();
                props.load(is);
                build_version = props.getProperty(BUILD_VERSION_KEY);
            }
            catch (Throwable t) {
                ZUtil.logDiagnostic(1, "Error loading build_version.properties - " + t);
            }
        }
        return build_version;
    }

    private static native String basicGetJzosDllVersion();

    public static String getJzosDllVersion() {
        String dllVersion = null;
        try {
            dllVersion = ZUtil.basicGetJzosDllVersion();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return dllVersion;
    }

    public static long peekOSMemory(long address, int len) throws RcException {
        if (len > 8) {
            throw new IllegalArgumentException("len > 8");
        }
        if (len <= 0) {
            throw new IllegalArgumentException("len <= 0");
        }
        byte[] bytes = new byte[len];
        ZUtil.peekOSMemory(address, bytes);
        return ByteUtil.bytesAsLong(bytes);
    }

    public static void peekOSMemory(long address, byte[] bytes) throws RcException {
        ZUtil.peekOSMemory(address, bytes, 0, bytes.length);
    }

    public static void peekOSMemory(long address, byte[] bytes, int offset, int len) throws RcException {
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be >= 0");
        }
        if (len <= 0) {
            throw new IllegalArgumentException("length must be > 0");
        }
        if (bytes.length < offset + len) {
            throw new IllegalArgumentException("bytes.length < offset + len");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JzosPermission("peekOSMemory"));
        }
        ZUtil.basicPeekOSMemory(address, bytes, offset, len);
    }

    public static void logDiagnostic(int level, String msg) {
        if (level < 0 || level > 5) {
            return;
        }
        try {
            ZUtil.basicLogDiagnostic(level, msg);
        }
        catch (Throwable t) {
            System.err.println(msg);
        }
    }

    public static void redirectStandardStreams() throws Exception {
        ZUtil.redirectStandardStreams(ZUtil.getDefaultPlatformEncoding(), true);
    }

    public static boolean redirectStandardStreams(String requestedEncoding, final boolean enableTranscoding) throws Exception {
        if (System.out instanceof TranscodingPrintStream) {
            return true;
        }
        String effectiveEncoding = requestedEncoding;
        try {
            ZUtil.setDefaultPlatformEncoding(requestedEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            effectiveEncoding = ZUtil.getDefaultPlatformEncoding();
        }
        final String enc = effectiveEncoding;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ZFileException, UnsupportedEncodingException {
                    PrintStream errPs;
                    PrintStream outPs;
                    block9: {
                        ZFile systemOutFile = null;
                        ZFile systemErrFile = null;
                        outPs = null;
                        errPs = null;
                        boolean mergeSysout = System.getProperty(ZUtil.JZOS_MERGE_SYSOUT_PROPERTY, "").equalsIgnoreCase("true");
                        if (mergeSysout) {
                            systemOutFile = ZFile.usingStderr();
                        } else {
                            systemOutFile = new ZFile("//DD:STDOUT", "w");
                            systemErrFile = new ZFile("//DD:STDERR", "w");
                        }
                        try {
                            outPs = new TranscodingPrintStream(systemOutFile.getOutputStream(), false, enc, enableTranscoding);
                            if (systemErrFile != null) {
                                errPs = new TranscodingPrintStream(systemErrFile.getOutputStream(), false, enc, enableTranscoding);
                            }
                            ZUtil.logDiagnostic(3, "Output encoding '" + enc + "' will be used.");
                        }
                        catch (UnsupportedCharsetException uce) {
                            ZUtil.logDiagnostic(0, "Unsupported charset, transcoding disabled: " + uce);
                            outPs = new PrintStream(systemOutFile.getOutputStream());
                            if (systemErrFile == null) break block9;
                            errPs = new PrintStream(systemErrFile.getOutputStream());
                        }
                    }
                    System.setOut(outPs);
                    if (errPs != null) {
                        System.setErr(errPs);
                    } else {
                        System.setErr(outPs);
                    }
                    try {
                        ZFile systemInFile = new ZFile("//DD:STDIN", "r");
                        System.setIn(systemInFile.getInputStream());
                    }
                    catch (Exception e) {
                        System.setIn(new InputStream(){

                            @Override
                            public int read() throws IOException {
                                return -1;
                            }
                        });
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return effectiveEncoding.equals(requestedEncoding);
    }

    public static PrintStream newEncodedPrintStream(OutputStream os, boolean autoFlush) throws UnsupportedEncodingException {
        return ZUtil.newEncodedPrintStream(os, autoFlush, ZUtil.getDefaultPlatformEncoding());
    }

    public static PrintStream newEncodedPrintStream(OutputStream os, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        return ZUtil.newEncodedPrintStream(os, autoFlush, encoding, true);
    }

    public static PrintStream newEncodedPrintStream(OutputStream os, boolean autoFlush, String encoding, boolean enable) throws UnsupportedEncodingException {
        TranscodingPrintStream tps = new TranscodingPrintStream(os, autoFlush, encoding, enable);
        return tps;
    }

    public static native int getLoggingLevel();

    public static native void setLoggingLevel(int var0);

    private static native void basicLogDiagnostic(int var0, String var1);

    private static native void basicPeekOSMemory(long var0, byte[] var2, int var3, int var4) throws RcException;

    public static native String getCodePageCurrentLocale();

    public static native int getPid();

    public static native int getPPid();

    public static byte[] getTodClock() {
        byte[] buffer = new byte[8];
        ZUtil.getTodClock(buffer);
        return buffer;
    }

    public static native void getTodClock(byte[] var0);

    public static byte[] getTodClockExtended() {
        byte[] buffer = new byte[16];
        ZUtil.getTodClockExtended(buffer);
        return buffer;
    }

    public static native void getTodClockExtended(byte[] var0);

    public static void smfRecord(int type, int subtype, byte[] record) throws ErrnoException {
        if (record.length < 24) {
            throw new IllegalArgumentException(Messages.getString("ZUtil.SmfRecordTooShort"));
        }
        ZUtil.basicSmfRecord(type, subtype, record);
    }

    private static native void basicSmfRecord(int var0, int var1, byte[] var2) throws ErrnoException;

    public static String substituteSystemSymbols(String pattern, boolean warn) throws RcException {
        return ZUtil.subSystemSymbols(pattern, warn);
    }

    public static String substituteSystemSymbols(String pattern) throws RcException {
        return ZUtil.subSystemSymbols(pattern, false);
    }

    private static native String subSystemSymbols(String var0, boolean var1) throws RcException;

    private static synchronized void cacheJobInfo() {
        if (cachedJobname != null) {
            return;
        }
        try {
            long pCVT = ZUtil.peekOSMemory(16L, 4);
            long pTCBW = ZUtil.peekOSMemory(pCVT + 0L, 4);
            long pTCB = ZUtil.peekOSMemory(pTCBW + 4L, 4);
            long pTIOT = ZUtil.peekOSMemory(pTCB + 12L, 4);
            byte[] tiotHeader = new byte[24];
            ZUtil.peekOSMemory(pTIOT, tiotHeader);
            cachedJobname = new String(tiotHeader, 0, 8, "IBM-1047");
            cachedJobname = cachedJobname.trim();
            cachedProcStepname = new String(tiotHeader, 8, 8, "IBM-1047");
            cachedProcStepname = cachedProcStepname.trim();
            cachedStepname = new String(tiotHeader, 16, 8, "IBM-1047");
            cachedStepname = cachedStepname.trim();
            if (cachedStepname.length() == 0) {
                cachedStepname = cachedProcStepname;
                cachedProcStepname = "";
            }
            long pJSCB = ZUtil.peekOSMemory(pTCB + 180L, 4);
            long pSSIB = ZUtil.peekOSMemory(pJSCB + 316L, 4);
            byte[] ssibJobname = new byte[8];
            ZUtil.peekOSMemory(pSSIB + 12L, ssibJobname);
            cachedJobid = new String(ssibJobname, "IBM-1047");
            cachedJobid = cachedJobid.trim();
            long pPSCB = ZUtil.peekOSMemory(pJSCB + 264L, 4);
            if (pPSCB != 0L) {
                cachedTsoUptAddr = ZUtil.peekOSMemory(pPSCB + 52L, 4);
            }
        }
        catch (UnsupportedEncodingException uce) {
            throw new RuntimeException(uce);
        }
        finally {
            if (cachedJobname == null) {
                cachedJobname = "UNKNOWN";
            }
        }
    }

    private static void initializeLoggingLevel() {
        try {
            String logLevel = System.getProperty("jzos.logging");
            if (logLevel != null && logLevel.length() > 0) {
                int level = loggingLevels.indexOf(logLevel.toUpperCase().charAt(0));
                if (level == -1) {
                    level = 3;
                }
                ZUtil.setLoggingLevel(level);
            }
        }
        catch (UnsatisfiedLinkError usle) {
            usle.printStackTrace(System.err);
        }
        catch (Throwable t) {
            ZUtil.logDiagnostic(1, "Unexpected exception in ZUtil.initializeLoggingLevel: " + t);
        }
    }

    private static void initializeDefaultPlatformEncoding() {
        defaultPlatformEncoding = "IBM-1047";
        String answer = "IBM-1047";
        try {
            answer = ZUtil.getCodePageCurrentLocale();
        }
        catch (Throwable t) {
            return;
        }
        try {
            ZUtil.setDefaultPlatformEncoding(answer);
        }
        catch (UnsupportedEncodingException uce) {
            ZUtil.logDiagnostic(0, "initializeDefaultPlatformEncoding to " + answer + " failed: " + uce);
        }
    }

    private static void reportVersion() {
        String jarVersion = ZUtil.getJzosJarVersion();
        String dllVersion = ZUtil.getJzosDllVersion();
        if (jarVersion == null) {
            ZUtil.logDiagnostic(1, "Could not determine JZOS Jar version.");
        }
        if (dllVersion == null) {
            ZUtil.logDiagnostic(1, "Could not determine JZOS DLL version.");
        }
        if (!jarVersion.equals(dllVersion)) {
            ZUtil.logDiagnostic(1, "jzos.jar build version '" + jarVersion + "' does not match libjzos DLL build version '" + dllVersion + "'");
        } else {
            ZUtil.logDiagnostic(4, "jzos.jar build version = " + jarVersion);
            ZUtil.logDiagnostic(4, "libjzos DLL build version = " + dllVersion);
        }
    }

    private static void loadLibrary() {
        String libname = "jzos";
        try {
            String[] parts;
            String javaVersion = System.getProperty("java.version", "1.8.0");
            String sdkVersion = "8";
            String sdkBit = "0";
            if ("64".equals(System.getProperty("com.ibm.vm.bitmode"))) {
                sdkBit = "6";
            }
            if ((parts = javaVersion.split(".")).length >= 2) {
                sdkVersion = parts[1];
            }
            libname = libname + sdkVersion + sdkBit;
            System.loadLibrary(libname);
        }
        catch (Throwable t) {
            try {
                libname = "jzos";
                System.loadLibrary(libname);
            }
            catch (Throwable t1) {
                System.err.println(Messages.getString("ZUtil.ErrorLoadingNativeLibrary"));
                t1.printStackTrace(System.err);
            }
        }
    }

    public static void touch() {
    }

    public static String formatStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    static native void setObjectField(Object var0, Object var1, String var2, String var3);

    static {
        ZUtil.loadLibrary();
        ZUtil.initializeLoggingLevel();
        ZUtil.initializeDefaultPlatformEncoding();
        ZUtil.reportVersion();
        cachedJobname = null;
        cachedStepname = null;
        cachedProcStepname = null;
        cachedJobid = null;
        cachedTsoUptAddr = 0L;
        eightChar = ">7BYTES";
    }
}

