/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.TranscodingPrintStream;
import com.ibm.jzos.ZLogstreamException;
import com.ibm.jzos.ZUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class ZLogstream {
    private String logstreamName;
    private long hWork;
    private boolean readOnly;
    private int browseToken;
    public static final int DEFAULT_WRITE_RETRY_COUNT = 20;
    private int writeRetryCount = 20;
    public static final long DEFAULT_RETRY_SLEEP_MS = 50L;
    private long retrySleepTimeMs = 50L;
    ReadDirection lastReadDirection = ReadDirection.INIT;

    public ZLogstream(String name) throws ZLogstreamException {
        this(name, false);
    }

    public ZLogstream(String name, boolean readOnly) throws ZLogstreamException {
        this.logstreamName = name;
        this.readOnly = readOnly;
        this.checkSecurityManager(readOnly);
        this.hWork = this.nativeConnect(name, readOnly);
    }

    public synchronized void close() throws ZLogstreamException {
        if (this.isClosed()) {
            return;
        }
        if (this.browseToken != 0) {
            try {
                this.browseEnd();
            }
            catch (ZLogstreamException zLogstreamException) {
                // empty catch block
            }
        }
        try {
            this.nativeDisconnect(this.hWork);
        }
        finally {
            this.hWork = 0L;
        }
    }

    public boolean isClosed() {
        return this.hWork == 0L;
    }

    public boolean isOpen() {
        return this.hWork != 0L;
    }

    public synchronized void reconnect() throws ZLogstreamException {
        if (this.isOpen()) {
            try {
                this.close();
            }
            catch (ZLogstreamException zLogstreamException) {
                // empty catch block
            }
        }
        this.hWork = this.nativeConnect(this.logstreamName, this.readOnly);
    }

    public synchronized void write(byte[] bytes, int offset, int len, boolean synch) throws ZLogstreamException {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        this.checkOpenForWrite();
        int retriesLeft = this.writeRetryCount;
        while (true) {
            try {
                this.nativeWrite(this.hWork, bytes, offset, len, synch);
            }
            catch (ZLogstreamException zle) {
                if (zle.isTokenInvalidError() && retriesLeft-- > 0) {
                    this.reconnect();
                    continue;
                }
                if ((zle.isStagingFormattingNotFinished() || zle.isStagingDatasetFull()) && retriesLeft-- > 0) {
                    this.sleepBetweenRetries();
                    continue;
                }
                throw zle;
            }
            break;
        }
    }

    public synchronized void browseStart(boolean activeOnly, boolean oldest) throws ZLogstreamException {
        this.checkOpen();
        if (this.hasBrowseSession()) {
            throw new IllegalStateException("Browse session already started");
        }
        this.browseToken = this.nativeBrowseStart(this.hWork, activeOnly, oldest);
    }

    public synchronized void browseStartSearch(boolean activeOnly, long timestamp) throws ZLogstreamException {
        this.checkOpen();
        if (this.hasBrowseSession()) {
            throw new IllegalStateException("Browse session already started");
        }
        this.browseToken = this.nativeBrowseStartSearch(this.hWork, activeOnly, timestamp);
    }

    public synchronized void browseStartBlockID(boolean activeOnly, long blockID) throws ZLogstreamException {
        this.checkOpen();
        if (this.hasBrowseSession()) {
            throw new IllegalStateException("Browse session already started");
        }
        this.browseToken = this.nativeBrowseStartBlockid(this.hWork, activeOnly, blockID);
    }

    public synchronized void browseEnd() throws ZLogstreamException {
        this.checkOpen();
        if (!this.hasBrowseSession()) {
            return;
        }
        try {
            this.nativeBrowseEnd(this.hWork, this.browseToken);
        }
        finally {
            this.browseToken = 0;
        }
    }

    public boolean hasBrowseSession() {
        return this.browseToken != 0;
    }

    public synchronized void deleteAll() throws ZLogstreamException {
        this.checkOpenForWrite();
        this.nativeDelete(this.hWork, false, 0L);
    }

    public synchronized void deleteRange(long blockID) throws ZLogstreamException {
        this.checkOpenForWrite();
        this.nativeDelete(this.hWork, true, blockID);
    }

    public synchronized int readCursor(byte[] bytes, int offset, boolean forward) throws ZLogstreamException {
        return this.readCursor(bytes, offset, forward, false);
    }

    public synchronized int readCursor(byte[] bytes, int offset, boolean forward, boolean multiBlock) throws ZLogstreamException {
        block9: {
            if (bytes == null) {
                throw new NullPointerException("bytes");
            }
            this.checkOpen();
            if (this.browseToken == 0) {
                try {
                    boolean oldest = forward;
                    this.browseStart(true, oldest);
                }
                catch (ZLogstreamException zle) {
                    if (!zle.isStreamEmpty()) break block9;
                    return -1;
                }
            }
        }
        try {
            if (!multiBlock) {
                return this.nativeBrowseReadCursor(this.hWork, this.browseToken, bytes, offset, forward);
            }
            boolean changeDirection = false;
            if (this.lastReadDirection != ReadDirection.INIT && (this.lastReadDirection == ReadDirection.FORWARD && !forward || this.lastReadDirection == ReadDirection.BACKWARD && forward)) {
                long blockID = this.getBlockID();
                this.readBlockID(blockID, bytes, offset);
                changeDirection = true;
            }
            this.lastReadDirection = forward ? ReadDirection.FORWARD : ReadDirection.BACKWARD;
            return this.nativeBrowseReadCursorMultiBlock(this.hWork, this.browseToken, bytes, offset, forward, changeDirection);
        }
        catch (ZLogstreamException zle) {
            if (zle.isEndReached()) {
                return -1;
            }
            throw zle;
        }
    }

    public synchronized int readBlockID(long blockID, byte[] bytes, int offset) throws ZLogstreamException {
        block4: {
            if (bytes == null) {
                throw new NullPointerException("bytes");
            }
            this.checkOpen();
            if (this.browseToken == 0) {
                try {
                    this.browseStart(true, true);
                }
                catch (ZLogstreamException zle) {
                    if (!zle.isStreamEmpty()) break block4;
                    return -1;
                }
            }
        }
        return this.nativeBrowseReadBlock(this.hWork, this.browseToken, false, blockID, bytes, offset);
    }

    public synchronized int readSearch(long timestamp, byte[] bytes, int offset) throws ZLogstreamException {
        block4: {
            if (bytes == null) {
                throw new NullPointerException("bytes");
            }
            this.checkOpen();
            if (this.browseToken == 0) {
                try {
                    this.browseStart(true, true);
                }
                catch (ZLogstreamException zle) {
                    if (!zle.isStreamEmpty()) break block4;
                    return -1;
                }
            }
        }
        return this.nativeBrowseReadBlock(this.hWork, this.browseToken, true, timestamp, bytes, offset);
    }

    public synchronized int getLastRecordRead(byte[] bytes, int offset) throws ZLogstreamException {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        this.checkOpen();
        return this.nativeBrowseGetLastRecordRead(this.hWork, bytes, offset);
    }

    public OutputStream getOutputStream(boolean synch) {
        return this.getOutputStream(synch, (byte)21);
    }

    public OutputStream getOutputStream(final boolean synch, final byte separator) {
        this.checkOpenForWrite();
        return new OutputStream(){
            private BOS bos = new BOS(1024);

            @Override
            public void close() throws IOException {
                try {
                    this.flush();
                }
                finally {
                    ZLogstream.this.close();
                }
            }

            @Override
            public void write(int b) throws IOException {
                byte[] buf = new byte[]{(byte)b};
                this.write(buf, 0, 1);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ZLogstream zLogstream = ZLogstream.this;
                synchronized (zLogstream) {
                    int start = off;
                    int end = off + len;
                    for (int i = off; i < end; ++i) {
                        if (b[i] != separator) continue;
                        if (this.bos.size() > 0) {
                            this.bos.write(b, start, i - start);
                            ZLogstream.this.write(this.bos.getRawBuf(), 0, this.bos.size(), synch);
                            this.bos.reset();
                        } else if (i - start > 0) {
                            ZLogstream.this.write(b, start, i - start, synch);
                        } else {
                            byte[] nullbyte = new byte[]{0};
                            ZLogstream.this.write(nullbyte, 0, 1, synch);
                        }
                        start = i + 1;
                    }
                    if (start < end) {
                        this.bos.write(b, start, end - start);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flush() throws IOException {
                ZLogstream zLogstream = ZLogstream.this;
                synchronized (zLogstream) {
                    if (this.bos.size() > 0) {
                        ZLogstream.this.write(this.bos.getRawBuf(), 0, this.bos.size(), synch);
                        this.bos.reset();
                    }
                }
            }
        };
    }

    public PrintStream getPrintStream(String encoding, boolean synch) throws UnsupportedEncodingException {
        return new TranscodingPrintStream(this.getOutputStream(synch), false, encoding, true);
    }

    public InputStream getInputStream() {
        return this.getInputStream((byte)21);
    }

    public InputStream getInputStream(final byte separator) {
        this.checkOpen();
        return new InputStream(){
            private byte[] recBuf;
            private int recBufLen = 0;
            private int recBufUsed = 0;

            @Override
            public void close() throws IOException {
                ZLogstream.this.close();
            }

            @Override
            public int read() throws IOException {
                byte[] buf = new byte[1];
                int nRead = this.read(buf, 0, 1);
                if (nRead < 0) {
                    return nRead;
                }
                return buf[0] & 0xFF;
            }

            @Override
            public int read(byte[] buf) throws IOException {
                return this.read(buf, 0, buf.length);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int nRead;
                int amtToUse;
                int recBufLeft;
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                int origLen = len;
                if (this.recBuf == null) {
                    this.recBuf = new byte[ZLogstream.this.getMaxBlockLength() + 1];
                }
                if ((recBufLeft = this.recBufLen - this.recBufUsed) > 0) {
                    amtToUse = Math.min(len, recBufLeft);
                    System.arraycopy(this.recBuf, this.recBufUsed, b, off, amtToUse);
                    len -= amtToUse;
                    off += amtToUse;
                    this.recBufUsed += amtToUse;
                }
                while (len > 0) {
                    this.recBufUsed = 0;
                    this.recBufLen = ZLogstream.this.readCursor(this.recBuf, 0, true);
                    if (this.recBufLen <= 0) break;
                    this.recBuf[this.recBufLen++] = separator;
                    amtToUse = Math.min(len, this.recBufLen);
                    System.arraycopy(this.recBuf, this.recBufUsed, b, off, amtToUse);
                    len -= amtToUse;
                    off += amtToUse;
                    this.recBufUsed += amtToUse;
                }
                if ((nRead = origLen - len) > 0) {
                    return nRead;
                }
                return -1;
            }
        };
    }

    public String getName() {
        return this.logstreamName;
    }

    public byte[] getToken() {
        if (this.isClosed()) {
            return null;
        }
        return this.nativeGetToken(this.hWork);
    }

    public synchronized long getBlockID() {
        this.checkOpen();
        return this.nativeGetBlockid(this.hWork);
    }

    public synchronized long getTimestamp() {
        this.checkOpen();
        return this.nativeGetTimestamp(this.hWork);
    }

    public synchronized int getMaxBlockLength() {
        this.checkOpen();
        return this.nativeGetMaxBlockLength(this.hWork);
    }

    public int getWriteRetryCount() {
        return this.writeRetryCount;
    }

    public void setWriteRetryCount(int writeRetryCount) {
        if (writeRetryCount < 0) {
            throw new IllegalArgumentException("Retry count may not be negative");
        }
        this.writeRetryCount = writeRetryCount;
    }

    public long getRetrySleepTimeMs() {
        return this.retrySleepTimeMs;
    }

    public void setRetrySleepTimeMs(long retryTimeMs) {
        if (retryTimeMs < 0L) {
            throw new IllegalArgumentException("Retry time  may not be negative");
        }
        this.retrySleepTimeMs = retryTimeMs;
    }

    public synchronized boolean isGMT() {
        this.checkOpen();
        return this.nativeIsGMT(this.hWork);
    }

    public synchronized void setGMT(boolean isGMT) {
        this.checkOpen();
        this.nativeSetGMT(this.hWork, isGMT);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("ZLogstream(");
        sb.append('\"');
        sb.append(this.logstreamName);
        sb.append("\"");
        if (this.isClosed()) {
            sb.append(", (closed)");
        }
        sb.append(")");
        return sb.toString();
    }

    private native long nativeConnect(String var1, boolean var2) throws ZLogstreamException;

    private native void nativeDisconnect(long var1) throws ZLogstreamException;

    private native void nativeWrite(long var1, byte[] var3, int var4, int var5, boolean var6) throws ZLogstreamException;

    private native int nativeBrowseStart(long var1, boolean var3, boolean var4) throws ZLogstreamException;

    private native int nativeBrowseStartBlockid(long var1, boolean var3, long var4) throws ZLogstreamException;

    private native int nativeBrowseStartSearch(long var1, boolean var3, long var4) throws ZLogstreamException;

    private native int nativeBrowseReadCursor(long var1, int var3, byte[] var4, int var5, boolean var6) throws ZLogstreamException;

    private native int nativeBrowseReadCursorMultiBlock(long var1, int var3, byte[] var4, int var5, boolean var6, boolean var7) throws ZLogstreamException;

    private native int nativeBrowseReadBlock(long var1, int var3, boolean var4, long var5, byte[] var7, int var8) throws ZLogstreamException;

    private native void nativeBrowseEnd(long var1, int var3) throws ZLogstreamException;

    private native int nativeBrowseGetLastRecordRead(long var1, byte[] var3, int var4) throws ZLogstreamException;

    private native void nativeDelete(long var1, boolean var3, long var4) throws ZLogstreamException;

    private native byte[] nativeGetToken(long var1);

    private native long nativeGetBlockid(long var1);

    private native long nativeGetTimestamp(long var1);

    private native int nativeGetMaxBlockLength(long var1);

    private native boolean nativeIsGMT(long var1);

    private native void nativeSetGMT(long var1, boolean var3);

    private void sleepBetweenRetries() {
        try {
            Thread.sleep(this.retrySleepTimeMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void checkSecurityManager(boolean readOnly) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        String path = "/LOGSTREAM/" + this.logstreamName;
        path = path.replace('.', '/');
        if (readOnly) {
            sm.checkRead(path);
        } else {
            sm.checkWrite(path);
        }
    }

    private void checkOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Logstream " + this.logstreamName + " is not open");
        }
    }

    private void checkOpenForWrite() {
        this.checkOpen();
        if (this.readOnly) {
            throw new IllegalStateException("Logstream " + this.logstreamName + " is not open in write mode");
        }
    }

    static {
        ZUtil.touch();
    }

    private static class BOS
    extends ByteArrayOutputStream {
        public BOS() {
        }

        public BOS(int size) {
            super(size);
        }

        byte[] getRawBuf() {
            return this.buf;
        }
    }

    private static enum ReadDirection {
        INIT,
        FORWARD,
        BACKWARD;

    }
}

