/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;

class ZFileRecordWriter
extends RecordWriter {
    protected ZFile zFile;
    private String ddname;
    private int blksize;
    private int lrecl;
    private int recfmBits;
    private String recfm;
    private String dsn;

    protected ZFileRecordWriter(ZFile zFile) throws ZFileException {
        this.zFile = zFile;
        this.blksize = zFile.getBlksize();
        this.lrecl = zFile.getLrecl();
        this.recfmBits = zFile.getRecfmBits();
        this.recfm = zFile.getRecfm();
        this.dsn = zFile.getActualFilename();
    }

    protected ZFileRecordWriter(String ddname) throws ZFileException {
        this(new ZFile("//DD:" + ddname, "wb,type=record,noseek,recfm=*"));
        this.ddname = ddname;
    }

    @Override
    public void close() throws ZFileException {
        this.zFile.close();
        this.doAutoFree();
    }

    @Override
    public int getBlksize() {
        return this.blksize;
    }

    @Override
    public String getDDName() {
        return this.ddname;
    }

    @Override
    public String getDsn() {
        return this.dsn;
    }

    @Override
    public int getLrecl() {
        return this.lrecl;
    }

    @Override
    public String getRecfm() {
        return this.recfm;
    }

    @Override
    public int getRecfmBits() {
        return this.recfmBits;
    }

    @Override
    public void write(byte[] buf) throws ZFileException {
        this.zFile.write(buf);
    }

    @Override
    public void write(byte[] buf, int offset, int len) throws ZFileException {
        this.zFile.write(buf, offset, len);
    }

    @Override
    public void flush() throws ZFileException {
        this.zFile.flush();
    }
}

