/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Messages;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZFileRecordReader;

class ZFileFixedRecordReader
extends ZFileRecordReader {
    private int lrecl;
    private byte[] block;
    private int currentBlockLength;
    private int currentOffset;

    ZFileFixedRecordReader(ZFile zFile) throws ZFileException {
        super(zFile);
        this.lrecl = zFile.getLrecl();
        this.block = new byte[zFile.getBlksize()];
        this.currentOffset = 0;
        this.currentBlockLength = 0;
        zFile.reopen(this.mutateOptionsToRecfmU(zFile.getOptions()));
    }

    @Override
    public int read(byte[] buf) throws ZFileException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws ZFileException {
        if (this.currentOffset >= this.currentBlockLength && !this.readNextBlock()) {
            return -1;
        }
        if (len > this.lrecl) {
            len = this.lrecl;
        }
        System.arraycopy(this.block, this.currentOffset, buf, offset, len);
        this.currentOffset += this.lrecl;
        return this.lrecl;
    }

    private boolean readNextBlock() throws ZFileException {
        while ((this.currentBlockLength = this.zFile.read(this.block)) == 0) {
        }
        this.currentOffset = 0;
        if (this.currentBlockLength == -1) {
            return false;
        }
        if (this.currentBlockLength % this.lrecl != 0) {
            throw new ZFileException(this.zFile.getFilename(), Messages.getString("ZFileFixedRecordReader.BlockNum") + this.zFile.getRecordCount() + Messages.getString("ZFileFixedRecordReader.WithLength") + this.currentBlockLength + Messages.getString("ZFileFixedRecordReader.IsNotMultipleOfLrecl") + this.lrecl, -1);
        }
        return true;
    }
}

