/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.ZFileConstants;
import com.ibm.jzos.ZUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ZFileException
extends IOException
implements ZFileConstants {
    static final long serialVersionUID = 200L;
    private String fileName;
    private String errnoMsg;
    private int errno;
    private int errno2;
    private int lastOp;
    private byte[] amrc_code_bytes;
    private static final int ERROR_CODE_OFF = 0;
    private static final int ERROR_CODE_LEN = 4;
    private static final int ABEND_CODE_OFF = 0;
    private static final int ABEND_CODE_LEN = 2;
    private static final int ABEND_RC_OFF = 2;
    private static final int ABEND_RC_LEN = 2;
    private static final int FDBK_RC_OFF = 1;
    private static final int FDBK_RC_LEN = 1;
    private static final int FDBK_FTNCD_OFF = 2;
    private static final int FDBK_FTNCD_LEN = 1;
    private static final int FDBK_FDBK_OFF = 3;
    private static final int FDBK_FDBK_LEN = 1;
    private static final int SVC99_INFO_OFF = 0;
    private static final int SVC99_INFO_LEN = 2;
    private static final int SVC99_ERROR_OFF = 2;
    private static final int SVC99_ERROR_LEN = 2;
    private static final int SYNAD_MSG_OFF = 12;
    private static final int SYNAD_MSG_LEN_OFF = 16;
    private static final int SYNAD_MSG_LEN_LEN = 2;
    private static final int SYNAD_MSG_LEN_BIAS = 20;
    private static final int SYNAD_MSG_STRT_OFF = 36;
    private static final int SYNAD_MSG_EXPECTED_LEN = 104;
    private static final int SYNAD_MSG2_OFF = 156;
    private static final int SYNAD_MSG2_LEN = 44;

    public ZFileException(String fileName, String msg, String errnoMsg, int errno, int errno2, int lastOp, byte[] amrc_code_bytes) {
        super(msg);
        this.fileName = fileName;
        this.errnoMsg = errnoMsg;
        this.errno = errno;
        this.errno2 = errno2;
        this.lastOp = lastOp;
        this.amrc_code_bytes = amrc_code_bytes;
    }

    public ZFileException(String fileName, String msg, int errno) {
        super(msg);
        this.fileName = fileName;
        this.errno = errno;
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer(this.fileName);
        sb.append(": ");
        sb.append(super.getMessage());
        if (this.errno != 0) {
            String synadMsg;
            if (this.errnoMsg != null) {
                sb.append("; ");
                sb.append(this.errnoMsg);
            }
            if ((synadMsg = this.getSynadMsg()) != null) {
                sb.append("; ");
                sb.append(synadMsg);
            }
            sb.append("; errno=");
            sb.append(this.errno);
            sb.append(" errno2=0x");
            sb.append(Integer.toHexString(this.errno2));
            sb.append(" last_op=");
            sb.append(this.lastOp);
            sb.append(" errorCode=0x");
            sb.append(Integer.toHexString(this.getErrorCode()));
        }
        return sb.toString();
    }

    public int getErrno() {
        return this.errno;
    }

    public int getErrno2() {
        return this.errno2;
    }

    public String getErrnoMsg() {
        return this.errnoMsg;
    }

    public int getErrorCode() {
        return this.amrc_code_bytes != null ? ByteUtil.bytesAsInt(this.amrc_code_bytes, 0, 4) : 0;
    }

    public int getAbendCode() {
        return this.amrc_code_bytes != null ? ByteUtil.bytesAsInt(this.amrc_code_bytes, 0, 2) : 0;
    }

    public int getAbendRc() {
        return this.amrc_code_bytes != null ? ByteUtil.bytesAsInt(this.amrc_code_bytes, 2, 2) : 0;
    }

    public int getFeedbackRc() {
        return this.amrc_code_bytes != null ? ByteUtil.bytesAsInt(this.amrc_code_bytes, 1, 1) : 0;
    }

    public int getFeedbackFtncd() {
        return this.amrc_code_bytes != null ? ByteUtil.bytesAsInt(this.amrc_code_bytes, 2, 1) : 0;
    }

    public int getFeedbackFdbk() {
        return this.amrc_code_bytes != null ? ByteUtil.bytesAsInt(this.amrc_code_bytes, 3, 1) : 0;
    }

    public int getAllocSvc99Info() {
        return this.amrc_code_bytes != null ? ByteUtil.bytesAsInt(this.amrc_code_bytes, 0, 2) : 0;
    }

    public int getAllocSvc99Error() {
        return this.amrc_code_bytes != null ? ByteUtil.bytesAsInt(this.amrc_code_bytes, 2, 2) : 0;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLastOp() {
        return this.lastOp;
    }

    public String getSynadMsg() {
        if (this.amrc_code_bytes == null || this.amrc_code_bytes.length < 18) {
            return null;
        }
        if (ZUtil.getLoggingLevel() >= 5) {
            for (int i = 0; i < this.amrc_code_bytes.length; ++i) {
                if (this.amrc_code_bytes[i] == 0) continue;
                ZUtil.logDiagnostic(5, "ZFileException.amrc_code_bytes=" + ByteUtil.toHexString(this.amrc_code_bytes));
                break;
            }
        }
        int msglen = ByteUtil.bytesAsInt(this.amrc_code_bytes, 16, 2);
        if ((msglen -= 20) <= 0 || this.amrc_code_bytes.length < 36 + msglen) {
            return null;
        }
        String msg = null;
        try {
            msg = new String(this.amrc_code_bytes, 36, msglen, ZUtil.getDefaultPlatformEncoding());
        }
        catch (UnsupportedEncodingException shouldNotHappen) {
            return null;
        }
        if (msg.length() == 104 && msg.charAt(103) == 'S' && this.amrc_code_bytes.length >= 200) {
            try {
                msg = msg + new String(this.amrc_code_bytes, 156, 44, ZUtil.getDefaultPlatformEncoding());
            }
            catch (UnsupportedEncodingException shouldNotHappen) {
                return null;
            }
        }
        return msg.trim();
    }

    public byte[] getAmrcBytes() {
        return this.amrc_code_bytes;
    }
}

