/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ZCompressor;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ZCompressorOutputStream
extends FilterOutputStream {
    static final int DEFAULT_BUF_SIZE = 16384;
    ZCompressor comp;
    byte[] buf;
    int count;
    final int fullThreshold;
    int extraBitCount;
    long totalSourcedBytes;
    long totalCompressedBytes;
    boolean releaseZCompressorOnClose = false;

    public ZCompressorOutputStream(ZCompressor compressor, OutputStream out) {
        this(compressor, out, 16384);
    }

    public ZCompressorOutputStream(ZCompressor compressor, OutputStream out, int buflen) {
        super(out);
        if (compressor == null || out == null) {
            throw new NullPointerException();
        }
        if (buflen <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.comp = compressor;
        this.buf = new byte[buflen];
        this.fullThreshold = buflen * 8 / 10;
    }

    public void releaseZCompressorOnClose(boolean value) {
        this.releaseZCompressorOnClose = value;
    }

    public long getTotalSourceBytes() {
        return this.totalSourcedBytes;
    }

    public long getTotalCompressedBytes() {
        return this.totalCompressedBytes;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (this.count >= this.fullThreshold) {
                this.flush();
            }
            ZCompressor.Result r = this.comp.compress(this.buf, this.count, this.extraBitCount, b, off, len);
            len -= r.getSourceBytesUsed();
            off += r.getSourceBytesUsed();
            this.totalSourcedBytes += (long)r.getSourceBytesUsed();
            this.count += r.getTargetBytesUsed();
            this.extraBitCount = r.getExtraCompressedBitsUsed();
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bb = new byte[]{(byte)b};
        this.write(bb, 0, 1);
    }

    @Override
    public void close() throws IOException {
        if (this.extraBitCount > 0) {
            ++this.count;
            this.extraBitCount = 0;
        }
        if (this.releaseZCompressorOnClose) {
            this.comp.release();
        }
        super.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.totalCompressedBytes += (long)this.count;
            if (this.extraBitCount > 0) {
                this.buf[0] = this.buf[this.count];
            }
            this.count = 0;
        }
        super.flush();
    }
}

