/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Messages;
import com.ibm.jzos.Transcoder;
import com.ibm.jzos.ZUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class TranscodingPrintStream
extends PrintStream {
    private ThreadLocal transcoderThreadLocal = new ThreadLocal();
    private boolean active = true;
    private String sourceEncoding = System.getProperty("file.encoding");
    private String targetEncoding;
    private byte[] translateTable = null;
    private byte[] translateBuffer = null;

    public TranscodingPrintStream(OutputStream out, boolean autoFlush, String targetEncoding, boolean enable) throws UnsupportedEncodingException {
        this(out, autoFlush, null, targetEncoding, enable);
    }

    public TranscodingPrintStream(OutputStream out, boolean autoFlush, String sourceEncoding, String targetEncoding, boolean enable) throws UnsupportedEncodingException {
        super(out, autoFlush, targetEncoding);
        this.active = enable;
        this.targetEncoding = targetEncoding;
        if (sourceEncoding != null) {
            this.sourceEncoding = sourceEncoding;
        }
        this.initialize();
    }

    private void initialize() throws UnsupportedEncodingException {
        if (!this.isActive()) {
            ZUtil.logDiagnostic(4, "TranscodingPrintStream is NOT transcoding.  Output encoding is '" + this.targetEncoding + "'");
            return;
        }
        Charset sourceCharset = Charset.forName(this.sourceEncoding);
        Charset targetCharset = Charset.forName(this.targetEncoding);
        ZUtil.logDiagnostic(4, "TranscodingPrintStream sourceCharset: " + sourceCharset.name() + " targetCharset: " + targetCharset.name());
        if (sourceCharset.equals(targetCharset)) {
            ZUtil.logDiagnostic(4, "Target and source charsets identical.  No transcoding will occur.");
            this.active = false;
        }
        if (this.isActive()) {
            if (sourceCharset.newEncoder().maxBytesPerChar() == 1.0f && targetCharset.newEncoder().maxBytesPerChar() == 1.0f) {
                ZUtil.logDiagnostic(4, "Target and source charsets are single byte encodings.  A translate table will be used.");
                byte[] identityMap = new byte[256];
                for (int i = 0; i < identityMap.length; ++i) {
                    identityMap[i] = (byte)i;
                }
                String unicodeFromSource = new String(identityMap, this.sourceEncoding);
                String unicodeFromTarget = new String(identityMap, this.targetEncoding);
                if (unicodeFromSource.equals(unicodeFromTarget)) {
                    ZUtil.logDiagnostic(4, "Identity transcoding table detected. No transcoding will occur.");
                    this.active = false;
                } else {
                    this.translateTable = unicodeFromSource.getBytes(this.targetEncoding);
                    this.translateBuffer = new byte[8092];
                }
            } else {
                ZUtil.logDiagnostic(4, "Multi-byte charset(s) detected. A Transcoder will be used.");
                this.translateTable = null;
            }
        }
        OutputStreamWriter osw = new OutputStreamWriter(this.out, this.targetEncoding);
        BufferedWriter bw = new BufferedWriter(osw);
        ZUtil.setObjectField(this, osw, "charOut", "Ljava/io/OutputStreamWriter;");
        ZUtil.setObjectField(this, bw, "textOut", "Ljava/io/BufferedWriter;");
    }

    @Override
    public void write(int b) {
        if (this.isActive()) {
            if (this.translateTable != null) {
                super.write(this.translateTable[b & 0xFF] & 0xFF);
            } else {
                this.transcode(new byte[]{(byte)(b & 0xFF)}, 0, 1);
            }
        } else {
            super.write(b);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (this.isActive()) {
            if (this.translateTable != null) {
                this.writeTranslatedBytes(buf, off, len);
            } else {
                this.transcode(buf, off, len);
            }
        } else {
            super.write(buf, off, len);
        }
    }

    private void transcode(byte[] buf, int off, int len) {
        try {
            this.getTranscoder().translate(buf, off, len);
        }
        catch (IOException ioe) {
            if (!this.checkError()) {
                System.err.println(Messages.getString("TranscodingPrintStream.TranscodingError") + ioe.getMessage());
            }
            this.setError();
        }
    }

    private synchronized void writeTranslatedBytes(byte[] buf, int off, int len) {
        if (len > this.translateBuffer.length) {
            this.translateBuffer = new byte[len * 5 / 4];
        }
        for (int i = 0; i < len; ++i) {
            this.translateBuffer[i] = this.translateTable[buf[i + off] & 0xFF];
        }
        super.write(this.translateBuffer, 0, len);
    }

    public boolean isActive() {
        return this.active;
    }

    public byte[] getTranslateTable() {
        return this.translateTable;
    }

    @Override
    public void flush() {
        if (this.isActive() && this.translateTable == null) {
            try {
                this.getTranscoder().flush();
            }
            catch (IOException ioe) {
                this.setError();
            }
        }
        super.flush();
    }

    private synchronized Transcoder getTranscoder() {
        Transcoder t = (Transcoder)this.transcoderThreadLocal.get();
        if (t == null) {
            t = new Transcoder(this.sourceEncoding, this.targetEncoding, this.out);
            t.setAutoFlush(true);
            this.transcoderThreadLocal.set(t);
        }
        return t;
    }
}

