/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.RauditxException;
import com.ibm.jzos.RauditxMessageHeader;
import com.ibm.jzos.RauditxParameters;
import com.ibm.jzos.RauditxRelocateHeader;
import com.ibm.jzos.ZUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class Rauditx {
    public static final long ATTR_EVENT_FAILURE = 0L;
    public static final long ATTR_EVENT_SUCCESS = 0x80000000L;
    public static final long ATTR_AUTHENTICATION_EVENT = 0x40000000L;
    public static final long ATTR_AUTHORIZATION_EVENT = 0x20000000L;
    public static final long ATTR_ALWAYS_LOG_SUCCESSES = 0x10000000L;
    public static final long ATTR_ALWAYS_LOG_FAILURES = 0x8000000L;
    public static final long ATTR_NEVER_LOG_SUCCESSES = 0x4000000L;
    public static final long ATTR_NEVER_LOG_FAILURES = 0x2000000L;
    public static final long ATTR_CHECK_WARNING_MODE = 0x1000000L;
    private static final byte[] LINK_VALUE_DEFAULT;
    private static final String RACF_CLASS_DEFAULT = "        ";
    private List messageSegments = new ArrayList();
    private int messageDataLen = 0;
    private List relocateSections = new ArrayList();
    private int relocateDataLen = 0;
    private RauditxParameters parms = new RauditxParameters();
    private boolean ignoreSuccessWithNoAuditLogRecord = false;

    public Rauditx() {
        this.setLinkValue(LINK_VALUE_DEFAULT);
        this.setRacfClass(RACF_CLASS_DEFAULT);
    }

    public void setAttributes(long attributeBits) {
        this.parms.setAttr(attributeBits);
    }

    public void setEventSuccess() {
        this.parms.setAttr(this.parms.getAttr() | 0x80000000L);
    }

    public void setEventFailure() {
        this.parms.setAttr(this.parms.getAttr() & 0xFFFFFFFF7FFFFFFFL);
    }

    public void setAuthorizationEvent() {
        this.parms.setAttr(this.parms.getAttr() | 0x20000000L);
    }

    public void setAuthenticationEvent() {
        this.parms.setAttr(this.parms.getAttr() | 0x40000000L);
    }

    public void setAlwaysLogSuccesses() {
        this.parms.setAttr(this.parms.getAttr() | 0x10000000L);
    }

    public void setNeverLogSuccesses() {
        this.parms.setAttr(this.parms.getAttr() | 0x4000000L);
    }

    public void setAlwaysLogFailures() {
        this.parms.setAttr(this.parms.getAttr() | 0x8000000L);
    }

    public void setNeverLogFailures() {
        this.parms.setAttr(this.parms.getAttr() | 0x2000000L);
    }

    public void setCheckWarningMode() {
        this.parms.setAttr(this.parms.getAttr() | 0x1000000L);
    }

    public void setRacfClass(String racfClass) {
        this.parms.setRacfCls(racfClass.toUpperCase());
    }

    public void setComponent(String component) {
        this.parms.setComp(component);
        this.parms.setCompLen(component.length());
    }

    public void setEvent(int event) {
        if (event < 1 || event > 255) {
            throw new IllegalArgumentException("event (" + event + ") must be between 1 and 255");
        }
        this.parms.setEvent(event);
    }

    public void setFmid(String fmid) {
        this.parms.setFmid(fmid);
    }

    public void setIgnoreSuccessWithNoAuditLogRecord(boolean ignoreSuccessWithNoAuditLogRecord) {
        this.ignoreSuccessWithNoAuditLogRecord = ignoreSuccessWithNoAuditLogRecord;
    }

    public void setLinkValue(byte[] bytes) {
        this.parms.setLinkval(bytes);
    }

    public void setLinkValue(String string) {
        try {
            this.setLinkValue(string.getBytes(ZUtil.getDefaultPlatformEncoding()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setLogString(String logString) {
        this.parms.setLog(logString);
        this.parms.setLogLen(logString.length());
    }

    public void setQualifier(int qualifier) {
        this.parms.setQualifier(qualifier);
    }

    public void setResource(String resource) {
        this.parms.setRes(resource);
        this.parms.setResLen(resource.length());
    }

    public void setSubtype(int subtype) {
        if (subtype < 2 || subtype > Short.MAX_VALUE) {
            throw new IllegalArgumentException("subtype (" + subtype + ") must be between 2 and 32767");
        }
        this.parms.setSubtype(subtype);
    }

    public void addMessageSegment(String message) {
        String msg = message.trim().toUpperCase();
        if (msg.length() > 70) {
            throw new IllegalArgumentException("Message segment must be <= 70 characters");
        }
        MessageSegment ms = new MessageSegment(message.toUpperCase());
        this.messageSegments.add(ms);
        this.messageDataLen += ms.getLen();
    }

    public void addRelocateSection(int type, byte[] data) {
        if (type < 100 || type > 65535) {
            throw new IllegalArgumentException("type (" + type + ") must be between 100 and 65535");
        }
        RelocateSection rs = new RelocateSection(type, data);
        this.relocateSections.add(rs);
        this.relocateDataLen += rs.getLen();
    }

    public void addRelocateSection(int type, String string) {
        try {
            this.addRelocateSection(type, string.getBytes(ZUtil.getDefaultPlatformEncoding()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void issue() throws RauditxException {
        this.validate();
        try {
            this.callRauditx(this.parms.getByteBuffer(), this.getRelocateBuffer(), this.getMessageBuffer());
        }
        catch (RauditxException rxe) {
            if (this.ignoreSuccessWithNoAuditLogRecord && rxe.getSafReturnCode() == 0 && rxe.getRacfReturnCode() == 0 && rxe.getRacfReasonCode() == 4) {
                return;
            }
            throw rxe;
        }
    }

    private void validate() {
        if (this.parms.getComp() == null || this.parms.getComp().trim().length() == 0) {
            throw new IllegalStateException("Component name required");
        }
        if (this.parms.getFmid() == null || this.parms.getFmid().trim().length() == 0) {
            throw new IllegalStateException("FMID required");
        }
        if (this.parms.getSubtype() < 2) {
            throw new IllegalStateException("Illegal value for Subtype (" + this.parms.getSubtype() + ") must be >=2");
        }
        if (this.parms.getEvent() < 1 || this.parms.getEvent() > 255) {
            throw new IllegalStateException("Illegal value for Event (" + this.parms.getEvent() + ") must be between 1 and 255");
        }
    }

    private byte[] getMessageBuffer() {
        this.parms.setMsgCnt(this.messageSegments.size());
        if (this.messageSegments.isEmpty()) {
            return null;
        }
        int hdrLen = RauditxMessageHeader._DEFAULT_LEN;
        int headerTotal = hdrLen * this.messageSegments.size();
        byte[] buffer = new byte[headerTotal + this.messageDataLen];
        int dataOffset = headerTotal;
        for (int i = 0; i < this.messageSegments.size(); ++i) {
            MessageSegment ms = (MessageSegment)this.messageSegments.get(i);
            System.arraycopy(ms.getByteBuffer(), 0, buffer, hdrLen * i, hdrLen);
            System.arraycopy(ms.getData(), 0, buffer, dataOffset, ms.getLen());
            dataOffset += ms.getLen();
        }
        return buffer;
    }

    private byte[] getRelocateBuffer() {
        this.parms.setRelCnt(this.relocateSections.size());
        if (this.relocateSections.isEmpty()) {
            return null;
        }
        int hdrLen = RauditxRelocateHeader._DEFAULT_LEN;
        int headerTotal = hdrLen * this.relocateSections.size();
        byte[] buffer = new byte[headerTotal + this.relocateDataLen];
        int dataOffset = headerTotal;
        for (int i = 0; i < this.relocateSections.size(); ++i) {
            RelocateSection rs = (RelocateSection)this.relocateSections.get(i);
            System.arraycopy(rs.getByteBuffer(), 0, buffer, hdrLen * i, hdrLen);
            System.arraycopy(rs.getData(), 0, buffer, dataOffset, rs.getLen());
            dataOffset += rs.getLen();
        }
        return buffer;
    }

    private native void callRauditx(byte[] var1, byte[] var2, byte[] var3) throws RauditxException;

    static {
        ZUtil.touch();
        RauditxParameters.RACF_CLS.setAllowTruncation(false);
        RauditxParameters.FMID.setAllowTruncation(false);
        RauditxParameters.COMP.setAllowTruncation(false);
        RauditxParameters.RES.setAllowTruncation(false);
        RauditxParameters.LOG.setAllowTruncation(false);
        LINK_VALUE_DEFAULT = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static class RelocateSection
    extends RauditxRelocateHeader {
        private byte[] data;

        public RelocateSection(int type, byte[] data) {
            this.data = data;
            this.setLen(data.length);
            this.setType(type);
        }

        public byte[] getData() {
            return this.data;
        }
    }

    private static class MessageSegment
    extends RauditxMessageHeader {
        private byte[] data;

        public MessageSegment(String message) {
            try {
                this.data = message.getBytes(ZUtil.getDefaultPlatformEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
            this.setLen(this.data.length);
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

