/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.JesSymbols;
import java.util.Map;

public class JesSymbolsException
extends RuntimeException {
    static final long serialVersionUID = 200L;
    private int rc;
    private int retcode;
    private int reason;
    private byte[] symbolTableBytes;

    public JesSymbolsException(String msg, int rc, int retcode, int reason, byte[] symbolTableBytes) {
        super(msg);
        this.rc = rc;
        this.retcode = retcode;
        this.reason = reason;
        this.symbolTableBytes = symbolTableBytes;
    }

    @Override
    public String getMessage() {
        if (this.rc != 0) {
            return super.getMessage() + " RC=" + this.rc;
        }
        return super.getMessage() + " retcode=" + this.retcode + " reason=" + this.reason;
    }

    public int getRc() {
        return this.rc;
    }

    public int getRetcode() {
        return this.retcode;
    }

    public int getReason() {
        return this.reason;
    }

    public Map<String, String> getSymbols() {
        Map<String, String> symbols = null;
        if (this.symbolTableBytes != null) {
            symbols = JesSymbols.buildMapFromJesSymbolTable(this.symbolTableBytes);
        }
        return symbols;
    }
}

