/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.JesSymbolTableEntry;
import com.ibm.jzos.JesSymbolTableHeader;
import com.ibm.jzos.JesSymbolsException;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZUtil;
import com.ibm.jzos.fields.BinaryAsIntField;
import com.ibm.jzos.fields.StringField;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JesSymbols {
    public static final int MAX_SYMBOL_NAME_LEN = 16;
    public static final int MAX_SYMBOL_VALUE_LEN = 4096;
    public static final String SYM_SYS_CORR_USRDATA = "SYS_CORR_USRDATA";
    private static final int JSYMLVLUD = 16;
    private static final int DALSYML_TU_KEY = 32811;
    private static final int DALSYML_INVALID_SYMBOL_ERROR = 58490923;
    static final String PRIMARY_SUBSYS;

    static String initPrimarySubsysInfo() {
        String primarySubsysName = null;
        int primarySubsysType = 0;
        long pCVT = ZUtil.peekOSMemory(16L, 4);
        long pJESCT = ZUtil.peekOSMemory(pCVT + 296L, 4);
        byte[] jespjesnm = new byte[4];
        ZUtil.peekOSMemory(pJESCT + 28L, jespjesnm);
        try {
            primarySubsysName = new String(jespjesnm, "IBM-1047").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] jesfg = new byte[1];
        ZUtil.peekOSMemory(pJESCT + 71L, jesfg);
        primarySubsysType = (jesfg[0] & 0x20) != 0 ? 3 : 2;
        return primarySubsysName;
    }

    private JesSymbols() {
        throw new UnsupportedOperationException("JesSymbols class cannot be instantiated");
    }

    public static void define(String symbol, String value, Level level, boolean replace) {
        if (symbol == null) {
            throw new NullPointerException("symbol is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        if (symbol.length() < 1 || symbol.length() > 16) {
            throw new IllegalArgumentException("Invalid symbol name '" + symbol + "'. Length must be between 1 and " + 16);
        }
        if (value.length() > 4096) {
            throw new IllegalArgumentException("Symbol value '" + value + "' exceeds maximum length " + 4096);
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        symbols.put(symbol, value);
        JesSymbols.define(symbols, level, replace);
    }

    public static void define(Map<String, String> symbols, Level level, boolean replace) {
        if (symbols == null) {
            throw new NullPointerException("symbol is null");
        }
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        if (symbols.isEmpty()) {
            return;
        }
        byte[] tableBytes = JesSymbols.getTableBytes(symbols);
        int levelOption = level.getValue();
        if (replace) {
            levelOption |= 0x10;
        }
        JesSymbols.nativeDefine(tableBytes, levelOption);
    }

    public static void delete(String symbolNameOrFilter) {
        if (symbolNameOrFilter == null) {
            throw new NullPointerException("symbolNameOrFilter is null");
        }
        if (symbolNameOrFilter.length() < 1 || symbolNameOrFilter.length() > 16) {
            throw new IllegalArgumentException("Invalid symbol name or filter '" + symbolNameOrFilter + "'. Length must be between 1 and " + 16);
        }
        ArrayList<String> names = new ArrayList<String>();
        names.add(symbolNameOrFilter);
        JesSymbols.delete(names);
    }

    public static void delete(Map<String, String> symbolNamesOrFilters) {
        if (symbolNamesOrFilters == null) {
            throw new NullPointerException("symbolNamesOrFilters is null");
        }
        if (symbolNamesOrFilters.isEmpty()) {
            return;
        }
        ArrayList<String> symbolNames = new ArrayList<String>(symbolNamesOrFilters.size());
        Iterator<String> e = symbolNamesOrFilters.keySet().iterator();
        while (e.hasNext()) {
            symbolNames.add(e.next());
        }
        JesSymbols.delete(symbolNames);
    }

    public static void delete(List<String> symbolNamesOrFilters) {
        if (symbolNamesOrFilters == null) {
            throw new NullPointerException("symbolNamesOrFilters is null");
        }
        if (symbolNamesOrFilters.isEmpty()) {
            return;
        }
        byte[] symbolNamesBytes = JesSymbols.getSymbolNamesBytes(symbolNamesOrFilters);
        JesSymbols.nativeDelete(symbolNamesBytes);
    }

    public static Map<String, String> extract(String symbolNameOrFilter) {
        if (symbolNameOrFilter == null) {
            throw new NullPointerException("symbolNameOrFilter is null");
        }
        ArrayList<String> names = new ArrayList<String>();
        names.add(symbolNameOrFilter);
        return JesSymbols.extract(names);
    }

    public static Map<String, String> extract(List<String> symbolNamesOrFilters) {
        if (symbolNamesOrFilters == null) {
            throw new NullPointerException("symbolNamesOrFilters is null");
        }
        if (symbolNamesOrFilters.isEmpty()) {
            return new HashMap<String, String>();
        }
        byte[] symbolNamesBytes = JesSymbols.getSymbolNamesBytes(symbolNamesOrFilters);
        byte[] tableBytes = JesSymbols.nativeExtract(symbolNamesBytes);
        Map<String, String> symbols = JesSymbols.buildMapFromJesSymbolTable(tableBytes);
        return symbols;
    }

    static String allocReader(String subsystem, String rdrClass, int lrecl, boolean isVariable, Map<String, String> symbols) throws RcException {
        List<String> symbolNames = JesSymbols.getMapKeys(symbols);
        return JesSymbols.allocReader(subsystem, rdrClass, lrecl, isVariable, symbolNames);
    }

    static String allocReader(String subsystem, String rdrClass, int lrecl, boolean isVariable, List<String> symbolNames) throws RcException {
        if (rdrClass == null || rdrClass.length() != 1) {
            throw new IllegalArgumentException("rdrClass is null or has length greater than 1");
        }
        subsystem = subsystem == null || subsystem.equals("") ? PRIMARY_SUBSYS : subsystem.trim();
        byte[] symbolNamesTU = JesSymbols.getSymbolNamesTU(symbolNames);
        return JesSymbols.nativeAllocReader(subsystem, rdrClass, lrecl, isVariable, symbolNamesTU);
    }

    private static native void nativeDefine(byte[] var0, int var1) throws JesSymbolsException;

    private static native void nativeDelete(byte[] var0) throws JesSymbolsException;

    private static native byte[] nativeExtract(byte[] var0) throws JesSymbolsException;

    private static native String nativeAllocReader(String var0, String var1, int var2, boolean var3, byte[] var4) throws RcException;

    private static byte[] getTableBytes(Map<String, String> symbols) {
        int count = symbols.size();
        int totalValuesLength = 0;
        for (String key : symbols.keySet()) {
            if (key == null) {
                throw new NullPointerException("symbol name is null ");
            }
            if (key.length() < 1 || key.length() > 16) {
                throw new IllegalArgumentException("Invalid symbol name '" + key + "'. Length must be between 1 and " + 16);
            }
            String value = symbols.get(key);
            if (value == null) {
                throw new NullPointerException("value for the symbol " + key + " is null");
            }
            if (value.length() > 4096) {
                throw new IllegalArgumentException("Symbol value '" + value + "' exceeds maximum length " + 4096);
            }
            totalValuesLength += value.length();
        }
        int buflen = 32 + count * 24 + totalValuesLength;
        JesSymbolTableHeader header = new JesSymbolTableHeader(new byte[buflen], 0);
        header.setJsyteye("JSYT");
        header.setJsytlen(buflen);
        header.setJsytver(1);
        header.setJsytent1(32);
        header.setJsytent_hash(count);
        header.setJsytents(24);
        int entOff = 32;
        int valOff = entOff + count * 24;
        for (String key : symbols.keySet()) {
            String value = symbols.get(key);
            JesSymbolTableEntry entry = new JesSymbolTableEntry(header._byteBuffer, entOff);
            entry.setJsyename(key);
            entry.setJsyevalo(valOff);
            entry.setJsyevals(value.length());
            StringField sf = new StringField(valOff, value.length());
            sf.putString(value, header._byteBuffer);
            entOff += 24;
            valOff += value.length();
        }
        return header._byteBuffer;
    }

    static Map<String, String> buildMapFromJesSymbolTable(byte[] tableBytes) {
        HashMap<String, String> symbols = new HashMap<String, String>();
        JesSymbolTableHeader header = new JesSymbolTableHeader(tableBytes, 0);
        int count = header.getJsytent_hash();
        int entOff = 32;
        for (int i = 0; i < count; ++i) {
            JesSymbolTableEntry entry = new JesSymbolTableEntry(header._byteBuffer, entOff);
            String key = entry.getJsyename().trim();
            int valOff = entry.getJsyevalo();
            int valLen = entry.getJsyevals();
            StringField sf = new StringField(valOff, valLen, false);
            String value = sf.getString(header._byteBuffer);
            symbols.put(key, value);
            entOff += 24;
        }
        return symbols;
    }

    private static List<String> getMapKeys(Map<String, String> dict) {
        if (dict == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(dict.size());
        Iterator<String> e = dict.keySet().iterator();
        while (e.hasNext()) {
            list.add(e.next());
        }
        return list;
    }

    private static byte[] getSymbolNamesBytes(List<String> symbolNames) {
        byte[] buf = new byte[symbolNames.size() * 16];
        StringField sf = new StringField(0, 16, false, false, false);
        int off = 0;
        for (String name : symbolNames) {
            if (name == null) {
                throw new NullPointerException("symbol name is null");
            }
            if (name.length() < 1 || name.length() > 16) {
                throw new IllegalArgumentException("Invalid symbol name '" + name + "'. Length must be between 1 and " + 16);
            }
            sf.putString(name, buf, off);
            off += 16;
        }
        return buf;
    }

    private static byte[] getSymbolNamesTU(List<String> symbolNames) {
        byte[] symbolNamesTU = null;
        if (symbolNames != null && symbolNames.size() > 0) {
            int totalNamesLength = 0;
            for (String symbol : symbolNames) {
                totalNamesLength += symbol.length();
            }
            symbolNamesTU = new byte[4 + 2 * symbolNames.size() + totalNamesLength];
            BinaryAsIntField ushortField = new BinaryAsIntField(0, 2, false);
            int off = 0;
            ushortField.putInt(32811, symbolNamesTU, off);
            ushortField.putInt(symbolNames.size(), symbolNamesTU, off += 2);
            off += 2;
            for (String symbol : symbolNames) {
                ushortField.putInt(symbol.length(), symbolNamesTU, off);
                StringField sf = new StringField(off += 2, symbol.length());
                sf.putString(symbol, symbolNamesTU);
                off += symbol.length();
            }
        }
        return symbolNamesTU;
    }

    static {
        ZUtil.touch();
        PRIMARY_SUBSYS = JesSymbols.initPrimarySubsysInfo();
    }

    public static enum Level {
        TASK(128),
        JOBSTEP(64);

        private final int value;

        public int getValue() {
            return this.value;
        }

        private Level(int value) {
            this.value = value;
        }
    }
}

