/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Messages;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileFactory {
    private FileFactory() {
    }

    public static InputStream newInputStream(String filename) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException(Messages.getString("FileFactory.FilenameNullError"));
        }
        if (filename.startsWith("//")) {
            return FileFactory.makeZFileInputStream(filename);
        }
        return FileFactory.makeJavaIoInputStream(filename);
    }

    public static BufferedInputStream newBufferedInputStream(String filename, int bsize) throws IOException {
        return new BufferedInputStream(FileFactory.newInputStream(filename), bsize);
    }

    public static BufferedInputStream newBufferedInputStream(String filename) throws IOException {
        return new BufferedInputStream(FileFactory.newInputStream(filename));
    }

    public static OutputStream newOutputStream(String filename) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException(Messages.getString("FileFactory.FilenameNullError"));
        }
        if (filename.startsWith("//")) {
            return FileFactory.makeZFileOutputStream(filename);
        }
        return FileFactory.makeJavaIoOutputStream(filename);
    }

    public static BufferedOutputStream newBufferedOutputStream(String filename, int bsize) throws IOException {
        return new BufferedOutputStream(FileFactory.newOutputStream(filename), bsize);
    }

    public static BufferedOutputStream newBufferedOutputStream(String filename) throws IOException {
        return new BufferedOutputStream(FileFactory.newOutputStream(filename));
    }

    public static BufferedReader newBufferedReader(String filename, String encoding, int bsize) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException(Messages.getString("FileFactory.FilenameNullError"));
        }
        if (filename.startsWith("//")) {
            return FileFactory.makeZFileReader(filename, encoding, bsize);
        }
        return FileFactory.makeJavaIoReader(filename, encoding, bsize);
    }

    public static BufferedReader newBufferedReader(String filename, String encoding) throws IOException {
        return FileFactory.newBufferedReader(filename, encoding, -1);
    }

    public static BufferedReader newBufferedReader(String filename) throws IOException {
        return FileFactory.newBufferedReader(filename, null, -1);
    }

    public static BufferedWriter newBufferedWriter(String filename, String encoding, int bsize) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException(Messages.getString("FileFactory.FilenameNullError"));
        }
        if (filename.startsWith("//")) {
            return FileFactory.makeZFileWriter(filename, encoding, bsize);
        }
        return FileFactory.makeJavaIoWriter(filename, encoding, bsize);
    }

    public static BufferedWriter newBufferedWriter(String filename, String encoding) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException(Messages.getString("FileFactory.FilenameNullError"));
        }
        if (filename.startsWith("//")) {
            return FileFactory.makeZFileWriter(filename, encoding, -1);
        }
        return FileFactory.makeJavaIoWriter(filename, encoding, -1);
    }

    public static BufferedWriter newBufferedWriter(String filename) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException(Messages.getString("FileFactory.FilenameNullError"));
        }
        if (filename.startsWith("//")) {
            return FileFactory.makeZFileWriter(filename, null, -1);
        }
        return FileFactory.makeJavaIoWriter(filename, null, -1);
    }

    public static String getDefaultEncoding(String filename) {
        if (filename.startsWith("//")) {
            return FileFactory.getDefaultZFileEncoding();
        }
        return FileFactory.getDefaultJavaIoEncoding();
    }

    public static String getDefaultZFileEncoding() {
        return ZUtil.getDefaultPlatformEncoding();
    }

    public static String getDefaultJavaIoEncoding() {
        return System.getProperty("file.encoding", "ISO-8859-1");
    }

    private static BufferedReader makeJavaIoReader(String filename, String encoding, int bsize) throws IOException {
        FileInputStream is = new FileInputStream(filename);
        if (encoding == null) {
            if (bsize <= 0) {
                return new BufferedReader(new InputStreamReader(is));
            }
            return new BufferedReader(new InputStreamReader(is), bsize);
        }
        if (bsize <= 0) {
            return new BufferedReader(new InputStreamReader((InputStream)is, encoding));
        }
        return new BufferedReader(new InputStreamReader((InputStream)is, encoding), bsize);
    }

    private static BufferedWriter makeJavaIoWriter(String filename, String encoding, int bsize) throws IOException {
        FileOutputStream os = new FileOutputStream(filename);
        if (encoding == null) {
            if (bsize <= 0) {
                return new BufferedWriter(new OutputStreamWriter(os));
            }
            return new BufferedWriter(new OutputStreamWriter(os), bsize);
        }
        if (bsize <= 0) {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)os, encoding));
        }
        return new BufferedWriter(new OutputStreamWriter((OutputStream)os, encoding), bsize);
    }

    private static BufferedReader makeZFileReader(String filename, String encoding, int bsize) throws IOException {
        ZFile zFile = new ZFile(filename, "rt");
        InputStream is = zFile.getInputStream();
        if (encoding == null) {
            encoding = FileFactory.getDefaultZFileEncoding();
        }
        if (bsize <= 0) {
            return new BufferedReader(new InputStreamReader(is, encoding));
        }
        return new BufferedReader(new InputStreamReader(is, encoding), bsize);
    }

    private static BufferedWriter makeZFileWriter(String filename, String encoding, int bsize) throws IOException {
        ZFile zFile = new ZFile(filename, "wt");
        OutputStream os = zFile.getOutputStream();
        if (encoding == null) {
            encoding = FileFactory.getDefaultZFileEncoding();
        }
        if (bsize <= 0) {
            return new BufferedWriter(new OutputStreamWriter(os, encoding));
        }
        return new BufferedWriter(new OutputStreamWriter(os, encoding), bsize);
    }

    private static InputStream makeZFileInputStream(String filename) throws IOException {
        ZFile zFile = new ZFile(filename, "rt");
        return zFile.getInputStream();
    }

    private static OutputStream makeZFileOutputStream(String filename) throws IOException {
        ZFile zFile = new ZFile(filename, "wt");
        return zFile.getOutputStream();
    }

    private static InputStream makeJavaIoInputStream(String filename) throws IOException {
        return new FileInputStream(filename);
    }

    private static OutputStream makeJavaIoOutputStream(String filename) throws IOException {
        return new FileOutputStream(filename);
    }
}

