/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ZUtil;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;

public final class FileAttribute {
    private static final int SECURITY_LABEL_LENGTH = 8;

    private FileAttribute() {
        throw new UnsupportedOperationException("New instance is not allowed");
    }

    public static void setSharedLibrary(String pathname, boolean value) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        ZUtil.logDiagnostic(5, String.format("FileAttribute.setSharedLibrary() pathname=%s, value=%b", pathname, value));
        ChattrCaller chattr = new ChattrCaller(pathname);
        chattr.sharedLibrary(value).call();
    }

    public static void setNoShareas(String pathname, boolean value) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        ZUtil.logDiagnostic(5, String.format("FileAttribute.setNoShareas() pathname=%s, value=%b", pathname, value));
        ChattrCaller chattr = new ChattrCaller(pathname);
        chattr.noShareas(value).call();
    }

    public static void setApfAuthorized(String pathname, boolean value) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        ZUtil.logDiagnostic(5, String.format("FileAttribute.setApfAuthorized() pathname=%s, value=%b", pathname, value));
        ChattrCaller chattr = new ChattrCaller(pathname);
        chattr.apfAuthorized(value).call();
    }

    public static void setProgramControlled(String pathname, boolean value) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        ZUtil.logDiagnostic(5, String.format("FileAttribute.setProgramControlled() pathname=%s, value=%b", pathname, value));
        ChattrCaller chattr = new ChattrCaller(pathname);
        chattr.progControlled(value).call();
    }

    public static void setAuditorAuditInfo(String pathname, int info) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        ZUtil.logDiagnostic(5, String.format("FileAttribute.setAuditorAuditInfo() pathname=%s, info=0x%08x", pathname, info));
        ChattrCaller chattr = new ChattrCaller(pathname);
        chattr.auditorAuditInfo(info).call();
    }

    public static void setUserAuditInfo(String pathname, int info) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        ZUtil.logDiagnostic(5, String.format("FileAttribute.setUserAuditInfo() pathname=%s, info=0x%08x", pathname, info));
        ChattrCaller chattr = new ChattrCaller(pathname);
        chattr.userAuditInfo(info).call();
    }

    public static void setChangeTime(String pathname) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        ZUtil.logDiagnostic(5, "FileAttribute.setChangeTime() pathname=" + pathname);
        ChattrCaller chattr = new ChattrCaller(pathname);
        chattr.changeTimeTOD().call();
    }

    public static void setChangeTime(String pathname, FileTime time) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        ZUtil.logDiagnostic(5, String.format("FileAttribute.setChangeTime() pathname=%s, time=%s", pathname, time));
        if (time == null) {
            FileAttribute.setChangeTime(pathname);
        } else {
            long changeTime = time.to(TimeUnit.SECONDS);
            if (changeTime < 0L) {
                throw new IllegalArgumentException("Time value prior to 1970 is not supported");
            }
            String bitmode = System.getProperty("com.ibm.vm.bitmode");
            if (bitmode != null && bitmode.equalsIgnoreCase("32") && changeTime > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Supplied time value is too large");
            }
            ChattrCaller chattr = new ChattrCaller(pathname);
            chattr.changeTime(changeTime).call();
        }
    }

    public static void setFormat(String pathname, byte format) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        ZUtil.logDiagnostic(5, String.format("FileAttribute.setFormat() pathname=%s, format=0x%02x", pathname, format));
        ChattrCaller chattr = new ChattrCaller(pathname);
        chattr.fileFormat(format).call();
    }

    public static void setTag(String pathname, Tag tag) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        if (tag == null) {
            throw new NullPointerException("tag is null");
        }
        char characterSetID = tag.getCodeCharacterSetID();
        boolean textOnly = tag.isTextOnly();
        ZUtil.logDiagnostic(5, String.format("FileAttribute.setTag() pathname=%s, characterSetID=%d, textOnly=%b", pathname, (int)characterSetID, textOnly));
        ChattrCaller chattr = new ChattrCaller(pathname);
        chattr.tag(characterSetID, textOnly).call();
    }

    public static void setSecurityLabel(String pathname, String label) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        if (label == null) {
            throw new NullPointerException("label is null");
        }
        if (label.length() > 8) {
            throw new IllegalArgumentException("label may contain at most 8 characters");
        }
        ZUtil.logDiagnostic(5, String.format("FileAttribute.setSecurityLabel() pathname=%s, label='%s'", pathname, label));
        String paddedLabel = String.format("%-8s", label);
        ChattrCaller chattr = new ChattrCaller(pathname);
        chattr.securityLabel(paddedLabel).call();
    }

    public static Stat getStat(String pathname) {
        if (pathname == null) {
            throw new NullPointerException("pathname is null");
        }
        ZUtil.logDiagnostic(5, "FileAttribute.getStat() pathname=" + pathname);
        return FileAttribute.stat(pathname);
    }

    private static native void chattr(String var0, boolean var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, boolean var12, boolean var13, boolean var14, boolean var15, boolean var16, int var17, int var18, long var19, byte var21, char var22, boolean var23, String var24);

    private static native Stat stat(String var0);

    static {
        ZUtil.touch();
    }

    public static final class Stat {
        private final boolean sharedLibraryFlag;
        private final boolean noShareasFlag;
        private final boolean apfAuthorizedFlag;
        private final boolean progControlledFlag;
        private final int auditorAuditInfo;
        private final int userAuditInfo;
        private final long changeTime;
        private final byte fileFormat;
        private final char characterSetID;
        private final boolean textFlag;
        private final String securityLabel;

        private Stat(boolean sharedLibraryFlag, boolean noShareasFlag, boolean apfAuthorizedFlag, boolean progControlledFlag, int auditorAuditInfo, int userAuditInfo, long changeTime, byte fileFormat, char characterSetID, boolean textFlag, String securityLabel) {
            ZUtil.logDiagnostic(5, String.format("FileAttribute.Stat() sharedLibraryFlag=%b, noShareasFlag=%b, apfAuthorizedFlag=%b, progControlledFlag=%b, auditorAuditInfo=0x%08x, userAuditInfo=0x%08x, changeTime (seconds)=%d, fileFormat=0x%02x, characterSetID=%d, textFlag=%b, securityLabel='%s'", sharedLibraryFlag, noShareasFlag, apfAuthorizedFlag, progControlledFlag, auditorAuditInfo, userAuditInfo, changeTime, fileFormat, (int)characterSetID, textFlag, securityLabel));
            this.sharedLibraryFlag = sharedLibraryFlag;
            this.noShareasFlag = noShareasFlag;
            this.apfAuthorizedFlag = apfAuthorizedFlag;
            this.progControlledFlag = progControlledFlag;
            this.auditorAuditInfo = auditorAuditInfo;
            this.userAuditInfo = userAuditInfo;
            this.changeTime = changeTime;
            this.fileFormat = fileFormat;
            this.characterSetID = characterSetID;
            this.textFlag = textFlag;
            this.securityLabel = securityLabel;
        }

        public boolean isSharedLibrary() {
            return this.sharedLibraryFlag;
        }

        public boolean isNoShareas() {
            return this.noShareasFlag;
        }

        public boolean isApfAuthorized() {
            return this.apfAuthorizedFlag;
        }

        public boolean isProgControlled() {
            return this.progControlledFlag;
        }

        public int getAuditorAuditInfo() {
            return this.auditorAuditInfo;
        }

        public int getUserAuditInfo() {
            return this.userAuditInfo;
        }

        public long getChangeTimeInSeconds() {
            return this.changeTime;
        }

        public FileTime getChangeTime() {
            return FileTime.from(this.changeTime, TimeUnit.SECONDS);
        }

        public byte getFormat() {
            return this.fileFormat;
        }

        public Tag getTag() {
            return new Tag(this.characterSetID, this.textFlag);
        }

        public String getSecurityLabel() {
            return this.securityLabel;
        }
    }

    public static final class Tag {
        public static final char CCSID_ISO_8859_1 = '\u0333';
        public static final char CCSID_IBM_1047 = '\u0417';
        private final char characterSetID;
        private final boolean textFlag;

        public Tag(char characterSetID, boolean textFlag) {
            ZUtil.logDiagnostic(5, String.format("FileAttribute.Tag() characterSetID=%d, textFlag=%b", characterSetID, textFlag));
            this.characterSetID = characterSetID;
            this.textFlag = textFlag;
        }

        public char getCodeCharacterSetID() {
            return this.characterSetID;
        }

        public boolean isTextOnly() {
            return this.textFlag;
        }
    }

    private static final class ChattrCaller {
        private final String pathname;
        private boolean setGeneralAttributes = false;
        private boolean setAuditorAuditInfo = false;
        private boolean setUserAuditInfo = false;
        private boolean setChangeTime = false;
        private boolean setChangeTimeTOD = false;
        private boolean setFileFormat = false;
        private boolean setFileTag = false;
        private boolean setSecurityLabel = false;
        private boolean setSharedLibrary = false;
        private boolean setNoShareas = false;
        private boolean setApfAuthorized = false;
        private boolean setProgControlled = false;
        private boolean sharedLibrary = false;
        private boolean noShareas = false;
        private boolean apfAuthorized = false;
        private boolean progControlled = false;
        private int auditorAuditInfo = 0;
        private int userAuditInfo = 0;
        private long changeTime = 0L;
        private byte fileFormat = 0;
        private char tagCharacterSetID = '\u0000';
        private boolean tagText = false;
        private String securityLabel = null;

        private ChattrCaller(String pathname) {
            if (pathname == null) {
                throw new NullPointerException("pathname is null");
            }
            this.pathname = pathname;
        }

        private ChattrCaller sharedLibrary(boolean value) {
            this.setGeneralAttributes = true;
            this.setSharedLibrary = true;
            this.sharedLibrary = value;
            return this;
        }

        private ChattrCaller noShareas(boolean value) {
            this.setGeneralAttributes = true;
            this.setNoShareas = true;
            this.noShareas = value;
            return this;
        }

        private ChattrCaller apfAuthorized(boolean value) {
            this.setGeneralAttributes = true;
            this.setApfAuthorized = true;
            this.apfAuthorized = value;
            return this;
        }

        private ChattrCaller progControlled(boolean value) {
            this.setGeneralAttributes = true;
            this.setProgControlled = true;
            this.progControlled = value;
            return this;
        }

        private ChattrCaller auditorAuditInfo(int value) {
            this.setAuditorAuditInfo = true;
            this.auditorAuditInfo = value;
            return this;
        }

        private ChattrCaller userAuditInfo(int value) {
            this.setUserAuditInfo = true;
            this.userAuditInfo = value;
            return this;
        }

        private ChattrCaller changeTimeTOD() {
            this.setChangeTime = false;
            this.changeTime = 0L;
            this.setChangeTimeTOD = true;
            return this;
        }

        private ChattrCaller changeTime(long value) {
            this.setChangeTimeTOD = false;
            this.setChangeTime = true;
            this.changeTime = value;
            return this;
        }

        private ChattrCaller fileFormat(byte value) {
            this.setFileFormat = true;
            this.fileFormat = value;
            return this;
        }

        private ChattrCaller tag(char characterSet, boolean text) {
            this.setFileTag = true;
            this.tagCharacterSetID = characterSet;
            this.tagText = text;
            return this;
        }

        private ChattrCaller securityLabel(String value) {
            if (value == null) {
                throw new NullPointerException("value is null");
            }
            if (value.length() != 8) {
                throw new IllegalArgumentException("value must be 8 characters long");
            }
            this.setSecurityLabel = true;
            this.securityLabel = value;
            return this;
        }

        private void call() {
            FileAttribute.chattr(this.pathname, this.setGeneralAttributes, this.setAuditorAuditInfo, this.setUserAuditInfo, this.setChangeTime, this.setChangeTimeTOD, this.setFileFormat, this.setFileTag, this.setSecurityLabel, this.setSharedLibrary, this.setNoShareas, this.setApfAuthorized, this.setProgControlled, this.sharedLibrary, this.noShareas, this.apfAuthorized, this.progControlled, this.auditorAuditInfo, this.userAuditInfo, this.changeTime, this.fileFormat, this.tagCharacterSetID, this.tagText, this.securityLabel);
        }
    }
}

