/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Messages;
import com.ibm.jzos.ZUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class Exec {
    public static final String CHILD_PROCESS_INPUT_ENCODING_PROPERTY = "com.ibm.jzos.Exec.input.encoding";
    private String command;
    private String[] cmdargs;
    private String[] envp;
    private File dir;
    private Process process;
    private boolean completed;
    private boolean timedOut;
    private boolean destroyed;
    private BufferedReader stdoutReader;
    private InputStream stdoutStream;
    private BufferedWriter stdinWriter;
    private StdErrConsumer stdErrConsumer = new StdErrConsumer();
    private Thread stdErrConsumerThread;
    private ProcessHealthTimerTask healthTimerTask = new ProcessHealthTimerTask();
    private Timer healthTimer = new Timer();

    public Exec(String command) {
        this(command, null, null);
    }

    public Exec(String command, String[] envp) {
        this(command, envp, null);
    }

    public Exec(String command, String[] envp, File dir) {
        this.command = command;
        this.envp = envp;
        this.dir = dir;
    }

    public Exec(String[] cmdargs) {
        this(cmdargs, null, null);
    }

    public Exec(String[] cmdargs, String[] envp) {
        this(cmdargs, envp, null);
    }

    public Exec(String[] cmdargs, String[] envp, File dir) {
        this.cmdargs = cmdargs;
        this.envp = envp;
        this.dir = dir;
    }

    public static void main(String[] args) throws IOException {
        String line;
        Exec exec;
        if (args.length == 0) {
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            System.out.println(Messages.getString("Exec.EnterCommandPrompt"));
            exec = new Exec(stdin.readLine());
        } else {
            exec = new Exec(args);
        }
        exec.run();
        while ((line = exec.readLine()) != null) {
            System.out.println(line);
        }
        System.out.println(Messages.getString("Exec.ReturnCode") + exec.getReturnCode());
        Iterator iter = exec.getErrorLines().iterator();
        while (iter.hasNext()) {
            System.err.println(iter.next());
        }
    }

    public static String getChildProcessInputEncoding() {
        String encoding = System.getProperty(CHILD_PROCESS_INPUT_ENCODING_PROPERTY);
        if (encoding != null) {
            return encoding;
        }
        if (System.getProperty("java.version").startsWith("1.4")) {
            return ZUtil.getCodePageCurrentLocale();
        }
        return System.getProperty("file.encoding", ZUtil.getCodePageCurrentLocale());
    }

    public List getErrorLines() {
        return this.stdErrConsumer.getErrorLines();
    }

    public void setMaxErrorLines(int maxErrorLines) {
        this.stdErrConsumer.setMaxLines(maxErrorLines);
    }

    public int getMaxErrorLines() {
        return this.stdErrConsumer.getMaxLines();
    }

    public int getReturnCode() {
        if (!this.completed && !this.destroyed) {
            while (true) {
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.healthTimer.cancel();
            try {
                this.stdErrConsumerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.completed = true;
        }
        try {
            return this.process.exitValue();
        }
        catch (IllegalThreadStateException tse) {
            while (true) {
                try {
                    return this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public OutputStream getStdinStream() {
        return this.process.getOutputStream();
    }

    public BufferedWriter getStdinWriter() {
        if (this.stdinWriter == null) {
            this.stdinWriter = this.getEncodedOutputStreamWriter(this.getStdinStream());
        }
        return this.stdinWriter;
    }

    public void setTimeout(int timeout) {
        this.healthTimerTask.setTimeout(timeout);
    }

    public void consumeOutput(StringBuffer buf) throws IOException {
        String line;
        BufferedReader rdr = this.getOutputReader();
        while ((line = rdr.readLine()) != null) {
            buf.append(line);
            buf.append('\n');
        }
    }

    public void consumeOutput() throws IOException {
        BufferedReader rdr = this.getOutputReader();
        while (rdr.readLine() != null) {
        }
    }

    public String readLine() throws IOException {
        return this.getOutputReader().readLine();
    }

    public BufferedReader getOutputReader() {
        if (this.stdoutStream != null) {
            throw new IllegalStateException("getOutputReader cannot be used with getStdoutStream");
        }
        if (this.stdoutReader == null) {
            this.stdoutReader = new BufferedReader(this.getEncodedInputStreamReader(this.process.getInputStream())){

                @Override
                public int read() throws IOException {
                    Exec.this.updateHealthTimer();
                    return super.read();
                }

                @Override
                public int read(char[] b, int o, int l) throws IOException {
                    Exec.this.updateHealthTimer();
                    return super.read(b, o, l);
                }

                @Override
                public int read(char[] b) throws IOException {
                    return this.read(b, 0, b.length);
                }

                @Override
                public String readLine() throws IOException {
                    Exec.this.updateHealthTimer();
                    return super.readLine();
                }
            };
        }
        return this.stdoutReader;
    }

    public InputStream getStdoutStream() {
        if (this.stdoutReader != null) {
            throw new IllegalStateException("getInputStream cannot be used with getOutputReader");
        }
        if (this.stdoutStream == null) {
            this.stdoutStream = new BufferedInputStream(this.process.getInputStream()){

                @Override
                public int available() {
                    return 1;
                }

                @Override
                public int read() throws IOException {
                    Exec.this.updateHealthTimer();
                    return super.read();
                }

                @Override
                public int read(byte[] b, int o, int l) throws IOException {
                    Exec.this.updateHealthTimer();
                    return super.read(b, o, l);
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return this.read(b, 0, b.length);
                }
            };
        }
        return this.stdoutStream;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void run() throws IOException {
        this.process = this.command != null ? Runtime.getRuntime().exec(this.command, this.envp, this.dir) : Runtime.getRuntime().exec(this.cmdargs, this.envp, this.dir);
        this.healthTimer.schedule((TimerTask)this.healthTimerTask, 1000L, 1000L);
        this.stdErrConsumerThread = new Thread(this.stdErrConsumer);
        this.stdErrConsumerThread.start();
    }

    public void updateHealthTimer() {
        this.healthTimerTask.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        Exec exec = this;
        synchronized (exec) {
            this.process.destroy();
            this.destroyed = true;
        }
        this.healthTimer.cancel();
        this.stdErrConsumer.setStopRequested(true);
        this.stdErrConsumerThread.interrupt();
        try {
            this.stdErrConsumerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Reader getEncodedInputStreamReader(InputStream is) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(is, ZUtil.getCodePageCurrentLocale());
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unsupported encoding", uee);
        }
        return reader;
    }

    private BufferedWriter getEncodedOutputStreamWriter(OutputStream os) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(os, Exec.getChildProcessInputEncoding()));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unsupported encoding", uee);
        }
        return writer;
    }

    private class ProcessHealthTimerTask
    extends TimerTask {
        private volatile long lastResponseTime = System.currentTimeMillis();
        private int timeout = 10000;

        private ProcessHealthTimerTask() {
        }

        void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        synchronized void update() {
            this.lastResponseTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currentTimeMillis;
            ProcessHealthTimerTask processHealthTimerTask = this;
            synchronized (processHealthTimerTask) {
                currentTimeMillis = System.currentTimeMillis();
                if (this.timeout == 0 || this.lastResponseTime + (long)this.timeout >= currentTimeMillis) {
                    return;
                }
            }
            System.err.println(Exec.class.getName() + Messages.getString("Exec.TimerTaskTimeout") + " lastResponseTime=" + this.lastResponseTime + ", timeout=" + this.timeout + ", currentTime=" + currentTimeMillis + ".");
            Exec.this.timedOut = true;
            Exec.this.destroy();
        }
    }

    private class StdErrConsumer
    implements Runnable {
        private volatile boolean stopRequested = false;
        private int maxLines = 50;
        private List errorLines = new ArrayList();

        private StdErrConsumer() {
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader reader = new BufferedReader(Exec.this.getEncodedInputStreamReader(Exec.this.process.getErrorStream()));
                int lineCount = 0;
                while (!this.stopRequested && (line = reader.readLine()) != null) {
                    if (this.maxLines > 0 && lineCount < this.maxLines) {
                        this.errorLines.add(line);
                        ++lineCount;
                    }
                    Exec.this.updateHealthTimer();
                }
            }
            catch (InterruptedIOException interIO) {
                System.err.println(Messages.getString("Exec.StdErrorThreadInterrupted"));
            }
            catch (IOException ioe) {
                System.err.println(Messages.getString("Exec.ExternalProcessException") + ioe.toString());
            }
        }

        public int getMaxLines() {
            return this.maxLines;
        }

        public void setMaxLines(int maxLines) {
            this.maxLines = maxLines;
        }

        public boolean isStopRequested() {
            return this.stopRequested;
        }

        public void setStopRequested(boolean stopRequested) {
            this.stopRequested = stopRequested;
        }

        public List getErrorLines() {
            return this.errorLines;
        }
    }
}

