/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.BufferCompressor;
import com.ibm.jzos.ZCompressor;
import com.ibm.jzos.ZCompressorInputStream;
import com.ibm.jzos.ZCompressorOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class CompressionFactory {
    public static final String PROPERTY_COMPRESSION_TYPE = "com.ibm.jzos.compression.type";
    public static final String DEFAULT_COMPRESSION_TYPE = Algorithm.gzip.toString();
    private static CompressionFactory defaultFactory = null;
    private Algorithm algorithm;
    private String[] algorithmParms;
    private ZCompressor zcompressor;
    private boolean doRelease = true;

    public static synchronized CompressionFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = new CompressionFactory(System.getProperty(PROPERTY_COMPRESSION_TYPE, DEFAULT_COMPRESSION_TYPE));
            CompressionFactory.defaultFactory.doRelease = false;
        }
        return defaultFactory;
    }

    public static synchronized void releaseDefault() {
        if (defaultFactory != null) {
            CompressionFactory.defaultFactory.doRelease = true;
            defaultFactory.release();
            defaultFactory = null;
        }
    }

    public static CompressionFactory getFactory(Algorithm algorithm, String parms) {
        return new CompressionFactory(algorithm, parms);
    }

    private CompressionFactory(Algorithm algorithm, String parms) {
        this.algorithm = algorithm;
        this.algorithmParms = parms != null && parms.length() > 0 ? parms.split(":") : new String[0];
    }

    private CompressionFactory(String argString) throws IllegalArgumentException {
        String[] parms = argString.split(":");
        this.algorithm = Algorithm.valueOf(parms[0]);
        this.algorithmParms = new String[parms.length - 1];
        System.arraycopy(parms, 1, this.algorithmParms, 0, this.algorithmParms.length);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String[] getAlgorithmParms() {
        return this.algorithmParms;
    }

    public OutputStream getCompressingOutputStream(OutputStream out) throws IOException {
        switch (this.algorithm) {
            case zcmpsc: {
                return new ZCompressorOutputStream(this.makeZCompressor(), out);
            }
            case gzip: {
                return new GZIPOutputStream(out);
            }
            case deflate: {
                return new DeflaterOutputStream(out, this.makeDeflater());
            }
        }
        throw new IllegalArgumentException("Missing algorithm: " + (Object)((Object)this.algorithm));
    }

    public OutputStream getCompressingOutputStream(OutputStream out, int bufsize) throws IOException {
        switch (this.algorithm) {
            case zcmpsc: {
                return new ZCompressorOutputStream(this.makeZCompressor(), out, bufsize);
            }
            case gzip: {
                return new GZIPOutputStream(out, bufsize);
            }
            case deflate: {
                return new DeflaterOutputStream(out, this.makeDeflater(), bufsize);
            }
        }
        throw new IllegalArgumentException("Missing algorithm: " + (Object)((Object)this.algorithm));
    }

    public InputStream getExpandingInputStream(InputStream in) throws IOException {
        switch (this.algorithm) {
            case zcmpsc: {
                return new ZCompressorInputStream(this.makeZCompressor(), in);
            }
            case gzip: {
                return new GZIPInputStream(in);
            }
            case deflate: {
                return new InflaterInputStream(in, this.makeInflater());
            }
        }
        throw new IllegalArgumentException("Missing algorithm: " + (Object)((Object)this.algorithm));
    }

    public InputStream getExpandingInputStream(InputStream in, int bufsize) throws IOException {
        switch (this.algorithm) {
            case zcmpsc: {
                return new ZCompressorInputStream(this.makeZCompressor(), in, bufsize);
            }
            case gzip: {
                return new GZIPInputStream(in, bufsize);
            }
            case deflate: {
                return new InflaterInputStream(in, this.makeInflater(), bufsize);
            }
        }
        throw new IllegalArgumentException("Missing algorithm: " + (Object)((Object)this.algorithm));
    }

    public BufferCompressor getBufferCompressor() throws IOException {
        switch (this.algorithm) {
            case zcmpsc: {
                return this.makeZCompressor();
            }
            case gzip: {
                return new GZIPBufferCompressor();
            }
            case deflate: {
                return new DeflateBufferCompressor();
            }
        }
        throw new IllegalArgumentException("Missing algorithm: " + (Object)((Object)this.algorithm));
    }

    public void release() {
        if (this.doRelease && this.algorithm != null && this.algorithm.equals((Object)Algorithm.zcmpsc)) {
            this.releaseZCompressor();
        }
    }

    private synchronized void releaseZCompressor() {
        if (this.zcompressor != null) {
            this.zcompressor.release();
        }
    }

    private synchronized ZCompressor makeZCompressor() throws IOException {
        if (this.zcompressor == null) {
            if (this.algorithmParms.length != 2) {
                throw new IllegalStateException("Algorithm '" + (Object)((Object)Algorithm.zcmpsc) + "' requires two parameters: dictionary symbol bits and file");
            }
            int dict_bits = 0;
            try {
                dict_bits = Integer.parseInt(this.algorithmParms[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Dictionary symbol bits must be an integer value, but is '" + this.algorithmParms[0] + "'");
            }
            String dicts_file = this.algorithmParms[1];
            this.zcompressor = new ZCompressor(dict_bits, dicts_file);
        }
        return this.zcompressor;
    }

    private Deflater makeDeflater() {
        if (this.algorithmParms.length > 1) {
            throw new IllegalStateException("Algorithm '" + (Object)((Object)Algorithm.deflate) + "' accepts one optional parameter, the compression level");
        }
        Deflater deflater = new Deflater();
        if (this.algorithmParms.length == 1) {
            try {
                deflater.setLevel(Integer.parseInt(this.algorithmParms[0]));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Compression level must be an integer value, but is '" + this.algorithmParms[0] + "'");
            }
        }
        return deflater;
    }

    private Inflater makeInflater() {
        if (this.algorithmParms.length > 1) {
            throw new IllegalStateException("Algorithm '" + (Object)((Object)Algorithm.deflate) + "' accepts one optional parameter, the compression level");
        }
        return new Inflater();
    }

    private static void checkArgs(byte[] output, int outoff, byte[] input, int inoff, int inlen) {
        if (outoff < 0 || outoff >= output.length) {
            throw new IndexOutOfBoundsException("outoff=" + outoff + " output.length=" + output.length);
        }
        if (inoff < 0 || inlen < 0 || inoff >= input.length || inlen > input.length - inoff) {
            throw new IndexOutOfBoundsException("inlen=" + inlen + " input.length=" + input.length + " inoff=" + inoff);
        }
    }

    private class DeflateBufferCompressor
    implements BufferCompressor {
        private Inflater inflater;
        private Deflater deflater;

        DeflateBufferCompressor() {
            this.deflater = CompressionFactory.this.makeDeflater();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compressBuffer(byte[] output, int outoff, byte[] input, int inoff, int inlen) {
            CompressionFactory.checkArgs(output, outoff, input, inoff, inlen);
            if (inlen == 0) {
                return 0;
            }
            if (this.deflater == null) {
                this.deflater = CompressionFactory.this.makeDeflater();
            }
            try {
                int n;
                this.deflater.setInput(input, inoff, inlen);
                this.deflater.finish();
                int pos = outoff;
                int outsize = output.length - pos;
                do {
                    if (outsize < 1) {
                        n = -1;
                        return n;
                    }
                    int nDeflated = this.deflater.deflate(output, pos, outsize);
                    pos += nDeflated;
                    outsize -= nDeflated;
                } while (!this.deflater.finished());
                n = pos - outoff;
                return n;
            }
            finally {
                this.deflater.reset();
            }
        }

        @Override
        public int expandBuffer(byte[] output, int outoff, byte[] input, int inoff, int inlen) {
            CompressionFactory.checkArgs(output, outoff, input, inoff, inlen);
            if (inlen == 0) {
                return 0;
            }
            if (this.inflater == null) {
                this.inflater = CompressionFactory.this.makeInflater();
            }
            try {
                int n;
                this.inflater.setInput(input, inoff, inlen);
                int pos = outoff;
                int outsize = output.length - pos;
                do {
                    if (outsize < 1) {
                        n = -1;
                        return n;
                    }
                    int nInflated = this.inflater.inflate(output, pos, outsize);
                    pos += nInflated;
                    outsize -= nInflated;
                } while (!this.inflater.finished());
                n = pos - outoff;
                return n;
            }
            catch (DataFormatException dfe) {
                throw new RuntimeException(dfe);
            }
            finally {
                this.inflater.reset();
            }
        }
    }

    private static class GZIPBufferCompressor
    implements BufferCompressor {
        private GZIPBufferCompressor() {
        }

        @Override
        public int compressBuffer(byte[] output, int outoff, byte[] input, int inoff, int inlen) {
            CompressionFactory.checkArgs(output, outoff, input, inoff, inlen);
            if (inlen == 0) {
                return 0;
            }
            int outsize = output.length - outoff;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(outsize){

                @Override
                public byte[] toByteArray() {
                    return this.buf;
                }
            };
            try {
                GZIPOutputStream gos = new GZIPOutputStream((OutputStream)bos, outsize);
                gos.write(input, inoff, inlen);
                gos.close();
                if (bos.size() <= outsize) {
                    System.arraycopy(bos.toByteArray(), 0, output, outoff, bos.size());
                    return bos.size();
                }
                return outsize - bos.size();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public int expandBuffer(byte[] output, int outoff, byte[] input, int inoff, int inlen) {
            CompressionFactory.checkArgs(output, outoff, input, inoff, inlen);
            if (inlen == 0) {
                return 0;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(input, inoff, inlen);
            GZIPInputStream gis = null;
            try {
                int outbufLeft = output.length - outoff;
                int pos = outoff;
                gis = new GZIPInputStream((InputStream)bis, outbufLeft);
                int nRead = 0;
                while (outbufLeft > 0 && nRead >= 0) {
                    nRead = gis.read(output, pos, outbufLeft);
                    if (nRead <= 0) continue;
                    outbufLeft -= nRead;
                    pos += nRead;
                }
                if (nRead < 0 || gis.read() < 0) {
                    int n = output.length - outoff - outbufLeft;
                    return n;
                }
                int n = -1;
                return n;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                if (gis != null) {
                    try {
                        gis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static enum Algorithm {
        zcmpsc,
        gzip,
        deflate;

    }
}

