/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamVRecordWriter;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;

class BsamVbRecordWriter
extends BsamVRecordWriter {
    BsamVbRecordWriter(Bsam bsam) throws ZFileException {
        super(bsam);
        this.lrecl = bsam.getLrecl();
        this.block = new byte[bsam.getBlksize()];
        this.blockOffset = 4;
    }

    @Override
    public synchronized void write(byte[] buf, int offset, int len) throws ZFileException {
        if (this.blockOffset + len + 4 > this.block.length) {
            this.writeBlock();
        }
        this.writeRecord(buf, offset, len);
    }

    @Override
    public synchronized void flush() throws ZFileException {
        if (this.blockOffset > 4) {
            this.writeBlock();
        }
        super.flush();
    }

    @Override
    public synchronized void close() throws ZFileException {
        try {
            if (this.blockOffset > 4) {
                this.writeBlock();
            }
        }
        catch (ZFileException zfe) {
            try {
                super.close();
            }
            catch (Exception e) {
                ZUtil.logDiagnostic(0, e.getMessage());
            }
            throw zfe;
        }
        super.close();
    }
}

