/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamFbRecordWriter;
import com.ibm.jzos.BsamVRecordWriter;
import com.ibm.jzos.BsamVbRecordWriter;
import com.ibm.jzos.BsamVbsRecordWriter;
import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFileException;
import java.util.regex.Pattern;

class BsamRecordWriter
extends RecordWriter {
    protected Bsam bsam;

    protected BsamRecordWriter(Bsam bsam) {
        this.bsam = bsam;
    }

    public static synchronized BsamRecordWriter newWriterForDD(String ddname) throws ZFileException {
        if (ddname == null) {
            throw new NullPointerException("The ddname is null");
        }
        if (!Pattern.matches("^[a-zA-Z$#@][0-9a-zA-Z$#@]{0,7}$", ddname)) {
            throw new UnsupportedOperationException("The specified ddname (" + ddname + ") is not supported");
        }
        int openFlag = 64;
        Bsam bsam = new Bsam(ddname, openFlag);
        BsamRecordWriter writer = null;
        if ((bsam.getRecfmBits() & 4) == 4) {
            writer = new BsamRecordWriter(bsam);
        } else if ((bsam.getRecfmBits() & 1) == 1) {
            writer = (bsam.getRecfmBits() & 8) == 0 ? new BsamRecordWriter(bsam) : new BsamFbRecordWriter(bsam);
        } else if ((bsam.getRecfmBits() & 2) == 2) {
            writer = (bsam.getRecfmBits() & 0x10) == 16 ? new BsamVbsRecordWriter(bsam) : ((bsam.getRecfmBits() & 8) == 8 ? new BsamVbRecordWriter(bsam) : new BsamVRecordWriter(bsam));
        } else {
            throw new IllegalArgumentException("Record format is not supported");
        }
        return writer;
    }

    @Override
    public synchronized void write(byte[] buf) throws ZFileException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public synchronized void write(byte[] buf, int offset, int len) throws ZFileException {
        if ((this.bsam.getRecfmBits() & 1) == 1 && len != this.getBlksize()) {
            throw new IllegalArgumentException("write length " + len + " does not match blocksize of " + this.getBlksize());
        }
        this.bsam.writeBlock(buf, offset, len);
    }

    @Override
    public synchronized void close() throws ZFileException {
        this.bsam.close();
        this.doAutoFree();
    }

    @Override
    public synchronized void flush() throws ZFileException {
        this.bsam.flush();
    }

    @Override
    public synchronized int getLrecl() {
        return this.bsam.getLrecl();
    }

    @Override
    public synchronized int getBlksize() {
        return this.bsam.getBlksize();
    }

    @Override
    public synchronized int getRecfmBits() {
        return this.bsam.getRecfmBits();
    }

    @Override
    public synchronized String getRecfm() {
        return this.bsam.getRecfm();
    }

    @Override
    public synchronized String getDDName() {
        return this.bsam.getDDName();
    }

    @Override
    public synchronized String getDsn() {
        return this.bsam.getDsn();
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("(");
        if (this.bsam != null) {
            sb.append("ddname=" + this.getDDName());
            sb.append(",dsn=" + this.getDsn());
        }
        sb.append(")");
        return sb.toString();
    }
}

