/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamRecordWriter;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;

class BsamFbRecordWriter
extends BsamRecordWriter {
    private int lrecl;
    private byte[] block;
    private int currentOffset;
    private boolean isStandard;

    BsamFbRecordWriter(Bsam bsam) throws ZFileException {
        super(bsam);
        this.lrecl = bsam.getLrecl();
        this.block = new byte[bsam.getBlksize()];
        this.currentOffset = 0;
        this.isStandard = (bsam.getRecfmBits() & 0x10) == 16;
    }

    @Override
    public synchronized void write(byte[] buf, int offset, int len) throws ZFileException {
        if (len != this.lrecl) {
            throw new IllegalArgumentException("Record length " + len + " Doesn't match fixed LRECL of " + this.lrecl);
        }
        if (this.currentOffset == this.block.length) {
            this.writeBlock();
        }
        System.arraycopy(buf, offset, this.block, this.currentOffset, len);
        this.currentOffset += len;
    }

    private void writeBlock() throws ZFileException {
        try {
            this.bsam.writeBlock(this.block, 0, this.currentOffset);
        }
        finally {
            this.currentOffset = 0;
        }
    }

    @Override
    public synchronized void flush() throws ZFileException {
        if (!this.isStandard && this.currentOffset > 0) {
            this.writeBlock();
        }
        super.flush();
    }

    @Override
    public synchronized void close() throws ZFileException {
        try {
            if (this.currentOffset != 0) {
                this.writeBlock();
            }
        }
        catch (ZFileException zfe) {
            try {
                super.close();
            }
            catch (Exception e) {
                ZUtil.logDiagnostic(0, e.getMessage());
            }
            throw zfe;
        }
        super.close();
    }
}

