/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.rmic.iiop;

import com.ibm.tools.rmic.iiop.AbstractType;
import com.ibm.tools.rmic.iiop.ArrayType;
import com.ibm.tools.rmic.iiop.BatchEnvironment;
import com.ibm.tools.rmic.iiop.ClassType;
import com.ibm.tools.rmic.iiop.ContextElement;
import com.ibm.tools.rmic.iiop.ContextStack;
import com.ibm.tools.rmic.iiop.DirectoryLoader;
import com.ibm.tools.rmic.iiop.IDLNames;
import com.ibm.tools.rmic.iiop.ImplementationType;
import com.ibm.tools.rmic.iiop.InterfaceType;
import com.ibm.tools.rmic.iiop.NCClassType;
import com.ibm.tools.rmic.iiop.NCInterfaceType;
import com.ibm.tools.rmic.iiop.PrimitiveType;
import com.ibm.tools.rmic.iiop.RemoteType;
import com.ibm.tools.rmic.iiop.SpecialClassType;
import com.ibm.tools.rmic.iiop.SpecialInterfaceType;
import com.ibm.tools.rmic.iiop.Type;
import com.ibm.tools.rmic.iiop.ValueType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import sun.rmi.rmic.IndentingWriter;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.tree.LocalMember;
import sun.tools.tree.Node;

public abstract class CompoundType
extends Type {
    protected Method[] methods;
    protected InterfaceType[] interfaces;
    protected Member[] members;
    protected ClassDefinition classDef;
    protected ClassDeclaration classDecl;
    protected boolean isCORBAObject = false;
    protected boolean isIDLEntity = false;
    protected boolean isAbstractBase = false;
    protected boolean isValueBase = false;
    protected boolean isCORBAUserException = false;
    protected boolean isException = false;
    protected boolean isCheckedException = false;
    protected boolean isRemoteExceptionOrSubclass = false;
    protected String idlExceptionName;
    protected String qualifiedIDLExceptionName;

    public boolean isCORBAObject() {
        return this.isCORBAObject;
    }

    public boolean isIDLEntity() {
        return this.isIDLEntity;
    }

    public boolean isValueBase() {
        return this.isValueBase;
    }

    public boolean isAbstractBase() {
        return this.isAbstractBase;
    }

    public boolean isException() {
        return this.isException;
    }

    public boolean isCheckedException() {
        return this.isCheckedException;
    }

    public boolean isRemoteExceptionOrSubclass() {
        return this.isRemoteExceptionOrSubclass;
    }

    public boolean isCORBAUserException() {
        return this.isCORBAUserException;
    }

    public boolean isIDLEntityException() {
        return this.isIDLEntity() && this.isException();
    }

    public boolean isBoxed() {
        return this.isIDLEntity() && !this.isValueBase() && !this.isAbstractBase() && !this.isCORBAObject() && !this.isIDLEntityException();
    }

    public String getIDLExceptionName() {
        return this.idlExceptionName;
    }

    public String getQualifiedIDLExceptionName(boolean bl) {
        if (this.qualifiedIDLExceptionName != null && bl && this.getIDLModuleNames().length > 0) {
            return "::" + this.qualifiedIDLExceptionName;
        }
        return this.qualifiedIDLExceptionName;
    }

    @Override
    public String getSignature() {
        String string = this.classDecl.getType().getTypeSignature();
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ClassDeclaration getClassDeclaration() {
        return this.classDecl;
    }

    public ClassDefinition getClassDefinition() {
        return this.classDef;
    }

    public ClassType getSuperclass() {
        return null;
    }

    public InterfaceType[] getInterfaces() {
        return (InterfaceType[])this.interfaces.clone();
    }

    public Method[] getMethods() {
        return (Method[])this.methods.clone();
    }

    public Member[] getMembers() {
        return (Member[])this.members.clone();
    }

    public static CompoundType forCompound(ClassDefinition classDefinition, ContextStack contextStack) {
        CompoundType compoundType = null;
        try {
            compoundType = (CompoundType)CompoundType.makeType(classDefinition.getType(), classDefinition, contextStack);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return compoundType;
    }

    @Override
    protected void destroy() {
        if (!this.destroyed) {
            int n;
            super.destroy();
            if (this.methods != null) {
                for (n = 0; n < this.methods.length; ++n) {
                    if (this.methods[n] == null) continue;
                    this.methods[n].destroy();
                }
                this.methods = null;
            }
            if (this.interfaces != null) {
                for (n = 0; n < this.interfaces.length; ++n) {
                    if (this.interfaces[n] == null) continue;
                    this.interfaces[n].destroy();
                }
                this.interfaces = null;
            }
            if (this.members != null) {
                for (n = 0; n < this.members.length; ++n) {
                    if (this.members[n] == null) continue;
                    this.members[n].destroy();
                }
                this.members = null;
            }
            this.classDef = null;
            this.classDecl = null;
        }
    }

    @Override
    protected Class loadClass() {
        Object object;
        Class clazz = null;
        try {
            this.env.getMain().compileAllClasses(this.env);
        }
        catch (Exception exception) {
            object = this.env.getClasses();
            while (object.hasMoreElements()) {
                ClassDeclaration classDeclaration = (ClassDeclaration)object.nextElement();
            }
            CompoundType.failedConstraint(26, false, this.stack, "required classes");
            this.env.flushErrors();
        }
        if (this.env.loader == null) {
            object = this.env.getMain().getDestinationDir();
            String string = object == null ? new String(".") : ((File)object).getPath();
            this.env.loader = new DirectoryLoader(this.env.tryToGetClassPath().toString(), string);
        }
        try {
            clazz = this.env.loader.loadClass(this.getQualifiedName(), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    protected boolean printExtends(IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        ClassType classType = this.getSuperclass();
        if (!(classType == null || bl2 && (classType.isType(1024) || classType.isType(2048)))) {
            indentingWriter.p(" extends ");
            classType.printTypeName(indentingWriter, bl, bl2, bl3);
            return true;
        }
        return false;
    }

    protected void printImplements(IndentingWriter indentingWriter, String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        InterfaceType[] interfaceTypeArray = this.getInterfaces();
        String string2 = " implements";
        if (this.isInterface()) {
            string2 = " extends";
        }
        if (bl2) {
            string2 = ":";
        }
        for (int i = 0; i < interfaceTypeArray.length; ++i) {
            if (bl2 && (interfaceTypeArray[i].isType(1024) || interfaceTypeArray[i].isType(2048))) continue;
            if (i == 0) {
                indentingWriter.p(string + string2 + " ");
            } else {
                indentingWriter.p(", ");
            }
            interfaceTypeArray[i].printTypeName(indentingWriter, bl, bl2, bl3);
        }
    }

    protected void printMembers(IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Member[] memberArray = this.getMembers();
        for (int i = 0; i < memberArray.length; ++i) {
            if (memberArray[i].isInnerClassDeclaration()) continue;
            Type type = memberArray[i].getType();
            String string = memberArray[i].getVisibility();
            String string2 = bl2 ? memberArray[i].getIDLName() : memberArray[i].getName();
            String string3 = memberArray[i].getValue();
            indentingWriter.p(string);
            if (string.length() > 0) {
                indentingWriter.p(" ");
            }
            type.printTypeName(indentingWriter, bl, bl2, bl3);
            indentingWriter.p(" " + string2);
            if (string3 != null) {
                indentingWriter.pln(" = " + string3 + ";");
                continue;
            }
            indentingWriter.pln(";");
        }
    }

    protected void printMethods(IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Method[] methodArray = this.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            this.printMethod(method, indentingWriter, bl, bl2, bl3);
        }
    }

    protected void printMethod(Method method, IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        String string = method.getVisibility();
        indentingWriter.p(string);
        if (string.length() > 0) {
            indentingWriter.p(" ");
        }
        method.getReturnType().printTypeName(indentingWriter, bl, bl2, bl3);
        if (bl2) {
            indentingWriter.p(" " + method.getIDLName());
        } else {
            indentingWriter.p(" " + method.getName());
        }
        indentingWriter.p(" (");
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        for (int i = 0; i < typeArray.length; ++i) {
            if (i > 0) {
                indentingWriter.p(", ");
            }
            if (bl2) {
                indentingWriter.p("in ");
            }
            typeArray[i].printTypeName(indentingWriter, bl, bl2, bl3);
            indentingWriter.p(" " + stringArray[i]);
        }
        indentingWriter.p(")");
        ValueType[] valueTypeArray = this.isType(65536) ? method.getImplExceptions() : method.getExceptions();
        for (int i = 0; i < valueTypeArray.length; ++i) {
            if (i == 0) {
                if (bl2) {
                    indentingWriter.p(" raises (");
                } else {
                    indentingWriter.p(" throws ");
                }
            } else {
                indentingWriter.p(", ");
            }
            if (bl2) {
                if (bl) {
                    indentingWriter.p(valueTypeArray[i].getQualifiedIDLExceptionName(bl3));
                } else {
                    indentingWriter.p(valueTypeArray[i].getIDLExceptionName());
                }
                indentingWriter.p(" [a.k.a. ");
                valueTypeArray[i].printTypeName(indentingWriter, bl, bl2, bl3);
                indentingWriter.p("]");
                continue;
            }
            valueTypeArray[i].printTypeName(indentingWriter, bl, bl2, bl3);
        }
        if (bl2 && valueTypeArray.length > 0) {
            indentingWriter.p(")");
        }
        if (method.isInherited()) {
            indentingWriter.p(" // Inherited from ");
            indentingWriter.p(method.getDeclaredBy());
        }
        indentingWriter.pln(";");
    }

    protected CompoundType(ContextStack contextStack, int n, ClassDefinition classDefinition) {
        super(contextStack, n);
        this.classDef = classDefinition;
        this.classDecl = classDefinition.getClassDeclaration();
        this.interfaces = new InterfaceType[0];
        this.methods = new Method[0];
        this.members = new Member[0];
        if (classDefinition.isInnerClass()) {
            this.setTypeCode(n | Integer.MIN_VALUE);
        }
        this.setFlags();
    }

    private void setFlags() {
        try {
            this.isCORBAObject = this.env.defCorbaObject.implementedBy(this.env, this.classDecl);
            this.isIDLEntity = this.env.defIDLEntity.implementedBy(this.env, this.classDecl);
            this.isValueBase = this.env.defValueBase.implementedBy(this.env, this.classDecl);
            this.isAbstractBase = this.isInterface() && this.isIDLEntity && !this.isValueBase && !this.isCORBAObject;
            boolean bl = this.isCORBAUserException = this.classDecl.getName() == idCorbaUserException;
            if (this.env.defThrowable.implementedBy(this.env, this.classDecl)) {
                this.isException = true;
                this.isCheckedException = !this.env.defRuntimeException.implementedBy(this.env, this.classDecl) && !this.env.defError.implementedBy(this.env, this.classDecl);
                this.isRemoteExceptionOrSubclass = this.env.defRemoteException.implementedBy(this.env, this.classDecl);
            } else {
                this.isException = false;
            }
        }
        catch (ClassNotFound classNotFound) {
            CompoundType.classNotFound(this.stack, classNotFound);
        }
    }

    protected CompoundType(ContextStack contextStack, ClassDefinition classDefinition, int n) {
        super(contextStack, n);
        this.classDef = classDefinition;
        this.classDecl = classDefinition.getClassDeclaration();
        if (classDefinition.isInnerClass()) {
            this.setTypeCode(n | Integer.MIN_VALUE);
        }
        this.setFlags();
        Identifier identifier = classDefinition.getName();
        try {
            String string = IDLNames.getClassOrInterfaceName(identifier, this.env);
            String[] stringArray = IDLNames.getModuleNames(identifier, this.isBoxed(), this.env);
            this.setNames(identifier, stringArray, string);
            if (this.isException()) {
                this.isException = true;
                this.idlExceptionName = IDLNames.getExceptionName(this.getIDLName());
                this.qualifiedIDLExceptionName = IDLNames.getQualifiedName(this.getIDLModuleNames(), this.idlExceptionName);
            }
            this.interfaces = null;
            this.methods = null;
            this.members = null;
        }
        catch (Exception exception) {
            CompoundType.failedConstraint(7, false, contextStack, identifier.toString(), exception.getMessage());
            throw new CompilerError("");
        }
    }

    protected boolean initialize(Vector vector, Vector vector2, Vector vector3, ContextStack contextStack, boolean bl) {
        boolean bl2 = true;
        if (vector != null && vector.size() > 0) {
            this.interfaces = new InterfaceType[vector.size()];
            vector.copyInto(this.interfaces);
        } else {
            this.interfaces = new InterfaceType[0];
        }
        if (vector2 != null && vector2.size() > 0) {
            this.methods = new Method[vector2.size()];
            vector2.copyInto(this.methods);
            try {
                IDLNames.setMethodNames(this.methods, this.env);
            }
            catch (Exception exception) {
                CompoundType.failedConstraint(13, bl, contextStack, this.getQualifiedName(), exception.getMessage());
                bl2 = false;
            }
        } else {
            this.methods = new Method[0];
        }
        if (vector3 != null && vector3.size() > 0) {
            this.members = new Member[vector3.size()];
            vector3.copyInto(this.members);
            for (int i = 0; i < this.members.length; ++i) {
                if (!this.members[i].isInnerClassDeclaration()) continue;
                try {
                    this.members[i].init(contextStack, this);
                    continue;
                }
                catch (CompilerError compilerError) {
                    return false;
                }
            }
            try {
                IDLNames.setMemberNames(this.members, this.methods, this.env);
            }
            catch (Exception exception) {
                int n = this.classDef.isInterface() ? 19 : 20;
                CompoundType.failedConstraint(n, bl, contextStack, this.getQualifiedName(), exception.getMessage());
                bl2 = false;
            }
        } else {
            this.members = new Member[0];
        }
        if (bl2) {
            bl2 = this.setRepositoryID();
        }
        return bl2;
    }

    protected static Type makeType(sun.tools.java.Type type, ClassDefinition classDefinition, ContextStack contextStack) {
        if (contextStack.anyErrors()) {
            return null;
        }
        String string = type.toString();
        Type type2 = CompoundType.getType(string, contextStack);
        if (type2 != null) {
            return type2;
        }
        type2 = CompoundType.getType(string + contextStack.getContextCodeString(), contextStack);
        if (type2 != null) {
            return type2;
        }
        BatchEnvironment batchEnvironment = contextStack.getEnv();
        int n = type.getTypeCode();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                type2 = PrimitiveType.forPrimitive(type, contextStack);
                break;
            }
            case 9: {
                type2 = ArrayType.forArray(type, contextStack);
                break;
            }
            case 10: {
                try {
                    ClassDefinition classDefinition2 = classDefinition;
                    if (classDefinition2 == null) {
                        classDefinition2 = batchEnvironment.getClassDeclaration(type).getClassDefinition(batchEnvironment);
                    }
                    if (classDefinition2.isInterface()) {
                        type2 = SpecialInterfaceType.forSpecial(classDefinition2, contextStack);
                        if (type2 != null) break;
                        if (batchEnvironment.defRemote.implementedBy(batchEnvironment, classDefinition2.getClassDeclaration())) {
                            boolean bl = contextStack.isParentAValue();
                            type2 = RemoteType.forRemote(classDefinition2, contextStack, bl);
                            if (type2 != null || !bl) break;
                            type2 = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
                            break;
                        }
                        type2 = AbstractType.forAbstract(classDefinition2, contextStack, true);
                        if (type2 != null) break;
                        type2 = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
                        break;
                    }
                    type2 = SpecialClassType.forSpecial(classDefinition2, contextStack);
                    if (type2 != null) break;
                    ClassDeclaration classDeclaration = classDefinition2.getClassDeclaration();
                    if (batchEnvironment.defRemote.implementedBy(batchEnvironment, classDeclaration)) {
                        boolean bl = contextStack.isParentAValue();
                        type2 = ImplementationType.forImplementation(classDefinition2, contextStack, bl);
                        if (type2 != null || !bl) break;
                        type2 = NCClassType.forNCClass(classDefinition2, contextStack);
                        break;
                    }
                    if (batchEnvironment.defSerializable.implementedBy(batchEnvironment, classDeclaration)) {
                        type2 = ValueType.forValue(classDefinition2, contextStack, true);
                    }
                    if (type2 != null) break;
                    type2 = NCClassType.forNCClass(classDefinition2, contextStack);
                }
                catch (ClassNotFound classNotFound) {
                    CompoundType.classNotFound(contextStack, classNotFound);
                }
                break;
            }
            default: {
                throw new CompilerError("Unknown typecode (" + n + ") for " + type.getTypeSignature());
            }
        }
        return type2;
    }

    public static boolean isRemoteException(ClassType classType, BatchEnvironment batchEnvironment) {
        sun.tools.java.Type type = classType.getClassDeclaration().getType();
        return type.equals(batchEnvironment.typeRemoteException) || type.equals(batchEnvironment.typeIOException) || type.equals(batchEnvironment.typeException) || type.equals(batchEnvironment.typeThrowable);
    }

    protected boolean isConformingRemoteMethod(Method method, boolean bl) throws ClassNotFound {
        int n;
        boolean bl2 = false;
        ValueType[] valueTypeArray = method.getExceptions();
        for (n = 0; n < valueTypeArray.length; ++n) {
            if (!CompoundType.isRemoteException(valueTypeArray[n], this.env)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            CompoundType.failedConstraint(5, bl, this.stack, method.getEnclosing(), method.toString());
        }
        int n2 = n = !this.isIDLEntityException(method.getReturnType(), method, bl) ? 1 : 0;
        if (n != 0) {
            Type[] typeArray = method.getArguments();
            for (int i = 0; i < typeArray.length; ++i) {
                if (!this.isIDLEntityException(typeArray[i], method, bl)) continue;
                n = 0;
                break;
            }
        }
        return bl2 && n != 0;
    }

    protected boolean isIDLEntityException(Type type, Method method, boolean bl) throws ClassNotFound {
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (type.isCompound() && ((CompoundType)type).isIDLEntityException()) {
            CompoundType.failedConstraint(18, bl, this.stack, method.getEnclosing(), method.toString());
            return true;
        }
        return false;
    }

    @Override
    protected void swapInvalidTypes() {
        int n;
        for (n = 0; n < this.interfaces.length; ++n) {
            if (this.interfaces[n].getStatus() == 1) continue;
            this.interfaces[n] = (InterfaceType)this.getValidType(this.interfaces[n]);
        }
        for (n = 0; n < this.methods.length; ++n) {
            this.methods[n].swapInvalidTypes();
        }
        for (n = 0; n < this.members.length; ++n) {
            this.members[n].swapInvalidTypes();
        }
    }

    @Override
    protected boolean addTypes(int n, HashSet hashSet, Vector vector) {
        boolean bl = super.addTypes(n, hashSet, vector);
        if (bl) {
            Type[] typeArray;
            int n2;
            ClassType classType = this.getSuperclass();
            if (classType != null) {
                classType.addTypes(n, hashSet, vector);
            }
            for (n2 = 0; n2 < this.interfaces.length; ++n2) {
                this.interfaces[n2].addTypes(n, hashSet, vector);
            }
            for (n2 = 0; n2 < this.methods.length; ++n2) {
                this.methods[n2].getReturnType().addTypes(n, hashSet, vector);
                typeArray = this.methods[n2].getArguments();
                for (int i = 0; i < typeArray.length; ++i) {
                    Type type = typeArray[i];
                    type.addTypes(n, hashSet, vector);
                }
                ValueType[] valueTypeArray = this.methods[n2].getExceptions();
                for (int i = 0; i < valueTypeArray.length; ++i) {
                    ValueType valueType = valueTypeArray[i];
                    valueType.addTypes(n, hashSet, vector);
                }
            }
            for (n2 = 0; n2 < this.members.length; ++n2) {
                typeArray = this.members[n2].getType();
                typeArray.addTypes(n, hashSet, vector);
            }
        }
        return bl;
    }

    private boolean isConformingConstantType(MemberDefinition memberDefinition) {
        return this.isConformingConstantType(memberDefinition.getType(), memberDefinition);
    }

    private boolean isConformingConstantType(sun.tools.java.Type type, MemberDefinition memberDefinition) {
        boolean bl = true;
        int n = type.getTypeCode();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 10: {
                if (type.getClassName() == idJavaLangString) break;
                CompoundType.failedConstraint(3, false, this.stack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                bl = false;
                break;
            }
            case 9: {
                CompoundType.failedConstraint(3, false, this.stack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                bl = false;
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
        return bl;
    }

    protected Vector updateParentClassMethods(ClassDefinition classDefinition, Vector vector, boolean bl, ContextStack contextStack) throws ClassNotFound {
        ClassDeclaration classDeclaration = classDefinition.getSuperClass(this.env);
        while (classDeclaration != null) {
            ClassDefinition classDefinition2 = classDeclaration.getClassDefinition(this.env);
            Identifier identifier = classDeclaration.getName();
            if (identifier == idJavaLangObject) break;
            for (MemberDefinition memberDefinition = classDefinition2.getFirstMember(); memberDefinition != null; memberDefinition = memberDefinition.getNextMember()) {
                Method method;
                if (!memberDefinition.isMethod() || memberDefinition.isInitializer() || memberDefinition.isConstructor() || memberDefinition.isPrivate()) continue;
                try {
                    method = new Method(this, memberDefinition, bl, contextStack);
                }
                catch (Exception exception) {
                    return null;
                }
                int n = vector.indexOf(method);
                if (n >= 0) {
                    Method method2 = (Method)vector.elementAt(n);
                    method2.setDeclaredBy(identifier);
                    continue;
                }
                vector.addElement(method);
            }
            classDeclaration = classDefinition2.getSuperClass(this.env);
        }
        return vector;
    }

    protected Vector addAllMethods(ClassDefinition classDefinition, Vector vector, boolean bl, boolean bl2, ContextStack contextStack) throws ClassNotFound {
        Cloneable cloneable;
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        for (int i = 0; i < classDeclarationArray.length; ++i) {
            cloneable = this.addAllMethods(classDeclarationArray[i].getClassDefinition(this.env), vector, bl, bl2, contextStack);
            if (cloneable != null) continue;
            return null;
        }
        for (MemberDefinition memberDefinition = classDefinition.getFirstMember(); memberDefinition != null; memberDefinition = memberDefinition.getNextMember()) {
            int n;
            Object object;
            if (!memberDefinition.isMethod() || memberDefinition.isInitializer() || memberDefinition.isPrivate()) continue;
            try {
                cloneable = new Method(this, memberDefinition, bl2, contextStack);
            }
            catch (Exception exception) {
                return null;
            }
            Object object2 = null;
            for (int i = 0; i < vector.size() && object2 == null; ++i) {
                object = (Method)vector.elementAt(i);
                String string = ((Method)object).getName();
                if (!string.equals(((Method)cloneable).getName())) continue;
                object2 = object;
            }
            if (object2 == null) {
                vector.addElement(cloneable);
                continue;
            }
            Identifier identifier = ((Method)cloneable).getDeclaredBy();
            object = ((Method)object2).getDeclaredBy();
            boolean bl3 = false;
            ClassDefinition classDefinition2 = null;
            ClassDefinition classDefinition3 = null;
            classDefinition2 = this.findBaseClass(this.classDef, identifier, null);
            if (classDefinition2 != null) {
                classDefinition3 = this.findBaseClass(classDefinition2, (Identifier)object, null);
            }
            if (classDefinition3 != null) {
                bl3 = true;
            }
            if (!((Method)cloneable).equals(object2) && this.findBaseClass(this.classDef, (Identifier)object, identifier) != null) {
                bl3 = false;
            }
            if (bl3) {
                if (!vector.contains(cloneable)) {
                    vector.addElement(cloneable);
                }
            } else if (bl && classDefinition != this.classDef && !contextStack.isParentAValue() && !contextStack.getContext().isValue()) {
                String string = ((Identifier)object).toString() + " and " + identifier.toString();
                CompoundType.failedConstraint(6, bl2, contextStack, this.classDef, string, ((Method)cloneable).getName());
                return null;
            }
            if ((n = vector.indexOf(cloneable)) == -1) continue;
            Method method = (Method)vector.get(n);
            Method method2 = ((Method)cloneable).mergeWith(method);
            vector.set(n, method2);
        }
        return vector;
    }

    private ClassDefinition findBaseClass(ClassDefinition classDefinition, Identifier identifier, Identifier identifier2) throws ClassNotFound {
        if (identifier2 != null && identifier2 == classDefinition.getName()) {
            return null;
        }
        if (identifier == classDefinition.getName()) {
            return classDefinition;
        }
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        for (int i = 0; i < classDeclarationArray.length; ++i) {
            ClassDefinition classDefinition2 = this.findBaseClass(classDeclarationArray[i].getClassDefinition(this.env), identifier, identifier2);
            if (classDefinition2 == null) continue;
            return classDefinition2;
        }
        return null;
    }

    protected Vector addRemoteInterfaces(Vector vector, boolean bl, ContextStack contextStack) throws ClassNotFound {
        ClassDefinition classDefinition = this.getClassDefinition();
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        contextStack.setNewContextCode(10);
        for (int i = 0; i < classDeclarationArray.length; ++i) {
            ClassDefinition classDefinition2 = classDeclarationArray[i].getClassDefinition(this.env);
            InterfaceType interfaceType = SpecialInterfaceType.forSpecial(classDefinition2, contextStack);
            if (interfaceType == null) {
                if (this.env.defRemote.implementedBy(this.env, classDeclarationArray[i])) {
                    interfaceType = RemoteType.forRemote(classDefinition2, contextStack, false);
                } else {
                    interfaceType = AbstractType.forAbstract(classDefinition2, contextStack, bl);
                    if (interfaceType != null && this instanceof ImplementationType) continue;
                    if (interfaceType == null && bl) {
                        interfaceType = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
                    }
                }
            }
            if (interfaceType != null) {
                vector.addElement(interfaceType);
                continue;
            }
            return null;
        }
        return vector;
    }

    protected Vector addNonRemoteInterfaces(Vector vector, ContextStack contextStack) throws ClassNotFound {
        ClassDefinition classDefinition = this.getClassDefinition();
        ClassDeclaration[] classDeclarationArray = classDefinition.getInterfaces();
        contextStack.setNewContextCode(10);
        for (int i = 0; i < classDeclarationArray.length; ++i) {
            ClassDefinition classDefinition2 = classDeclarationArray[i].getClassDefinition(this.env);
            InterfaceType interfaceType = SpecialInterfaceType.forSpecial(classDefinition2, contextStack);
            if (interfaceType == null && (interfaceType = AbstractType.forAbstract(classDefinition2, contextStack, true)) == null) {
                interfaceType = NCInterfaceType.forNCInterface(classDefinition2, contextStack);
            }
            if (interfaceType == null) {
                return null;
            }
            vector.addElement(interfaceType);
        }
        return vector;
    }

    protected boolean addAllMembers(Vector vector, boolean bl, boolean bl2, ContextStack contextStack) {
        boolean bl3 = true;
        for (MemberDefinition memberDefinition = this.getClassDefinition().getFirstMember(); memberDefinition != null && bl3; memberDefinition = memberDefinition.getNextMember()) {
            if (memberDefinition.isMethod()) continue;
            try {
                String string = null;
                memberDefinition.getValue(this.env);
                Node node = memberDefinition.getValue();
                if (node != null) {
                    string = node.toString();
                }
                if (bl && memberDefinition.getInnerClass() == null && (string == null || !this.isConformingConstantType(memberDefinition))) {
                    CompoundType.failedConstraint(3, bl2, contextStack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                    bl3 = false;
                    break;
                }
                try {
                    Member member = new Member(memberDefinition, string, contextStack, this);
                    vector.addElement(member);
                }
                catch (CompilerError compilerError) {
                    bl3 = false;
                }
                continue;
            }
            catch (ClassNotFound classNotFound) {
                CompoundType.classNotFound(contextStack, classNotFound);
                bl3 = false;
            }
        }
        return bl3;
    }

    protected boolean addConformingConstants(Vector vector, boolean bl, ContextStack contextStack) {
        boolean bl2 = true;
        for (MemberDefinition memberDefinition = this.getClassDefinition().getFirstMember(); memberDefinition != null && bl2; memberDefinition = memberDefinition.getNextMember()) {
            if (memberDefinition.isMethod()) continue;
            try {
                String string = null;
                memberDefinition.getValue(this.env);
                Node node = memberDefinition.getValue();
                if (node != null) {
                    string = node.toString();
                }
                if (string == null) continue;
                if (!this.isConformingConstantType(memberDefinition)) {
                    CompoundType.failedConstraint(3, bl, contextStack, memberDefinition.getClassDefinition(), memberDefinition.getName());
                    bl2 = false;
                    break;
                }
                try {
                    Member member = new Member(memberDefinition, string, contextStack, this);
                    vector.addElement(member);
                }
                catch (CompilerError compilerError) {
                    bl2 = false;
                }
                continue;
            }
            catch (ClassNotFound classNotFound) {
                CompoundType.classNotFound(contextStack, classNotFound);
                bl2 = false;
            }
        }
        return bl2;
    }

    protected ValueType[] getMethodExceptions(MemberDefinition memberDefinition, boolean bl, ContextStack contextStack) throws Exception {
        int n;
        int n2;
        boolean bl2 = true;
        contextStack.setNewContextCode(5);
        ClassDeclaration[] classDeclarationArray = memberDefinition.getExceptions(this.env);
        ValueType[] valueTypeArray = new ValueType[classDeclarationArray.length];
        try {
            for (n2 = 0; n2 < classDeclarationArray.length; ++n2) {
                ClassDefinition classDefinition = classDeclarationArray[n2].getClassDefinition(this.env);
                try {
                    ValueType valueType = ValueType.forValue(classDefinition, contextStack, false);
                    if (valueType != null) {
                        valueTypeArray[n2] = valueType;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                catch (ClassCastException classCastException) {
                    CompoundType.failedConstraint(22, bl, contextStack, this.getQualifiedName());
                    throw new CompilerError("Method: exception " + classDefinition.getName() + " not a class type!");
                }
                catch (NullPointerException nullPointerException) {
                    CompoundType.failedConstraint(23, bl, contextStack, this.getQualifiedName());
                    throw new CompilerError("Method: caught null pointer exception");
                }
            }
        }
        catch (ClassNotFound classNotFound) {
            CompoundType.classNotFound(bl, contextStack, classNotFound);
            bl2 = false;
        }
        if (!bl2) {
            throw new Exception();
        }
        n2 = 0;
        for (n = 0; n < valueTypeArray.length; ++n) {
            for (int i = 0; i < valueTypeArray.length; ++i) {
                if (n == i || valueTypeArray[n] == null || valueTypeArray[n] != valueTypeArray[i]) continue;
                valueTypeArray[i] = null;
                ++n2;
            }
        }
        if (n2 > 0) {
            n = 0;
            ValueType[] valueTypeArray2 = new ValueType[valueTypeArray.length - n2];
            for (int i = 0; i < valueTypeArray.length; ++i) {
                if (valueTypeArray[i] == null) continue;
                valueTypeArray2[n++] = valueTypeArray[i];
            }
            valueTypeArray = valueTypeArray2;
        }
        return valueTypeArray;
    }

    protected static String getVisibilityString(MemberDefinition memberDefinition) {
        String string = "";
        String string2 = "";
        if (memberDefinition.isPublic()) {
            string = string + "public";
            string2 = " ";
        } else if (memberDefinition.isProtected()) {
            string = string + "protected";
            string2 = " ";
        } else if (memberDefinition.isPrivate()) {
            string = string + "private";
            string2 = " ";
        }
        if (memberDefinition.isStatic()) {
            string = string + string2;
            string = string + "static";
            string2 = " ";
        }
        if (memberDefinition.isFinal()) {
            string = string + string2;
            string = string + "final";
            string2 = " ";
        }
        return string;
    }

    protected boolean assertNotImpl(Type type, boolean bl, ContextStack contextStack, CompoundType compoundType, boolean bl2) {
        if (type.isType(65536)) {
            int n = bl2 ? 28 : 21;
            CompoundType.failedConstraint(n, bl, contextStack, type, compoundType.getName());
            return false;
        }
        return true;
    }

    public class Member
    implements ContextElement,
    Cloneable {
        private CompoundType enclosing;
        private Type type;
        private String vis;
        private String value;
        private String name;
        private String idlName;
        private boolean innerClassDecl;
        private boolean constant;
        private MemberDefinition member;
        private boolean forceTransient;

        public CompoundType getEnclosing() {
            return this.enclosing;
        }

        @Override
        public String getElementName() {
            return "\"" + this.getName() + "\"";
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getIDLName() {
            return this.idlName;
        }

        public String getVisibility() {
            return this.vis;
        }

        public boolean isPublic() {
            return this.member.isPublic();
        }

        public boolean isPrivate() {
            return this.member.isPrivate();
        }

        public boolean isStatic() {
            return this.member.isStatic();
        }

        public boolean isFinal() {
            return this.member.isFinal();
        }

        public boolean isTransient() {
            if (this.forceTransient) {
                return true;
            }
            return this.member.isTransient();
        }

        public String getValue() {
            return this.value;
        }

        public boolean isInnerClassDeclaration() {
            return this.innerClassDecl;
        }

        public boolean isConstant() {
            return this.constant;
        }

        public String toString() {
            String string = this.type.toString();
            if (this.value != null) {
                string = string + " = " + this.value;
            }
            return string;
        }

        protected void swapInvalidTypes() {
            if (this.type.getStatus() != 1) {
                this.type = CompoundType.this.getValidType(this.type);
            } else if (this.type instanceof ArrayType) {
                this.type.swapInvalidTypes();
            }
        }

        protected void setTransient() {
            if (!this.isTransient()) {
                this.forceTransient = true;
                this.vis = this.vis.length() > 0 ? this.vis + " transient" : "transient";
            }
        }

        protected MemberDefinition getMemberDefinition() {
            return this.member;
        }

        public void destroy() {
            if (this.type != null) {
                this.type.destroy();
                this.type = null;
                this.vis = null;
                this.value = null;
                this.name = null;
                this.idlName = null;
                this.member = null;
            }
        }

        public Member(MemberDefinition memberDefinition, String string, ContextStack contextStack, CompoundType compoundType2) {
            this.member = memberDefinition;
            this.value = string;
            this.enclosing = compoundType2;
            this.forceTransient = false;
            boolean bl = this.innerClassDecl = memberDefinition.getInnerClass() != null;
            if (!this.innerClassDecl) {
                this.init(contextStack, compoundType2);
            }
        }

        public void init(ContextStack contextStack, CompoundType compoundType) {
            int n;
            char c;
            this.constant = false;
            this.name = this.member.getName().toString();
            this.vis = CompoundType.getVisibilityString(this.member);
            this.idlName = null;
            int n2 = 6;
            contextStack.setNewContextCode(n2);
            if (this.member.isVariable()) {
                if (this.value != null && this.member.isConstant()) {
                    n2 = 7;
                    this.constant = true;
                } else if (this.member.isStatic()) {
                    n2 = 8;
                } else if (this.member.isTransient()) {
                    n2 = 9;
                }
            }
            contextStack.setNewContextCode(n2);
            contextStack.push(this);
            this.type = CompoundType.makeType(this.member.getType(), null, contextStack);
            if (this.type == null || !this.innerClassDecl && !this.member.isStatic() && !this.member.isTransient() && !CompoundType.this.assertNotImpl(this.type, false, contextStack, compoundType, true)) {
                contextStack.pop(false);
                throw new CompilerError("");
            }
            if (this.constant && this.type.isPrimitive() && !Character.isDigit(c = this.value.charAt((n = this.value.length()) - 1))) {
                this.value = this.value.substring(0, n - 1);
            }
            contextStack.pop(true);
        }

        public void setIDLName(String string) {
            this.idlName = string;
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("clone failed");
            }
        }
    }

    public class Method
    implements ContextElement,
    Cloneable {
        private MemberDefinition memberDef;
        private CompoundType enclosing;
        private ValueType[] exceptions;
        private ValueType[] implExceptions;
        private Type returnType;
        private Type[] arguments;
        private String[] argumentNames;
        private String vis;
        private String name;
        private String idlName;
        private String stringRep = null;
        private int attributeKind = 0;
        private String attributeName = null;
        private int attributePairIndex = -1;
        private Identifier declaredBy = null;

        public boolean isInherited() {
            return this.declaredBy != this.enclosing.getIdentifier();
        }

        public boolean isAttribute() {
            return this.attributeKind != 0;
        }

        public boolean isReadWriteAttribute() {
            return this.attributeKind == 3 || this.attributeKind == 4;
        }

        public int getAttributeKind() {
            return this.attributeKind;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public int getAttributePairIndex() {
            return this.attributePairIndex;
        }

        public Method mergeWith(Method method) {
            if (!this.equals(method)) {
                CompoundType.this.env.error(0L, "attempt to merge method failed:", this.getName(), this.enclosing.getClassDefinition().getName());
            }
            ArrayList arrayList = new ArrayList();
            try {
                this.collectCompatibleExceptions(method.exceptions, this.exceptions, arrayList);
                this.collectCompatibleExceptions(this.exceptions, method.exceptions, arrayList);
            }
            catch (ClassNotFound classNotFound) {
                CompoundType.this.env.error(0L, "class.not.found", classNotFound.name, this.enclosing.getClassDefinition().getName());
                return null;
            }
            Method method2 = (Method)this.clone();
            method2.exceptions = new ValueType[arrayList.size()];
            method2.exceptions = arrayList.toArray(method2.exceptions);
            method2.implExceptions = method2.exceptions;
            return method2;
        }

        private void collectCompatibleExceptions(ValueType[] valueTypeArray, ValueType[] valueTypeArray2, List list) throws ClassNotFound {
            block0: for (int i = 0; i < valueTypeArray.length; ++i) {
                if (list.contains(valueTypeArray[i])) continue;
                ClassDefinition classDefinition = valueTypeArray[i].getClassDefinition();
                for (int j = 0; j < valueTypeArray2.length; ++j) {
                    if (!classDefinition.subClassOf(this.enclosing.getEnv(), valueTypeArray2[j].getClassDeclaration())) continue;
                    list.add(valueTypeArray[i]);
                    continue block0;
                }
            }
        }

        @Override
        public String getElementName() {
            return this.memberDef.toString();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            Method method = (Method)object;
            if (this.getName().equals(method.getName()) && this.arguments.length == method.arguments.length) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    if (this.arguments[i].equals(method.arguments[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public CompoundType getEnclosing() {
            return this.enclosing;
        }

        public Identifier getDeclaredBy() {
            return this.declaredBy;
        }

        public String getVisibility() {
            return this.vis;
        }

        public boolean isPublic() {
            return this.memberDef.isPublic();
        }

        public boolean isProtected() {
            return this.memberDef.isPrivate();
        }

        public boolean isPrivate() {
            return this.memberDef.isPrivate();
        }

        public boolean isStatic() {
            return this.memberDef.isStatic();
        }

        public String getName() {
            return this.name;
        }

        public String getIDLName() {
            return this.idlName;
        }

        public String getIDLName(boolean bl) {
            if (bl && this.idlName.startsWith("_") && !this.idlName.startsWith("_get_") && !this.idlName.startsWith("_set_")) {
                return this.idlName.substring(1);
            }
            return this.idlName;
        }

        public sun.tools.java.Type getType() {
            return this.memberDef.getType();
        }

        public boolean isConstructor() {
            return this.memberDef.isConstructor();
        }

        public boolean isNormalMethod() {
            return !this.memberDef.isConstructor() && this.attributeKind == 0;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public Type[] getArguments() {
            return (Type[])this.arguments.clone();
        }

        public String[] getArgumentNames() {
            return this.argumentNames;
        }

        public MemberDefinition getMemberDefinition() {
            return this.memberDef;
        }

        public ValueType[] getExceptions() {
            return (ValueType[])this.exceptions.clone();
        }

        public ValueType[] getImplExceptions() {
            return (ValueType[])this.implExceptions.clone();
        }

        public ValueType[] getUniqueCatchList(ValueType[] valueTypeArray) {
            int n;
            ValueType[] valueTypeArray2 = valueTypeArray;
            int n2 = valueTypeArray.length;
            try {
                Constants constants;
                int n3;
                for (n3 = 0; n3 < valueTypeArray.length; ++n3) {
                    constants = valueTypeArray[n3].getClassDeclaration();
                    if (!CompoundType.this.env.defRemoteException.superClassOf(CompoundType.this.env, (ClassDeclaration)constants) && !CompoundType.this.env.defRuntimeException.superClassOf(CompoundType.this.env, (ClassDeclaration)constants) && !CompoundType.this.env.defError.superClassOf(CompoundType.this.env, (ClassDeclaration)constants)) continue;
                    valueTypeArray[n3] = null;
                    --n2;
                }
                for (n3 = 0; n3 < valueTypeArray.length; ++n3) {
                    if (valueTypeArray[n3] == null) continue;
                    constants = valueTypeArray[n3].getClassDefinition();
                    for (n = 0; n < valueTypeArray.length; ++n) {
                        if (n == n3 || valueTypeArray[n3] == null || valueTypeArray[n] == null || !((ClassDefinition)constants).superClassOf(CompoundType.this.env, valueTypeArray[n].getClassDeclaration())) continue;
                        valueTypeArray[n] = null;
                        --n2;
                    }
                }
            }
            catch (ClassNotFound classNotFound) {
                Type.classNotFound(CompoundType.this.stack, classNotFound);
            }
            if (n2 < valueTypeArray.length) {
                ValueType[] valueTypeArray3 = new ValueType[n2];
                int n4 = 0;
                for (n = 0; n < valueTypeArray.length; ++n) {
                    if (valueTypeArray[n] == null) continue;
                    valueTypeArray3[n4++] = valueTypeArray[n];
                }
                valueTypeArray = valueTypeArray3;
            }
            if (valueTypeArray.length == 0) {
                return null;
            }
            return valueTypeArray;
        }

        public ValueType[] getFilteredStubExceptions(ValueType[] valueTypeArray) {
            ValueType[] valueTypeArray2 = valueTypeArray;
            int n = valueTypeArray.length;
            try {
                for (int i = 0; i < valueTypeArray.length; ++i) {
                    ClassDeclaration classDeclaration = valueTypeArray[i].getClassDeclaration();
                    if ((!CompoundType.this.env.defRemoteException.superClassOf(CompoundType.this.env, classDeclaration) || CompoundType.this.env.defRemoteException.getClassDeclaration().equals(classDeclaration)) && !CompoundType.this.env.defRuntimeException.superClassOf(CompoundType.this.env, classDeclaration) && !CompoundType.this.env.defError.superClassOf(CompoundType.this.env, classDeclaration)) continue;
                    valueTypeArray[i] = null;
                    --n;
                }
            }
            catch (ClassNotFound classNotFound) {
                Type.classNotFound(CompoundType.this.stack, classNotFound);
            }
            if (n < valueTypeArray.length) {
                ValueType[] valueTypeArray3 = new ValueType[n];
                int n2 = 0;
                for (int i = 0; i < valueTypeArray.length; ++i) {
                    if (valueTypeArray[i] == null) continue;
                    valueTypeArray3[n2++] = valueTypeArray[i];
                }
                valueTypeArray = valueTypeArray3;
            }
            return valueTypeArray;
        }

        public String toString() {
            if (this.stringRep == null) {
                int n;
                StringBuffer stringBuffer = new StringBuffer(this.returnType.toString());
                stringBuffer.append(" ");
                stringBuffer.append(this.getName());
                stringBuffer.append(" (");
                for (n = 0; n < this.arguments.length; ++n) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.arguments[n]);
                    stringBuffer.append(" ");
                    stringBuffer.append(this.argumentNames[n]);
                }
                stringBuffer.append(")");
                for (n = 0; n < this.exceptions.length; ++n) {
                    if (n == 0) {
                        stringBuffer.append(" throws ");
                    } else {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.exceptions[n]);
                }
                stringBuffer.append(";");
                this.stringRep = stringBuffer.toString();
            }
            return this.stringRep;
        }

        public void setAttributeKind(int n) {
            this.attributeKind = n;
        }

        public void setAttributePairIndex(int n) {
            this.attributePairIndex = n;
        }

        public void setAttributeName(String string) {
            this.attributeName = string;
        }

        public void setIDLName(String string) {
            this.idlName = string;
        }

        public void setImplExceptions(ValueType[] valueTypeArray) {
            this.implExceptions = valueTypeArray;
        }

        public void setDeclaredBy(Identifier identifier) {
            this.declaredBy = identifier;
        }

        protected void swapInvalidTypes() {
            int n;
            if (this.returnType.getStatus() != 1) {
                this.returnType = CompoundType.this.getValidType(this.returnType);
            } else if (this.returnType instanceof ArrayType) {
                this.returnType.swapInvalidTypes();
            }
            for (n = 0; n < this.arguments.length; ++n) {
                if (this.arguments[n].getStatus() != 1) {
                    this.arguments[n] = CompoundType.this.getValidType(this.arguments[n]);
                    continue;
                }
                if (!(this.arguments[n] instanceof ArrayType)) continue;
                this.arguments[n].swapInvalidTypes();
            }
            for (n = 0; n < this.exceptions.length; ++n) {
                if (this.exceptions[n].getStatus() == 1) continue;
                this.exceptions[n] = (ValueType)CompoundType.this.getValidType(this.exceptions[n]);
            }
            for (n = 0; n < this.implExceptions.length; ++n) {
                if (this.implExceptions[n].getStatus() == 1) continue;
                this.implExceptions[n] = (ValueType)CompoundType.this.getValidType(this.implExceptions[n]);
            }
        }

        public void destroy() {
            if (this.memberDef != null) {
                int n;
                this.memberDef = null;
                this.enclosing = null;
                if (this.exceptions != null) {
                    for (n = 0; n < this.exceptions.length; ++n) {
                        if (this.exceptions[n] != null) {
                            this.exceptions[n].destroy();
                        }
                        this.exceptions[n] = null;
                    }
                    this.exceptions = null;
                }
                if (this.implExceptions != null) {
                    for (n = 0; n < this.implExceptions.length; ++n) {
                        if (this.implExceptions[n] != null) {
                            this.implExceptions[n].destroy();
                        }
                        this.implExceptions[n] = null;
                    }
                    this.implExceptions = null;
                }
                if (this.returnType != null) {
                    this.returnType.destroy();
                }
                this.returnType = null;
                if (this.arguments != null) {
                    for (n = 0; n < this.arguments.length; ++n) {
                        if (this.arguments[n] != null) {
                            this.arguments[n].destroy();
                        }
                        this.arguments[n] = null;
                    }
                    this.arguments = null;
                }
                if (this.argumentNames != null) {
                    for (n = 0; n < this.argumentNames.length; ++n) {
                        this.argumentNames[n] = null;
                    }
                    this.argumentNames = null;
                }
                this.vis = null;
                this.name = null;
                this.idlName = null;
                this.stringRep = null;
                this.attributeName = null;
                this.declaredBy = null;
            }
        }

        private String makeArgName(int n, Type type) {
            return "arg" + n;
        }

        public Method(CompoundType compoundType2, MemberDefinition memberDefinition, boolean bl, ContextStack contextStack) throws Exception {
            this.enclosing = compoundType2;
            this.memberDef = memberDefinition;
            this.vis = CompoundType.getVisibilityString(memberDefinition);
            this.idlName = null;
            boolean bl2 = true;
            this.declaredBy = memberDefinition.getClassDeclaration().getName();
            this.name = memberDefinition.getName().toString();
            contextStack.setNewContextCode(2);
            contextStack.push(this);
            contextStack.setNewContextCode(3);
            sun.tools.java.Type type = memberDefinition.getType();
            sun.tools.java.Type type2 = type.getReturnType();
            if (type2 == sun.tools.java.Type.tVoid) {
                this.returnType = PrimitiveType.forPrimitive(type2, contextStack);
            } else {
                this.returnType = CompoundType.makeType(type2, null, contextStack);
                if (this.returnType == null || !CompoundType.this.assertNotImpl(this.returnType, bl, contextStack, compoundType2, false)) {
                    bl2 = false;
                    Type.failedConstraint(24, bl, contextStack, compoundType2.getName());
                }
            }
            contextStack.setNewContextCode(4);
            sun.tools.java.Type[] typeArray = memberDefinition.getType().getArgumentTypes();
            this.arguments = new Type[typeArray.length];
            this.argumentNames = new String[typeArray.length];
            Vector vector = memberDefinition.getArguments();
            for (int i = 0; i < typeArray.length; ++i) {
                Type type3 = null;
                try {
                    type3 = CompoundType.makeType(typeArray[i], null, contextStack);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (type3 != null) {
                    if (!CompoundType.this.assertNotImpl(type3, bl, contextStack, compoundType2, false)) {
                        bl2 = false;
                        continue;
                    }
                    this.arguments[i] = type3;
                    if (vector != null) {
                        LocalMember localMember = (LocalMember)vector.elementAt(i + 1);
                        this.argumentNames[i] = localMember.getName().toString();
                        continue;
                    }
                    this.argumentNames[i] = this.makeArgName(i, type3);
                    continue;
                }
                bl2 = false;
                Type.failedConstraint(25, false, contextStack, compoundType2.getQualifiedName(), this.name);
            }
            if (!bl2) {
                contextStack.pop(false);
                throw new Exception();
            }
            try {
                this.exceptions = compoundType2.getMethodExceptions(memberDefinition, bl, contextStack);
                this.implExceptions = this.exceptions;
                contextStack.pop(true);
            }
            catch (Exception exception) {
                contextStack.pop(false);
                throw new Exception();
            }
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("clone failed");
            }
        }
    }
}

