/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IBootstrapRunnable;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9RASImageDataFactory;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASSystemInfoPointer;
import com.ibm.j9ddr.vm29.structure.RasdumpInternalConstants;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class J9RASInfoBootstrapShim
implements IBootstrapRunnable {
    @Override
    public void run(IVMData vmData, Object[] userData) {
        Object[] passbackArray = (Object[])userData[0];
        passbackArray[0] = new J9RASInfoObject();
    }

    private static final class J9RASInfoObject
    implements J9RASImageDataFactory.MachineData,
    J9RASImageDataFactory.ProcessData {
        private final J9RASPointer ptr = DataType.getJ9RASPointer();

        J9RASInfoObject() {
        }

        @Override
        public int version() throws CorruptDataException {
            return this.ptr.version().intValue() >> 16;
        }

        @Override
        public int cpus() throws CorruptDataException {
            try {
                return this.ptr.cpus().intValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.cpus().getHexValue(), e);
            }
        }

        @Override
        public long memoryBytes() throws CorruptDataException {
            try {
                return this.ptr.memory().longValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.memory().getHexValue(), e);
            }
        }

        @Override
        public String osArch() throws CorruptDataException {
            return this.ptr.osarchEA().getCStringAtOffset(0L);
        }

        @Override
        public String osName() throws CorruptDataException {
            return this.ptr.osnameEA().getCStringAtOffset(0L);
        }

        @Override
        public String osVersion() throws CorruptDataException {
            return this.ptr.osversionEA().getCStringAtOffset(0L);
        }

        @Override
        public long pid() throws CorruptDataException {
            try {
                return this.ptr.pid().longValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.pid().getHexValue(), e);
            }
        }

        @Override
        public long tid() throws CorruptDataException {
            try {
                return this.ptr.tid().longValue();
            }
            catch (InvalidDataTypeException e) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.tid().getHexValue(), e);
            }
        }

        @Override
        public String gpInfo() throws CorruptDataException {
            if (this.ptr.crashInfo().isNull()) {
                return "";
            }
            if (this.ptr.crashInfo().gpInfo().isNull()) {
                return null;
            }
            return this.ptr.crashInfo().gpInfo().getCStringAtOffset(0L);
        }

        @Override
        public String hostName() throws DataUnavailableException, CorruptDataException {
            if (this.ptr.hostnameEA().notNull()) {
                return this.ptr.hostnameEA().getCStringAtOffset(0L);
            }
            throw new DataUnavailableException("Host name not available");
        }

        @Override
        public Iterator<Object> ipaddresses() throws DataUnavailableException, CorruptDataException {
            ArrayList<Object> addresses = new ArrayList<Object>();
            U8Pointer ip = this.ptr.ipAddressesEA();
            if (ip.isNull()) {
                throw new DataUnavailableException("IP addresses not available");
            }
            byte[] ipv4 = new byte[4];
            byte[] ipv6 = new byte[16];
            block7: while (true) {
                int type2 = ip.at(0L).intValue();
                ip = ip.add(1L);
                try {
                    InetAddress address;
                    switch (type2) {
                        case 0: {
                            break block7;
                        }
                        case 4: {
                            DataType.getProcess().getBytesAt(ip.getAddress(), ipv4);
                            ip = ip.add(ipv4.length);
                            address = InetAddress.getByAddress(ipv4);
                            break;
                        }
                        case 6: {
                            DataType.getProcess().getBytesAt(ip.getAddress(), ipv6);
                            ip = ip.add(ipv6.length);
                            address = InetAddress.getByAddress(ipv6);
                            break;
                        }
                        default: {
                            addresses.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Unknown IP address type identifier : " + type2));
                            break block7;
                        }
                    }
                    if (addresses.contains(address)) continue;
                    addresses.add(address);
                }
                catch (UnknownHostException e) {
                    addresses.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Corrupt IP address : " + e.getMessage()));
                }
            }
            if (addresses.isEmpty()) {
                throw new DataUnavailableException("IP addresses not available");
            }
            return addresses.iterator();
        }

        @Override
        public IProcess getProcess() {
            return DataType.getProcess();
        }

        @Override
        public long getEnvironment() throws CorruptDataException {
            return this.ptr.environment().longValue();
        }

        @Override
        public Properties systemInfo() throws DataUnavailableException, CorruptDataException {
            Properties properties = new Properties();
            J9RASSystemInfoPointer systemInfo = this.ptr.systemInfo();
            if (systemInfo.notNull()) {
                J9RASSystemInfoPointer firstSystemInfo = systemInfo;
                do {
                    int key;
                    if ((key = systemInfo.key().intValue()) == (int)RasdumpInternalConstants.J9RAS_SYSTEMINFO_SCHED_COMPAT_YIELD) {
                        byte[] data = new byte[1];
                        systemInfo.dataEA().getBytesAtOffset(0L, data);
                        properties.put("/proc/sys/kernel/sched_compat_yield", new String(data, StandardCharsets.UTF_8));
                        continue;
                    }
                    if (key == (int)RasdumpInternalConstants.J9RAS_SYSTEMINFO_HYPERVISOR) {
                        properties.put("Hypervisor", U8Pointer.cast(systemInfo.data()).getCStringAtOffset(0L));
                        continue;
                    }
                    if (key == (int)RasdumpInternalConstants.J9RAS_SYSTEMINFO_CORE_PATTERN) {
                        properties.put("/proc/sys/kernel/core_pattern", U8Pointer.cast(systemInfo.data()).getCStringAtOffset(0L));
                        continue;
                    }
                    if (key != (int)RasdumpInternalConstants.J9RAS_SYSTEMINFO_CORE_USES_PID) continue;
                    properties.put("/proc/sys/kernel/core_uses_pid", U8Pointer.cast(systemInfo.data()).getCStringAtOffset(0L));
                } while (!(systemInfo = systemInfo.linkNext()).equals(firstSystemInfo));
            }
            return properties;
        }

        @Override
        public long dumpTimeMillis() throws DataUnavailableException, CorruptDataException {
            long timestamp = this.ptr.dumpTimeMillis().longValue();
            if (timestamp == 0L) {
                throw new DataUnavailableException("Dump creation time (millisecs) not set");
            }
            return timestamp;
        }

        @Override
        public long dumpTimeNanos() throws DataUnavailableException, CorruptDataException {
            long timestamp = this.ptr.dumpTimeNanos().longValue();
            if (timestamp == 0L) {
                throw new DataUnavailableException("Dump creation time (nanosecs) not set");
            }
            return timestamp;
        }
    }
}

