/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;

public class CoreInfoCommand
extends Command {
    public CoreInfoCommand() {
        this.addCommand("coreinfo", "", "Prints commandline, platform and -version info of VM found in the current core file.");
    }

    private void printUsage(PrintStream out) {
        out.println("coreinfo - Prints commandline, platform and -version info of VM found in the current core file.");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (0 < args.length) {
            out.println("!coreinfo expects no args. Usage :");
            this.printUsage(out);
            return;
        }
        try {
            J9RASPointer ras = DataType.getJ9RASPointer();
            J9JavaVMPointer vm = J9RASHelper.getVM(ras);
            IProcess process = vm.getProcess();
            J9DDRImageProcess ddrProcess = new J9DDRImageProcess(process);
            try {
                out.println("COMMANDLINE");
                out.println(ddrProcess.getCommandLine());
                out.println();
            }
            catch (DataUnavailable e) {
                out.println("COMMANDLINE is not available");
                out.println();
            }
            catch (com.ibm.dtfj.image.CorruptDataException e) {
                throw new DDRInteractiveCommandException("CorruptDataException occured while getting the command line from process");
            }
            Properties properties = J9JavaVMHelper.getSystemProperties(vm);
            String unavailable = "- not available";
            out.println("JAVA VM NAME\t- " + properties.getProperty("java.vm.name", unavailable));
            out.println("JAVA VM VERSION\t- " + properties.getProperty("java.vm.version", unavailable));
            out.println("JAVA SERVICE LEVEL INFO");
            try {
                out.println(ras.serviceLevel().getCStringAtOffset(0L));
            }
            catch (CorruptDataException e) {
                out.println(unavailable);
            }
            try {
                U8Pointer productName = ras.productName();
                if (productName.notNull()) {
                    out.println("JAVA PRODUCT INFO");
                    try {
                        out.println(productName.getCStringAtOffset(0L));
                    }
                    catch (CorruptDataException e) {
                        out.println(unavailable);
                    }
                }
            }
            catch (NoSuchFieldException productName) {
                // empty catch block
            }
            out.println("JAVA VERSION INFO");
            out.println(properties.getProperty("java.fullversion", unavailable));
            out.println();
            boolean is64BitPlatform = process.bytesPerPointer() == 8;
            ICore core = process.getAddressSpace().getCore();
            Platform platform = core.getPlatform();
            out.println("PLATFORM INFO");
            out.print("Platform Name :\t");
            out.print(platform.name());
            out.println(is64BitPlatform ? " 64Bit" : " 32Bit");
            out.print("OS Level\t: ");
            try {
                out.println(ras.osnameEA().getCStringAtOffset(0L) + " " + ras.osversionEA().getCStringAtOffset(0L));
            }
            catch (CorruptDataException e) {
                out.println(unavailable);
            }
            out.println("Processors -");
            out.print("  Architecture\t: ");
            try {
                out.println(ras.osarchEA().getCStringAtOffset(0L));
            }
            catch (CorruptDataException e) {
                out.println(unavailable);
            }
            out.println("  How Many\t: " + ras.cpus().longValue());
            out.println();
            out.println("VM PROPERTIES (these are not Java system properties)");
            ArrayList<String> propNames = new ArrayList<String>(properties.stringPropertyNames());
            Collections.sort(propNames);
            for (String key : propNames) {
                out.println("  " + key + " = " + properties.get(key));
            }
            try {
                Properties environment = ddrProcess.getEnvironment();
                ArrayList<String> envNames = new ArrayList<String>(environment.stringPropertyNames());
                Collections.sort(envNames);
                out.println();
                out.println("ENVIRONMENT VARIABLES");
                for (String key : envNames) {
                    out.println("  " + key + "=" + environment.get(key));
                }
            }
            catch (com.ibm.dtfj.image.CorruptDataException e) {
                throw new DDRInteractiveCommandException("CorruptDataException occured while getting the environment variables from process");
            }
            catch (DataUnavailable e) {
                out.println("Environment variables are not available");
                out.println();
            }
        }
        catch (CorruptDataException e) {
            e.printStackTrace();
        }
    }
}

