/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.MonitorTable;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MonitorTableListEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.util.NoSuchElementException;

public class MonitorTableListIterator
implements SlotIterator<J9ObjectMonitorPointer> {
    private MonitorTable currentMonitorTable = MonitorTable.from(J9RASHelper.getVM(DataType.getJ9RASPointer()).monitorTableList());
    SlotIterator<J9ObjectMonitorPointer> localIterator = this.currentMonitorTable.iterator();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNext() {
        while (!this.localIterator.hasNext()) {
            J9MonitorTableListEntryPointer entry = this.currentMonitorTable.getMonitorTableListEntryPointer();
            try {
                entry = entry.next();
                if (!entry.notNull()) {
                    return false;
                }
                this.currentMonitorTable = MonitorTable.from(entry);
                this.localIterator = this.currentMonitorTable.iterator();
            }
            catch (CorruptDataException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public J9ObjectMonitorPointer next() {
        if (this.hasNext()) {
            return (J9ObjectMonitorPointer)this.localIterator.next();
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public MonitorTable currentMonitorTable() {
        return this.currentMonitorTable;
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            return this.localIterator.nextAddress();
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

