/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.walkers.Base;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9VMThreadPointer;
import java.util.NoSuchElementException;

public class ThreadListIterator
extends Base {
    protected J9VMThreadPointer initialVMThread;
    protected J9VMThreadPointer currentVMThread;
    protected boolean consumedInitial;

    protected ThreadListIterator() throws CorruptDataException {
        this.currentVMThread = this.initialVMThread = ThreadListIterator.getJavaVM().mainThread();
    }

    public static ThreadListIterator from() throws CorruptDataException {
        return new ThreadListIterator();
    }

    public boolean hasNext() {
        return this.currentVMThread.notNull();
    }

    public J9VMThreadPointer next() {
        try {
            if (this.hasNext()) {
                J9VMThreadPointer next = this.currentVMThread;
                this.currentVMThread = this.currentVMThread.linkNext();
                if (this.currentVMThread.equals(this.initialVMThread)) {
                    this.currentVMThread = J9VMThreadPointer.NULL;
                }
                return next;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error getting next item", cde, false);
            return null;
        }
    }

    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

