/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.HelperBase;
import com.ibm.j9ddr.StructureReader;
import java.util.LinkedHashMap;
import java.util.Map;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;

final class StructureHelper
extends HelperBase {
    private final String className;
    private final ClassWriter clazz;
    private final MethodVisitor clinit;
    private final StructureReader.StructureDescriptor structure;

    static byte[] getClassBytes(StructureReader.StructureDescriptor structure, String className) {
        StructureHelper helper = new StructureHelper(structure, className);
        return helper.generate();
    }

    private StructureHelper(StructureReader.StructureDescriptor structure, String className) {
        this.className = className;
        this.structure = structure;
        this.clazz = new ClassWriter(0);
        this.clazz.visit(52, 49, className, null, "java/lang/Object", null);
        this.clinit = this.clazz.visitMethod(8, "<clinit>", "()V", null, null);
        this.clinit.visitCode();
    }

    private void defineField(String name, Type type2, long value) {
        String typeDescriptor = type2.getDescriptor();
        this.clazz.visitField(25, name, typeDescriptor, null, null).visitEnd();
        if (type2.getSort() == 5) {
            StructureHelper.loadInt(this.clinit, (int)value);
        } else {
            StructureHelper.loadLong(this.clinit, value);
        }
        this.clinit.visitFieldInsn(179, this.className, name, typeDescriptor);
    }

    private void defineFields() {
        this.defineField("SIZEOF", Type.LONG_TYPE, this.structure.getSizeOf());
        for (StructureReader.ConstantDescriptor constantDescriptor : this.structure.getConstants()) {
            this.defineField(constantDescriptor.getName(), Type.LONG_TYPE, constantDescriptor.getValue());
        }
        for (Map.Entry entry : this.getFieldMap().entrySet()) {
            String fieldName = (String)entry.getKey();
            int fieldValue = (Integer)entry.getValue();
            this.defineField(fieldName, Type.INT_TYPE, fieldValue);
        }
        this.clinit.visitInsn(177);
        this.clinit.visitMaxs(2, 0);
        this.clinit.visitEnd();
    }

    private byte[] generate() {
        this.defineFields();
        MethodVisitor method = this.clazz.visitMethod(1, "<init>", "()V", null, null);
        method.visitCode();
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        method.visitInsn(177);
        method.visitMaxs(1, 1);
        method.visitEnd();
        this.clazz.visitEnd();
        return this.clazz.toByteArray();
    }

    private Map<String, Integer> getFieldMap() {
        LinkedHashMap<String, Integer> fields = new LinkedHashMap<String, Integer>();
        int bitFieldBitCount = 0;
        for (StructureReader.FieldDescriptor field : this.structure.getFields()) {
            if (!field.isPresent()) continue;
            String fieldName = field.getName();
            int fieldOffset = field.getOffset();
            String type2 = field.getType();
            int colonIndex = type2.lastIndexOf(58);
            if (colonIndex <= 0 || type2.charAt(colonIndex - 1) == ':') {
                fields.put(String.format("_%sOffset_", fieldName), fieldOffset);
                continue;
            }
            int bitSize = Integer.parseInt(type2.substring(colonIndex + 1).trim());
            if (bitSize > 32 - (bitFieldBitCount = Math.max(bitFieldBitCount, fieldOffset * 8)) % 32) {
                throw new InternalError(String.format("Bitfield %s->%s must not span cells", this.structure.getName(), fieldName));
            }
            fields.put(String.format("_%s_s_", fieldName), bitFieldBitCount);
            fields.put(String.format("_%s_b_", fieldName), bitSize);
            bitFieldBitCount += bitSize;
        }
        return fields;
    }
}

