/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Opcodes;

abstract class HelperBase
implements Opcodes {
    static final String byteFromLong = "(J)B";
    static final String doubleFromLong = "(J)D";
    static final String doubleFromVoid = "()D";
    static final String floatFromLong = "(J)F";
    static final String floatFromVoid = "()F";
    static final String intFromLong = "(J)I";
    static final String longFromLong = "(J)J";
    static final String longFromVoid = "()J";
    static final String shortFromLong = "(J)S";
    static final String voidFromLong = "(J)V";
    static final String voidMethod = "()V";

    HelperBase() {
    }

    static final void addLong(MethodVisitor method, long value) {
        if (value != 0L) {
            HelperBase.loadLong(method, value);
            method.visitInsn(97);
        }
    }

    static final void loadInt(MethodVisitor method, int value) {
        switch (value) {
            case -1: {
                method.visitInsn(2);
                break;
            }
            case 0: {
                method.visitInsn(3);
                break;
            }
            case 1: {
                method.visitInsn(4);
                break;
            }
            case 2: {
                method.visitInsn(5);
                break;
            }
            case 3: {
                method.visitInsn(6);
                break;
            }
            case 4: {
                method.visitInsn(7);
                break;
            }
            case 5: {
                method.visitInsn(8);
                break;
            }
            default: {
                if (-128 <= value && value <= 127) {
                    method.visitIntInsn(16, value);
                    break;
                }
                if (Short.MIN_VALUE <= value && value <= Short.MAX_VALUE) {
                    method.visitIntInsn(17, value);
                    break;
                }
                method.visitLdcInsn(value);
            }
        }
    }

    static final void loadLong(MethodVisitor method, long value) {
        if (value == 0L) {
            method.visitInsn(9);
        } else if (value == 1L) {
            method.visitInsn(10);
        } else {
            method.visitLdcInsn(value);
        }
    }
}

