/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.CCVTStatus;
import com.ibm.misc.Debug;
import java.security.Provider;
import java.util.ArrayList;
import java.util.List;

class TableObject {
    public static boolean IsAvailable;
    private static Debug debug;
    private static final String className = "com.ibm.crypto.ibmjcehybrid.provider.TableObject";
    private String algorithm = null;
    private List<Provider> providerList = null;
    private int resetCounter = 0;
    private String bestProvider = null;
    private List<String> failureList = new ArrayList<String>();
    private int NUMFAILURES_OR_SUCCESSES = 5;
    private CCVTStatus status = null;
    private static boolean IsPCICAPresent;
    private static boolean IsPCIXCCPresent;
    private static boolean IsPCICCPresent;
    private static boolean IsCryptoAssistPresent;
    private static boolean IsDESCryptoAssistPresent;
    private static boolean Is3DESCryptoAssistPresent;
    private static boolean IsSHACryptoAssistPresent;
    private static boolean IsICSFPresent;
    private boolean PrevIsPCICAPresent = false;
    private boolean PrevIsPCIXCCPresent = false;
    private boolean PrevIsPCICCPresent = false;
    private boolean PrevIsCryptoAssistPresent = false;
    private boolean PrevIsDESCryptoAssistPresent = false;
    private boolean PrevIs3DESCryptoAssistPresent = false;
    private boolean PrevIsSHACryptoAssistPresent = false;
    private boolean PrevIsICSFPresent = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableObject(String algorithm, List<Provider> providerList) {
        String string = className;
        synchronized (className) {
            this.status = new CCVTStatus();
            this.algorithm = algorithm;
            this.providerList = providerList;
            this.status.SetupCardInformation(this);
            this.PrevIsPCICAPresent = IsPCICAPresent;
            this.PrevIsPCIXCCPresent = IsPCIXCCPresent;
            this.PrevIsPCICCPresent = IsPCICCPresent;
            this.PrevIsCryptoAssistPresent = IsCryptoAssistPresent;
            this.PrevIsDESCryptoAssistPresent = IsDESCryptoAssistPresent;
            this.PrevIs3DESCryptoAssistPresent = Is3DESCryptoAssistPresent;
            this.PrevIsSHACryptoAssistPresent = IsSHACryptoAssistPresent;
            this.PrevIsICSFPresent = IsICSFPresent;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBestProvider() {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getBestProvider");
        }
        String string = className;
        synchronized (className) {
            ++this.resetCounter;
            this.doResetIfNeeded();
            for (Provider provider : this.providerList) {
                if (provider.getName().equalsIgnoreCase("IBMJCEHYBRID") || this.failureList.contains(provider.getName())) continue;
                this.bestProvider = provider.getName();
                if (debug != null) {
                    debug.exit(49152L, (Object)className, "getBestProvider", (Object)this.bestProvider);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.bestProvider;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getBestProvider", null);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCurrentBestProvider() {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getCurrentBestProvider");
        }
        String string = className;
        synchronized (className) {
            for (Provider provider : this.providerList) {
                if (provider.getName().equalsIgnoreCase("IBMJCEHYBRID") || this.failureList.contains(provider.getName())) continue;
                this.bestProvider = provider.getName();
                if (debug != null) {
                    debug.exit(49152L, (Object)className, "getBestProvider", (Object)this.bestProvider);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.bestProvider;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getCurrentBestProvider", null);
            }
            return null;
        }
    }

    public void doReset() {
        this.resetCounter = 0;
        this.failureList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResetIfNeeded() {
        String string = className;
        synchronized (className) {
            if (this.resetCounter == this.NUMFAILURES_OR_SUCCESSES) {
                this.doReset();
            }
            this.status.SetupCardInformation(this);
            if (this.PrevIsPCICAPresent != IsPCICAPresent || this.PrevIsPCIXCCPresent != IsPCIXCCPresent || this.PrevIsPCICCPresent != IsPCICCPresent || this.PrevIsCryptoAssistPresent != IsCryptoAssistPresent || this.PrevIsDESCryptoAssistPresent != IsDESCryptoAssistPresent || this.PrevIs3DESCryptoAssistPresent != Is3DESCryptoAssistPresent || this.PrevIsSHACryptoAssistPresent != IsSHACryptoAssistPresent || this.PrevIsICSFPresent != IsICSFPresent) {
                this.doReset();
            }
            this.PrevIsPCICAPresent = IsPCICAPresent;
            this.PrevIsPCIXCCPresent = IsPCIXCCPresent;
            this.PrevIsPCICCPresent = IsPCICCPresent;
            this.PrevIsCryptoAssistPresent = IsCryptoAssistPresent;
            this.PrevIsDESCryptoAssistPresent = IsDESCryptoAssistPresent;
            this.PrevIs3DESCryptoAssistPresent = Is3DESCryptoAssistPresent;
            this.PrevIsSHACryptoAssistPresent = IsSHACryptoAssistPresent;
            this.PrevIsICSFPresent = IsICSFPresent;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateProvider(String provider) {
        String string = className;
        synchronized (className) {
            this.failureList.add(provider);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return "Algorithm: " + this.algorithm + "\nSupported Providers: " + this.providerList + "\nReset Counter: " + this.resetCounter + "\nBest Provider: " + this.bestProvider;
    }

    static {
        block2: {
            debug = Debug.getInstance((String)"ibmjcehybrid");
            try {
                System.loadLibrary("status");
                IsAvailable = true;
            }
            catch (Throwable t) {
                IsAvailable = false;
                if (debug == null) break block2;
                debug.exception(16384L, (Object)className, "status", t);
            }
        }
        IsPCICAPresent = false;
        IsPCIXCCPresent = false;
        IsPCICCPresent = false;
        IsCryptoAssistPresent = false;
        IsDESCryptoAssistPresent = false;
        Is3DESCryptoAssistPresent = false;
        IsSHACryptoAssistPresent = false;
        IsICSFPresent = false;
    }
}

