/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.HybridUtils;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;

public final class IBMJCEHYBRID
extends Provider {
    private static final long serialVersionUID = -8832040333988007223L;
    private static String info = "IBMJCEHybrid Provider";
    private static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static String className = "com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHYBRID";

    public IBMJCEHYBRID() {
        super("IBMJCEHYBRID", 1.0, info);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IBMJCEHYBRID");
            HybridUtils.traceEnvironment();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IBMJCEHYBRID.this.setupSupportedServices();
                return null;
            }
        });
        if (debug != null) {
            debug.exit(16384L, (Object)className, "IBMJCEHYBRID");
        }
    }

    void setupSupportedServices() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setupSupportedServices", null);
        }
        String[] aliases = null;
        this.putService(new JceHybridService(this, "AlgorithmParameters", "AlgParmNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProAlgorithmParameters", null));
        this.putService(new JceHybridService(this, "AlgorithmParameterGenerator", "AlgParmGenNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProAlgorithmParameterGenerator", null));
        this.putService(new JceHybridService(this, "CertificateFactory", "CertFactNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProCertificateFactory", null));
        this.putService(new JceHybridService(this, "Cipher", "CipherNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProCipher", null));
        this.putService(new JceHybridService(this, "KeyAgreement", "KeyAgreeNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProKeyAgreement", null));
        this.putService(new JceHybridService(this, "KeyFactory", "KeyFactNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProKeyFactory", null));
        this.putService(new JceHybridService(this, "KeyGenerator", "KeyGenNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProKeyGenerator", null));
        this.putService(new JceHybridService(this, "KeyPairGenerator", "KeyPairGenNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProKeyPairGenerator", aliases));
        this.putService(new JceHybridService(this, "Mac", "MacNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProMac", null));
        this.putService(new JceHybridService(this, "MessageDigest", "MsgDigestNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProMessageDigest", null));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "SecretKeyFactNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProSecretKeyFactory", null));
        this.putService(new JceHybridService(this, "Signature", "SignatureNoPro", "com.ibm.crypto.ibmjcehybrid.provider.NoProSignature", null));
        this.putService(new JceHybridService(this, "SecureRandom", "IBMSecureRandom", "com.ibm.crypto.ibmjcehybrid.provider.IBMSecureRandomHybrid", null));
        this.putService(new JceHybridService(this, "SecureRandom", "SHA1PRNG", "com.ibm.crypto.ibmjcehybrid.provider.SHA1PRNGHybrid", null));
        aliases = new String[]{"SHA-1withRSA", "SHA-1/RSA", "SHA1/RSA", "SHA/RSA", "RSA", "OID.1.3.14.3.2.26", "1.3.14.3.2.26", "OID.1.2.840.113549.1.1.5", "1.2.840.113549.1.1.5", "SHA1withRSA"};
        this.putService(new JceHybridService(this, "Signature", "SHA1withRSA", "com.ibm.crypto.ibmjcehybrid.provider.SHA1withRSAHybrid", aliases));
        aliases = new String[]{"NoHashwithRSA"};
        this.putService(new JceHybridService(this, "Signature", "RSAforSSL", "com.ibm.crypto.ibmjcehybrid.provider.RSAforSSLHybrid", aliases));
        aliases = new String[]{"NoHashwithDSA"};
        this.putService(new JceHybridService(this, "Signature", "DSAforSSL", "com.ibm.crypto.ibmjcehybrid.provider.DSAforSSLHybrid", aliases));
        aliases = new String[]{"MD2/RSA", "OID.1.2.840.113549.1.1.2", "1.2.840.113549.1.1.2", "OID.1.3.14.3.2.24", "1.3.14.3.2.24"};
        this.putService(new JceHybridService(this, "Signature", "MD2withRSA", "com.ibm.crypto.ibmjcehybrid.provider.MD2withRSAHybrid", aliases));
        aliases = new String[]{"MD5/RSA", "OID.1.2.840.113549.1.1.4", "1.2.840.113549.1.1.4", "OID.1.3.14.3.2.25", "1.3.14.3.2.25"};
        this.putService(new JceHybridService(this, "Signature", "MD5withRSA", "com.ibm.crypto.ibmjcehybrid.provider.MD5withRSAHybrid", aliases));
        aliases = new String[]{"SHA-1withDSA", "SHA-1/DSA", "SHA1/DSA", "SHA/DSA", "DSA", "DSS", "SHAwithDSA", "DSAWithSHA1", "OID.1.2.840.10040.4.3", "1.2.840.10040.4.3", "OID.1.3.14.3.2.13", "1.3.14.3.2.13", "OID.1.3.14.3.2.27", "1.3.14.3.2.27"};
        this.putService(new JceHybridService(this, "Signature", "SHA1withDSA", "com.ibm.crypto.ibmjcehybrid.provider.SHA1withDSAHybrid", aliases));
        aliases = new String[]{"SHA256withRSA", "SHA2/RSA", "OID.2.16.840.1.101.3.4.2.1", "2.16.840.1.101.3.4.2.1", "OID.1.2.840.113549.1.1.11", "1.2.840.113549.1.1.11"};
        this.putService(new JceHybridService(this, "Signature", "SHA2withRSA", "com.ibm.crypto.ibmjcehybrid.provider.SHA2withRSAHybrid", aliases));
        aliases = new String[]{"SHA384withRSA", "SHA3/RSA", "OID.2.16.840.1.101.3.4.2.2", "2.16.840.1.101.3.4.2.2", "OID.1.2.840.113549.1.1.12", "1.2.840.113549.1.1.12"};
        this.putService(new JceHybridService(this, "Signature", "SHA3withRSA", "com.ibm.crypto.ibmjcehybrid.provider.SHA3withRSAHybrid", aliases));
        aliases = new String[]{"SHA512withRSA", "SHA5/RSA", "OID.2.16.840.1.101.3.4.2.3", "2.16.840.1.101.3.4.2.3", "OID.1.2.840.113549.1.1.13", "1.2.840.113549.1.1.13"};
        this.putService(new JceHybridService(this, "Signature", "SHA5withRSA", "com.ibm.crypto.ibmjcehybrid.provider.SHA5withRSAHybrid", aliases));
        aliases = new String[]{"RSASSA-PSS", "RSAPSS", "RSA-PSS", "RSASA-PSS", "1.2.840.113549.1.1.10", "OID.1.2.840.113549.1.1.10"};
        this.putService(new JceHybridService(this, "Signature", "RSAPSS", "com.ibm.crypto.ibmjcehybrid.provider.RSAPSSSignatureHybrid", aliases));
        aliases = new String[]{"SHAwithECDSA", "SHA-1withECDSA", "SHA/ECDSA", "SHA-1/ECDSA", "OID.1.2.840.10045.4.1", "1.2.840.10045.4.1"};
        this.putService(new JceHybridService(this, "Signature", "SHA1withECDSA", "com.ibm.crypto.ibmjcehybrid.provider.SHA1withECDSAHybrid", aliases));
        aliases = new String[]{"NONEwithECDSA"};
        this.putService(new JceHybridService(this, "Signature", "ECDSAforSSL", "com.ibm.crypto.ibmjcehybrid.provider.ECDSAforSSLHybrid", aliases));
        aliases = new String[]{"SHA224/ECDSA", "OID.1.2.840.10045.4.3.1", "1.2.840.10045.4.3.1"};
        this.putService(new JceHybridService(this, "Signature", "SHA224withECDSA", "com.ibm.crypto.ibmjcehybrid.provider.SHA224withECDSAHybrid", aliases));
        aliases = new String[]{"SHA256withECDSA", "ECDSA", "EC", "SHA2/ECDSA", "OID.1.2.840.10045.4.3.2", "1.2.840.10045.4.3.2"};
        this.putService(new JceHybridService(this, "Signature", "SHA2withECDSA", "com.ibm.crypto.ibmjcehybrid.provider.SHA2withECDSAHybrid", aliases));
        aliases = new String[]{"SHA384withECDSA", "SHA3/ECDSA", "OID.1.2.840.10045.4.3.3", "1.2.840.10045.4.3.3"};
        this.putService(new JceHybridService(this, "Signature", "SHA3withECDSA", "com.ibm.crypto.ibmjcehybrid.provider.SHA3withECDSAHybrid", aliases));
        aliases = new String[]{"SHA512withECDSA", "SHA5/ECDSA", "OID.1.2.840.10045.4.3.4", "1.2.840.10045.4.3.4"};
        this.putService(new JceHybridService(this, "Signature", "SHA5withECDSA", "com.ibm.crypto.ibmjcehybrid.provider.SHA5withECDSAHybrid", aliases));
        this.putService(new JceHybridService(this, "Cipher", "AES", "com.ibm.crypto.ibmjcehybrid.provider.AESCipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "AES/CBC/NoPadding", "com.ibm.crypto.ibmjcehybrid.provider.AES_CBC_NoPad_CipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "AES/CBC/PKCS5Padding", "com.ibm.crypto.ibmjcehybrid.provider.AES_CBC_PKCS5_CipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "AES/ECB/NoPadding", "com.ibm.crypto.ibmjcehybrid.provider.AES_ECB_NoPad_CipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "AES/ECB/PKCS5Padding", "com.ibm.crypto.ibmjcehybrid.provider.AES_ECB_PKCS5_CipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "DES/CBC/NoPadding", "com.ibm.crypto.ibmjcehybrid.provider.DES_CBC_NoPad_CipherHybrid", null));
        aliases = new String[]{"DESede/CBC/NoPadding"};
        this.putService(new JceHybridService(this, "Cipher", "TripleDES/CBC/NoPadding", "com.ibm.crypto.ibmjcehybrid.provider.TripleDES_CBC_NoPad_CipherHybrid", aliases));
        this.putService(new JceHybridService(this, "Cipher", "DES", "com.ibm.crypto.ibmjcehybrid.provider.DESCipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "ELGamal", "com.ibm.crypto.ibmjcehybrid.provider.ELGamalCipherHybrid", null));
        aliases = new String[]{"TripleDES", "3DES"};
        this.putService(new JceHybridService(this, "Cipher", "DESede", "com.ibm.crypto.ibmjcehybrid.provider.DESedeCipherHybrid", aliases));
        this.putService(new JceHybridService(this, "Cipher", "PBEWithMD2AndDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD2andDESCipherHybrid", null));
        aliases = new String[]{"PBEWithMD2And3DES", "PBEWithMD2AndDESede"};
        this.putService(new JceHybridService(this, "Cipher", "PBEWithMD2AndTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD2andTripleDESCipherHybrid", aliases));
        this.putService(new JceHybridService(this, "Cipher", "PBEWithMD5AndDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD5andDESCipherHybrid", null));
        aliases = new String[]{"PBEWithMD5And3DES", "PBEWithMD5AndDESede"};
        this.putService(new JceHybridService(this, "Cipher", "PBEWithMD5AndTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD5andTripleDESCipherHybrid", aliases));
        aliases = new String[]{"PBEWithSHAAndDES", "OID.1.2.840.113549.1.5.10", "PBEWithSHA-1AndDES"};
        this.putService(new JceHybridService(this, "Cipher", "PBEWithSHA1AndDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHA1andDESCipherHybrid", aliases));
        aliases = new String[]{"PBEWithSHAAndTripleDES", "PBEWithSHA-1AndTripleDES", "PBEWithSHA1And3DES", "PBEWithSHAAnd3DES", "PBEWithSHA-1And3DES", "PBEWithSHA1AndDESede", "PBEWithSHAAndDESede", "PBEWithSHA-1AndDESede"};
        this.putService(new JceHybridService(this, "Cipher", "PBEWithSHA1AndTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHA1andTripleDESCipherHybrid", aliases));
        this.putService(new JceHybridService(this, "Cipher", "RSA", "com.ibm.crypto.ibmjcehybrid.provider.RSACipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "RSAforSSL", "com.ibm.crypto.ibmjcehybrid.provider.RSAforSSLCipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "RSA/ECB/PKCS1Padding", "com.ibm.crypto.ibmjcehybrid.provider.RSA_ECB_PKCS1_CipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "RSA/SSL/PKCS1Padding", "com.ibm.crypto.ibmjcehybrid.provider.RSA_SSL_PKCS1_CipherHybrid", null));
        aliases = new String[]{"PBEWithSHA1And2KeyTripleDES", "PBEWithSHA-1And2KeyTripleDES", "PBEWithSHAAnd2Key3DES", "PBEWithSHA1And2Key3DES", "PBEWithSHA-1And2Key3DES", "PBEWithSHAAnd2KeyDESede", "PBEWithSHA1And2KeyDESede", "PBEWithSHA-1And2KeyDESede"};
        this.putService(new JceHybridService(this, "Cipher", "PBEWithSHAAnd2KeyTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand2KeyTripleDESCipherHybrid", aliases));
        aliases = new String[]{"PBEWithSHA1And3KeyTripleDES", "PBEWithSHA-1And3KeyTripleDES", "PBEWithSHAAnd3Key3DES", "PBEWithSHA1And3Key3DES", "PBEWithSHA-1And3Key3DES", "PBEWithSHAAnd3KeyDESede", "PBEWithSHA1And3KeyDESede", "PBEWithSHA-1And3KeyDESede", "OID.1.2.840.113549.1.12.1.3"};
        this.putService(new JceHybridService(this, "Cipher", "PBEWithSHAAnd3KeyTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand3KeyTripleDESCipherHybrid", aliases));
        this.putService(new JceHybridService(this, "Cipher", "PBEWithMD2AndRC2", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD2andRC2CipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "PBEWithMD5AndRC2", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD5andRC2CipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "PBEWithSHA1AndRC2", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHA1andRC2CipherHybrid", null));
        aliases = new String[]{"PBEWithSHAAndRC2", "PBEWithSHA-1AndRC2", "OID.1.2.840.113549.1.5.11"};
        this.putService(new JceHybridService(this, "Cipher", "PBEWithSHAAndRC2", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAandRC2CipherHybrid", aliases));
        this.putService(new JceHybridService(this, "Cipher", "Blowfish", "com.ibm.crypto.ibmjcehybrid.provider.BlowFishCipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "RSAwithNoPad", "com.ibm.crypto.ibmjcehybrid.provider.RSA_NoPad_CipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "RC4", "com.ibm.crypto.ibmjcehybrid.provider.RC4CipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "ARCFOUR", "com.ibm.crypto.ibmjcehybrid.provider.ARCFOURCipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "Seal", "com.ibm.crypto.ibmjcehybrid.provider.SealCipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "RC2", "com.ibm.crypto.ibmjcehybrid.provider.RC2CipherHybrid", null));
        this.putService(new JceHybridService(this, "Cipher", "Mars", "com.ibm.crypto.ibmjcehybrid.provider.MARSCipherHybrid", null));
        aliases = new String[]{"PBEWithSHA1And40BitRC2", "PBEWithSHA-1And40BitRC2"};
        this.putService(new JceHybridService(this, "Cipher", "PBEWithSHAAnd40BitRC2", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand40BitRC2CipherHybrid", aliases));
        aliases = new String[]{"PBEWithSHA1And128BitRC2", "PBEWithSHA-1And128BitRC2"};
        this.putService(new JceHybridService(this, "Cipher", "PBEWithSHAAnd128BitRC2", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand128BitRC2CipherHybrid", aliases));
        aliases = new String[]{"PBEWithSHA1And40BitRC4", "PBEWithSHA-1And40BitRC4"};
        this.putService(new JceHybridService(this, "Cipher", "PBEWithSHAAnd40BitRC4", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand40BitRC4CipherHybrid", aliases));
        aliases = new String[]{"PBEWithSHA1And128BitRC4", "PBEWithSHA-1And128BitRC4"};
        this.putService(new JceHybridService(this, "Cipher", "PBEWithSHAAnd128BitRC4", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand128BitRC4CipherHybrid", aliases));
        this.putService(new JceHybridService(this, "KeyGenerator", "DES", "com.ibm.crypto.ibmjcehybrid.provider.DESKeyGeneratorHybrid", null));
        aliases = new String[]{"TripleDES", "3DES"};
        this.putService(new JceHybridService(this, "KeyGenerator", "DESede", "com.ibm.crypto.ibmjcehybrid.provider.DESedeKeyGeneratorHybrid", aliases));
        this.putService(new JceHybridService(this, "KeyGenerator", "AES", "com.ibm.crypto.ibmjcehybrid.provider.AESKeyGeneratorHybrid", null));
        aliases = new String[]{"HMACwithMD2"};
        this.putService(new JceHybridService(this, "KeyGenerator", "HmacMD2", "com.ibm.crypto.ibmjcehybrid.provider.HmacMD2KeyGeneratorHybrid", aliases));
        aliases = new String[]{"HMACwithMD5"};
        this.putService(new JceHybridService(this, "KeyGenerator", "HmacMD5", "com.ibm.crypto.ibmjcehybrid.provider.HmacMD5KeyGeneratorHybrid", aliases));
        aliases = new String[]{"HMACwithSHA1"};
        this.putService(new JceHybridService(this, "KeyGenerator", "HmacSHA1", "com.ibm.crypto.ibmjcehybrid.provider.HmacSHA1KeyGeneratorHybrid", aliases));
        aliases = new String[]{"OID.1.2.5.8.1.1", "1.2.5.8.1.1"};
        this.putService(new JceHybridService(this, "KeyPairGenerator", "RSA", "com.ibm.crypto.ibmjcehybrid.provider.RSAKeyPairGeneratorHybrid", aliases));
        aliases = new String[]{"OID.1.2.840.10040.4.1", "1.2.840.10040.4.1", "OID.1.3.14.3.2.12", "1.3.14.3.2.12"};
        this.putService(new JceHybridService(this, "KeyPairGenerator", "DSA", "com.ibm.crypto.ibmjcehybrid.provider.DSAKeyPairGeneratorHybrid", aliases));
        this.putService(new JceHybridService(this, "KeyGenerator", "Blowfish", "com.ibm.crypto.ibmjcehybrid.provider.BlowFishKeyGeneratorHybrid", null));
        aliases = new String[]{"HMACwithSHA256"};
        this.putService(new JceHybridService(this, "KeyGenerator", "HmacSHA256", "com.ibm.crypto.ibmjcehybrid.provider.HmacSHA256KeyGeneratorHybrid", aliases));
        aliases = new String[]{"HMACwithSHA384"};
        this.putService(new JceHybridService(this, "KeyGenerator", "HmacSHA384", "com.ibm.crypto.ibmjcehybrid.provider.HmacSHA384KeyGeneratorHybrid", aliases));
        aliases = new String[]{"HMACwithSHA512"};
        this.putService(new JceHybridService(this, "KeyGenerator", "HmacSHA512", "com.ibm.crypto.ibmjcehybrid.provider.HmacSHA512KeyGeneratorHybrid", aliases));
        aliases = new String[]{"DH"};
        this.putService(new JceHybridService(this, "KeyPairGenerator", "DiffieHellman", "com.ibm.crypto.ibmjcehybrid.provider.DiffieHellmanKeyPairGeneratorHybrid", aliases));
        this.putService(new JceHybridService(this, "KeyGenerator", "RC4", "com.ibm.crypto.ibmjcehybrid.provider.RC4KeyGeneratorHybrid", null));
        this.putService(new JceHybridService(this, "KeyGenerator", "ARCFOUR", "com.ibm.crypto.ibmjcehybrid.provider.ARCFOURKeyGeneratorHybrid", null));
        this.putService(new JceHybridService(this, "KeyGenerator", "Seal", "com.ibm.crypto.ibmjcehybrid.provider.SealKeyGeneratorHybrid", null));
        this.putService(new JceHybridService(this, "KeyGenerator", "RC2", "com.ibm.crypto.ibmjcehybrid.provider.RC2KeyGeneratorHybrid", null));
        this.putService(new JceHybridService(this, "KeyGenerator", "Mars", "com.ibm.crypto.ibmjcehybrid.provider.MARSKeyGeneratorHybrid", null));
        aliases = new String[]{"RSASSA-PSS", "RSAPSS", "RSA-PSS", "RSASA-PSS", "1.2.840.113549.1.1.10", "OID.1.2.840.113549.1.1.10"};
        this.putService(new JceHybridService(this, "KeyPairGenerator", "RSAPSS", "com.ibm.crypto.ibmjcehybrid.provider.RSAPSSKeyPairGeneratorHybrid", aliases));
        aliases = new String[]{"OID.1.2.840.10045.2.1", "1.2.840.10045.2.1"};
        this.putService(new JceHybridService(this, "KeyPairGenerator", "EC", "com.ibm.crypto.ibmjcehybrid.provider.ECKeyPairGeneratorHybrid", aliases));
        this.putService(new JceHybridService(this, "MessageDigest", "MD5", "com.ibm.crypto.ibmjcehybrid.provider.MD5DigestHybrid", null));
        aliases = new String[]{"SHA-1", "SHA1"};
        this.putService(new JceHybridService(this, "MessageDigest", "SHA", "com.ibm.crypto.ibmjcehybrid.provider.SHADigestHybrid", aliases));
        this.putService(new JceHybridService(this, "MessageDigest", "MD2", "com.ibm.crypto.ibmjcehybrid.provider.MD2DigestHybrid", null));
        this.putService(new JceHybridService(this, "MessageDigest", "MD5old", "com.ibm.crypto.ibmjcehybrid.provider.MD5OldDigestHybrid", null));
        aliases = new String[]{"SHA-2", "SHA-256", "SHA256"};
        this.putService(new JceHybridService(this, "MessageDigest", "SHA2", "com.ibm.crypto.ibmjcehybrid.provider.SHA2DigestHybrid", aliases));
        aliases = new String[]{"SHA-3", "SHA-384", "SHA384"};
        this.putService(new JceHybridService(this, "MessageDigest", "SHA3", "com.ibm.crypto.ibmjcehybrid.provider.SHA3DigestHybrid", aliases));
        aliases = new String[]{"SHA-5", "SHA-512", "SHA512"};
        this.putService(new JceHybridService(this, "MessageDigest", "SHA5", "com.ibm.crypto.ibmjcehybrid.provider.SHA5DigestHybrid", aliases));
        this.putService(new JceHybridService(this, "MessageDigest", "MD4", "com.ibm.crypto.ibmjcehybrid.provider.MD4DigestHybrid", null));
        this.putService(new JceHybridService(this, "AlgorithmParameterGenerator", "DSA", "com.ibm.crypto.ibmjcehybrid.provider.DSAParameterGeneratorHybrid", null));
        aliases = new String[]{"DH"};
        this.putService(new JceHybridService(this, "AlgorithmParameterGenerator", "DiffieHellman", "com.ibm.crypto.ibmjcehybrid.provider.DiffieHellmanParameterGeneratorHybrid", aliases));
        this.putService(new JceHybridService(this, "AlgorithmParameterGenerator", "EC", "com.ibm.crypto.ibmjcehybrid.provider.ECParameterGeneratorHybrid", null));
        aliases = new String[]{"DH"};
        this.putService(new JceHybridService(this, "KeyAgreement", "DiffieHellman", "com.ibm.crypto.ibmjcehybrid.provider.DiffieHellmanKeyAgreementHybrid", aliases));
        aliases = null;
        this.putService(new JceHybridService(this, "KeyAgreement", "ECDH", "com.ibm.crypto.ibmjcehybrid.provider.ECDHKeyAgreementHybrid", aliases));
        this.putService(new JceHybridService(this, "AlgorithmParameters", "DES", "com.ibm.crypto.ibmjcehybrid.provider.DESParametersHybrid", null));
        aliases = new String[]{"TripleDES", "3DES"};
        this.putService(new JceHybridService(this, "AlgorithmParameters", "DESede", "com.ibm.crypto.ibmjcehybrid.provider.DESedeParametersHybrid", aliases));
        this.putService(new JceHybridService(this, "AlgorithmParameters", "AES", "com.ibm.crypto.ibmjcehybrid.provider.AESParametersHybrid", null));
        aliases = new String[]{"PBEWithMD2AndDES", "PBEWithMD2AndTripleDES", "PBEWithMD2And3DES", "PBEWithMD2AndDESede", "PBEWithMD5AndDES", "PBEWithMD5AndTripleDES", "PBEWithMD5And3DES", "PBEWithMD5AndDESede", "PBEWithSHAAndDES", "PBEWithSHA1AndDES", "PBEWithSHA-1AndDES", "PBEWithSHAAndTripleDES", "PBEWithSHA1AndTripleDES", "PBEWithSHA-1AndTripleDES", "PBEWithSHAAnd3DES", "PBEWithSHA1And3DES", "PBEWithSHA-1And3DES", "PBEWithSHAAndDESede", "PBEWithSHA1AndDESede", "PBEWithSHA-1AndDESede", "PBEWithSHAAnd2KeyTripleDES", "PBEWithSHA1And2KeyTripleDES", "PBEWithSHA-1And2KeyTripleDES", "PBEWithSHAAnd2Key3DES", "PBEWithSHA1And2Key3DES", "PBEWithSHA-1And2Key3DES", "PBEWithSHAAnd2KeyDESede", "PBEWithSHA1And2KeyDESede", "PBEWithSHA-1And2KeyDESede", "PBEWithSHAAnd3KeyTripleDES", "PBEWithSHA1And3KeyTripleDES", "PBEWithSHA-1And3KeyTripleDES", "PBEWithSHAAnd3Key3DES", "PBEWithSHA1And3Key3DES", "PBEWithSHA-1And3Key3DES", "PBEWithSHAAnd3KeyDESede", "PBEWithSHA1And3KeyDESede", "PBEWithSHA-1And3KeyDESede", "PBEWithMD2AndRC2", "PBEWithMD5AndRC2", "PBEWithSHAAndRC2", "PBEWithSHA1AndRC2", "PBEWithSHA-1AndRC2", "PBEWithSHAAnd40BitRC2", "PBEWithSHA1And40BitRC2", "PBEWithSHA-1And40BitRC2", "PBEWithSHAAnd128BitRC2", "PBEWithSHA1And128BitRC2", "PBEWithSHA-1And128BitRC2", "PBEWithSHAAnd40BitRC4", "PBEWithSHA1And40BitRC4", "PBEWithSHA-1And40BitRC4", "PBEWithSHAAnd128BitRC4", "PBEWithSHA1And128BitRC4", "PBEWithSHA-1And128BitRC4"};
        this.putService(new JceHybridService(this, "AlgorithmParameters", "PBE", "com.ibm.crypto.ibmjcehybrid.provider.PBEParametersHybrid", aliases));
        aliases = new String[]{"1.2.840.113533.7.66.13", "OID.1.2.840.113533.7.66.13", "PasswordBasedMac"};
        this.putService(new JceHybridService(this, "AlgorithmParameters", "PBM", "com.ibm.crypto.ibmjcehybrid.provider.PBMParametersHybrid", aliases));
        aliases = new String[]{"1.3.14.3.2.12", "1.2.840.10040.4.1"};
        this.putService(new JceHybridService(this, "AlgorithmParameters", "DSA", "com.ibm.crypto.ibmjcehybrid.provider.DSAParametersHybrid", aliases));
        aliases = new String[]{"DH"};
        this.putService(new JceHybridService(this, "AlgorithmParameters", "DiffieHellman", "com.ibm.crypto.ibmjcehybrid.provider.DiffieHellmanParametersHybrid", aliases));
        this.putService(new JceHybridService(this, "AlgorithmParameters", "Blowfish", "com.ibm.crypto.ibmjcehybrid.provider.BlowFishParametersHybrid", null));
        this.putService(new JceHybridService(this, "AlgorithmParameters", "RC2", "com.ibm.crypto.ibmjcehybrid.provider.RC2ParametersHybrid", null));
        this.putService(new JceHybridService(this, "AlgorithmParameters", "Mars", "com.ibm.crypto.ibmjcehybrid.provider.MARSParametersHybrid", null));
        this.putService(new JceHybridService(this, "AlgorithmParameters", "OAEP", "com.ibm.crypto.ibmjcehybrid.provider.OAEPParametersHybrid", null));
        aliases = new String[]{"RSASSA-PSS", "RSAPSS", "RSA-PSS", "RSASA-PSS", "1.2.840.113549.1.1.10", "OID.1.2.840.113549.1.1.10"};
        this.putService(new JceHybridService(this, "AlgorithmParameters", "RSAPSS", "com.ibm.crypto.ibmjcehybrid.provider.PSSParametersHybrid", aliases));
        aliases = new String[]{"OID.1.2.840.10045.2.1", "1.2.840.10045.2.1"};
        this.putService(new JceHybridService(this, "AlgorithmParameters", "EC", "com.ibm.crypto.ibmjcehybrid.provider.ECParametersHybrid", aliases));
        aliases = new String[]{"OID.1.2.5.8.1.1", "1.2.5.8.1.1", "OID.1.2.840.113549.1.1.1", "1.2.840.113549.1.1.1"};
        this.putService(new JceHybridService(this, "KeyFactory", "RSA", "com.ibm.crypto.ibmjcehybrid.provider.RSAKeyFactoryHybrid", aliases));
        aliases = new String[]{"OID.1.3.14.3.2.12", "1.3.14.3.2.12", "OID.1.2.840.10040.4.1", "1.2.840.10040.4.1"};
        this.putService(new JceHybridService(this, "KeyFactory", "DSA", "com.ibm.crypto.ibmjcehybrid.provider.DSAKeyFactoryHybrid", aliases));
        aliases = new String[]{"DH"};
        this.putService(new JceHybridService(this, "KeyFactory", "DiffieHellman", "com.ibm.crypto.ibmjcehybrid.provider.DiffieHellmanKeyFactoryHybrid", aliases));
        aliases = new String[]{"RSASSA-PSS", "RSAPSS", "RSA-PSS", "RSASA-PSS", "1.2.840.113549.1.1.10", "OID.1.2.840.113549.1.1.10"};
        this.putService(new JceHybridService(this, "KeyFactory", "RSAPSS", "com.ibm.crypto.ibmjcehybrid.provider.RSAPSSKeyFactoryHybrid", aliases));
        aliases = new String[]{"OID.1.2.840.10045.2.1", "1.2.840.10045.2.1"};
        this.putService(new JceHybridService(this, "KeyFactory", "EC", "com.ibm.crypto.ibmjcehybrid.provider.ECKeyFactoryHybrid", aliases));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "DES", "com.ibm.crypto.ibmjcehybrid.provider.DESKeyFactoryHybrid", null));
        aliases = new String[]{"TripleDES", "3DES"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "DESede", "com.ibm.crypto.ibmjcehybrid.provider.DESedeKeyFactoryHybrid", aliases));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "AES", "com.ibm.crypto.ibmjcehybrid.provider.AESKeyFactoryHybrid", null));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBE", "com.ibm.crypto.ibmjcehybrid.provider.PBEKeyFactoryHybrid", null));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithMD2AndDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD2andDESKeyFactoryHybrid", null));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithMD5AndDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD5andDESKeyFactoryHybrid", null));
        aliases = new String[]{"PBEWithSHA1AndDES", "PBEWithSHA-1AndDES"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithSHAAndDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAandDESKeyFactoryHybrid", aliases));
        aliases = new String[]{"PBEWithSHA1AndTripleDES", "PBEWithSHA-1AndTripleDES", "PBEWithSHAAnd3DES", "PBEWithSHA1And3DES", "PBEWithSHA-1And3DES", "PBEWithSHAAndDESede", "PBEWithSHA1AndDESede", "PBEWithSHA-1AndDESede"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithSHAAndTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAandTripleDESKeyFactoryHybrid", aliases));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithSHAAndTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAandTripleDESKeyFactoryHybrid", null));
        aliases = new String[]{"PBEWithMD2AndDESede"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithMD2AndTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD2andTripleDESKeyFactoryHybrid", aliases));
        aliases = new String[]{"PBEWithMD5AndDESede"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithMD5AndTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD5andTripleDESKeyFactoryHybrid", aliases));
        aliases = new String[]{"PBEWithSHA1And2KeyTripleDES", "PBEWithSHA-1And2KeyTripleDES", "PBEWithSHAAnd2Key3DES", "PBEWithSHA1And2Key3DES", "PBEWithSHA-1And2Key3DES", "PBEWithSHAAnd2KeyDESede", "PBEWithSHA1And2KeyDESede", "PBEWithSHA-1And2KeyDESede"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithSHAAnd2KeyTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand2KeyTripleDESKeyFactoryHybrid", aliases));
        aliases = new String[]{"PBEWithSHA1And3KeyTripleDES", "PBEWithSHA-1And3KeyTripleDES", "PBEWithSHAAnd3Key3DES", "PBEWithSHA1And3Key3DES", "PBEWithSHA-1And3Key3DES", "PBEWithSHAAnd3KeyDESede", "PBEWithSHA1And3KeyDESede", "PBEWithSHA-1And3KeyDESede"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithSHAAnd3KeyTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand3KeyTripleDESKeyFactoryHybrid", aliases));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PKCS5Key", "com.ibm.crypto.ibmjcehybrid.provider.PKCS5KeyFactoryHybrid", null));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBKDF1", "com.ibm.crypto.ibmjcehybrid.provider.PBKDF1KeyFactoryHybrid", null));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBKDF2", "com.ibm.crypto.ibmjcehybrid.provider.PBKDF2KeyFactoryHybrid", null));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "RC4", "com.ibm.crypto.ibmjcehybrid.provider.RC4KeyFactoryHybrid", null));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "Seal", "com.ibm.crypto.ibmjcehybrid.provider.SEALKeyFactoryHybrid", null));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "RC2", "com.ibm.crypto.ibmjcehybrid.provider.RC2KeyFactoryHybrid", null));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "Mars", "com.ibm.crypto.ibmjcehybrid.provider.MARSKeyFactoryHybrid", null));
        aliases = new String[]{"PBEWithSHA1And40BitRC2,PBEWithSHA-1And40BitRC2"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithSHAAnd40BitRC2", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand40BitRC2KeyFactoryHybrid", aliases));
        aliases = new String[]{"PBEWithSHA1And128BitRC2,PBEWithSHA-1And128BitRC2"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithSHAAnd128BitRC2", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand128BitRC2KeyFactoryHybrid", aliases));
        aliases = new String[]{"PBEWithSHA1And40BitRC4,PBEWithSHA-1And40BitRC4"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithSHAAnd40BitRC4", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand40BitRC4KeyFactoryHybrid", aliases));
        aliases = new String[]{"PBEWithSHA1And128BitRC4,PBEWithSHA-1And128BitRC4"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithSHAAnd128BitRC4", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHAand128BitRC4KeyFactoryHybrid", aliases));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithMD2AndRC2", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD2andRC2KeyFactoryHybrid", null));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithMD5AndRC2", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithMD5andRC2KeyFactoryHybrid", null));
        aliases = new String[]{"PBEWithSHAAndRC2,PBEWithSHA-1AndRC2"};
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithSHA1AndRC2", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHA1andRC2KeyFactoryHybrid", aliases));
        this.putService(new JceHybridService(this, "SecretKeyFactory", "PBEWithSHA1AndTripleDES", "com.ibm.crypto.ibmjcehybrid.provider.PBEwithSHA1andTripleDESKeyFactoryHybrid", aliases));
        aliases = new String[]{"HMACwithMD2"};
        this.putService(new JceHybridService(this, "Mac", "HmacMD2", "com.ibm.crypto.ibmjcehybrid.provider.HmacMD2Hybrid", aliases));
        aliases = new String[]{"HMACwithMD5"};
        this.putService(new JceHybridService(this, "Mac", "HmacMD5", "com.ibm.crypto.ibmjcehybrid.provider.HmacMD5Hybrid", aliases));
        aliases = new String[]{"HMACwithSHA1"};
        this.putService(new JceHybridService(this, "Mac", "HmacSHA1", "com.ibm.crypto.ibmjcehybrid.provider.HmacSHA1Hybrid", aliases));
        aliases = new String[]{"1.2.840.113533.7.66.13", "OID.1.2.840.113533.7.66.13", "PasswordBasedMac"};
        this.putService(new JceHybridService(this, "Mac", "PBM", "com.ibm.crypto.ibmjcehybrid.provider.PBMHybrid", aliases));
        aliases = new String[]{"HMACwithSHA256"};
        this.putService(new JceHybridService(this, "Mac", "HmacSHA256", "com.ibm.crypto.ibmjcehybrid.provider.HmacSHA256Hybrid", aliases));
        aliases = new String[]{"HMACwithSHA384"};
        this.putService(new JceHybridService(this, "Mac", "HmacSHA384", "com.ibm.crypto.ibmjcehybrid.provider.HmacSHA384Hybrid", aliases));
        aliases = new String[]{"HMACwithSHA512"};
        this.putService(new JceHybridService(this, "Mac", "HmacSHA512", "com.ibm.crypto.ibmjcehybrid.provider.HmacSHA512Hybrid", aliases));
        aliases = new String[]{"X.509"};
        this.putService(new JceHybridService(this, "CertificateFactory", "X509", "com.ibm.crypto.ibmjcehybrid.provider.X509FactoryHybrid", aliases));
        this.putService(new JceHybridService(this, "KeyStore", "JCEHYBRIDRACFKS", "com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", aliases));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "setupSupportedServices", null);
        }
    }

    public String getCurrentBestProvider(String service, String algorithm) throws NoSuchAlgorithmException {
        NoSuchAlgorithmException nsae;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getCurrentBestProvider", (Object)("Service: " + service + ", Algorithm: " + algorithm));
        }
        TableObject tblObj = null;
        String provider = null;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)className, "getCurrentBestProvider", rteMessage);
                debug.exception(16384L, (Object)className, "getCurrentBestProvider", (Throwable)rte);
                debug.exit(16384L, (Object)className, "getCurrentBestProvider");
            }
            throw new RuntimeException(rte);
        }
        tblObj = AlgorithmTable.getStateData(service, algorithm);
        if (null == tblObj) {
            int end = algorithm.indexOf(47);
            if (service.equalsIgnoreCase("Cipher") && end > 0) {
                String algorithmNoTransform = algorithm.substring(0, end);
                if (debug != null) {
                    debug.text(16384L, (Object)className, "getCurrentBestProvider", service + "." + algorithm + " not found as a registered algorithm, so we are trying " + service + "." + algorithmNoTransform);
                }
                tblObj = AlgorithmTable.getStateData(service, algorithmNoTransform);
            }
        }
        if (null == tblObj) {
            String message = service + "." + algorithm + " not found as a registered algorithm";
            nsae = new NoSuchAlgorithmException(message);
            if (debug != null) {
                debug.exception(16384L, (Object)className, "getCurrentBestProvider", (Throwable)nsae);
                debug.text(16384L, (Object)className, "getCurrentBestProvider", message);
                debug.exit(16384L, (Object)className, "getCurrentBestProvider");
            }
            throw nsae;
        }
        provider = tblObj.getCurrentBestProvider();
        if (provider == null) {
            String message = service + "." + algorithm + " has no registered providers. This could be the result of a previous failure.";
            nsae = new NoSuchAlgorithmException(message);
            if (debug != null) {
                debug.exception(16384L, (Object)className, "getCurrentBestProvider", (Throwable)nsae);
                debug.text(16384L, (Object)className, "getCurrentBestProvider", message);
                debug.exit(16384L, (Object)className, "getCurrentBestProvider");
            }
            throw nsae;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCurrentBestProvider", (Object)provider);
        }
        return provider;
    }

    private static class JceHybridService
    extends Provider.Service {
        private static String className = "com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHYBRID.JceHybridService";

        JceHybridService(Provider provider, String type, String algorithm, String className, String[] aliases) {
            super(provider, type, algorithm, className, JceHybridService.toList(aliases), null);
        }

        private static List<String> toList(String[] aliases) {
            return aliases == null ? null : Arrays.asList(aliases);
        }

        @Override
        public boolean supportsParameter(Object param) {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "supportsParameter", param);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "supportsParameter", (Object)"true");
            }
            return true;
        }
    }
}

