/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.misc.Debug;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

class HybridUtils {
    private static String implementationLevelHybrid = null;
    private static String buildLevelHybrid = null;
    private static String buildFileHybrid = null;
    private static String buildDateHybrid = null;
    private static final String HybridManifestRecognitionString = "IBM Java(tm) Hybrid JCE Provider IBMJCEHYBRID";
    private static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridUtils";

    HybridUtils() {
    }

    protected static void traceEnvironment() throws RuntimeException {
        String PROPERTY_NOT_SET = "Property NOT Set";
        if (null == debug) {
            return;
        }
        String environment = "\nibmjcehybrid.jar Build-Level: " + HybridUtils.getBuildLevelHybrid() + "\nibmjcehybrid.jar Build-Date:  " + HybridUtils.getBuildDateHybrid() + "\nibmjcehybrid.jar Build-File:  " + HybridUtils.getBuildFileHybrid() + "\nibmjcehybrid.jar Implementation-Version: " + implementationLevelHybrid + "\nHybrid com.ibm.oti.vm.bootstrap.library.path: " + System.getProperty("com.ibm.oti.vm.bootstrap.library.path", PROPERTY_NOT_SET) + "\nHybrid java.library.path: " + System.getProperty("java.library.path", PROPERTY_NOT_SET) + "\nHybrid java.class.path:   " + System.getProperty("java.class.path", PROPERTY_NOT_SET) + "\nHybrid os.name:    " + System.getProperty("os.name", PROPERTY_NOT_SET) + "\nHybrid os.version: " + System.getProperty("os.version", PROPERTY_NOT_SET) + "\nHybrid os.arch:    " + System.getProperty("os.arch", PROPERTY_NOT_SET) + "\n";
        debug.text(8192L, (Object)hybridClassName, "traceEnvironment", environment);
    }

    private static String getBuildDateHybrid() {
        if (buildDateHybrid == null) {
            HybridUtils.getImplementationVersion(HybridUtils.class);
        }
        return buildDateHybrid;
    }

    private static String getBuildLevelHybrid() {
        if (buildLevelHybrid == null) {
            HybridUtils.getImplementationVersion(HybridUtils.class);
        }
        return buildLevelHybrid;
    }

    private static String getBuildFileHybrid() {
        if (buildFileHybrid == null) {
            HybridUtils.getImplementationVersion(HybridUtils.class);
        }
        return buildFileHybrid;
    }

    private static String getImplementationVersion(Class theClass) {
        String buildDate;
        String buildFile;
        String buildLevel;
        String implementationVersion;
        block8: {
            Manifest manifest = null;
            String recogString = null;
            implementationVersion = null;
            buildLevel = null;
            buildFile = null;
            buildDate = null;
            String implementationTitle = null;
            boolean StillLooking = true;
            try {
                Enumeration<URL> resources = theClass.getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (resources.hasMoreElements() && StillLooking) {
                    try {
                        manifest = new Manifest(resources.nextElement().openStream());
                        Attributes attributes = manifest.getMainAttributes();
                        implementationTitle = attributes.getValue("Implementation-Title");
                        recogString = attributes.getValue("Jar-Recognition-String");
                        if (debug != null) {
                            debug.text(8192L, (Object)hybridClassName, "getImplementationVersion", "this manifest:  RecognitionString = " + recogString + "  ImplementationTitle = " + implementationTitle);
                        }
                        if (!HybridManifestRecognitionString.equals(recogString)) continue;
                        if (debug != null) {
                            debug.text(8192L, (Object)hybridClassName, "getImplementationVersion", "ibmjcehybrid manifest found");
                        }
                        StillLooking = false;
                        implementationVersion = attributes.getValue("Implementation-Version");
                        buildLevel = attributes.getValue("Build-Level");
                        buildFile = attributes.getValue("Build-File");
                        buildDate = attributes.getValue("Build-Date");
                    }
                    catch (IOException E) {
                        if (debug == null) continue;
                        debug.text(8192L, (Object)hybridClassName, "getImplementationVersion", "IOException reading a manifest file.");
                        debug.exception(8192L, (Object)hybridClassName, "getImplementationVersion", (Throwable)E);
                    }
                }
            }
            catch (Exception e) {
                if (debug == null) break block8;
                debug.text(8192L, (Object)hybridClassName, "getImplementationVersion", "Cannot read manifest file.");
                debug.exception(8192L, (Object)hybridClassName, "getImplementationVersion", (Throwable)e);
            }
        }
        buildLevelHybrid = null != buildLevel ? buildLevel : "Build Level Not Available In Manifest";
        buildFileHybrid = null != buildFile ? buildFile : "Build File Not Available In Manifest";
        buildDateHybrid = null != buildDate ? buildDate : "Build Date Not Available In Manifest";
        String string = implementationLevelHybrid = null != implementationVersion ? implementationVersion : "Implementation Version Not Available In Manifest";
        if (debug != null) {
            debug.exit(8192L, (Object)hybridClassName, "getImplementationVersion", (Object)implementationVersion);
        }
        return implementationVersion;
    }

    public static void fail() throws RuntimeException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "fail");
        }
        String fail = System.getProperties().getProperty("fail");
        if (debug != null) {
            debug.text(16384L, (Object)hybridClassName, "fail", "The System property fail is set to: " + fail);
        }
        if (fail != null && fail.equals("true")) {
            System.getProperties().setProperty("fail", "false");
            RuntimeException e = new RuntimeException("Forced failure occurred");
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "fail", "The System property fail equals true, throwing an exception");
                debug.exception(16384L, (Object)hybridClassName, "fail", (Throwable)e);
            }
            throw e;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "fail");
        }
    }
}

