/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.util.Vector;

abstract class HybridSecureRandom
extends SecureRandomSpi {
    private SecureRandom theGenerator = null;
    private static final String serviceType = "SecureRandom";
    private String algorithm;
    private byte[] seedBytes = null;
    private String theProvider = null;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridSecureRandom";

    public HybridSecureRandom(String algorithm) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridSecureRandom", (Object)algorithm);
        }
        this.algorithm = algorithm;
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getGenerator(this.seedBytes);
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridSecureRandom", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridSecureRandom", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for SecureRandom " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridSecureRandom", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridSecureRandom", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridSecureRandom");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridSecureRandom");
        }
    }

    public HybridSecureRandom(String algorithm, byte[] seed) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridSecureRandom", (Object)algorithm, (Object)seed);
        }
        this.algorithm = algorithm;
        this.seedBytes = seed;
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridSecureRandom", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridSecureRandom", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridSecureRandom");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getGenerator(this.seedBytes);
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridSecureRandom", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridSecureRandom", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for SecureRandom " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridSecureRandom", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridSecureRandom", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridSecureRandom");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridSecureRandom");
        }
    }

    @Override
    public synchronized void engineSetSeed(byte[] seed) throws UnsupportedOperationException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineSetSeed", (Object)seed);
        }
        this.seedBytes = seed;
        this.setSeed(this.seedBytes, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineSetSeed");
        }
    }

    private synchronized void setSeed(byte[] seed, boolean isExternalCall) throws UnsupportedOperationException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "setSeed", (Object)seed, (Object)new Boolean(isExternalCall));
        }
        this.seedBytes = seed;
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            this.theGenerator.setSeed(this.seedBytes);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "setSeed", "Successful call to setSeed(seed) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "setSeed", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "setSeed", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "setSeed", "Attempting failover to another provider for " + this.algorithm);
            }
            this.getGenerator(this.seedBytes);
            this.setSeed(this.seedBytes, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "setSeed");
        }
    }

    @Override
    public synchronized void engineNextBytes(byte[] bytes) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineNextBytes", (Object)bytes);
        }
        this.nextBytes(bytes, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineNextBytes");
        }
    }

    private synchronized void nextBytes(byte[] bytes, boolean isExternalCall) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "nextBytes", (Object)bytes, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            this.theGenerator.nextBytes(bytes);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "nextBytes", "Successful call to nextBytes(bytes) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "nextBytes", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "nextBytes", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "nextBytes", "Attempting failover to another provider for " + this.algorithm);
            }
            this.getGenerator(this.seedBytes);
            this.nextBytes(bytes, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "nextBytes");
        }
    }

    @Override
    public byte[] engineGenerateSeed(int numBytes) {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGenerateSeed", (Object)new Integer(numBytes));
        }
        result = this.generateSeed(numBytes, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGenerateSeed");
        }
        return result;
    }

    private byte[] generateSeed(int numBytes, boolean isExternalCall) {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateSeed", (Object)new Integer(numBytes), (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theGenerator.generateSeed(numBytes);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateSeed", "Successful call to generateSeed(numBytes) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateSeed", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generateSeed", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateSeed", "Attempting failover to another provider for " + this.algorithm);
            }
            this.getGenerator(this.seedBytes);
            result = this.generateSeed(numBytes, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateSeed");
        }
        return result;
    }

    protected void getGenerator(byte[] seed) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getGenerator", (Object)seed);
        }
        if (null != this.theGenerator) {
            TableObject tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm);
            tblObj.invalidateProvider(this.theGenerator.getProvider().getName());
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
        }
        try {
            this.theGenerator = this.getBestInstance(seed);
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", e.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getGenerator", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getGenerator", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getGenerator");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getGenerator");
        }
    }

    public SecureRandom getBestInstance(byte[] seed) {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getBestInstance", (Object)this.algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("SecureRandom." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theGenerator = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 1");
            }
            while (null == this.theGenerator && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theGenerator = SecureRandom.getInstance(this.algorithm, this.theProvider);
                    if (null != seed) {
                        this.setSeed(seed, false);
                    }
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Exception thrown on SecureRandom.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for SecureRandom " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theGenerator) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.doReset() for SecureRandom," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theGenerator) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "SecureRandom " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
        }
        return this.theGenerator;
    }
}

