/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.ibmjcehybrid.provider.HybridRACFInputStream;
import com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyContainer;
import com.ibm.crypto.ibmjcehybrid.provider.HybridRACFOutputStream;
import com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.provider.RACFInputStream;
import com.ibm.crypto.provider.RACFOutputStream;
import com.ibm.misc.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HybridRACFKeyStore
extends KeyStoreSpi {
    private Hashtable<String, HybridRACFKeyContainer> entries = new Hashtable();
    private KeyStore hwKS = null;
    private boolean hwKSisInitialized = false;
    private KeyStore swKS = null;
    private boolean swKSisInitialized = false;
    private boolean hwKSNeedsStore = false;
    private boolean swKSNeedsStore = false;
    private static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore";

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetKey", (Object)alias, (Object)password);
        }
        if (alias == null || "".equals(alias)) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetKey", "alias is null, return null");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetKey");
            }
            return null;
        }
        HybridRACFKeyContainer entry = this.entries.get(alias);
        if (entry == null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetKey", "Key <" + alias + "> not found.");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetKey", null);
            }
            return null;
        }
        HybridRACFPrivateKey x = entry.getPrivateKey();
        if (x == null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetKey", "Key <" + alias + "> did not contain any private key material. Returning null.");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetKey", null);
            }
            return null;
        }
        if (x.getIBMJCECCAPrivateKey() == null && x.getIBMJCEPrivateKey() == null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetKey", "Key <" + alias + "> did not contain any private key material. Returning null.");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetKey", null);
            }
            return null;
        }
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetKey", "Key <" + alias + "> found.");
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetKey", (Object)x);
        }
        return x;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificateChain", (Object)alias);
        }
        if (alias == null || "".equals(alias)) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificateChain", "alias is null, return null");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificateChain");
            }
            return null;
        }
        HybridRACFKeyContainer existingKey = this.entries.get(alias);
        if (existingKey == null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificate", "alias not found, return null");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificate");
            }
            return null;
        }
        Certificate[] certArray = existingKey.getCertificateChain();
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificateChain", "Certificate chain length: " + certArray.length);
            for (int i = 0; i < certArray.length; ++i) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificateChain", "Certificate[" + i + "]:\n" + certArray[i].toString());
            }
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificateChain", (Object)certArray);
        }
        return certArray;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificate", (Object)alias);
        }
        if (alias == null || "".equals(alias)) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificate", "alias is null, return null");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificate");
            }
            return null;
        }
        HybridRACFKeyContainer existingKey = this.entries.get(alias);
        if (existingKey == null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificate", "alias not found, return null");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificate");
            }
            return null;
        }
        Certificate cert = existingKey.getCertificate();
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificate", (Object)cert);
        }
        return cert;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCreationDate", (Object)alias);
        }
        if (alias == null || "".equals(alias)) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCreationDate", "alias is null, return null");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCreationDate");
            }
            return null;
        }
        HybridRACFKeyContainer existingKey = this.entries.get(alias);
        if (existingKey == null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCreationDate", "alias not found, return null");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCreationDate");
            }
            return null;
        }
        Date date = null;
        try {
            date = this.swKS.getCreationDate(alias);
            if (date == null) {
                date = this.hwKS.getCreationDate(alias);
            }
        }
        catch (KeyStoreException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCreationDate", (Throwable)e);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCreationDate");
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCreationDate", (Object)date);
        }
        return date;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        HybridRACFPrivateKey privKey;
        KeyStoreException e;
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, password, chain};
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", parms);
        }
        if (key == null) {
            e = new KeyStoreException("key can't be null.");
            if (debug == null) throw e;
            debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", (Throwable)e);
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry");
            throw e;
        }
        if (alias == null || "".equals(alias)) {
            e = new KeyStoreException("alias can't be null.");
            if (debug == null) throw e;
            debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", (Throwable)e);
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry");
            throw e;
        }
        if (key instanceof RSAPrivateHWKey && !this.hwKSisInitialized) {
            e = new KeyStoreException("Cannot insert a key of type com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey. Underlying JCECCARACFKS keystore has not been loaded.");
            if (debug == null) throw e;
            debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", (Throwable)e);
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry");
            throw e;
        }
        if (key instanceof ECPrivateHWKey && !this.hwKSisInitialized) {
            e = new KeyStoreException("Cannot insert a key of type com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey. Underlying JCECCARACFKS keystore has not been loaded.");
            if (debug == null) throw e;
            debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", (Throwable)e);
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry");
            throw e;
        }
        if ((key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey) && !this.swKSisInitialized) {
            e = new KeyStoreException("Cannot insert a key of type RSAPrivateKey or RSAPrivateCrtKey. Underlying JCERACFKS keystore has not been loaded.");
            if (debug == null) throw e;
            debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", (Throwable)e);
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry");
            throw e;
        }
        if (!(key instanceof PrivateKey)) {
            e = new KeyStoreException("Key is not a private key.");
            if (debug == null) throw e;
            debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", (Throwable)e);
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", (Object)e);
            throw e;
        }
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", "Key is a PrivateKey.");
        }
        if (key instanceof RSAPrivateHWKey) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", "Key is of type RSAPrivateHWKey.");
            }
            privKey = new HybridRACFPrivateKey((PrivateKey)key, null);
            HybridRACFKeyContainer entry = new HybridRACFKeyContainer(chain[0], chain, privKey);
            this.entries.put(alias, entry);
            this.hwKS.setKeyEntry(alias, key, password, chain);
            this.hwKSNeedsStore = true;
            return;
        }
        if (key instanceof ECPrivateHWKey) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", "Key is of type ECPrivateHWKey.");
            }
            privKey = new HybridRACFPrivateKey((PrivateKey)key, null);
            HybridRACFKeyContainer entry = new HybridRACFKeyContainer(chain[0], chain, privKey);
            this.entries.put(alias, entry);
            this.swKS.setKeyEntry(alias, key, password, chain);
            this.hwKSNeedsStore = true;
            return;
        }
        if (!(key instanceof RSAPrivateKey) && !(key instanceof RSAPrivateCrtKey)) {
            e = new KeyStoreException("Key of given type cannot be inserted into RACF.");
            if (debug == null) throw e;
            debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", (Throwable)e);
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", null);
            throw e;
        }
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", "Key is of type RSAPrivateKey or RSAPrivateCrtKey.");
        }
        privKey = new HybridRACFPrivateKey(null, (PrivateKey)key);
        HybridRACFKeyContainer entry = new HybridRACFKeyContainer(chain[0], chain, privKey);
        this.entries.put(alias, entry);
        this.swKS.setKeyEntry(alias, key, password, chain);
        this.swKSNeedsStore = true;
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        KeyStoreException e = new KeyStoreException("Key to be stored must be a Key Object. Therefore, this function is unsupported.");
        if (debug != null) {
            Object[] parms = new Object[]{alias, key, chain};
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", parms);
            debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry", (Throwable)e);
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetKeyEntry");
        }
        throw e;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        KeyStoreException e;
        if (debug != null) {
            Object[] parms = new Object[]{alias, cert};
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetCertificateEntry", parms);
        }
        if (cert == null) {
            e = new KeyStoreException("cert can't be null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetCertificateEntry", (Throwable)e);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetCertificateEntry");
            }
            throw e;
        }
        if (alias == null || "".equals(alias)) {
            e = new KeyStoreException("alias can't be null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetCertificateEntry", (Throwable)e);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetCertificateEntry");
            }
            throw e;
        }
        HybridRACFKeyContainer entry = new HybridRACFKeyContainer(cert, null, null);
        this.entries.put(alias, entry);
        this.swKS.setCertificateEntry(alias, cert);
        this.swKSNeedsStore = true;
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSetCertificateEntry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineDeleteEntry", (Object)alias);
        }
        if (alias == null || "".equals(alias)) {
            KeyStoreException e = new KeyStoreException("alias can't be null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineDeleteEntry", (Throwable)e);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineDeleteEntry");
            }
            throw e;
        }
        if (this.hwKSisInitialized) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineDeleteEntry", "Deleting entry <" + alias + "> from JCECCARACFKS keystore.");
            }
            this.hwKS.deleteEntry(alias);
            this.hwKSNeedsStore = true;
        }
        if (this.swKSisInitialized) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineDeleteEntry", "Deleting entry <" + alias + "> from JCERACFKS keystore");
            }
            this.swKS.deleteEntry(alias);
            this.swKSNeedsStore = true;
        }
        Hashtable<String, HybridRACFKeyContainer> hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(alias);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineDeleteEntry");
        }
    }

    public Enumeration engineAliases() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineAliases");
        }
        Enumeration<String> x = this.entries.keys();
        if (debug != null) {
            String aliases = "";
            Enumeration<String> e = this.entries.keys();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                aliases = aliases + "<" + alias + "> ";
            }
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineAliases", (Object)aliases);
        }
        return x;
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineContainsAlias", (Object)alias);
        }
        boolean contains = this.entries.containsKey(alias);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineContainsAlias", contains);
        }
        return contains;
    }

    @Override
    public int engineSize() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSize");
        }
        int size = this.entries.size();
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineSize", size);
        }
        return size;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsKeyEntry", (Object)alias);
        }
        if (alias == null) {
            IllegalArgumentException iae = new IllegalArgumentException("alias can't be null");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsKeyEntry", (Throwable)iae);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsKeyEntry");
            }
            throw iae;
        }
        HybridRACFKeyContainer keyContainer = this.entries.get(alias);
        if (keyContainer == null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsKeyEntry", "alias not found, return false");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsKeyEntry");
            }
            return false;
        }
        if (keyContainer.getPrivateKey() != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsKeyEntry", true);
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsKeyEntry", false);
        }
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        boolean isCertEntry;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsCertificateEntry", (Object)alias);
        }
        if (alias == null) {
            IllegalArgumentException iae = new IllegalArgumentException("alias can't be null");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsCertificateEntry", (Throwable)iae);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsCertificateEntry");
            }
            throw iae;
        }
        HybridRACFKeyContainer keyContainer = this.entries.get(alias);
        if (keyContainer == null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsCertificateEntry", "alias not found, return false");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsCertificateEntry");
            }
            return false;
        }
        boolean bl = isCertEntry = !this.engineIsKeyEntry(alias);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineIsCertificateEntry", isCertEntry);
        }
        return isCertEntry;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificateAlias", (Object)cert);
        }
        Enumeration<String> e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certElem;
            String alias = e.nextElement();
            HybridRACFKeyContainer keyContainer = this.entries.get(alias);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificateAlias", "Checking to see if certificate matches alias: " + alias);
            }
            if (this.engineIsCertificateEntry(alias)) {
                certElem = keyContainer.getCertificate();
                if (!certElem.equals(cert)) continue;
                if (debug != null) {
                    debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificateAlias", (Object)alias);
                }
                return alias;
            }
            if (!this.engineIsKeyEntry(alias) || !(certElem = keyContainer.getCertificateChain()[0]).equals(cert)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificateAlias", (Object)alias);
            }
            return alias;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineGetCertificateAlias", null);
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        IOException e;
        if (debug != null) {
            Object[] parms = new Object[]{stream, password};
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore", parms);
        }
        if (stream == null) {
            e = new IOException("OutputStream passed to JCEHYBRIDRACFKS store method cannot be null value.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore", (Throwable)e);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore");
            }
            throw e;
        }
        if (!(stream instanceof HybridRACFOutputStream)) {
            e = new IOException("OutputStream passed to JCEHYBRIDRACFKS load method must be a com.ibm.crypto.ibmjcehybrid.provider.HybridRACFOutputStream. User passed " + stream.getClass().getName() + ".");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore", (Throwable)e);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore");
            }
            throw e;
        }
        String username = ((HybridRACFOutputStream)stream).getUserid();
        String keyring = ((HybridRACFOutputStream)stream).getRingid();
        if (this.hwKSisInitialized && this.hwKSNeedsStore) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore", "Storing keyring " + keyring + " as a JCECCARACFKS type keystore.");
            }
            com.ibm.crypto.hdwrCCA.provider.RACFOutputStream hwOutputStream = new com.ibm.crypto.hdwrCCA.provider.RACFOutputStream(username, keyring, password);
            try {
                this.hwKS.store((OutputStream)hwOutputStream, password);
            }
            catch (KeyStoreException e2) {
                IOException e22 = new IOException("Error storing keystore", e2);
                if (debug != null) {
                    debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore", (Throwable)e22);
                    debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore");
                }
                throw e22;
            }
            this.hwKSNeedsStore = false;
        } else if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore", "JCECCARACFKS keystore not initialized. Skipping store method.");
        }
        if (this.swKSisInitialized && this.swKSNeedsStore) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore", "Storing keyring " + keyring + " as a JCERACFKS type keystore.");
            }
            RACFOutputStream swOutputStream = new RACFOutputStream(username, keyring, password);
            try {
                this.swKS.store((OutputStream)swOutputStream, password);
            }
            catch (KeyStoreException e3) {
                IOException e2 = new IOException("Error storing keystore", e3);
                if (debug != null) {
                    debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore", (Throwable)e2);
                    debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore");
                }
                throw e2;
            }
            this.swKSNeedsStore = false;
        } else if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore", "JCERACFKS keystore not initialized. Skipping store method.");
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineStore");
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        block22: {
            String str;
            if (debug != null) {
                String strParm = null;
                if (password != null) {
                    strParm = new String(password);
                }
                Object[] parms = new Object[]{stream, strParm};
                debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad", parms);
            }
            this.hwKSisInitialized = false;
            this.swKSisInitialized = false;
            this.hwKSNeedsStore = false;
            this.swKSNeedsStore = false;
            this.hwKS = null;
            this.swKS = null;
            Vector<Exception> exceptionHistory = new Vector<Exception>();
            this.entries.clear();
            if (stream == null) {
                block21: {
                    try {
                        this.hwKS = KeyStore.getInstance("JCECCARACFKS");
                        this.hwKS.load(null, password);
                        this.hwKSisInitialized = true;
                    }
                    catch (KeyStoreException e) {
                        if (debug == null) break block21;
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad", "Exception Getting JCECCARACFKS Keystore.", (Object)e);
                    }
                }
                try {
                    this.swKS = KeyStore.getInstance("JCERACFKS");
                    this.swKS.load(null, password);
                    this.swKSisInitialized = true;
                }
                catch (KeyStoreException e) {
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad", "Exception Getting JCERACFKS Keystore.", (Object)e);
                    }
                    break block22;
                }
            }
            if (!(stream instanceof HybridRACFInputStream)) {
                IOException e = new IOException("InputStream passed to JCEHYBRIDRACFKS load method must be a com.ibm.crypto.ibmjcehybrid.provider.HybridRACFInputStream. User passed " + stream.getClass().getName() + ".");
                if (debug != null) {
                    debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad", (Throwable)e);
                    debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad");
                }
                throw e;
            }
            String username = ((HybridRACFInputStream)stream).getUserid();
            String keyring = ((HybridRACFInputStream)stream).getRingid();
            char[] passwordStreamChars = ((HybridRACFInputStream)stream).getPassword();
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad", "Loading keyring " + keyring + " as a JCECCARACFKS type keystore.");
            }
            try {
                this.hwKS = KeyStore.getInstance("JCECCARACFKS");
                com.ibm.crypto.hdwrCCA.provider.RACFInputStream hwInputStream = new com.ibm.crypto.hdwrCCA.provider.RACFInputStream(username, keyring, passwordStreamChars);
                this.hwKS.load((InputStream)hwInputStream, password);
                this.cacheCertificateAndKeyMaterial(this.hwKS, "IBMJCECCA", passwordStreamChars);
                this.hwKSisInitialized = true;
            }
            catch (Exception e) {
                if (debug != null) {
                    str = "Error loading and storing certificates and key material from underlying JCECCARACFKS keyring " + keyring + "\n" + e + ". This can be expected if the IBMJCECCA is not setup correctly or ICSF is down. Will now attempt to load the keyring as a JCERACFKS keyring.";
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad", str);
                }
                exceptionHistory.addElement(e);
            }
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad", "Loading keyring " + keyring + " as a JCERACFKS type keystore.");
            }
            try {
                this.swKS = KeyStore.getInstance("JCERACFKS");
                RACFInputStream swInputStream = new RACFInputStream(username, keyring, passwordStreamChars);
                this.swKS.load((InputStream)swInputStream, password);
                this.cacheCertificateAndKeyMaterial(this.swKS, "IBMJCE", passwordStreamChars);
                this.swKSisInitialized = true;
            }
            catch (Exception e) {
                if (debug != null) {
                    str = "Error loading and storing certificates and key material from underlying JCERACFKS keyring " + keyring + "\n" + e + ". This can be expected if the IBMJCE is not setup correctly.";
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad", str);
                }
                exceptionHistory.addElement(e);
            }
            if (!this.swKSisInitialized && !this.hwKSisInitialized) {
                IBMJCEHybridException cause = new IBMJCEHybridException("Errors encountered loading keyring. Keyring could not be loaded as a JCECCARACFKS or JCERACFKS keystore.", exceptionHistory);
                IOException e = new IOException("Errors encountered loading keyring. Keyring could not be loaded as a JCECCARACFKS or JCERACFKS keystore.", cause);
                if (debug != null) {
                    debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad", (Throwable)e);
                    debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad");
                }
                throw e;
            }
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad", "JCEHYBRIDRACFKS keystore sucessfully loaded.");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "engineLoad");
            }
        }
    }

    private void cacheCertificateAndKeyMaterial(KeyStore ks, String prov, char[] passwordStreamChars) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (debug != null) {
            String strParm = null;
            if (passwordStreamChars != null) {
                strParm = new String(passwordStreamChars);
            }
            Object[] parms = new Object[]{ks, prov, strParm};
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", parms);
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", "Adding key and certificate material from " + prov + " keystore");
        }
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", "   Alias: " + alias);
            }
            Certificate cert = ks.getCertificate(alias);
            Certificate[] certChain = ks.getCertificateChain(alias);
            Key privKey = ks.getKey(alias, passwordStreamChars);
            HybridRACFKeyContainer existingKey = this.entries.get(alias);
            HybridRACFKeyContainer newKey = new HybridRACFKeyContainer();
            HybridRACFKeyContainer keyToUpdate = null;
            boolean isNew = false;
            if (existingKey != null) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", "      Alias " + alias + " already exists in local keystore.");
                }
                keyToUpdate = existingKey;
                isNew = false;
            } else {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", "      Alias " + alias + " does not yet exist in local keystore.");
                }
                keyToUpdate = newKey;
                isNew = true;
            }
            if (cert != null) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", "      Alias " + alias + " contains a certificate.");
                }
                keyToUpdate.setCertificate(cert);
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", "         Certificate added to hybrid key object.");
                }
            }
            if (certChain != null) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", "      Alias " + alias + " contains a certificate chain.");
                }
                keyToUpdate.setCertificateChain(certChain);
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", "         Certificate chain added to hybrid key object.");
                }
            }
            if (privKey != null) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", "      Alias " + alias + " contains a private key derived from " + prov);
                }
                HybridRACFPrivateKey hybridPrivKeyTemp = null;
                hybridPrivKeyTemp = keyToUpdate != null && keyToUpdate.getPrivateKey() != null ? new HybridRACFPrivateKey(keyToUpdate.getPrivateKey().getIBMJCECCAPrivateKey(), keyToUpdate.getPrivateKey().getIBMJCEPrivateKey()) : new HybridRACFPrivateKey(null, null);
                if (prov.equalsIgnoreCase("IBMJCECCA")) {
                    hybridPrivKeyTemp.setIBMJCECCAPrivateKey((PrivateKey)privKey);
                } else {
                    hybridPrivKeyTemp.setIBMJCEPrivateKey((PrivateKey)privKey);
                }
                keyToUpdate.setPrivateKey(hybridPrivKeyTemp);
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", "         " + prov + " Private key added to hybrid key object.");
                }
            }
            if (!isNew) continue;
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial", "      Alias " + alias + " does not yet exist in local keystore. Saving in local keystore cache.");
            }
            this.entries.put(alias, keyToUpdate);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFKeyStore", "cacheCertificateAndKeyMaterial");
        }
    }
}

