/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;
import java.util.Vector;

abstract class HybridMessageDigest
extends MessageDigestSpi
implements Cloneable {
    private MessageDigest theDigest;
    private static final String serviceType = "MessageDigest";
    private String algorithm;
    private String theProvider = null;
    private int blockSize = -2;
    private boolean blocking_active = false;
    private boolean blocking_limited = true;
    private int data_bytes_saved = 0;
    private Vector dataSegList;
    private boolean failoverPossible = true;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridMessageDigest";

    public HybridMessageDigest(String algorithm, int block_size) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridMessageDigest", (Object)algorithm, (Object)block_size);
        }
        this.algorithm = algorithm;
        this.blockSize = block_size;
        if (-2 >= this.blockSize) {
            this.blockSize = 0;
        }
        if (0 == this.blockSize) {
            this.blocking_active = false;
        } else {
            this.blocking_active = true;
            this.blocking_limited = -1 != this.blockSize;
            this.dataSegList = new Vector();
            this.turn_on_data_blocking();
        }
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridMessageDigest", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridMessageDigest", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridMessageDigest");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getDigest();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridMessageDigest", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridMessageDigest", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for MessageDigest " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridMessageDigest", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridMessageDigest", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridMessageDigest");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridMessageDigest");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        HybridMessageDigest that = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "clone");
        }
        try {
            that = (HybridMessageDigest)super.clone();
            that.theDigest = (MessageDigest)this.theDigest.clone();
            that.ExceptionHistory = (Vector)this.ExceptionHistory.clone();
            if (null == this.dataSegList) {
                that.dataSegList = null;
            } else {
                that.dataSegList = new Vector();
                int data_seg_count = this.dataSegList.size();
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "clone", "Copying " + data_seg_count + " data segments from this.dataSegList to that.dataSegList. ");
                }
                byte[] seg = null;
                for (int idx = 0; idx < data_seg_count; ++idx) {
                    seg = (byte[])this.dataSegList.get(idx);
                    that.dataSegList.addElement(seg);
                }
            }
            that.ExceptionHistory = new Vector();
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "clone", "Successful call to clone() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (CloneNotSupportedException e) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "clone", e.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "clone", (Throwable)e);
                debug.exit(16384L, (Object)hybridClassName, "clone", (Object)that);
            }
            throw new CloneNotSupportedException("Clone not supported when underlying objects used by IBMJCEHYBRID cannot be cloned");
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "clone", e.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "clone", (Throwable)e);
                debug.exit(16384L, (Object)hybridClassName, "clone", (Object)that);
            }
            throw new RuntimeException(e);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "clone", (Object)that);
        }
        return that;
    }

    @Override
    protected void engineReset() {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineReset");
        }
        this.failoverPossible = true;
        if (0 != this.blockSize) {
            this.turn_on_data_blocking();
        }
        try {
            this.theDigest.reset();
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "engineReset", "Successful call to reset() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "engineReset", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "engineReset", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getDigest();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineReset");
        }
    }

    @Override
    protected int engineGetDigestLength() {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGetDigestLength");
        }
        int result = this.theDigest.getDigestLength();
        if (debug != null) {
            debug.text(16384L, (Object)hybridClassName, "engineGetDigestLength", "Successful call to getDigestLength() in provider: " + this.theProvider);
        }
        this.ExceptionHistory = new Vector();
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGetDigestLength", result);
        }
        return result;
    }

    @Override
    protected synchronized void engineUpdate(byte b) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineUpdate", (Object)new Byte(b));
        }
        byte[] input = new byte[]{b};
        this.engineUpdate(input, 0, 1);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineUpdate");
        }
    }

    protected synchronized void engineUpdate(byte[] input) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineUpdate");
        }
        this.engineUpdate(input, 0, input.length);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineUpdate");
        }
    }

    @Override
    protected synchronized void engineUpdate(byte[] input, int offset, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(offset), new Integer(len)};
            debug.entry(16384L, (Object)hybridClassName, "engineUpdate", parms);
        }
        this.update(input, offset, len, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineUpdate");
        }
    }

    private synchronized void update(byte[] input, int offset, int len, boolean isExternalCall) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(offset), new Integer(len), new Boolean(isExternalCall)};
            debug.entry(16384L, (Object)hybridClassName, "update", parms);
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (this.blocking_active) {
                byte[] data_seg = new byte[len];
                System.arraycopy(input, offset, data_seg, 0, len);
                this.dataSegList.addElement(data_seg);
                this.data_bytes_saved += len;
            }
        }
        try {
            this.theDigest.update(input, offset, len);
            if (debug != null) {
                String msg = null;
                msg = this.blocking_active ? (this.blocking_limited ? new String("Successful call to update() in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved) : new String("Successful call to update() in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is not limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved)) : new String("Successful call to update() in provider: " + this.theProvider + "\n\tBlocking is not active.");
                debug.text(16384L, (Object)hybridClassName, "update", msg);
            }
            this.ExceptionHistory = new Vector();
            if (this.blocking_active) {
                if (this.blocking_limited && this.blockSize <= this.data_bytes_saved && isExternalCall) {
                    this.turn_off_data_blocking();
                    this.failoverPossible = false;
                }
            } else {
                this.failoverPossible = false;
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "update", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "update", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "update", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getDigest();
                if (this.blocking_active) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "update", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        byte[] seg = (byte[])this.dataSegList.get(idx);
                        this.update(seg, 0, seg.length, false);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "update", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                } else {
                    this.update(input, offset, len, false);
                }
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "update", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "update", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "update");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "update");
        }
    }

    @Override
    protected byte[] engineDigest() {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineDigest");
        }
        byte[] result = this.digest(true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineDigest", (Object)result);
        }
        return result;
    }

    private byte[] digest(boolean isExternalCall) {
        byte[] result;
        if (debug != null) {
            Object[] parms = new Object[]{new Boolean(isExternalCall)};
            debug.entry(16384L, (Object)hybridClassName, "digest", parms);
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theDigest.digest();
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "digest", "Successful call to digest(buf,offset,len) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            this.failoverPossible = true;
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "digest", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "digest", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "digest", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getDigest();
                if (this.blocking_active && 0 < this.data_bytes_saved) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "update", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    byte[] seg = null;
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        seg = (byte[])this.dataSegList.get(idx);
                        this.update(seg, 0, seg.length, false);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "update", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                }
                return this.digest(false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "digest", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "digest", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "digest");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "digest", (Object)result);
        }
        return result;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (debug != null) {
            Object[] parms = new Object[]{buf, new Integer(offset), new Integer(len)};
            debug.entry(16384L, (Object)hybridClassName, "engineDigest", parms);
        }
        int result = this.digest(buf, offset, len, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineDigest", result);
        }
        return result;
    }

    private int digest(byte[] buf, int offset, int len, boolean isExternalCall) throws DigestException {
        int result;
        if (debug != null) {
            Object[] parms = new Object[]{buf, new Integer(offset), new Integer(len), new Boolean(isExternalCall)};
            debug.entry(16384L, (Object)hybridClassName, "digest", parms);
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theDigest.digest(buf, offset, len);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "digest", "Successful call to digest(buf,offset,len) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            this.failoverPossible = true;
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "digest", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "digest", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "digest", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getDigest();
                if (this.blocking_active && 0 < this.data_bytes_saved) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "update", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    byte[] seg = null;
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        seg = (byte[])this.dataSegList.get(idx);
                        this.update(seg, 0, seg.length, false);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "update", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                }
                return this.digest(buf, offset, len, false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "digest", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "digest", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "digest");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "digest", result);
        }
        return result;
    }

    private void turn_on_data_blocking() {
        this.blocking_active = true;
        this.blocking_limited = -1 != this.blockSize;
        int data_seg_count = this.dataSegList.size();
        byte[] seg = null;
        for (int idx = data_seg_count - 1; idx >= 0; --idx) {
            seg = (byte[])this.dataSegList.get(idx);
            this.dataSegList.remove(idx);
            seg = null;
        }
        this.data_bytes_saved = 0;
        this.dataSegList.clear();
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "turn_on_data_blocking", (Object)("blockSize = " + this.blockSize + "  blocking_limited = " + this.blocking_limited));
        }
    }

    private void turn_off_data_blocking() {
        this.blocking_active = false;
        int data_seg_count = this.dataSegList.size();
        byte[] seg = null;
        for (int idx = data_seg_count - 1; idx >= 0; --idx) {
            seg = (byte[])this.dataSegList.get(idx);
            this.dataSegList.remove(idx);
            seg = null;
        }
        this.data_bytes_saved = 0;
        this.dataSegList.clear();
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "turn_off_data_blocking", (Object)("blockSize = " + this.blockSize + "  blocking_limited = " + this.blocking_limited));
        }
    }

    private void getDigest() {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getDigest", (Object)this.algorithm);
        }
        if (null != this.theDigest) {
            TableObject tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm);
            tblObj.invalidateProvider(this.theDigest.getProvider().getName());
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getDigest", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
        }
        try {
            this.theDigest = this.getBestInstance();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getDigest", e.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getDigest", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getDigest", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getDigest", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getDigest");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getDigest");
        }
    }

    private MessageDigest getBestInstance() {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getBestInstance", (Object)this.algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("MessageDigest." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theDigest = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 1");
            }
            while (null == this.theDigest && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theDigest = MessageDigest.getInstance(this.algorithm, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Exception thrown on MessageDigest.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for MessageDigest " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theDigest) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theDigest) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "MessageDigest " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
        }
        return this.theDigest;
    }
}

