/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;
import javax.crypto.Mac;
import javax.crypto.MacSpi;
import javax.crypto.NoSuchPaddingException;

abstract class HybridMac
extends MacSpi
implements Cloneable {
    private Mac theMac;
    private static final String serviceType = "Mac";
    private String algorithm;
    private int blockSize = -2;
    private boolean blocking_active = false;
    private boolean blocking_limited = true;
    private int data_bytes_saved = 0;
    private Vector dataSegList;
    private String theProvider = null;
    private Key key = null;
    private AlgorithmParameterSpec paramspec = null;
    private boolean failoverPossible = true;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridMac";

    public HybridMac(String algorithm, int block_size) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "HybridMac", (Object)algorithm, (Object)block_size);
        }
        this.algorithm = algorithm;
        this.blockSize = block_size;
        if (0 == this.blockSize) {
            this.blocking_active = false;
        } else {
            this.blocking_active = true;
            this.blocking_limited = -1 != this.blockSize;
            this.dataSegList = new Vector();
            this.turn_on_data_blocking();
        }
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "HybridMac", rteMessage);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "HybridMac", (Throwable)rte);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "HybridMac");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getMac();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "HybridMac", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "HybridMac", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for Mac " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "HybridMac", rteMessage);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "HybridMac", (Throwable)rte);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "HybridMac");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "HybridMac");
        }
    }

    @Override
    protected int engineGetMacLength() {
        int result = 0;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineGetMacLength");
        }
        result = this.getMacLength(true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineGetMacLength", result);
        }
        return result;
    }

    private int getMacLength(boolean isExternalCall) {
        int result = 0;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMacLength", (Object)new String("isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theMac.getMacLength();
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMacLength", "Successful call to getMacLength() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMacLength", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMacLength", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.reInitMac();
            result = this.getMacLength(false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMacLength", result);
        }
        return result;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineInit", (Object)new String("key=" + key + " params=" + params));
        }
        this.init(key, params, true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineInit");
        }
    }

    private void init(Key key, AlgorithmParameterSpec params, boolean isExternalCall) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "init", (Object)new String("key = " + key + "  params = " + params + "  isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            this.failoverPossible = true;
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
        }
        this.key = key;
        this.paramspec = params;
        try {
            this.theMac.init(key, params);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "init", "Successful call to init(key,paramSpec) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "init", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.reInitMac();
            this.init(key, params, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "init");
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineUpdate", (Object)new Byte(input));
        }
        this.update(input, true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineUpdate");
        }
    }

    private void update(byte input, boolean isExternalCall) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", (Object)new String("input = " + new Byte(input) + "  isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (this.blocking_active) {
                byte[] data_seg = new byte[]{input};
                this.dataSegList.addElement(data_seg);
                ++this.data_bytes_saved;
            }
        }
        try {
            this.theMac.update(input);
            if (debug != null) {
                String msg = null;
                msg = this.blocking_active ? (this.blocking_limited ? new String("Successful call to update(byte) in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved) : new String("Successful call to update(byte) in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is not limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved)) : new String("Successful call to update(byte) in provider: " + this.theProvider + "\n\tBlocking is not active.");
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", msg);
            }
            this.ExceptionHistory = new Vector();
            if (this.blocking_active) {
                if (this.blocking_limited && this.blockSize <= this.data_bytes_saved && isExternalCall) {
                    this.turn_off_data_blocking();
                    this.failoverPossible = false;
                }
            } else {
                this.failoverPossible = false;
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", "Attempting failover to another provider for " + this.algorithm);
                }
                this.reInitMac();
                if (this.blocking_active) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    byte[] seg = null;
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        seg = (byte[])this.dataSegList.get(idx);
                        this.update(seg, 0, seg.length, false);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                } else {
                    this.update(input, false);
                }
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update");
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(offset), new Integer(len)};
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineUpdate", parms);
        }
        this.update(input, offset, len, true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineUpdate");
        }
    }

    private void update(byte[] input, int offset, int len, boolean isExternalCall) {
        if (debug != null) {
            int inLen = 0;
            if (null != input) {
                inLen = input.length;
            }
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", (Object)new String("input[] length = " + inLen + "  offset = " + offset + "  len = " + len + "  isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (this.blocking_active) {
                byte[] data_seg = new byte[len];
                System.arraycopy(input, offset, data_seg, 0, len);
                this.dataSegList.addElement(data_seg);
                this.data_bytes_saved += len;
            }
        }
        try {
            this.theMac.update(input, offset, len);
            if (debug != null) {
                String msg = null;
                msg = this.blocking_active ? (this.blocking_limited ? new String("Successful call to update(input,offset,len) in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved) : new String("Successful call to update(input,offset,len) in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is not limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved)) : new String("Successful call to update(input,offset,len) in provider: " + this.theProvider + "\n\tBlocking is not active.");
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", msg);
            }
            this.ExceptionHistory = new Vector();
            if (this.blocking_active) {
                if (this.blocking_limited && this.blockSize <= this.data_bytes_saved && isExternalCall) {
                    this.turn_off_data_blocking();
                    this.failoverPossible = false;
                }
            } else {
                this.failoverPossible = false;
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", "Attempting failover to another provider for " + this.algorithm);
                }
                this.reInitMac();
                if (this.blocking_active) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    byte[] seg = null;
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        seg = (byte[])this.dataSegList.get(idx);
                        this.update(seg, 0, seg.length, false);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                } else {
                    this.update(input, offset, len, false);
                }
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update");
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineDoFinal");
        }
        result = this.doFinal(true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineDoFinal", (Object)result);
        }
        return result;
    }

    private byte[] doFinal(boolean isExternalCall) {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "doFinal", (Object)new String("isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theMac.doFinal();
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "doFinal", "Successful call to doFinal() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            this.failoverPossible = true;
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "doFinal", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "doFinal", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "doFinal", "Attempting failover to another provider for " + this.algorithm);
                }
                this.reInitMac();
                if (this.blocking_active && 0 < this.data_bytes_saved) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    byte[] seg = null;
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        seg = (byte[])this.dataSegList.get(idx);
                        this.update(seg, 0, seg.length, false);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "update", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                }
                result = this.doFinal(false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "doFinal", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "doFinal", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "doFinal");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "doFinal", (Object)result);
        }
        return result;
    }

    @Override
    protected void engineReset() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineReset");
        }
        this.reset(true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "engineReset");
        }
    }

    private void reset(boolean isExternalCall) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reset", (Object)new String("isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            this.theMac.reset();
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reset", "Successful call to reset() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            this.failoverPossible = true;
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reset", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reset", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.reInitMac();
            this.reset(false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reset");
        }
    }

    @Override
    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "clone");
        }
        CloneNotSupportedException cnse = new CloneNotSupportedException();
        RuntimeException wrapped_cnse = new RuntimeException(cnse);
        if (debug != null) {
            debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "clone", (Throwable)wrapped_cnse);
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "clone");
        }
        throw wrapped_cnse;
    }

    private void turn_on_data_blocking() {
        this.blocking_active = true;
        this.blocking_limited = -1 != this.blockSize;
        int data_seg_count = this.dataSegList.size();
        byte[] seg = null;
        for (int idx = data_seg_count - 1; idx >= 0; --idx) {
            seg = (byte[])this.dataSegList.get(idx);
            this.dataSegList.remove(idx);
            seg = null;
        }
        this.data_bytes_saved = 0;
        this.dataSegList.clear();
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "turn_on_data_blocking", (Object)("blockSize = " + this.blockSize + "  blocking_limited = " + this.blocking_limited));
        }
    }

    private void turn_off_data_blocking() {
        this.blocking_active = false;
        int data_seg_count = this.dataSegList.size();
        byte[] seg = null;
        for (int idx = data_seg_count - 1; idx >= 0; --idx) {
            seg = (byte[])this.dataSegList.get(idx);
            this.dataSegList.remove(idx);
            seg = null;
        }
        this.data_bytes_saved = 0;
        this.dataSegList.clear();
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "turn_off_data_blocking", (Object)("blockSize = " + this.blockSize + "  blocking_limited = " + this.blocking_limited));
        }
    }

    private void getMac() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMac", (Object)this.algorithm);
        }
        try {
            this.theMac = this.getBestInstance();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMac", e.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMac", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMac", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMac", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMac");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getMac");
        }
    }

    private void reInitMac() {
        TableObject tblObject = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reInitMac");
        }
        tblObject = AlgorithmTable.getStateData(serviceType, this.algorithm);
        tblObject.invalidateProvider(this.theMac.getProvider().getName());
        this.theMac = null;
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reInitMac", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
        }
        this.getMac();
        if (null != this.key || null != this.paramspec) {
            try {
                this.init(this.key, this.paramspec, false);
            }
            catch (IBMJCEHybridException ijhe) {
                throw ijhe;
            }
            catch (Exception ex) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reInitMac", ex.getMessage());
                    debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reInitMac", (Throwable)ex);
                }
                this.ExceptionHistory.addElement(ex);
                String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
                IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reInitMac", ijheMsg);
                    debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reInitMac", (Throwable)ijhe);
                    debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reInitMac");
                }
                throw ijhe;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "reInitMac");
        }
    }

    private Mac getBestInstance() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", (Object)this.algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("Mac." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theMac = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", "Top of loop 1");
            }
            while (null == this.theMac && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theMac = Mac.getInstance(this.algorithm, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", "Exception thrown on Mac.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for Mac " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theMac) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", "Calling tblObj.doReset() for Mac," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theMac) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", "Message Authentication Code (MAC) " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridMac", "getBestInstance", (Object)this.theMac);
        }
        return this.theMac;
    }
}

