/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Vector;
import javax.crypto.NoSuchPaddingException;

abstract class HybridKeyFactory
extends KeyFactorySpi {
    private KeyFactory theFactory;
    private static final String serviceType = "KeyFactory";
    private String algorithm;
    private String theProvider = null;
    private boolean firstProvider = true;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridKeyFactory";

    public HybridKeyFactory(String algorithm) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridKeyFactory", (Object)algorithm);
        }
        this.algorithm = algorithm;
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridKeyFactory", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridKeyFactory", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridKeyFactory");
            }
            throw new RuntimeException(rte);
        }
        this.firstProvider = true;
        try {
            this.getFactory();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridKeyFactory", this.theProvider + ": " + ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridKeyFactory", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for KeyFactory " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridKeyFactory", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridKeyFactory", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridKeyFactory");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridKeyFactory");
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        PrivateKey result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGeneratePrivate", (Object)keySpec);
        }
        result = this.generatePrivate(keySpec, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGeneratePrivate", (Object)result);
        }
        return result;
    }

    private PrivateKey generatePrivate(KeySpec keySpec, boolean isExternalCall) throws InvalidKeySpecException {
        PrivateKey result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generatePrivate", (Object)keySpec, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.generatePrivate(keySpec);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generatePrivate", "Successful call to generatePrivate(keySpec) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generatePrivate", this.theProvider + ": " + ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generatePrivate", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.generatePrivate(keySpec, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generatePrivate", (Object)result);
        }
        return result;
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        PublicKey result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGeneratePublic", (Object)keySpec);
        }
        result = this.generatePublic(keySpec, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGeneratePublic", (Object)result);
        }
        return result;
    }

    private PublicKey generatePublic(KeySpec keySpec, boolean isExternalCall) throws InvalidKeySpecException {
        PublicKey result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generatePublic", (Object)keySpec, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.generatePublic(keySpec);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generatePublic", "Successful call to generatePublic(keySpec) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generatePublic", this.theProvider + ": " + ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generatePublic", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.generatePublic(keySpec, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generatePublic", (Object)result);
        }
        return result;
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpecClass) throws InvalidKeySpecException {
        KeySpec result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGetKeySpec", (Object)key, (Object)keySpecClass);
        }
        result = this.getKeySpec(key, keySpecClass, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGetKeySpec", (Object)(result + ""));
        }
        return result;
    }

    private KeySpec getKeySpec(Key key, Class<KeySpec> keySpecClass, boolean isExternalCall) throws InvalidKeySpecException {
        KeySpec result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getKeySpec", (Object)new String("key=" + key + "  keySpecClass=" + keySpecClass + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.getKeySpec(key, keySpecClass);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getKeySpec", "Successful call to getKeySpec(key,keySpecClass) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getKeySpec", this.theProvider + ": " + ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getKeySpec", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.getKeySpec(key, keySpecClass, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getKeySpec", (Object)(result + ""));
        }
        return result;
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        Key result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineTranslateKey", (Object)key);
        }
        result = this.translateKey(key, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineTranslateKey", (Object)result);
        }
        return result;
    }

    private Key translateKey(Key key, boolean isExternalCall) throws InvalidKeyException {
        Key result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "translateKey", (Object)key, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.translateKey(key);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "translateKey", "Successful call to translateKey(key) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "translateKey", this.theProvider + ": " + ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "translateKey", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.translateKey(key, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "translateKey", (Object)result);
        }
        return result;
    }

    private void getFactory() {
        if (debug != null) {
            String parms = new String("algorithm: " + this.algorithm + "  firstProvider: " + this.firstProvider);
            debug.entry(16384L, (Object)hybridClassName, "getFactory", (Object)parms);
        }
        if (null != this.theFactory) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getFactory", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
            TableObject tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm);
            tblObj.invalidateProvider(this.theFactory.getProvider().getName());
        }
        try {
            this.theFactory = this.getBestInstance();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getFactory", this.theProvider + ": " + e.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getFactory", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getFactory", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getFactory", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getFactory");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getFactory");
        }
    }

    private KeyFactory getBestInstance() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getBestInstance", (Object)this.algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("KeyFactory." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theFactory = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 1");
            }
            while (null == this.theFactory && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theFactory = KeyFactory.getInstance(this.algorithm, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", this.theProvider + ": " + ex.getMessage());
                        debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Exception thrown on KeyFactory.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for KeyFactory " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theFactory) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.doReset() for KeyFactory," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theFactory) {
            this.firstProvider = false;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "SecretKeyFactory " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
        }
        return this.theFactory;
    }
}

