/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

abstract class HybridKeyAgreement
extends KeyAgreementSpi {
    private KeyAgreement theAgreement;
    private static final String serviceType = "KeyAgreement";
    private String algorithm;
    private String theProvider = null;
    private Key key = null;
    private SecureRandom random = null;
    private AlgorithmParameterSpec paramspec = null;
    private boolean failoverPossible = true;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement";

    public HybridKeyAgreement(String algorithm) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "HybridKeyAgreement", (Object)algorithm);
        }
        this.algorithm = algorithm;
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "HybridKeyAgreement", rteMessage);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "HybridKeyAgreement", (Throwable)rte);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "HybridKeyAgreement");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getAgreement();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "HybridKeyAgreement", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "HybridKeyAgreement", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for KeyAgreement " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "HybridKeyAgreement", rteMessage);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "HybridKeyAgreement", (Throwable)rte);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "HybridKeyAgreement");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "HybridKeyAgreement");
        }
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineInit", (Object)new String("key=" + key + "  random=" + random));
        }
        this.init(key, random, true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineInit");
        }
    }

    private void init(Key key, SecureRandom random, boolean isExternalCall) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "init", (Object)new String("key=" + key + "  random=" + random + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        this.failoverPossible = true;
        this.key = key;
        this.paramspec = null;
        this.random = random;
        try {
            this.theAgreement.init(key, random);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "init", "Successful call to init(key,random) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "init", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getAgreement();
            this.init(key, random, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "init");
        }
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineInit", (Object)new String("key=" + key + "  random=" + random + "  params=" + params));
        }
        this.init(key, params, random, true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineInit");
        }
    }

    private void init(Key key, AlgorithmParameterSpec params, SecureRandom random, boolean isExternalCall) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "init", (Object)new String("key=" + key + "  random=" + random + "  params=" + params + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        this.failoverPossible = true;
        this.key = key;
        this.paramspec = params;
        this.random = random;
        try {
            this.theAgreement.init(key, params, random);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "init", "Successful call to init(key,paramSpec,random) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "init", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getAgreement();
            this.init(key, params, random, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "init");
        }
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        Key result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineDoPhase", (Object)new String("key=" + key + "  lastPhase=" + lastPhase));
        }
        result = this.doPhase(key, lastPhase, true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineDoPhase");
        }
        return result;
    }

    private Key doPhase(Key key, boolean lastPhase, boolean isExternalCall) throws InvalidKeyException, IllegalStateException {
        Key result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "doPhase", (Object)new String("key=" + key + "  lastPhase=" + lastPhase + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            if (!isExternalCall && null != this.key) {
                this.theAgreement.init(this.key, this.paramspec, this.random);
            }
            result = this.theAgreement.doPhase(key, lastPhase);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "doPhase", "Successful call to doPhase(key,isLastPhase) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            this.failoverPossible = false;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "doPhase", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "doPhase", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "doPhase", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getAgreement();
                return this.doPhase(key, lastPhase, false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "doPhase", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "doPhase", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "doPhase");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "doPhase");
        }
        return result;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineGenerateSecret");
        }
        result = this.generateSecret(true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineGenerateSecret");
        }
        return result;
    }

    private byte[] generateSecret(boolean isExternalCall) throws IllegalStateException {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", (Object)new String("isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            if (!isExternalCall && null != this.key) {
                this.theAgreement.init(this.key, this.paramspec, this.random);
            }
            result = this.theAgreement.generateSecret();
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", "Successful call to generateSecret() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            this.failoverPossible = true;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getAgreement();
                return this.generateSecret(false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret");
        }
        return result;
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        int result = 0;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineGenerateSecret", (Object)new String("offset = " + offset));
        }
        result = this.generateSecret(sharedSecret, offset, true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineGenerateSecret");
        }
        return result;
    }

    private int generateSecret(byte[] sharedSecret, int offset, boolean isExternalCall) throws IllegalStateException, ShortBufferException {
        int result = 0;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", (Object)new String("offset = " + offset + "  isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            if (!isExternalCall && null != this.key) {
                this.theAgreement.init(this.key, this.paramspec, this.random);
            }
            result = this.theAgreement.generateSecret(sharedSecret, offset);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", "Successful call to generateSecret(sharedSecret,offset) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            this.failoverPossible = true;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getAgreement();
                return this.generateSecret(sharedSecret, offset, false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret");
        }
        return result;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        SecretKey result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineGenerateSecret", (Object)algorithm);
        }
        result = this.generateSecret(algorithm, true);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "engineGenerateSecret");
        }
        return result;
    }

    private SecretKey generateSecret(String algorithm, boolean isExternalCall) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        SecretKey result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", (Object)new String("algorithm = " + algorithm + "  isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            if (!isExternalCall && null != this.key) {
                this.theAgreement.init(this.key, this.paramspec, this.random);
            }
            result = this.theAgreement.generateSecret(algorithm);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", "Successful call to generateSecret(algorithm) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            this.failoverPossible = true;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getAgreement();
                return this.generateSecret(algorithm, false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "generateSecret");
        }
        return result;
    }

    private void getAgreement() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getAgreement");
        }
        if (null != this.theAgreement) {
            TableObject tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm);
            tblObj.invalidateProvider(this.theAgreement.getProvider().getName());
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getAgreement", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
        }
        try {
            this.theAgreement = this.getBestInstance();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getAgreement", e.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getAgreement", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getAgreement", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getAgreement", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getAgreement");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getAgreement");
        }
    }

    private KeyAgreement getBestInstance() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", (Object)this.algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("KeyAgreement." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theAgreement = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", "Top of loop 1");
            }
            while (null == this.theAgreement && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theAgreement = KeyAgreement.getInstance(this.algorithm, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", "Exception thrown on KeyAgreement.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for KeyAgreement " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theAgreement) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", "Calling tblObj.doReset() for KeyAgreement," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theAgreement) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", "KeyAgreement " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridKeyAgreement", "getBestInstance", (Object)this.theAgreement);
        }
        return this.theAgreement;
    }
}

