/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

abstract class HybridCipher
extends CipherSpi {
    private Cipher theCipher;
    private static final String serviceType = "Cipher";
    private String algorithm;
    private String cipherMode = null;
    private String padding = null;
    private boolean algorithmPassedSeparately = true;
    private String cipherSpec = null;
    private String theProvider = null;
    private static final int ThreeArgInit = 1;
    private static final int FourArgInitParam = 2;
    private static final int FourArgInitParamSpec = 3;
    private int initMethod = 0;
    private Key key = null;
    private SecureRandom random = null;
    private int opmode = -1;
    private AlgorithmParameterSpec paramspec = null;
    private AlgorithmParameters params = null;
    private Vector aadList;
    private boolean firstProvider = true;
    private int blockSize = -2;
    private boolean blocking_active = false;
    private boolean blocking_limited = true;
    private int data_bytes_saved = 0;
    private Vector dataSegList;
    private boolean failoverPossible = true;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridCipher";

    public HybridCipher(String algorithm, int block_size) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "HybridCipher", (Object)algorithm, (Object)block_size);
        }
        this.algorithm = algorithm;
        this.cipherMode = null;
        this.padding = null;
        this.blockSize = block_size;
        this.algorithmPassedSeparately = true;
        this.aadList = new Vector();
        if (-2 >= this.blockSize) {
            this.blockSize = 0;
        }
        if (0 == this.blockSize) {
            this.blocking_active = false;
        } else {
            this.blocking_active = true;
            this.blocking_limited = -1 != this.blockSize;
            this.dataSegList = new Vector();
            this.turn_on_data_blocking();
        }
        this.tableObjectReset = false;
        this.firstProvider = true;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "HybridAlgorithmParameterGenerator", rteMessage);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "HybridAlgorithmParameterGenerator", (Throwable)rte);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "HybridAlgorithmParameterGenerator");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "HybridCipher");
        }
    }

    public HybridCipher(String algorithm, String mode, String paddingScheme, int block_size) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "HybridCipher", (Object)new String("algorithm:" + algorithm + "  mode:" + mode + "  paddingScheme:" + paddingScheme + "  blockSize: " + block_size));
        }
        this.algorithm = algorithm;
        this.cipherMode = mode;
        this.padding = paddingScheme;
        this.blockSize = block_size;
        this.algorithmPassedSeparately = false;
        this.aadList = new Vector();
        if (-2 >= this.blockSize) {
            this.blockSize = 0;
        }
        if (0 == this.blockSize) {
            this.blocking_active = false;
        } else {
            this.blocking_active = true;
            this.blocking_limited = -1 != this.blockSize;
            this.dataSegList = new Vector();
            this.turn_on_data_blocking();
        }
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "HybridCipher", rteMessage);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "HybridCipher", (Throwable)rte);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "HybridCipher");
            }
            throw new RuntimeException(rte);
        }
        this.firstProvider = true;
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "HybridCipher");
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineSetMode", (Object)mode);
        }
        this.cipherMode = mode;
        this.algorithmPassedSeparately = true;
        this.tableObjectReset = false;
        this.firstProvider = true;
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineSetMode");
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineSetPadding", (Object)paddingScheme);
        }
        this.padding = paddingScheme;
        this.algorithmPassedSeparately = true;
        this.tableObjectReset = false;
        this.firstProvider = true;
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineSetPadding");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        int result = 0;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetBlocksize");
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        result = this.theCipher.getBlockSize();
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetBlocksize", "Successful call to getBlockSize() in provider: " + this.theProvider);
        }
        this.ExceptionHistory = new Vector();
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetBlocksize", result);
        }
        return result;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetKeySize", (Object)("Cipher algorithm = " + this.algorithm));
        }
        int acceptableSize = 0;
        try {
            acceptableSize = Cipher.getMaxAllowedKeyLength(this.algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            String rteMessage = new String("algorithm not defined to Framework Cipher: " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetKeySize", rteMessage);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetKeySize", (Throwable)rte);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetKeySize");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetKeySize", acceptableSize);
        }
        return acceptableSize;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        int result = 0;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetOutputSize", (Object)new Integer(inputLen));
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        result = this.theCipher.getOutputSize(inputLen);
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetOutputSize", "Successful call to getOutputSize(inputLen) in provider: " + this.theProvider);
        }
        this.ExceptionHistory = new Vector();
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetOutputSize", (Object)new Integer(result));
        }
        return result;
    }

    @Override
    protected byte[] engineGetIV() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetIV");
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        byte[] result = this.theCipher.getIV();
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetIV", "Successful call to getIV() in provider: " + this.theProvider);
        }
        this.ExceptionHistory = new Vector();
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetIV", (Object)result);
        }
        return result;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetParameters");
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        result = this.theCipher.getParameters();
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetParameters", "Successful call to getParameters() in provider: " + this.theProvider);
        }
        this.ExceptionHistory = new Vector();
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineGetParameters", (Object)result);
        }
        return result;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineInit 1", (Object)new String("opmode=" + opmode + "  key=" + key + "  random=" + random));
        }
        boolean externalCall = true;
        boolean inRecovery = false;
        this.init(opmode, key, random, externalCall, inRecovery);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineInit");
        }
    }

    private void init(int opmode, Key key, SecureRandom random, boolean isExternalCall, boolean recoveryInProgress) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init 1", (Object)new String("opmode=" + opmode + "  key=" + key + "  random=" + random + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
            this.failoverPossible = true;
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        this.initMethod = 1;
        this.opmode = opmode;
        this.key = key;
        this.random = random;
        try {
            if (key instanceof HybridRACFPrivateKey) {
                Key unwraveledKey;
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", "HybridRACFPrivateKey found. Need to unwravel the key for use with underlying provider.");
                }
                key = unwraveledKey = this.unwravelKey((HybridRACFPrivateKey)key);
            }
            this.theCipher.init(opmode, key, random);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", "Successful call to init(opmode,key,random) in provider: " + this.theProvider);
            }
            if (!recoveryInProgress) {
                this.ExceptionHistory = new Vector();
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.reInitCipher();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineInit 2", (Object)new String("opmode=" + opmode + "  key=" + key + "  params=" + params + "  random=" + random));
        }
        boolean externalCall = true;
        boolean inRecovery = false;
        this.init(opmode, key, params, random, externalCall, inRecovery);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineInit");
        }
    }

    private void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random, boolean isExternalCall, boolean recoveryInProgress) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init 2", (Object)new String("opmode=" + opmode + "  key=" + key + "  params=" + params + "  random=" + random + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
            this.failoverPossible = true;
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        this.initMethod = 3;
        this.opmode = opmode;
        this.key = key;
        this.paramspec = params;
        this.random = random;
        try {
            if (key instanceof HybridRACFPrivateKey) {
                Key unwraveledKey;
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", "HybridRACFPrivateKey found. Need to unwravel the key for use with underlying provider.");
                }
                key = unwraveledKey = this.unwravelKey((HybridRACFPrivateKey)key);
            }
            this.theCipher.init(opmode, key, params, random);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", "Successful call to init(opmode,key,paramSpec,random) in provider: " + this.theProvider);
            }
            if (!recoveryInProgress) {
                this.ExceptionHistory = new Vector();
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.reInitCipher();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineInit 3", (Object)new String("opmode=" + opmode + "  key=" + key + "  params=" + params + "  random=" + random));
        }
        boolean externalCall = true;
        boolean inRecovery = false;
        this.init(opmode, key, params, random, externalCall, inRecovery);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineInit");
        }
    }

    private void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random, boolean isExternalCall, boolean recoveryInProgress) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init 3", (Object)new String("opmode=" + opmode + "  key=" + key + "  params=" + params + "  random=" + random));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
            this.failoverPossible = true;
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        this.initMethod = 2;
        this.opmode = opmode;
        this.key = key;
        this.params = params;
        this.random = random;
        try {
            if (key instanceof HybridRACFPrivateKey) {
                Key unwraveledKey;
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", "HybridRACFPrivateKey found. Need to unwravel the key for use with underlying provider.");
                }
                key = unwraveledKey = this.unwravelKey((HybridRACFPrivateKey)key);
            }
            this.theCipher.init(opmode, key, params, random);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", "Successful call to init(opmode,key,params,random) in provider: " + this.theProvider);
            }
            if (!recoveryInProgress) {
                this.ExceptionHistory = new Vector();
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.reInitCipher();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "init");
        }
    }

    protected void engineUpdateAAD(byte[] src) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineUpdateAAD", (Object)src);
        }
        int srcLen = 0;
        if (null != src) {
            srcLen = src.length;
        }
        boolean externalCall = true;
        boolean inRecovery = false;
        this.updateAAD(src, 0, srcLen, externalCall, inRecovery);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineUpdateAAD");
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineUpdateAAD", (Object)new String("offset=" + offset + "  len=" + len));
        }
        boolean externalCall = true;
        boolean inRecovery = false;
        this.updateAAD(src, offset, len, externalCall, inRecovery);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineUpdateAAD");
        }
    }

    private void updateAAD(byte[] src, int offset, int inputLen, boolean isExternalCall, boolean recoveryInProgress) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        if (debug != null) {
            int srcLen = 0;
            if (null != src) {
                srcLen = src.length;
            }
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "updateAAD", (Object)(new String("input length=" + srcLen + "  inputOffset=" + offset + "  inputLen=" + inputLen) + " isExternalCall=" + isExternalCall + " recoveryInProgress=" + recoveryInProgress));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (this.failoverPossible && 0 < inputLen) {
                byte[] aad_seg = new byte[inputLen];
                System.arraycopy(src, offset, aad_seg, 0, inputLen);
                this.aadList.addElement(aad_seg);
            }
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        try {
            this.theCipher.updateAAD(src, offset, inputLen);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "updateAAD", "Successful call to updateAAD(src,offset,len) in provider: " + this.theProvider);
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "updateAAD", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "updateAAD", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "updateAAD", "Attempting failover to another provider for " + this.cipherSpec);
                }
                this.reInitCipher();
                boolean externalCall = false;
                boolean inRecovery = true;
                if (this.blocking_active && 0 < this.data_bytes_saved) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    byte[] lastReturn = null;
                    byte[] seg = null;
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        seg = (byte[])this.dataSegList.get(idx);
                        lastReturn = this.update(seg, 0, seg.length, externalCall, inRecovery);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "updateAAD", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                }
                int aad_seg_count = this.aadList.size();
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Beginning replay of " + aad_seg_count + " aad[] segments.");
                }
                byte[] aadSeg = null;
                for (int idx = 0; idx < aad_seg_count; ++idx) {
                    aadSeg = (byte[])this.aadList.get(idx);
                    this.updateAAD(aadSeg, 0, aadSeg.length, externalCall, inRecovery);
                }
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "updateAAD", "Completed replay of " + aad_seg_count + " aad[] segments.");
                }
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "updateAAD", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "updateAAD", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "updateAAD");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "updateAAD");
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineUpdate", (Object)new String("inputOffset=" + inputOffset + "  inputLen=" + inputLen));
        }
        boolean externalCall = true;
        boolean inRecovery = false;
        result = this.update(input, inputOffset, inputLen, externalCall, inRecovery);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineUpdate");
        }
        return result;
    }

    private byte[] update(byte[] input, int inputOffset, int inputLen, boolean isExternalCall, boolean recoveryInProgress) {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update 1", (Object)new String("inputOffset=" + inputOffset + "  inputLen=" + inputLen + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (this.blocking_active && 0 < inputLen) {
                byte[] data_seg = new byte[inputLen];
                System.arraycopy(input, inputOffset, data_seg, 0, inputLen);
                this.dataSegList.addElement(data_seg);
                this.data_bytes_saved += inputLen;
            }
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        try {
            result = this.theCipher.update(input, inputOffset, inputLen);
            if (debug != null) {
                String msg = null;
                msg = this.blocking_active ? (this.blocking_limited ? new String("Successful call to update(input,inputOffset,inputLen) in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved) : new String("Successful call to update(input,inputOffset,inputLen) in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is not limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved)) : new String("Successful call to update(input,inputOffset,inputLen) in provider: " + this.theProvider + "\n\tBlocking is not active.");
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", msg);
            }
            if (!recoveryInProgress) {
                this.ExceptionHistory = new Vector();
            }
            if (this.blocking_active) {
                if (this.blocking_limited && this.blockSize <= this.data_bytes_saved && isExternalCall) {
                    this.turn_off_data_blocking();
                    this.failoverPossible = false;
                }
            } else {
                this.failoverPossible = false;
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Attempting failover to another provider for " + this.cipherSpec);
                }
                this.reInitCipher();
                boolean externalCall = false;
                boolean inRecovery = true;
                int aad_seg_count = this.aadList.size();
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Beginning replay of " + aad_seg_count + " aad[] segments.");
                }
                byte[] aadSeg = null;
                for (int idx = 0; idx < aad_seg_count; ++idx) {
                    aadSeg = (byte[])this.aadList.get(idx);
                    this.updateAAD(aadSeg, 0, aadSeg.length, externalCall, inRecovery);
                }
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Completed replay of " + aad_seg_count + " aad[] segments.");
                }
                if (this.blocking_active && 0 < this.data_bytes_saved) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    byte[] lastReturn = null;
                    byte[] seg = null;
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        seg = (byte[])this.dataSegList.get(idx);
                        lastReturn = this.update(seg, 0, seg.length, externalCall, inRecovery);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                    return lastReturn;
                }
                return this.update(input, inputOffset, inputLen, externalCall, inRecovery);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update");
        }
        return result;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int result = 0;
        if (debug != null) {
            int inLen = 0;
            if (null != input) {
                inLen = input.length;
            }
            int outLen = 0;
            if (null != output) {
                outLen = output.length;
            }
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineUpdate", (Object)new String("input length=" + inLen + "  inputOffset=" + inputOffset + "  inputLen=" + inputLen + "  output length=" + outLen + "  outputOffset=" + outputOffset));
        }
        boolean externalCall = true;
        boolean inRecovery = false;
        result = this.update(input, inputOffset, inputLen, output, outputOffset, externalCall, inRecovery);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineUpdate", result);
        }
        return result;
    }

    private int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, boolean isExternalCall, boolean recoveryInProgress) throws ShortBufferException {
        int result = 0;
        if (debug != null) {
            int inLen = 0;
            if (null != input) {
                inLen = input.length;
            }
            int outLen = 0;
            if (null != output) {
                outLen = output.length;
            }
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update 2", (Object)new String("input length=" + inLen + "  inputOffset=" + inputOffset + "  inputLen=" + inputLen + "  output length=" + outLen + "  outputOffset=" + outputOffset + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (this.blocking_active && 0 < inputLen) {
                byte[] data_seg = new byte[inputLen];
                System.arraycopy(input, inputOffset, data_seg, 0, inputLen);
                this.dataSegList.addElement(data_seg);
                this.data_bytes_saved += inputLen;
            }
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        try {
            result = this.theCipher.update(input, inputOffset, inputLen, output, outputOffset);
            if (debug != null) {
                String msg = null;
                msg = this.blocking_active ? (this.blocking_limited ? new String("Successful call to update(input,inputOffset,inputLen,output,outputOffset) in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved) : new String("Successful call to update(input,inputOffset,inputLen,output,outputOffset) in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is not limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved)) : new String("Successful call to update(input,inputOffset,inputLen,output,outputOffset) in provider: " + this.theProvider + "\n\tBlocking is not active.");
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", msg);
            }
            if (!recoveryInProgress) {
                this.ExceptionHistory = new Vector();
            }
            if (this.blocking_active) {
                if (this.blocking_limited && this.blockSize <= this.data_bytes_saved && isExternalCall) {
                    this.turn_off_data_blocking();
                    this.failoverPossible = false;
                }
            } else {
                this.failoverPossible = false;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", (Object)new Integer(result));
            }
            return result;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Attempting failover to another provider for " + this.cipherSpec);
                }
                this.reInitCipher();
                boolean externalCall = false;
                boolean inRecovery = true;
                int aad_seg_count = this.aadList.size();
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Beginning replay of " + aad_seg_count + " aad[] segments.");
                }
                byte[] aadSeg = null;
                for (int idx = 0; idx < aad_seg_count; ++idx) {
                    aadSeg = (byte[])this.aadList.get(idx);
                    this.updateAAD(aadSeg, 0, aadSeg.length, externalCall, inRecovery);
                }
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Completed replay of " + aad_seg_count + " aad[] segments.");
                }
                if (this.blocking_active && 0 < this.data_bytes_saved) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    int lastReturn = 0;
                    byte[] seg = null;
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        seg = (byte[])this.dataSegList.get(idx);
                        lastReturn = this.update(seg, 0, seg.length, output, outputOffset, externalCall, inRecovery);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                    return lastReturn;
                }
                return this.update(input, inputOffset, inputLen, output, outputOffset, externalCall, inRecovery);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "update");
            }
            throw ijhe;
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineDoFinal", (Object)new String("inputOffset=" + inputOffset + "  inputLen=" + inputLen));
        }
        boolean externalCall = true;
        boolean inRecovery = false;
        result = this.doFinal(input, inputOffset, inputLen, externalCall, inRecovery);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineDoFinal", (Object)result);
        }
        return result;
    }

    private byte[] doFinal(byte[] input, int inputOffset, int inputLen, boolean isExternalCall, boolean recoveryInProgress) throws IllegalBlockSizeException, BadPaddingException {
        byte[] result = null;
        if (debug != null) {
            int inLen = 0;
            if (null != input) {
                inLen = input.length;
            }
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal 1", (Object)new String("input length=" + inLen + "  inputOffset=" + inputOffset + "  inputLen=" + inputLen + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (this.blocking_active && 0 < inputLen) {
                byte[] data_seg = new byte[inputLen];
                System.arraycopy(input, inputOffset, data_seg, 0, inputLen);
                this.dataSegList.addElement(data_seg);
                this.data_bytes_saved += inputLen;
            }
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        try {
            if (0 == inputOffset && 0 == inputLen) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Calling theCipher.doFinal() with no arguments");
                }
                result = this.theCipher.doFinal();
            } else {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Calling theCipher.doFinal(input,inputOffset,inputLen)");
                }
                result = this.theCipher.doFinal(input, inputOffset, inputLen);
            }
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Successful call to doFinal(input,inputOffset,inputLen) in provider: " + this.theProvider);
            }
            if (!recoveryInProgress) {
                this.ExceptionHistory = new Vector();
            }
            this.failoverPossible = true;
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", (Object)result);
            }
            return result;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Attempting failover to another provider for " + this.cipherSpec);
                }
                this.reInitCipher();
                boolean externalCall = false;
                boolean inRecovery = true;
                int aad_seg_count = this.aadList.size();
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Beginning replay of " + aad_seg_count + " aad[] segments.");
                }
                byte[] aadSeg = null;
                for (int idx = 0; idx < aad_seg_count; ++idx) {
                    aadSeg = (byte[])this.aadList.get(idx);
                    this.updateAAD(aadSeg, 0, aadSeg.length, externalCall, inRecovery);
                }
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Completed replay of " + aad_seg_count + " aad[] segments.");
                }
                if (this.blocking_active && 0 < this.data_bytes_saved) {
                    byte[] lastReturn = null;
                    byte[] seg = null;
                    int data_seg_count = this.dataSegList.size();
                    if (1 == data_seg_count) {
                        if (debug != null) {
                            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Beginning replay of " + data_seg_count + " data[] segments.");
                        }
                        seg = (byte[])this.dataSegList.get(0);
                        lastReturn = this.doFinal(seg, 0, seg.length, externalCall, inRecovery);
                        if (debug != null) {
                            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Completed replay of " + data_seg_count + " data[] segments.");
                        }
                    } else {
                        if (debug != null) {
                            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Beginning replay of " + data_seg_count + " data[] segments.");
                        }
                        for (int idx = 0; idx < data_seg_count - 1; ++idx) {
                            seg = (byte[])this.dataSegList.get(idx);
                            this.update(seg, 0, seg.length, externalCall, inRecovery);
                        }
                        seg = (byte[])this.dataSegList.get(data_seg_count - 1);
                        lastReturn = this.doFinal(seg, 0, seg.length, externalCall, inRecovery);
                        if (debug != null) {
                            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Completed replay of " + data_seg_count + " data[] segments.");
                        }
                    }
                    return lastReturn;
                }
                return this.doFinal(input, inputOffset, inputLen, externalCall, inRecovery);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal");
            }
            throw ijhe;
        }
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int result = 0;
        if (debug != null) {
            int inLen = 0;
            if (null != input) {
                inLen = input.length;
            }
            int outLen = 0;
            if (null != output) {
                outLen = output.length;
            }
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineDoFinal", (Object)new String("input length=" + inLen + "  inputOffset=" + inputOffset + "  inputLen=" + inputLen + "  output length=" + outLen + "  outputOffset=" + outputOffset));
        }
        boolean externalCall = true;
        boolean inRecovery = false;
        result = this.doFinal(input, inputOffset, inputLen, output, outputOffset, externalCall, inRecovery);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineDoFinal", (Object)new Integer(result));
        }
        return result;
    }

    private int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, boolean isExternalCall, boolean recoveryInProgress) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int result = 0;
        if (debug != null) {
            int inLen = 0;
            if (null != input) {
                inLen = input.length;
            }
            int outLen = 0;
            if (null != output) {
                outLen = output.length;
            }
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal 3", (Object)new String("input length=" + inLen + "  inputOffset=" + inputOffset + "  inputLen=" + inputLen + "  output length=" + outLen + "  outputOffset=" + outputOffset + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (this.blocking_active && 0 < inputLen) {
                byte[] data_seg = new byte[inputLen];
                System.arraycopy(input, inputOffset, data_seg, 0, inputLen);
                this.dataSegList.addElement(data_seg);
                this.data_bytes_saved += inputLen;
            }
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        try {
            if (0 == inputOffset && 0 == inputLen) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Calling theCipher.doFinal(output,outputOffset)");
                }
                result = this.theCipher.doFinal(output, outputOffset);
            } else {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Calling theCipher.doFinal(input,inputOffset,inputLen,output,outputOffset)");
                }
                result = this.theCipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
            }
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Successful call to doFinal(input,inputOffset,inputLen,output,outputOffset) in provider: " + this.theProvider);
            }
            if (!recoveryInProgress) {
                this.ExceptionHistory = new Vector();
            }
            this.failoverPossible = true;
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", (Object)new Integer(result));
            }
            return result;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                IBMJCEHybridException frameWorksIJHE = null;
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Attempting failover to another provider for " + this.cipherSpec);
                }
                try {
                    this.reInitCipher();
                }
                catch (IBMJCEHybridException ijhe) {
                    try {
                        if (debug != null) {
                            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "calling engineInit because reInitCipher failed - initMethod=" + this.initMethod);
                        }
                        switch (this.initMethod) {
                            case 1: {
                                this.engineInit(this.opmode, this.key, this.random);
                                break;
                            }
                            case 2: {
                                this.engineInit(this.opmode, this.key, this.params, this.random);
                                break;
                            }
                            case 3: {
                                this.init(this.opmode, this.key, this.paramspec, this.random, false, true);
                            }
                        }
                    }
                    catch (Exception ex2) {
                        Vector oldVector = ijhe.getEmbeddedExceptionVector();
                        Vector<Exception> newVector = new Vector<Exception>();
                        for (int i = 0; i < oldVector.size(); ++i) {
                            Exception tempEx = (Exception)oldVector.get(i);
                            newVector.addElement(tempEx);
                        }
                        newVector.addElement(ex2);
                        String ijheMsg = "Failover exhausted, all registered providers attempted and failed during recovery.";
                        IBMJCEHybridException ijhe2 = new IBMJCEHybridException(ijheMsg, newVector);
                        throw ijhe2;
                    }
                    frameWorksIJHE = ijhe;
                }
                boolean externalCall = false;
                boolean inRecovery = true;
                int aad_seg_count = this.aadList.size();
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Beginning replay of " + aad_seg_count + " aad[] segments.");
                }
                byte[] aadSeg = null;
                for (int idx = 0; idx < aad_seg_count; ++idx) {
                    aadSeg = (byte[])this.aadList.get(idx);
                    this.updateAAD(aadSeg, 0, aadSeg.length, externalCall, inRecovery);
                }
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Completed replay of " + aad_seg_count + " aad[] segments.");
                }
                if (frameWorksIJHE != null) {
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", frameWorksIJHE.getMessage());
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", (Throwable)frameWorksIJHE);
                        debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal");
                    }
                    throw frameWorksIJHE;
                }
                if (this.blocking_active && 0 < this.data_bytes_saved) {
                    int lastReturn = 0;
                    byte[] seg = null;
                    int data_seg_count = this.dataSegList.size();
                    if (1 == data_seg_count) {
                        if (debug != null) {
                            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Beginning replay of " + data_seg_count + " data[] segments.");
                        }
                        seg = (byte[])this.dataSegList.get(0);
                        lastReturn = this.doFinal(seg, 0, seg.length, output, outputOffset, externalCall, inRecovery);
                        if (debug != null) {
                            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Completed replay of " + data_seg_count + " data[] segments.");
                        }
                    } else {
                        if (debug != null) {
                            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Beginning replay of " + data_seg_count + " data[] segments.");
                        }
                        for (int idx = 0; idx < data_seg_count - 1; ++idx) {
                            seg = (byte[])this.dataSegList.get(idx);
                            this.update(seg, 0, seg.length, externalCall, inRecovery);
                        }
                        seg = (byte[])this.dataSegList.get(data_seg_count - 1);
                        lastReturn = this.doFinal(seg, 0, seg.length, output, outputOffset, externalCall, inRecovery);
                        if (debug != null) {
                            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", "Completed replay of " + data_seg_count + " data[] segments.");
                        }
                    }
                    return lastReturn;
                }
                return this.doFinal(input, inputOffset, inputLen, output, outputOffset, externalCall, inRecovery);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "doFinal");
            }
            throw ijhe;
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineWrap");
        }
        boolean externalCall = true;
        boolean inRecovery = false;
        result = this.wrap(key, externalCall, inRecovery);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineWrap", (Object)result);
        }
        return result;
    }

    private byte[] wrap(Key key, boolean isExternalCall, boolean recoveryInProgress) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "wrap", (Object)key, (Object)isExternalCall);
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        try {
            result = this.theCipher.wrap(key);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "wrap", "Successful call to wrap(key) in provider: " + this.theProvider);
            }
            if (!recoveryInProgress) {
                this.ExceptionHistory = new Vector();
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "wrap", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "sign", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.reInitCipher();
            boolean externalCall = false;
            boolean inRecovery = true;
            return this.wrap(key, externalCall, inRecovery);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "wrap", (Object)result);
        }
        return result;
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        Key result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineUnwrap", (Object)new String("wrappedKey=" + wrappedKey + "  wrappedKeyAlgorithm=" + wrappedKeyAlgorithm + "  wrappedKeyType=" + wrappedKeyType));
        }
        boolean externalCall = true;
        boolean inRecovery = false;
        result = this.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType, externalCall, inRecovery);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "engineUnwrap", (Object)result);
        }
        return result;
    }

    private Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType, boolean isExternalCall, boolean recoveryInProgress) throws InvalidKeyException, NoSuchAlgorithmException {
        Key result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "unwrap", (Object)new String("wrappedKey=" + wrappedKey + "  wrappedKeyAlgorithm=" + wrappedKeyAlgorithm + "  wrappedKeyType=" + wrappedKeyType + " isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        if (null == this.theCipher) {
            this.getCipher();
        }
        try {
            result = this.theCipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "unwrap", "Successful call to unwrap(wrappedKey,wrappedKeyAlgorithm,wrappedKeyType) in provider: " + this.theProvider);
            }
            if (!recoveryInProgress) {
                this.ExceptionHistory = new Vector();
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "unwrap", ex.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "sign", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.reInitCipher();
            boolean externalCall = false;
            boolean inRecovery = true;
            return this.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType, externalCall, inRecovery);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "unwrap", (Object)result);
        }
        return result;
    }

    private void turn_on_data_blocking() {
        this.blocking_active = true;
        this.blocking_limited = -1 != this.blockSize;
        int data_seg_count = this.dataSegList.size();
        byte[] seg = null;
        for (int idx = data_seg_count - 1; idx >= 0; --idx) {
            seg = (byte[])this.dataSegList.get(idx);
            this.dataSegList.remove(idx);
            seg = null;
        }
        this.data_bytes_saved = 0;
        this.dataSegList.clear();
        int aad_seg_count = this.aadList.size();
        byte[] aadSeg = null;
        for (int idx = aad_seg_count - 1; idx >= 0; --idx) {
            aadSeg = (byte[])this.aadList.get(idx);
            this.aadList.remove(idx);
            aadSeg = null;
        }
        this.aadList.clear();
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "turn_on_data_blocking", (Object)("blockSize = " + this.blockSize + "  blocking_limited = " + this.blocking_limited));
        }
    }

    private void turn_off_data_blocking() {
        this.blocking_active = false;
        int data_seg_count = this.dataSegList.size();
        byte[] seg = null;
        for (int idx = data_seg_count - 1; idx >= 0; --idx) {
            seg = (byte[])this.dataSegList.get(idx);
            this.dataSegList.remove(idx);
            seg = null;
        }
        this.data_bytes_saved = 0;
        this.dataSegList.clear();
        int aad_seg_count = this.aadList.size();
        byte[] aadSeg = null;
        for (int idx = aad_seg_count - 1; idx >= 0; --idx) {
            aadSeg = (byte[])this.aadList.get(idx);
            this.aadList.remove(idx);
            aadSeg = null;
        }
        this.aadList.clear();
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "turn_off_data_blocking", (Object)("blockSize = " + this.blockSize + "  blocking_limited = " + this.blocking_limited));
        }
    }

    private void getCipher() {
        if (debug != null) {
            String data = new String("this.algorithm=" + this.algorithm + "; this.cipherMode=" + this.cipherMode + "; this.padding=" + this.padding + "; algorithmPassedSeparately=" + this.algorithmPassedSeparately + "; tableObjectReset=" + this.tableObjectReset + "; firstProvider=" + this.firstProvider);
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getCipher", (Object)data);
        }
        this.cipherSpec = this.algorithm;
        if (null != this.cipherMode) {
            this.cipherSpec = this.cipherSpec + "/" + this.cipherMode;
        }
        if (null != this.padding) {
            if (null == this.cipherMode) {
                this.cipherSpec = this.cipherSpec + "/";
            }
            this.cipherSpec = this.cipherSpec + "/" + this.padding;
        }
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getCipher", new String("cipherSpec = " + this.cipherSpec));
        }
        try {
            this.theCipher = this.getBestInstance();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getCipher", e.getMessage());
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getCipher", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getCipher", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getCipher", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getCipher");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getCipher");
        }
    }

    private void reInitCipher() {
        TableObject tblObject = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher");
        }
        this.cipherSpec = this.algorithm;
        if (null != this.cipherMode) {
            this.cipherSpec = this.cipherSpec + "/" + this.cipherMode;
        }
        if (null != this.padding) {
            if (null == this.cipherMode) {
                this.cipherSpec = this.cipherSpec + "/";
            }
            this.cipherSpec = this.cipherSpec + "/" + this.padding;
        }
        String tblKey = null;
        tblKey = true == this.algorithmPassedSeparately ? this.algorithm : this.cipherSpec;
        if (null != this.theProvider) {
            tblObject = AlgorithmTable.getStateData(serviceType, tblKey);
            tblObject.invalidateProvider(this.theProvider);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
        }
        this.theCipher = null;
        boolean externalCall = false;
        boolean inRecovery = true;
        switch (this.initMethod) {
            case 1: {
                try {
                    this.init(this.opmode, this.key, this.random, externalCall, inRecovery);
                    break;
                }
                catch (IBMJCEHybridException ijhe) {
                    throw ijhe;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", ex.getMessage());
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
                    IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", ijheMsg);
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", (Throwable)ijhe);
                        debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher");
                    }
                    throw ijhe;
                }
            }
            case 2: {
                try {
                    this.init(this.opmode, this.key, this.params, this.random, externalCall, inRecovery);
                    break;
                }
                catch (IBMJCEHybridException ijhe) {
                    throw ijhe;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", ex.getMessage());
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
                    IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", ijheMsg);
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", (Throwable)ijhe);
                        debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher");
                    }
                    throw ijhe;
                }
            }
            case 3: {
                try {
                    this.init(this.opmode, this.key, this.paramspec, this.random, externalCall, inRecovery);
                    break;
                }
                catch (IBMJCEHybridException ijhe) {
                    throw ijhe;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", ex.getMessage());
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
                    IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", ijheMsg);
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", (Throwable)ijhe);
                        debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher");
                    }
                    throw ijhe;
                }
            }
            default: {
                IllegalArgumentException ex = new IllegalArgumentException("Internal error");
                this.ExceptionHistory.addElement(ex);
                String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
                IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", ijheMsg);
                    debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher", (Throwable)ijhe);
                    debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher");
                }
                throw ijhe;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "reInitCipher");
        }
    }

    private Cipher getBestInstance() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", (Object)this.cipherSpec);
        }
        String tblKey = null;
        tblKey = true == this.algorithmPassedSeparately ? this.algorithm : this.cipherSpec;
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", new String("tblKey = " + tblKey + "  cipherSpec = " + this.cipherSpec));
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, tblKey))) {
            String ijheMessage = new String("Cipher." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theCipher = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", "Top of loop 1");
            }
            while (notDone && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theCipher = Cipher.getInstance(this.cipherSpec, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", (Throwable)ex);
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", "Exception thrown on Cipher.getInstance(" + this.cipherSpec + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for Cipher " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (!notDone) continue;
            if (this.tableObjectReset) {
                if (!this.algorithmPassedSeparately) {
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", "No cipher obtained from providers registered for " + this.cipherSpec + ". \n\tRetrying with providers registered for " + this.algorithm);
                    }
                    this.algorithmPassedSeparately = true;
                    this.tableObjectReset = false;
                    tblKey = this.algorithm;
                    tblObj = AlgorithmTable.getStateData(serviceType, tblKey);
                    continue;
                }
                if (this.firstProvider) {
                    String ijheMessage = new String("No provider found for Cipher " + this.algorithm);
                    IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
                    if (debug != null) {
                        debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", ijheMessage);
                        debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", (Throwable)ijhe);
                        debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance");
                    }
                    throw ijhe;
                }
                String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
                IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", ijheMsg);
                    debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", (Throwable)ijhe);
                    debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance");
                }
                throw ijhe;
            }
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", "Calling tblObj.doReset() for Cipher," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theCipher) {
            this.firstProvider = false;
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", "Cipher " + this.cipherSpec + " obtained from provider: " + this.theProvider);
            }
        } else {
            if (this.firstProvider) {
                String ijheMessage = new String("No provider found for Cipher " + this.algorithm);
                IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
                if (debug != null) {
                    debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", ijheMessage);
                    debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", (Throwable)ijhe);
                    debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance");
                }
                throw new RuntimeException(ijhe);
            }
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "getBestInstance", (Object)this.theCipher);
        }
        return this.theCipher;
    }

    private Key unwravelKey(HybridRACFPrivateKey key) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "unwravelKey", (Object)key);
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "unwravelKey", "Provider is: " + this.theProvider);
        }
        if (this.theProvider.equalsIgnoreCase("IBMJCECCA")) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "unwravelKey", "Unwraveled to a hardware key.");
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "unwravelKey");
            }
            return key.getIBMJCECCAPrivateKey();
        }
        if (debug != null) {
            debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "unwravelKey", "Unwraveled to a software key.");
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridCipher", "unwravelKey");
        }
        return key.getIBMJCEPrivateKey();
    }
}

