/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.crypto.NoSuchPaddingException;

abstract class HybridCertificateFactory
extends CertificateFactorySpi {
    private CertificateFactory theFactory;
    private static final String serviceType = "CertificateFactory";
    private String algorithm;
    private String theProvider = null;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridCertificateFactory";

    public HybridCertificateFactory(String algorithm) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridCertificateFactory", (Object)algorithm);
        }
        this.algorithm = algorithm;
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridCertificateFactory", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridCertificateFactory", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridCertificateFactory");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getFactory();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridCertificateFactory", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridCertificateFactory", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for CertificateFactory " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridCertificateFactory", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridCertificateFactory", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridCertificateFactory");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridCertificateFactory");
        }
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream is) throws CertificateException {
        Certificate result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGenerateCertificate", (Object)is);
        }
        result = this.generateCertificate(is, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGenerateCertificate", (Object)result);
        }
        return result;
    }

    private Certificate generateCertificate(InputStream is, boolean isExternalCall) throws CertificateException {
        Certificate result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateCertificate", (Object)is, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.generateCertificate(is);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCertificate", "Successful call to generateCertificate(inputStream) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCertificate", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generateCertificate", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.generateCertificate(is, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateCertificate", (Object)result);
        }
        return result;
    }

    @Override
    public Collection<? extends Certificate> engineGenerateCertificates(InputStream is) throws CertificateException {
        Collection<? extends Certificate> result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGenerateCertificates", (Object)is);
        }
        result = this.generateCertificates(is, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGenerateCertificates", result);
        }
        return result;
    }

    private Collection<? extends Certificate> generateCertificates(InputStream is, boolean isExternalCall) throws CertificateException {
        Collection<? extends Certificate> result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateCertificates", (Object)is, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.generateCertificates(is);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCertificates", "Successful call to generateCertificates(inputStream) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCertificates", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generateCertificates", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.generateCertificates(is, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateCertificates", result);
        }
        return result;
    }

    @Override
    public CRL engineGenerateCRL(InputStream is) throws CRLException {
        CRL result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGenerateCRL", (Object)is);
        }
        result = this.generateCRL(is, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGenerateCRL", (Object)result);
        }
        return result;
    }

    private CRL generateCRL(InputStream is, boolean isExternalCall) throws CRLException {
        CRL result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateCRL", (Object)is, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.generateCRL(is);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCRL", "Successful call to generateCRL(inputStream) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCRL", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generateCRL", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.generateCRL(is, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateCRL", (Object)result);
        }
        return result;
    }

    @Override
    public Collection<? extends CRL> engineGenerateCRLs(InputStream is) throws CRLException {
        Collection<? extends CRL> result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGenerateCRLs", (Object)is);
        }
        result = this.generateCRLs(is, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGenerateCRLs", result);
        }
        return result;
    }

    private Collection<? extends CRL> generateCRLs(InputStream is, boolean isExternalCall) throws CRLException {
        Collection<? extends CRL> result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateCRLs", (Object)is, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.generateCRLs(is);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCRLs", "Successful call to generateCRLs(inputStream) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCRLs", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generateCRLs", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.generateCRLs(is, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateCRLs", result);
        }
        return result;
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream is) throws CertificateException {
        CertPath result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGenerateCertPath", (Object)is);
        }
        result = this.generateCertPath(is, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGenerateCertPath", (Object)result);
        }
        return result;
    }

    private CertPath generateCertPath(InputStream is, boolean isExternalCall) throws CertificateException {
        CertPath result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateCertPath", (Object)is, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.generateCertPath(is);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCertPath", "Successful call to generateCertPath(inputStream) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCertPath", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generateCertPath", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.generateCertPath(is, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateCertPath", (Object)result);
        }
        return result;
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        CertPath result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGenerateCertPath ", (Object)inStream, (Object)encoding);
        }
        result = this.generateCertPath(inStream, encoding, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGenerateCertPath", (Object)result);
        }
        return result;
    }

    private CertPath generateCertPath(InputStream inStream, String encoding, boolean isExternalCall) throws CertificateException {
        CertPath result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateCertPath ", (Object)new String("inStream=" + inStream + "  encoding=" + encoding + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.generateCertPath(inStream, encoding);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCertPath", "Successful call to generateCertPath(inputStream,encoding) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCertPath", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generateCertPath", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.generateCertPath(inStream, encoding, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateCertPath", (Object)result);
        }
        return result;
    }

    @Override
    public CertPath engineGenerateCertPath(List<? extends Certificate> certificates) throws CertificateException {
        CertPath result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGenerateCertPath ", certificates);
        }
        result = this.generateCertPath(certificates, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGenerateCertPath", (Object)result);
        }
        return result;
    }

    private CertPath generateCertPath(List<? extends Certificate> certificates, boolean isExternalCall) throws CertificateException {
        CertPath result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateCertPath ", certificates, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.generateCertPath(certificates);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCertPath", "Successful call to generateCertPath(certificateList) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateCertPath", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generateCertPath", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.generateCertPath(certificates, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateCertPath", (Object)result);
        }
        return result;
    }

    @Override
    public Iterator<String> engineGetCertPathEncodings() {
        Iterator<String> result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGetCertPathEncodings");
        }
        result = this.getCertPathEncodings(true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGetCertPathEncodings", result);
        }
        return result;
    }

    private Iterator<String> getCertPathEncodings(boolean isExternalCall) {
        Iterator<String> result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getCertPathEncodings", (Object)isExternalCall);
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.getCertPathEncodings();
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getCertPathEncodings", "Successful call to getCertPathEncodings() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getCertPathEncodings", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getCertPathEncodings", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.getCertPathEncodings(false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getCertPathEncodings", result);
        }
        return result;
    }

    private void getFactory() {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getFactory", (Object)this.algorithm);
        }
        if (null != this.theFactory) {
            TableObject tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm);
            tblObj.invalidateProvider(this.theFactory.getProvider().getName());
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getFactory", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
        }
        try {
            this.theFactory = this.getBestInstance();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getFactory", e.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getFactory", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getFactory", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getFactory", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getFactory");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getFactory");
        }
    }

    private CertificateFactory getBestInstance() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getBestInstance", (Object)this.algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("CertificateFactory." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theFactory = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 1");
            }
            while (null == this.theFactory && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theFactory = CertificateFactory.getInstance(this.algorithm, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Exception thrown on CertificateFactory.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for CertificateFactory " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theFactory) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.doReset() for CertificateFactory," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theFactory) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "CertificateFactory " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
        }
        return this.theFactory;
    }
}

