/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Vector;
import javax.crypto.NoSuchPaddingException;

abstract class HybridAlgorithmParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private AlgorithmParameterGenerator theGenerator = null;
    private AlgorithmParameterSpec paramSpec = null;
    private int size = 0;
    private SecureRandom random = null;
    private static final String serviceType = "AlgorithmParameterGenerator";
    private String algorithm = null;
    private String theProvider = null;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridAlgorithmParameterGenerator";

    public HybridAlgorithmParameterGenerator(String algorithm) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator", (Object)algorithm);
        }
        this.algorithm = algorithm;
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getGenerator();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for AlgorithmParameterGenerator " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator");
        }
    }

    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInit", (Object)paramSpec);
        }
        this.paramSpec = paramSpec;
        this.size = -1;
        this.random = null;
        this.engineInit(this.paramSpec, (SecureRandom)null);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInit");
        }
    }

    protected void engineInit(int size) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInit", (Object)size);
        }
        this.paramSpec = null;
        this.size = size;
        this.random = null;
        this.engineInit(this.size, (SecureRandom)null);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInit");
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec, SecureRandom random) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInit", (Object)paramSpec, (Object)random);
        }
        this.paramSpec = paramSpec;
        this.random = random;
        this.size = -1;
        this.init(this.paramSpec, this.random, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInit");
        }
    }

    private void init(AlgorithmParameterSpec paramSpec, SecureRandom random, boolean isExternalCall) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "init", (Object)new String("paramSpec=" + paramSpec + "  random=" + random + "  isExternalCall=" + isExternalCall));
        }
        this.paramSpec = paramSpec;
        this.random = random;
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            this.theGenerator.init(paramSpec, random);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", "Successful call to init(paramSpec) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getGenerator();
            this.init(paramSpec, random, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "init");
        }
    }

    @Override
    protected void engineInit(int size, SecureRandom random) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInit", (Object)size, (Object)random);
        }
        this.paramSpec = null;
        this.random = random;
        this.size = size;
        this.init(size, random, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInit");
        }
    }

    private void init(int size, SecureRandom random, boolean isExternalCall) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "init", (Object)new String("size=" + size + "  random=" + random + "  isExternalCall=" + isExternalCall));
        }
        this.size = size;
        this.random = random;
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            this.theGenerator.init(size, random);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", "Successful call to init(size) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getGenerator();
            this.init(size, random, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "init");
        }
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters theParms = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGenerateParameters", (Object)this.algorithm);
        }
        theParms = this.generateParameters(true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGenerateParameters");
        }
        return theParms;
    }

    private AlgorithmParameters generateParameters(boolean isExternalCall) {
        AlgorithmParameters theParms = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateParameters", (Object)new String("isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            theParms = this.theGenerator.generateParameters();
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateParameters", "Successful call to generateParameters() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateParameters", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generateParameters", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getGenerator();
            if (null != this.paramSpec) {
                this.init(this.paramSpec, this.random, false);
            } else if (-1 < this.size) {
                this.init(this.size, this.random, false);
            }
            theParms = this.generateParameters(false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateParameters");
        }
        return theParms;
    }

    private void getGenerator() {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getGenerator", (Object)this.algorithm);
        }
        if (null != this.theGenerator) {
            TableObject tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm);
            tblObj.invalidateProvider(this.theGenerator.getProvider().getName());
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
        }
        try {
            this.theGenerator = this.getBestInstance();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", e.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getGenerator", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getGenerator", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getGenerator");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getGenerator");
        }
    }

    private AlgorithmParameterGenerator getBestInstance() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getBestInstance", (Object)this.algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("AlgorithmParameterGenerator." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theGenerator = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 1");
            }
            while (null == this.theGenerator && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theGenerator = AlgorithmParameterGenerator.getInstance(this.algorithm, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Exception thrown on AlgorithmParameterGenerator.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for AlgorithmParameterGenerator " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theGenerator) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.doReset() for AlgorithmParameterGenerator," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theGenerator) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "AlgorithmParameters for " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
        }
        return this.theGenerator;
    }
}

