/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

public class AlgorithmTable {
    private static final String SECURERANDOMSVC = new String("SecureRandom");
    private static final String SIGNATURESVC = new String("Signature");
    private static final String CIPHERSVC = new String("Cipher");
    private static final String KEYGENERATORSVC = new String("KeyGenerator");
    private static final String KEYPAIRGENERATORSVC = new String("KeyPairGenerator");
    private static final String MESSAGEDIGESTSVC = new String("MessageDigest");
    private static final String ALGORITHMPARAMETERGENERATORSVC = new String("AlgorithmParameterGenerator");
    private static final String KEYAGREEMENTSVC = new String("KeyAgreement");
    private static final String ALGORITHMPARAMETERSSVC = new String("AlgorithmParameters");
    private static final String KEYFACTORYSVC = new String("KeyFactory");
    private static final String SECRETKEYFACTORYSVC = new String("SecretKeyFactory");
    private static final String MACSVC = new String("Mac");
    private static final String CERTIFICATEFACTORYSVC = new String("CertificateFactory");
    private static final String KEYSTORESVC = new String("KeyStore");
    private static Hashtable algorithms = new Hashtable();
    private static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String className = "com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable";
    private static boolean isInitialized = false;

    public AlgorithmTable() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AlgorithmTable");
        }
        if (!isInitialized) {
            AlgorithmTable.tableInitAll();
            isInitialized = true;
            if (debug != null) {
                debug.text(16384L, (Object)className, "AlgorithmTable", "\nAlgorithm table after initialization:\n" + this.toString());
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "AlgorithmTable");
        }
    }

    public static TableObject getStateData(String svcType, String algorithm) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getStateData", (Object)svcType, (Object)algorithm);
        }
        TableObject data = (TableObject)algorithms.get(svcType.toUpperCase() + "." + algorithm.toUpperCase());
        if (debug != null) {
            if (null == data) {
                debug.exit(16384L, (Object)className, "getStateData", (Object)new String("returning null TableObject as state data for " + svcType + "." + algorithm));
            } else {
                debug.exit(16384L, (Object)className, "getStateData", (Object)data.toString());
            }
        }
        return data;
    }

    private static final void tableInitAll() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "tableInitAll");
        }
        AlgorithmTable.tableInit(SECURERANDOMSVC);
        AlgorithmTable.tableInit(SIGNATURESVC);
        AlgorithmTable.tableInit(CIPHERSVC);
        AlgorithmTable.tableInit(KEYGENERATORSVC);
        AlgorithmTable.tableInit(KEYPAIRGENERATORSVC);
        AlgorithmTable.tableInit(MESSAGEDIGESTSVC);
        AlgorithmTable.tableInit(ALGORITHMPARAMETERGENERATORSVC);
        AlgorithmTable.tableInit(KEYAGREEMENTSVC);
        AlgorithmTable.tableInit(ALGORITHMPARAMETERSSVC);
        AlgorithmTable.tableInit(KEYFACTORYSVC);
        AlgorithmTable.tableInit(SECRETKEYFACTORYSVC);
        AlgorithmTable.tableInit(MACSVC);
        AlgorithmTable.tableInit(CERTIFICATEFACTORYSVC);
        AlgorithmTable.tableInit(KEYSTORESVC);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "tableInitAll");
        }
    }

    private static final void tableInit(String serviceType) {
        block8: {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "tableInit", (Object)serviceType);
            }
            try {
                Set<String> algs = Security.getAlgorithms(serviceType);
                for (String thisAlgorithm : algs) {
                    thisAlgorithm = thisAlgorithm.toUpperCase();
                    HashMap<String, String> filter = new HashMap<String, String>();
                    filter.put(new String(serviceType + "." + thisAlgorithm), "");
                    Provider[] providerArray = Security.getProviders(filter);
                    if (null == providerArray || 0 >= providerArray.length) {
                        if (debug == null) continue;
                        debug.entry(16384L, (Object)className, "tableInit", (Object)new String(serviceType + "." + thisAlgorithm + ": providerArray is NULL"));
                        continue;
                    }
                    if (debug != null) {
                        debug.entry(16384L, (Object)className, "tableInit", (Object)new String(serviceType + "." + thisAlgorithm + ": providerArray.length = " + providerArray.length));
                    }
                    List<Provider> providerList = Collections.synchronizedList(new ArrayList());
                    for (int idx = 0; idx < providerArray.length; ++idx) {
                        providerList.add(providerArray[idx]);
                    }
                    TableObject entry = new TableObject(serviceType + "." + thisAlgorithm, providerList);
                    algorithms.put(serviceType.toUpperCase() + "." + thisAlgorithm.toUpperCase(), entry);
                }
            }
            catch (Exception ex) {
                if (debug == null) break block8;
                debug.exception(8192L, (Object)className, "tableInit", (Throwable)ex);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "tableInit");
        }
    }

    public String toString() {
        String result = "";
        Enumeration e = algorithms.keys();
        while (e.hasMoreElements()) {
            String algorithm = (String)e.nextElement();
            result = result + "\nAlgorithm: " + algorithm + "\n";
            result = result + "Value: " + algorithms.get(algorithm) + "\n";
        }
        return result;
    }
}

