/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.fmt;

import com.ibm.crypto.provider.PBMParameterSpec;
import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkAttr;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConfRepEvent;
import com.ibm.security.certclient.base.PkConfReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkEvent;
import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkGnrlRepEvent;
import com.ibm.security.certclient.base.PkGnrlReqEvent;
import com.ibm.security.certclient.base.PkInitRepEvent;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkIoException;
import com.ibm.security.certclient.base.PkKrecRepEvent;
import com.ibm.security.certclient.base.PkKrecReqEvent;
import com.ibm.security.certclient.base.PkKupdRepEvent;
import com.ibm.security.certclient.base.PkKupdReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.base.PkRevoRepEvent;
import com.ibm.security.certclient.base.PkRevoReqEvent;
import com.ibm.security.certclient.base.PkSecnRepEvent;
import com.ibm.security.certclient.base.PkSecnReqEvent;
import com.ibm.security.certclient.base.PkXcerRepEvent;
import com.ibm.security.certclient.base.PkXcerReqEvent;
import com.ibm.security.certclient.util.PkArray;
import com.ibm.security.certclient.util.PkString;
import com.ibm.security.cmp.CertOrEncCert;
import com.ibm.security.cmp.CertRepMessage;
import com.ibm.security.cmp.CertResponse;
import com.ibm.security.cmp.CertifiedKeyPair;
import com.ibm.security.cmp.ErrorMsgContent;
import com.ibm.security.cmp.InfoTypeAndValue;
import com.ibm.security.cmp.PKIBody;
import com.ibm.security.cmp.PKIFreeText;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.cmp.PKIStatusInfo;
import com.ibm.security.cmp.RevDetails;
import com.ibm.security.cmp.RevDetailsv2;
import com.ibm.security.cmp.RevPassphraseInfoValue;
import com.ibm.security.cmp.RevRepContent;
import com.ibm.security.cmp.RevReqContent;
import com.ibm.security.cmp.RevReqContentv2;
import com.ibm.security.crmf.CertReqMessages;
import com.ibm.security.crmf.CertReqMsg;
import com.ibm.security.crmf.CertRequest;
import com.ibm.security.crmf.CertTemplate;
import com.ibm.security.crmf.EncryptedValue;
import com.ibm.security.crmf.OptionalValidity;
import com.ibm.security.crmf.PKIPublicationInfo;
import com.ibm.security.crmf.POPOPrivKey;
import com.ibm.security.crmf.POPOSigningKey;
import com.ibm.security.crmf.ProofOfPossession;
import com.ibm.security.crmf.SinglePubInfo;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CRLExtensions;
import com.ibm.security.x509.CRLReasonCodeExtension;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.ReasonFlags;
import com.ibm.security.x509.UniqueIdentity;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PkCmpEventFormatter
extends PkEventFormatter
implements PkConstants {
    private static final String sccsid = "%Z% %M% %I%    %W% %G% %U%";
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static Object className = "com.ibm.security.certclient.fmt.PkCmpEventFormatter";
    private static final PKIStatusInfo statusOk = new PKIStatusInfo(0, null, null);
    private static ObjectIdentifier TPKI_ENROLL_OID = PkCmpEventFormatter.getOID();
    private static final int MESSAGE_BODY_CERTCONF = 24;
    private static final Map<Class, Integer> types = new HashMap<Class, Integer>();
    private BigInteger certReqId = BigInteger.valueOf(0L);
    private final String SIG_PROBS = "Problems signing. Change the exception being thrown";

    private static final ObjectIdentifier getOID() {
        try {
            return new ObjectIdentifier("1.3.6.1.4.1.2.13.5.7.1.3");
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(4L, className, "getOID", (Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public PkEvent readEvent(Object object, InputStream inputStream, PkReqEvent pkReqEvent) throws PkException, IOException {
        PkEvent pkEvent;
        block49: {
            boolean bl;
            PKIHeader pKIHeader;
            Object object2;
            PKIMessage pKIMessage;
            block48: {
                pKIMessage = new PKIMessage(new DerValue(inputStream).toByteArray());
                object2 = pKIMessage.getBody();
                if (debug != null) {
                    debug.text(0L, className, "readEvent", "msg is {0}", (Object)pKIMessage.toString());
                }
                if (debug != null) {
                    debug.text(0L, className, "readEvent", "msg body type is {0}", (Object)new Integer(pKIMessage.getBodyType()));
                }
                pKIHeader = pKIMessage.getHeader();
                if (debug != null) {
                    debug.text(0L, className, "readEvent", "#####  sender kid is msg body type is {0}", (Object)pKIHeader.getSenderKID());
                }
                bl = pKIMessage.getProtection() != null;
                boolean bl2 = pKIHeader.getPvno().equals(BIG_ONE);
                if (debug != null) {
                    debug.text(0L, className, "readEvent", " isCmpV1 is {0}", (Object)new Boolean(bl2).toString());
                }
                if (pKIMessage.getBodyType() != 0 && pKIMessage.getBodyType() != 11 && pKIMessage.getBodyType() != 12 && pKIMessage.getBodyType() != 24 && !bl2) {
                    if (debug != null) {
                        debug.text(0L, className, "readEvent", " reset CMP version to 1 ");
                    }
                    bl2 = true;
                }
                if (!bl2) break block48;
                switch (pKIMessage.getBodyType()) {
                    case 0: {
                        PkAttrs pkAttrs = PkCmpEventFormatter.getAttrsFromCertReqMessages((CertReqMessages)object2);
                        pkAttrs.add("cert.oper.messageProtected", 2, new Boolean(bl));
                        pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, pKIHeader.getSenderKID());
                        pkAttrs.add("cert.oper.RECIPIENT_DN", 2, pKIHeader.getRecipient());
                        pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
                        pkAttrs.add("cert.oper.CMP_VERSION", 2, BIG_ONE);
                        pkEvent = new PkInitReqEvent(object, pKIMessage, pkAttrs);
                        break block49;
                    }
                    case 1: {
                        PrivateKey privateKey = (PrivateKey)pkReqEvent.getAttrs().getValue("cert.oper.privateKeyEE", null);
                        X509CertImpl x509CertImpl = this.getCert((CertRepMessage)object2, privateKey);
                        if (x509CertImpl == null) {
                            pkReqEvent.getAttrs().add("PASSTHRU", 2, Boolean.TRUE);
                            if (debug != null) {
                                debug.text(0L, className, "readEvent", "passThru set to true");
                            }
                        }
                        pkReqEvent.getAttrs().add("cert.oper.responseHeader", 2, pKIHeader);
                        pkEvent = new PkInitRepEvent(object, pKIMessage, pkReqEvent, (Certificate)x509CertImpl);
                        break block49;
                    }
                    case 2: {
                        PkAttrs pkAttrs = PkCmpEventFormatter.getAttrsFromCertReqMessages((CertReqMessages)object2);
                        pkAttrs.add("cert.oper.messageProtected", 2, new Boolean(bl));
                        pkAttrs.add("TMP_MSG_HDR", 2, pKIHeader);
                        pkAttrs.add("cert.oper.responseHeader", 2, pKIHeader);
                        pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, pKIHeader.getSenderKID());
                        pkAttrs.add("cert.oper.RECIPIENT_DN", 2, pKIHeader.getRecipient());
                        pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
                        pkEvent = new PkSecnReqEvent(object, pKIMessage, pkAttrs);
                        break block49;
                    }
                    case 3: {
                        PrivateKey privateKey = (PrivateKey)pkReqEvent.getAttrs().getValue("cert.oper.privateKeyEE", null);
                        X509CertImpl x509CertImpl = this.getCert((CertRepMessage)object2, privateKey);
                        pkReqEvent.getAttrs().repOrAdd("cert.oper.responseHeader", 2, pKIHeader);
                        if (x509CertImpl == null) {
                            pkReqEvent.getAttrs().add("PASSTHRU", 2, Boolean.TRUE);
                            if (debug != null) {
                                debug.text(0L, className, "readEvent", "passThru set to true");
                            }
                        } else if (debug != null) {
                            debug.text(0L, className, "readEvent", "passThru set to false as private key available");
                        }
                        pkEvent = new PkSecnRepEvent(object, pKIMessage, pkReqEvent, (Certificate)x509CertImpl);
                        break block49;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        throw new UnsupportedOperationException(PkNLSConstants.CMPEVENT_UNSUPPORTED_EVENT + pKIMessage.getBodyType());
                    }
                    case 7: {
                        pkEvent = new PkKupdReqEvent(object, pKIMessage, PkCmpEventFormatter.getAttrsFromCertReqMessages((CertReqMessages)object2));
                        break block49;
                    }
                    case 8: {
                        pkEvent = new PkKupdRepEvent(object, pKIMessage, pkReqEvent, (Certificate)this.getCert((CertRepMessage)object2, null));
                        break block49;
                    }
                    case 9: {
                        pkEvent = new PkKrecReqEvent(object, pKIMessage, null);
                        break block49;
                    }
                    case 10: {
                        pkEvent = new PkKrecRepEvent(object, pKIMessage, pkReqEvent);
                        break block49;
                    }
                    case 11: {
                        PkAttrs pkAttrs = PkCmpEventFormatter.getAttrsFromRevReqContent((RevReqContent)object2);
                        if (pkAttrs.getValue("x509.info.key", null) != null) {
                            pkAttrs.add("x509.info.certrevopublickey", 2, pkAttrs.getValue("x509.info.key"));
                        }
                        pkAttrs.add("TMP_MSG_HDR", 2, pKIHeader);
                        pkAttrs.add("cert.oper.messageProtected", 2, new Boolean(bl));
                        if (debug != null) {
                            debug.text(0L, className, "readEvent", "case-rr, msgProtected is {0}", (Object)new Boolean(bl));
                        }
                        if (bl) {
                            pkAttrs.add("PASSTHRU", 2, Boolean.TRUE);
                        }
                        pkAttrs.add("x509.info.algorithmID", 2, pKIHeader.getProtectionAlg());
                        pkAttrs.add("cert.oper.CMP_VERSION", 2, BIG_ONE);
                        pkAttrs.add("cert.oper.certRevocationPassphrase", 2, pKIHeader.getGeneralInfo());
                        pkEvent = new PkRevoReqEvent(object, pKIMessage, pkAttrs);
                        break block49;
                    }
                    case 12: {
                        pkEvent = new PkRevoRepEvent(object, pKIMessage, pkReqEvent);
                        break block49;
                    }
                    case 13: {
                        PkAttrs pkAttrs = PkCmpEventFormatter.getAttrsFromCertReqMessages((CertReqMessages)object2);
                        pkAttrs.add("cert.oper.RECIPIENT_DN", 2, pKIHeader.getRecipient());
                        pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, pKIHeader.getSenderKID());
                        pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
                        pkAttrs.add("cert.oper.CMP_VERSION", 2, BIG_ONE);
                        pkEvent = new PkXcerReqEvent(object, pKIMessage, pkAttrs);
                        break block49;
                    }
                    case 14: {
                        pkReqEvent.getAttrs().add("cert.oper.responseHeader", 2, pKIHeader);
                        pkEvent = new PkXcerRepEvent(object, pKIMessage, pkReqEvent, (Certificate)this.getCert((CertRepMessage)object2, null));
                        break block49;
                    }
                    case 19: {
                        if (debug != null) {
                            debug.text(0L, className, "readEvent", "######### from message_body_conf, msg is {0}", (Object)pKIMessage);
                        }
                        PkAttrs pkAttrs = new PkAttrs();
                        PkCmpEventFormatter.add(pkAttrs, "HDR", pKIMessage.getHeader());
                        pkAttrs.add("cert.oper.certRevocationPassphrase", 2, pKIHeader.getGeneralInfo());
                        pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, pKIHeader.getSenderKID());
                        pkEvent = new PkConfReqEvent(object, pKIMessage, pkAttrs);
                        if (debug != null) {
                            debug.text(0L, className, "readEvent", "########## the confReqEvent is {0}", (Object)pkEvent);
                        }
                        break block49;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 20: {
                        throw new UnsupportedOperationException(PkNLSConstants.CMPEVENT_UNSUPPORTED_EVENT + pKIMessage.getBodyType());
                    }
                    case 21: {
                        pkEvent = new PkGnrlReqEvent(object, pKIMessage, null);
                        break block49;
                    }
                    case 22: {
                        pkEvent = new PkGnrlRepEvent(object, pKIMessage, pkReqEvent);
                        break block49;
                    }
                    case 23: {
                        if (debug != null) {
                            debug.text(0L, className, "readEvent", "############ MESSAGE_BODY_ERROR... body ={0} ", object2);
                        }
                        this.throwException((ErrorMsgContent)object2);
                        pkEvent = null;
                        break block49;
                    }
                    default: {
                        throw new PkIoException(PkNLSConstants.CMPEVENT_INVALID_PKI_MESSAGE_TAG + pKIMessage.getBodyType());
                    }
                }
            }
            switch (pKIMessage.getBodyType()) {
                case 0: {
                    PkAttrs pkAttrs = PkCmpEventFormatter.getAttrsFromCertReqMessages((CertReqMessages)object2);
                    pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, pKIHeader.getSenderKID());
                    pkAttrs.add("cert.oper.RECIPIENT_DN", 2, pKIHeader.getRecipient());
                    pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
                    pkAttrs.add("cert.oper.CMP_VERSION", 2, BIG_TWO);
                    pkEvent = new PkInitReqEvent(object, pKIMessage, pkAttrs);
                    break;
                }
                case 1: {
                    PrivateKey privateKey = (PrivateKey)pkReqEvent.getAttrs().getValue("cert.oper.privateKeyEE", null);
                    X509CertImpl x509CertImpl = this.getCert((CertRepMessage)object2, privateKey);
                    if (x509CertImpl == null) {
                        pkReqEvent.getAttrs().add("PASSTHRU", 2, Boolean.TRUE);
                        if (debug != null) {
                            debug.text(0L, className, "readEvent", "passThru set to true");
                        }
                    }
                    pkReqEvent.getAttrs().add("cert.oper.responseHeader", 2, pKIHeader);
                    pkReqEvent.getAttrs().add("cert.oper.CMP_VERSION", 2, BIG_TWO);
                    pkEvent = new PkInitRepEvent(object, pKIMessage, pkReqEvent, (Certificate)x509CertImpl);
                    break;
                }
                case 11: {
                    PkAttrs pkAttrs = PkCmpEventFormatter.getAttrsFromRevReqContent((RevReqContentv2)object2);
                    pkAttrs.add("TMP_MSG_HDR", 2, pKIHeader);
                    pkAttrs.add("cert.oper.messageProtected", 2, new Boolean(bl));
                    pkAttrs.add("x509.info.algorithmID", 2, pKIHeader.getProtectionAlg());
                    pkAttrs.add("cert.oper.CMP_VERSION", 2, BIG_TWO);
                    pkEvent = new PkRevoReqEvent(object, pKIMessage, pkAttrs);
                    break;
                }
                case 12: {
                    PkAttrs pkAttrs = pkReqEvent.getAttrs();
                    pkAttrs.add("cert.oper.CMP_VERSION", 2, BIG_TWO);
                    pkAttrs.add("cert.oper.responseHeader", 2, pKIHeader);
                    pkAttrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
                    pkEvent = new PkRevoRepEvent(object, pKIMessage, pkReqEvent);
                    break;
                }
                case 24: {
                    if (debug != null) {
                        debug.text(0L, className, "readEvent", "from message_body_conf -v2, msg is {0}", (Object)pKIMessage);
                    }
                    PkAttrs pkAttrs = new PkAttrs();
                    pkAttrs.add("cert.oper.CMP_VERSION", 2, BIG_TWO);
                    PkCmpEventFormatter.add(pkAttrs, "HDR", pKIMessage.getHeader());
                    pkAttrs.add("cert.oper.certRevocationPassphrase", 2, pKIHeader.getGeneralInfo());
                    pkAttrs.add("cert.oper.SenderKeyIdentifier", 2, pKIHeader.getSenderKID());
                    pkEvent = new PkConfReqEvent(object, pKIMessage, pkAttrs);
                    if (debug == null) break;
                    debug.text(0L, className, "readEvent", "########## the confReqEvent is {0}", (Object)pkEvent);
                    break;
                }
                default: {
                    throw new PkIoException(PkNLSConstants.CMPEVENT_INVALID_PKI_MESSAGE_TAG + pKIMessage.getBodyType());
                }
            }
        }
        return pkEvent;
    }

    @Override
    public void writeException(Exception exception, OutputStream outputStream) throws IOException {
        Throwable throwable;
        Object object;
        boolean[] blArray = null;
        PKIFreeText pKIFreeText = null;
        ErrorMsgContent errorMsgContent = null;
        if (exception.getMessage() != null) {
            object = new String(exception.getMessage().getBytes("UTF-8"), "UTF-8");
            if (debug != null) {
                debug.text(0L, className, "writeException..", "emsg is {0}", object);
            }
            pKIFreeText = new PKIFreeText(new String[]{object});
        } else if (exception instanceof PkException && ((PkException)(object = (PkException)exception)).hasWrappedException() && (throwable = ((PkException)object).getWrappedException()).getMessage() != null) {
            pKIFreeText = new PKIFreeText(new String[]{throwable.getMessage()});
        }
        if (exception instanceof PkRejectionException) {
            object = (PkRejectionException)exception;
            blArray = ((PkRejectionException)object).getFailureInfo();
        }
        object = new PKIStatusInfo(2, pKIFreeText, blArray);
        errorMsgContent = new ErrorMsgContent((PKIStatusInfo)object, null, null);
        throwable = new GeneralName((GeneralNameInterface)new X500Name(""));
        GeneralName generalName = new GeneralName((GeneralNameInterface)new X500Name(""));
        PKIHeader pKIHeader = new PKIHeader(BIG_ONE, (GeneralName)throwable, generalName, null, null, null, null, null, null, null, null, null);
        new PKIMessage(pKIHeader, 23, (Object)errorMsgContent, null, null).encode(outputStream);
    }

    private void throwException(ErrorMsgContent errorMsgContent) throws PkException {
        int n = errorMsgContent.getPKIStatusInfo().getStatus();
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                Object[] objectArray = new String[]{};
                PKIStatusInfo pKIStatusInfo = null;
                try {
                    pKIStatusInfo = errorMsgContent.getPKIStatusInfo();
                    objectArray = (String[])pKIStatusInfo.getStatusString().getFreeText().clone();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    objectArray = (String[])PkArray.append(objectArray, errorMsgContent.getErrorDetails().getFreeText());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                String string = PkString.join((String[])objectArray, "\n");
                if (pKIStatusInfo == null) {
                    throw new PkRejectionException(string);
                }
                throw new PkRejectionException(string, pKIStatusInfo.getFailureInfos());
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                String[] stringArray = errorMsgContent.getErrorDetails().getFreeText();
                String string = stringArray != null && stringArray.length > 0 ? stringArray[0] : "";
                throw new PkException(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCertReq(PkCertReqEvent pkCertReqEvent, OutputStream outputStream) throws IOException, PkException {
        BigInteger bigInteger;
        Object object = this;
        synchronized (object) {
            bigInteger = this.certReqId;
            this.certReqId = this.certReqId.add(BigInteger.ONE);
        }
        object = pkCertReqEvent.getAttrs();
        Boolean bl = (Boolean)pkCertReqEvent.getAttrs().getValue("cert.oper.messageProtected", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeCertReq", "messageProtected {0}", (Object)bl);
        }
        if (bl.booleanValue()) {
            PKIMessage pKIMessage = (PKIMessage)pkCertReqEvent.getMsg();
            pKIMessage.encode(outputStream);
        } else {
            POPOSigningKey pOPOSigningKey;
            AlgorithmId algorithmId;
            Object object2;
            Signature signature;
            PrivateKey privateKey;
            Object object3;
            String string;
            Date date;
            Date date2;
            InfoTypeAndValue[] infoTypeAndValueArray;
            GeneralName generalName;
            KeyIdentifier keyIdentifier;
            GeneralName generalName2;
            block27: {
                PublicKey publicKey;
                generalName2 = new GeneralName((GeneralNameInterface)((X500Name)((PkAttrs)object).getValue("x509.info.subject")));
                keyIdentifier = (KeyIdentifier)((PkAttrs)object).getValue("cert.oper.SenderKeyIdentifier");
                generalName = (GeneralName)((PkAttrs)object).getValue("cert.oper.RECIPIENT_DN");
                infoTypeAndValueArray = null;
                infoTypeAndValueArray = (InfoTypeAndValue[])((PkAttrs)object).getValue("cert.oper.certRevocationPassphrase", null);
                CertTemplate certTemplate = new CertTemplate();
                if (((PkAttrs)object).has("x509.info.validity.notBefore") || ((PkAttrs)object).has("x509.info.validity.notAfter")) {
                    date2 = (Date)((PkAttrs)object).getValue("x509.info.validity.notBefore", null);
                    date = (Date)((PkAttrs)object).getValue("x509.info.validity.notAfter", null);
                    certTemplate.setValidity(new OptionalValidity(date2, date));
                }
                PkCmpEventFormatter.addToTempl(certTemplate, (PkAttrs)object);
                date2 = new CertRequest(bigInteger, certTemplate, null);
                date = null;
                try {
                    publicKey = (PublicKey)((PkAttrs)object).getValue("x509.info.key");
                }
                catch (NoSuchElementException noSuchElementException) {
                    PkException pkException = new PkException(noSuchElementException);
                    if (debug != null) {
                        debug.text(0L, className, "writeCertReq", pkException.getMessage());
                    }
                    throw pkException;
                }
                publicKey = new DerOutputStream();
                date2.encode((OutputStream)((Object)publicKey));
                boolean bl2 = false;
                boolean bl3 = false;
                KeyUsageExtension keyUsageExtension = (KeyUsageExtension)((PkAttrs)object).getValue("x509.info.extensions.KeyUsage", null);
                boolean bl4 = true;
                boolean[] blArray = null;
                if (keyUsageExtension == null) {
                    bl4 = false;
                } else {
                    blArray = keyUsageExtension.getBits();
                    if (blArray.length == 0) {
                        bl4 = false;
                    }
                }
                string = (String)((PkAttrs)object).getValue("cert.oper.PROVIDER", null);
                if (string == null) {
                    PkRejectionException pkRejectionException = new PkRejectionException(PkNLSConstants.NEED_PROVIDER);
                    if (debug != null) {
                        debug.text(0L, className, "writeCertReq", pkRejectionException.getMessage());
                    }
                    throw pkRejectionException;
                }
                if (bl4) {
                    bl2 = blArray[0];
                }
                if (bl2 || !bl4) {
                    try {
                        object3 = null;
                        if (debug != null) {
                            debug.text(0L, className, "writeCertReq", "######## from PkCmpEventFormatter... digitalSignature");
                        }
                        privateKey = (PrivateKey)((PkAttrs)object).getValue("cert.oper.privateKey", null);
                        object3 = (String)((PkAttrs)object).getValue("x509.info.algorithmName", null);
                        if (privateKey != null) {
                            signature = Signature.getInstance((String)object3, string);
                            signature.initSign(privateKey);
                            signature.update(publicKey.toByteArray());
                            object2 = signature.sign();
                            algorithmId = (AlgorithmId)((PkAttrs)object).getValue("x509.info.algorithmID", null);
                            pOPOSigningKey = new POPOSigningKey(null, algorithmId, (byte[])object2);
                            date = new ProofOfPossession(1, (Object)pOPOSigningKey);
                        }
                        break block27;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        if (debug != null) {
                            debug.text(0L, className, "writeCertReq", generalSecurityException.getMessage());
                        }
                        break block27;
                    }
                }
                if (debug != null) {
                    debug.text(0L, className, "writeCertReq", "######## from PkCmpEventFormatter... encipherment");
                }
                object3 = new POPOPrivKey(1, (Object)new Integer(0));
                date = new ProofOfPossession(2, object3);
            }
            object3 = new CertReqMsg((CertRequest)date2, (ProofOfPossession)date, null);
            privateKey = new CertReqMessages(new CertReqMsg[]{object3});
            signature = this.generateProtectionAlg(string);
            object2 = (BigInteger)((PkAttrs)object).getValue("cert.oper.CMP_VERSION");
            algorithmId = new PKIHeader((BigInteger)object2, generalName2, generalName, new Date(), (AlgorithmId)signature, keyIdentifier, null, new Long(new Date().getTime()).toString().getBytes(), new Date().toString().getBytes(), null, null, infoTypeAndValueArray);
            if (debug != null) {
                debug.text(0L, className, "writeCertReq", "pkiHeader ={0} ", (Object)algorithmId);
            }
            pOPOSigningKey = new PKIMessage((PKIHeader)algorithmId, PkCmpEventFormatter.getBodyType(pkCertReqEvent), (Object)privateKey, null, null);
            Object object4 = null;
            try {
                String string2 = (String)((PkAttrs)object).getValue("x509.info.init_pwd");
                object4 = string2 != null ? pOPOSigningKey.protect(string2.getBytes()) : pOPOSigningKey;
            }
            catch (Exception exception) {
                PkException pkException = new PkException(exception);
                if (debug != null) {
                    debug.text(0L, className, "writeCertReq", pkException.getMessage());
                }
                throw pkException;
            }
            object4.encode(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSecnReq(PkSecnReqEvent pkSecnReqEvent, OutputStream outputStream) throws IOException, PkException {
        Boolean bl = (Boolean)pkSecnReqEvent.getAttrs().getValue("PASSTHRU", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeSecnReq", "passThru = {0}", (Object)bl);
        }
        Boolean bl2 = (Boolean)pkSecnReqEvent.getAttrs().getValue("cert.oper.messageProtected", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeSecnReq", "messageProtected {0}", (Object)bl2);
        }
        if (bl.booleanValue() || bl2.booleanValue()) {
            PKIMessage pKIMessage = (PKIMessage)pkSecnReqEvent.getMsg();
            pKIMessage.encode(outputStream);
        } else {
            String string;
            KeyIdentifier keyIdentifier;
            AlgorithmId algorithmId;
            Object object;
            Signature signature;
            Object object2;
            Object object3;
            Serializable serializable;
            Date date;
            BigInteger bigInteger;
            Object object4 = this;
            synchronized (object4) {
                bigInteger = this.certReqId;
                this.certReqId = this.certReqId.add(BigInteger.ONE);
            }
            object4 = pkSecnReqEvent.getAttrs();
            GeneralName generalName = new GeneralName((GeneralNameInterface)((X500Name)((PkAttrs)object4).getValue("x509.info.subject")));
            GeneralName generalName2 = (GeneralName)((PkAttrs)object4).getValue("cert.oper.RECIPIENT_DN");
            CertTemplate certTemplate = new CertTemplate();
            if (((PkAttrs)object4).has("x509.info.validity.notBefore") || ((PkAttrs)object4).has("x509.info.validity.notAfter")) {
                date = (Date)((PkAttrs)object4).getValue("x509.info.validity.notBefore", null);
                serializable = (Date)((PkAttrs)object4).getValue("x509.info.validity.notAfter", null);
                certTemplate.setValidity(new OptionalValidity(date, serializable));
            }
            PkCmpEventFormatter.addToTempl(certTemplate, (PkAttrs)object4);
            date = new CertRequest(bigInteger, certTemplate, null);
            try {
                serializable = (PublicKey)((PkAttrs)object4).getValue("x509.info.key");
            }
            catch (NoSuchElementException noSuchElementException) {
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", noSuchElementException.getMessage());
                }
                throw new PkException(noSuchElementException);
            }
            serializable = new DerOutputStream();
            date.encode((OutputStream)((Object)serializable));
            boolean bl3 = false;
            KeyUsageExtension keyUsageExtension = (KeyUsageExtension)((PkAttrs)object4).getValue("x509.info.extensions.KeyUsage", null);
            bl3 = keyUsageExtension != null ? (((boolean[])(object3 = keyUsageExtension.getBits())).length == 0 ? true : object3[0]) : true;
            object3 = null;
            PrivateKey privateKey = (PrivateKey)((PkAttrs)object4).getValue("cert.oper.privateKey", null);
            if (privateKey != null) {
                if (bl3) {
                    try {
                        object2 = (String)((PkAttrs)object4).getValue("x509.info.algorithmName", null);
                        signature = Signature.getInstance((String)object2, (String)((PkAttrs)object4).getValue("cert.oper.PROVIDER"));
                        signature.initSign(privateKey);
                        signature.update(serializable.toByteArray());
                        object = signature.sign();
                        algorithmId = (AlgorithmId)((PkAttrs)object4).getValue("x509.info.algorithmID", null);
                        keyIdentifier = new POPOSigningKey(null, algorithmId, (byte[])object);
                        object3 = new ProofOfPossession(1, (Object)keyIdentifier);
                    }
                    catch (Exception exception) {
                        if (exception instanceof PkException) {
                            if (debug != null) {
                                debug.text(0L, className, "writeSecnReq", exception.getMessage());
                            }
                            throw (PkException)exception;
                        }
                        PkException pkException = new PkException(exception);
                        if (debug != null) {
                            debug.text(0L, className, "writeSecnReq", pkException.getMessage());
                        }
                        throw pkException;
                    }
                } else {
                    object2 = new POPOPrivKey(1, (Object)new Integer(0));
                    object3 = new ProofOfPossession(2, object2);
                }
            }
            object2 = new CertReqMsg((CertRequest)date, (ProofOfPossession)object3, null);
            signature = new CertReqMessages(new CertReqMsg[]{object2});
            object = (String)((PkAttrs)object4).getValue("x509.info.messageProtectionAlgorithmName");
            algorithmId = (AlgorithmId)((PkAttrs)object4).getValue("x509.info.messageProtectionAlgorithmID");
            keyIdentifier = (KeyIdentifier)((PkAttrs)object4).getValue("cert.oper.SenderKeyIdentifier");
            PKIHeader pKIHeader = new PKIHeader(BIG_ONE, generalName, generalName2, new Date(), algorithmId, keyIdentifier, null, new Long(new Date().getTime()).toString().getBytes(), new Date().toString().getBytes(), null, null, null);
            DerOutputStream derOutputStream = new DerOutputStream();
            pKIHeader.encode((OutputStream)derOutputStream);
            PKIBody pKIBody = new PKIBody(PkCmpEventFormatter.getBodyType(pkSecnReqEvent), (Object)signature);
            pKIBody.encode((OutputStream)derOutputStream);
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream);
            byte[] byArray = derOutputStream2.toByteArray();
            byte[] byArray2 = null;
            try {
                string = (String)((PkAttrs)object4).getValue("cert.oper.PROVIDER");
                Signature signature2 = Signature.getInstance((String)object, string);
                PrivateKey privateKey2 = (PrivateKey)((PkAttrs)object4).getValue("cert.oper.messageProtectionKey", null);
                if (privateKey2 == null) {
                    PkRejectionException pkRejectionException = new PkRejectionException(PkNLSConstants.MISSING_PRIVATE_KEY);
                    if (debug != null) {
                        debug.text(0L, className, "writeSecnReq", pkRejectionException.getMessage());
                    }
                    throw pkRejectionException;
                }
                signature2.initSign(privateKey2);
                signature2.update(byArray);
                byArray2 = signature2.sign();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", "Exception from writeCertReq (CR case) in cmpeventformatter");
                }
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", noSuchAlgorithmException.getMessage());
                    debug.text(0L, className, "writeSecnReq", noSuchAlgorithmException.getMessage());
                }
                PkRejectionException pkRejectionException = new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION);
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", pkRejectionException.getMessage());
                }
                throw pkRejectionException;
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", "Exception from writeCertReq (CR case) in cmpeventformatter");
                }
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", generalSecurityException.getMessage());
                    debug.text(0L, className, "writeSecnReq", generalSecurityException.getMessage());
                }
                PkRejectionException pkRejectionException = new PkRejectionException(PkNLSConstants.GENERAL_SECURITY_EXCEPTION);
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", pkRejectionException.getMessage());
                }
                throw pkRejectionException;
            }
            string = new PKIMessage(pKIHeader, PkCmpEventFormatter.getBodyType(pkSecnReqEvent), (Object)signature, byArray2, null);
            if (debug != null) {
                debug.text(0L, className, "writeSecnReq", "From writeSecnReq(CR) {0}", (Object)string);
            }
            string.encode(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXcerReq(PkXcerReqEvent pkXcerReqEvent, OutputStream outputStream) throws IOException, PkException {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        BigInteger bigInteger;
        Object object2 = this;
        synchronized (object2) {
            bigInteger = this.certReqId;
            this.certReqId = this.certReqId.add(BigInteger.ONE);
        }
        object2 = pkXcerReqEvent.getAttrs();
        GeneralName generalName = null;
        GeneralName generalName2 = null;
        try {
            generalName = new GeneralName((GeneralNameInterface)((X500Name)((PkAttrs)object2).getValue("x509.info.subject")));
            generalName2 = (GeneralName)((PkAttrs)object2).getValue("cert.oper.RECIPIENT_DN");
        }
        catch (NoSuchElementException noSuchElementException) {
            PkException pkException = new PkException(noSuchElementException);
            if (debug != null) {
                debug.text(0L, className, "writeXCertReq", pkException.getMessage());
            }
            throw pkException;
        }
        KeyIdentifier keyIdentifier = (KeyIdentifier)((PkAttrs)object2).getValue("cert.oper.SenderKeyIdentifier");
        CertTemplate certTemplate = new CertTemplate();
        if (((PkAttrs)object2).has("x509.info.validity.notBefore") || ((PkAttrs)object2).has("x509.info.validity.notAfter")) {
            serializable2 = (Date)((PkAttrs)object2).getValue("x509.info.validity.notBefore", null);
            serializable = (Date)((PkAttrs)object2).getValue("x509.info.validity.notAfter", null);
            certTemplate.setValidity(new OptionalValidity(serializable2, (Date)serializable));
        }
        PkCmpEventFormatter.addToTempl(certTemplate, (PkAttrs)object2);
        try {
            serializable2 = (BasicConstraintsExtension)certTemplate.getExtensions().get("BasicConstraints");
            serializable = (Boolean)serializable2.get("is_ca");
            if (!((Boolean)serializable).booleanValue()) {
                PkRejectionException pkRejectionException = new PkRejectionException(PkNLSConstants.BASIC_CONSTRAINTS_EXTENSION_MUST_BE_FOR_CA);
                if (debug != null) {
                    debug.text(0L, className, "writeXcerReq", pkRejectionException.getMessage());
                }
                throw pkRejectionException;
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(4L, className, "writeXcerReq", (Throwable)iOException);
            }
            serializable = new BasicConstraintsExtension(true, 1);
            certTemplate.addExtension(new Extension[]{serializable});
        }
        try {
            serializable2 = (PublicKey)((PkAttrs)object2).getValue("x509.info.key");
        }
        catch (NoSuchElementException noSuchElementException) {
            serializable = new PkException(noSuchElementException);
            if (debug != null) {
                debug.text(0L, className, "writeXCerReq", ((Throwable)serializable).getMessage());
            }
            throw serializable;
        }
        boolean bl = false;
        boolean bl2 = false;
        KeyUsageExtension keyUsageExtension = (KeyUsageExtension)((PkAttrs)object2).getValue("x509.info.extensions.KeyUsage", null);
        if (keyUsageExtension == null) {
            keyUsageExtension = new KeyUsageExtension();
            keyUsageExtension.set("key_certsign", (Object)Boolean.TRUE);
            certTemplate.addExtension(new Extension[]{keyUsageExtension});
        } else {
            object = keyUsageExtension.getBits();
            int n = ((boolean[])object).length;
            if (n == 0) {
                keyUsageExtension = new KeyUsageExtension();
                keyUsageExtension.set("key_certsign", (Object)Boolean.TRUE);
                certTemplate.addExtension(new Extension[]{keyUsageExtension});
            } else {
                boolean bl3 = false;
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    if (!object[i]) continue;
                    n2 += i;
                }
                if (n2 == 5 || n2 == 6 || n2 == 11) {
                    if (debug != null) {
                        debug.text(0L, className, "writeXCerReq", "keyUsageExtension is ok. sum ={0} ", (Object)new Integer(n2));
                    }
                } else {
                    PkRejectionException pkRejectionException = new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
                    if (debug != null) {
                        debug.text(0L, className, "writeXCerReq", pkRejectionException.getMessage());
                    }
                    throw pkRejectionException;
                }
            }
        }
        object = new CertRequest(bigInteger, certTemplate, null);
        DerOutputStream derOutputStream = new DerOutputStream();
        object.encode((OutputStream)derOutputStream);
        String string = (String)((PkAttrs)object2).getValue("cert.oper.PROVIDER", null);
        if (string == null || string.length() == 0) {
            PkRejectionException pkRejectionException = new PkRejectionException(PkNLSConstants.NEED_PROVIDER);
            if (debug != null) {
                debug.text(0L, className, "writeXcerReq", pkRejectionException.getMessage());
            }
            throw pkRejectionException;
        }
        ProofOfPossession proofOfPossession = null;
        CertReqMsg certReqMsg = new CertReqMsg((CertRequest)object, proofOfPossession, null);
        CertReqMessages certReqMessages = new CertReqMessages(new CertReqMsg[]{certReqMsg});
        AlgorithmId algorithmId = this.generateProtectionAlg(string);
        BigInteger bigInteger2 = (BigInteger)((PkAttrs)object2).getValue("cert.oper.CMP_VERSION", BIG_ONE);
        PKIHeader pKIHeader = new PKIHeader(bigInteger2, generalName, generalName2, new Date(), algorithmId, keyIdentifier, null, new Long(new Date().getTime()).toString().getBytes(), new Date().toString().getBytes(), null, null, null);
        if (debug != null) {
            debug.text(0L, className, "writeXCerReq", "pkiHeader ={0} ", (Object)pKIHeader);
        }
        PKIMessage pKIMessage = new PKIMessage(pKIHeader, PkCmpEventFormatter.getBodyType(pkXcerReqEvent), (Object)certReqMessages, null, null);
        PKIMessage pKIMessage2 = null;
        try {
            String string2 = (String)((PkAttrs)object2).getValue("x509.info.init_pwd");
            if (string2 != null) {
                pKIMessage2 = pKIMessage.protect(string2.getBytes());
            }
        }
        catch (Exception exception) {
            PkException pkException = new PkException(exception);
            if (debug != null) {
                debug.text(0L, className, "writeXCertReq", pkException.getMessage());
            }
            throw pkException;
        }
        if (debug != null) {
            debug.text(0L, className, "writeXCertReq", "pkiMessage1 ={0} ", (Object)pKIMessage2);
        }
        pKIMessage2.encode(outputStream);
    }

    @Override
    public void writeCertRep(PkCertRepEvent pkCertRepEvent, OutputStream outputStream) throws IOException, PkException {
        Boolean bl = (Boolean)pkCertRepEvent.getReq().getAttrs().getValue("PASSTHRU", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeCertRep", "passThru = {0}", (Object)bl);
        }
        if (bl.booleanValue()) {
            PKIMessage pKIMessage = (PKIMessage)pkCertRepEvent.getMsg();
            pKIMessage.encode(outputStream);
        } else {
            X509CertImpl x509CertImpl = (X509CertImpl)pkCertRepEvent.getCert();
            PkAttrs pkAttrs = pkCertRepEvent.getReq().getAttrs();
            CertOrEncCert certOrEncCert = null;
            CertifiedKeyPair certifiedKeyPair = null;
            SinglePubInfo[] singlePubInfoArray = new SinglePubInfo[1];
            PKIPublicationInfo pKIPublicationInfo = new PKIPublicationInfo(0, singlePubInfoArray);
            certOrEncCert = new CertOrEncCert((Certificate)x509CertImpl);
            certifiedKeyPair = new CertifiedKeyPair(certOrEncCert, null, pKIPublicationInfo);
            PkReqEvent pkReqEvent = pkCertRepEvent.getReq();
            PkAttrs pkAttrs2 = pkReqEvent.getAttrs();
            this.certReqId = (BigInteger)pkAttrs2.getValue("cert.oper.certReqId");
            CertResponse certResponse = new CertResponse(this.certReqId, statusOk, certifiedKeyPair, null);
            Certificate[] certificateArray = (Certificate[])pkAttrs2.getValue("cert.oper.caPubs");
            CertRepMessage certRepMessage = new CertRepMessage(certificateArray, new CertResponse[]{certResponse});
            PKIMessage pKIMessage = null;
            if (pkReqEvent instanceof PkInitReqEvent) {
                Boolean bl2 = (Boolean)pkAttrs2.getValue("cert.oper.raEnrollment", Boolean.FALSE);
                if (!bl2.booleanValue()) {
                    PKIMessage pKIMessage2 = new PKIMessage((PKIHeader)pkCertRepEvent.getReq().getAttrs().getValue("cert.oper.responseHeader"), 1, (Object)certRepMessage, null, null);
                    pKIMessage = null;
                    try {
                        String string = (String)pkAttrs2.getValue("x509.info.init_pwd", null);
                        if (string == null) {
                            pKIMessage = pKIMessage2;
                        }
                        pKIMessage = pKIMessage2.protect(string.getBytes());
                    }
                    catch (Exception exception) {
                        if (exception instanceof PkException) {
                            if (debug != null) {
                                debug.text(0L, className, "writeCertReq", exception.getMessage());
                            }
                            throw (PkException)exception;
                        }
                        PkException pkException = new PkException(exception);
                        if (debug != null) {
                            debug.text(0L, className, "writeCertReq", pkException.getMessage());
                        }
                        throw pkException;
                    }
                } else {
                    Certificate[] certificateArray2;
                    DerOutputStream derOutputStream = new DerOutputStream();
                    PKIHeader pKIHeader = (PKIHeader)pkCertRepEvent.getReq().getAttrs().getValue("cert.oper.responseHeader");
                    pKIHeader.encode((OutputStream)derOutputStream);
                    PKIBody pKIBody = new PKIBody(1, (Object)certRepMessage);
                    pKIBody.encode((OutputStream)derOutputStream);
                    DerOutputStream derOutputStream2 = new DerOutputStream();
                    derOutputStream2.write((byte)48, derOutputStream);
                    byte[] byArray = derOutputStream2.toByteArray();
                    byte[] byArray2 = null;
                    String string = null;
                    try {
                        string = PkEeFactory.getProvider();
                        certificateArray2 = (Certificate[])pkAttrs2.getValue("x509.info.algorithmName");
                        PrivateKey privateKey = (PrivateKey)pkAttrs2.getValue("cert.oper.privateKey", null);
                        if (privateKey != null) {
                            Object var26_33 = null;
                            Signature signature = Signature.getInstance((String)certificateArray2, string);
                            signature.initSign(privateKey);
                            signature.update(byArray);
                            byArray2 = signature.sign();
                        }
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        PkException pkException = new PkException(generalSecurityException);
                        if (debug != null) {
                            debug.text(0L, className, "writeCertReq", pkException.getMessage());
                        }
                        throw pkException;
                    }
                    certificateArray2 = new Certificate[]{x509CertImpl};
                    pKIMessage = new PKIMessage(pKIHeader, 1, (Object)certRepMessage, byArray2, certificateArray);
                }
            } else if (pkReqEvent instanceof PkSecnReqEvent) {
                pKIMessage = new PKIMessage((PKIHeader)pkCertRepEvent.getReq().getAttrs().getValue("cert.oper.responseHeader"), 3, (Object)certRepMessage, null, null);
            }
            if (debug != null) {
                debug.text(0L, className, "writeCertRep", "######## in writeCertRep....., pkiMessage = {0}", pKIMessage);
                debug.text(0L, className, "writeCertRep", "writeCertRep/secnReqEvent...., rep = {0}", (Object)pkCertRepEvent);
            }
            pKIMessage.encode(outputStream);
        }
    }

    public void writeSecnRep(PkCertRepEvent pkCertRepEvent, OutputStream outputStream) throws IOException {
        Boolean bl = (Boolean)pkCertRepEvent.getReq().getAttrs().getValue("PASSTHRU", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeSecnRep", "passThru = {0}", (Object)bl);
        }
        if (bl.booleanValue()) {
            PKIMessage pKIMessage = (PKIMessage)pkCertRepEvent.getMsg();
            pKIMessage.encode(outputStream);
        } else {
            X509CertImpl x509CertImpl = (X509CertImpl)pkCertRepEvent.getCert();
            CertOrEncCert certOrEncCert = new CertOrEncCert((Certificate)x509CertImpl);
            CertifiedKeyPair certifiedKeyPair = new CertifiedKeyPair(certOrEncCert, null, null);
            this.certReqId = this.certReqId.add(BigInteger.ONE);
            CertResponse certResponse = new CertResponse(this.certReqId, statusOk, certifiedKeyPair, null);
            CertRepMessage certRepMessage = new CertRepMessage(null, new CertResponse[]{certResponse});
            PKIMessage pKIMessage = new PKIMessage((PKIHeader)pkCertRepEvent.getReq().getAttrs().getValue("cert.oper.responseHeader"), 3, (Object)certRepMessage, null, null);
            if (debug != null) {
                debug.text(0L, className, "writeSecnRep", "######## in writeSecnRep....., pkiMessage = {0}", (Object)pKIMessage);
            }
            pKIMessage.encode(outputStream);
        }
    }

    @Override
    public void writeXcerRep(PkXcerRepEvent pkXcerRepEvent, OutputStream outputStream) throws IOException, PkException {
        Boolean bl = (Boolean)pkXcerRepEvent.getReq().getAttrs().getValue("PASSTHRU", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeXCerRep", "passThru = {0}", (Object)bl);
        }
        if (bl.booleanValue()) {
            PKIMessage pKIMessage = (PKIMessage)pkXcerRepEvent.getMsg();
            pKIMessage.encode(outputStream);
        } else {
            X509CertImpl x509CertImpl = (X509CertImpl)pkXcerRepEvent.getCert();
            PkAttrs pkAttrs = pkXcerRepEvent.getReq().getAttrs();
            boolean bl2 = true;
            CertOrEncCert certOrEncCert = null;
            CertifiedKeyPair certifiedKeyPair = null;
            SinglePubInfo[] singlePubInfoArray = new SinglePubInfo[1];
            PKIPublicationInfo pKIPublicationInfo = new PKIPublicationInfo(0, singlePubInfoArray);
            certOrEncCert = new CertOrEncCert((Certificate)x509CertImpl);
            certifiedKeyPair = new CertifiedKeyPair(certOrEncCert, null, pKIPublicationInfo);
            PkReqEvent pkReqEvent = pkXcerRepEvent.getReq();
            PkAttrs pkAttrs2 = pkReqEvent.getAttrs();
            this.certReqId = (BigInteger)pkAttrs2.getValue("cert.oper.certReqId");
            CertResponse certResponse = new CertResponse(this.certReqId, statusOk, certifiedKeyPair, null);
            Certificate[] certificateArray = (Certificate[])pkAttrs2.getValue("cert.oper.caPubs");
            CertRepMessage certRepMessage = new CertRepMessage(certificateArray, new CertResponse[]{certResponse});
            PKIMessage pKIMessage = null;
            PKIMessage pKIMessage2 = new PKIMessage((PKIHeader)pkXcerRepEvent.getReq().getAttrs().getValue("cert.oper.responseHeader"), 14, (Object)certRepMessage, null, null);
            pKIMessage = null;
            try {
                String string = (String)pkAttrs2.getValue("x509.info.init_pwd", null);
                pKIMessage = string == null ? pKIMessage2 : pKIMessage2.protect(string.getBytes());
            }
            catch (Exception exception) {
                if (exception instanceof PkException) {
                    if (debug != null) {
                        debug.text(0L, className, "writeXCerRep", exception.getMessage());
                    }
                    throw (PkException)exception;
                }
                PkException pkException = new PkException(exception);
                if (debug != null) {
                    debug.text(0L, className, "writeXCerRep", pkException.getMessage());
                }
                throw pkException;
            }
            if (debug != null) {
                debug.text(0L, className, "writeXCerRep", "######## in writeXcerRep....., pkiMessage = {0}", (Object)pKIMessage);
            }
            pKIMessage.encode(outputStream);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeRevoReq(PkRevoReqEvent pkRevoReqEvent, OutputStream outputStream) throws IOException, PkException {
        ReasonFlags reasonFlags;
        Date date;
        boolean bl;
        boolean bl2 = false;
        CertTemplate certTemplate = new CertTemplate();
        PkAttrs pkAttrs = pkRevoReqEvent.getAttrs();
        String string = (String)pkAttrs.getValue("FROM_BROWSER", null);
        boolean bl3 = bl = string != null;
        if (!bl) {
            RevDetails[] revDetailsArray;
            void var13_22;
            ReasonFlags reasonFlags2;
            Boolean bl4 = (Boolean)pkAttrs.getValue("cert.oper.messageProtected", Boolean.FALSE);
            if (debug != null) {
                debug.text(0L, className, "writeRevoReq", "messageProtected {0}", (Object)bl4);
            }
            Boolean bl5 = (Boolean)pkAttrs.getValue("PASSTHRU", Boolean.FALSE);
            if (debug != null) {
                debug.text(0L, className, "writeRevoReq", "passThru {0}", (Object)bl5);
            }
            if (bl4.booleanValue() || bl5.booleanValue()) {
                if (debug != null) {
                    debug.text(0L, className, "writeRevoReq", "Send message through");
                }
                PKIMessage pKIMessage = (PKIMessage)pkRevoReqEvent.getMsg();
                pKIMessage.encode(outputStream);
                return;
            }
            InfoTypeAndValue[] infoTypeAndValueArray = (InfoTypeAndValue[])pkAttrs.getValue("cert.oper.certRevocationPassphrase", null);
            PrivateKey privateKey = (PrivateKey)pkAttrs.getValue("cert.oper.privateKey", null);
            if (infoTypeAndValueArray == null && privateKey == null) {
                throw new PkRejectionException(PkNLSConstants.MSG_CANNOT_BE_PROTECTED);
            }
            Object var13_19 = null;
            if (infoTypeAndValueArray != null) {
                Object var14_27 = null;
                try {
                    RevPassphraseInfoValue revPassphraseInfoValue = new RevPassphraseInfoValue(infoTypeAndValueArray[0].getValue());
                    EncryptedValue encryptedValue = (EncryptedValue)revPassphraseInfoValue.getValue();
                    String string2 = new String(encryptedValue.getEncValue());
                }
                catch (IOException iOException) {
                    Object var13_21 = null;
                }
            }
            if (pkAttrs.has("x509.info.validity.notBefore") || pkAttrs.has("x509.info.validity.notAfter")) {
                Date date2 = (Date)pkAttrs.getValue("x509.info.validity.notBefore", null);
                Date date3 = (Date)pkAttrs.getValue("x509.info.validity.notAfter", null);
                certTemplate.setValidity(new OptionalValidity(date2, date3));
            }
            PkCmpEventFormatter.addToTempl(certTemplate, pkAttrs);
            BigInteger bigInteger = (BigInteger)pkAttrs.getValue("x509.info.serialNumber", null);
            Date date4 = (Date)pkAttrs.getValue("revo.badSinceDate", null);
            if (date4 == null) {
                PkException pkException = new PkException(PkNLSConstants.MISSING_BAD_SINCE_DATE);
                if (debug == null) throw pkException;
                debug.text(0L, className, "writeRevoReq", pkException.getMessage());
                throw pkException;
            }
            Integer n = (Integer)pkAttrs.getValue("revo.reasonFlags", null);
            if (n == null) {
                reasonFlags2 = null;
            } else {
                boolean[] blArray;
                int n2 = n;
                if (n2 >= 0 && n2 <= 8 && n2 != 7) {
                    blArray = new boolean[8];
                    for (int i = 0; i < blArray.length; ++i) {
                        blArray[i] = false;
                    }
                } else {
                    PkRejectionException pkRejectionException = new PkRejectionException(PkNLSConstants.INCORRECT_REASON);
                    if (debug == null) throw pkRejectionException;
                    debug.text(0L, className, "writeRevoReq", pkRejectionException.getMessage());
                    throw pkRejectionException;
                }
                if (n2 != 8) {
                    blArray[n2] = true;
                } else {
                    bl2 = true;
                    blArray[0] = true;
                }
                reasonFlags2 = new ReasonFlags(blArray);
            }
            CRLExtensions cRLExtensions = (CRLExtensions)pkAttrs.getValue("revo.extensions", null);
            if (bl2) {
                CRLReasonCodeExtension cRLReasonCodeExtension = new CRLReasonCodeExtension(false, 8);
                if (cRLExtensions == null) {
                    cRLExtensions = new CRLExtensions();
                }
                cRLExtensions.set("CRLReasonCode", (Object)cRLReasonCodeExtension);
            }
            Object var18_54 = null;
            PKIHeader pKIHeader = (PKIHeader)pkAttrs.getValue("TMP_MSG_HDR");
            AlgorithmId algorithmId = null;
            String string3 = (String)pkAttrs.getValue("x509.info.algorithmName", null);
            algorithmId = (AlgorithmId)pkAttrs.getValue("x509.info.algorithmID", null);
            if (algorithmId == null) {
                if ("SHA1withRSA".equalsIgnoreCase(string3)) {
                    algorithmId = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
                } else if ("MD5withRSA".equalsIgnoreCase(string3)) {
                    algorithmId = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
                } else if ("MD2withRSA".equalsIgnoreCase(string3)) {
                    algorithmId = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid);
                } else if ("sha1WithDSA".equalsIgnoreCase(string3)) {
                    algorithmId = new AlgorithmId(AlgorithmId.sha1WithDSA_oid);
                }
            }
            KeyIdentifier keyIdentifier = (KeyIdentifier)pkAttrs.getValue("cert.oper.SenderKeyIdentifier", null);
            BigInteger bigInteger2 = (BigInteger)pkAttrs.getValue("cert.oper.CMP_VERSION");
            PKIHeader pKIHeader2 = null;
            if (privateKey != null || var13_22 == null) {
                pKIHeader2 = new PKIHeader(bigInteger2, pKIHeader.getSender(), pKIHeader.getRecipient(), new Date(), algorithmId, keyIdentifier, null, new Long(new Date().getTime()).toString().getBytes(), pKIHeader.getSenderNonce(), null, null, null);
                if (debug != null) {
                    debug.text(0L, className, "writeRevoReq", "private-key-case");
                }
            } else {
                revDetailsArray = this.generateProtectionAlg(PkEeFactory.getProvider());
                pKIHeader2 = new PKIHeader(bigInteger2, pKIHeader.getSender(), pKIHeader.getRecipient(), new Date(), (AlgorithmId)revDetailsArray, keyIdentifier, null, new Long(new Date().getTime()).toString().getBytes(), pKIHeader.getSenderNonce(), null, null, infoTypeAndValueArray);
            }
            revDetailsArray = new RevDetails[]{new RevDetails(certTemplate, reasonFlags2, date4, cRLExtensions)};
            RevReqContent revReqContent = new RevReqContent(revDetailsArray);
            X509CertImpl x509CertImpl = (X509CertImpl)pkAttrs.getValue("CERT_X509", null);
            Certificate[] certificateArray = new Certificate[]{x509CertImpl};
            if (x509CertImpl == null) {
                certificateArray = null;
            }
            PKIMessage pKIMessage = null;
            DerOutputStream derOutputStream = new DerOutputStream();
            pKIHeader2.encode((OutputStream)derOutputStream);
            PKIBody pKIBody = new PKIBody(PkCmpEventFormatter.getBodyType(pkRevoReqEvent), (Object)revReqContent);
            pKIBody.encode((OutputStream)derOutputStream);
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream);
            if (privateKey != null || var13_22 == null) {
                byte[] byArray = derOutputStream2.toByteArray();
                byte[] byArray2 = null;
                String string4 = null;
                try {
                    if (privateKey != null) {
                        string4 = (String)pkAttrs.getValue("cert.oper.PROVIDER", PkEeFactory.getProvider());
                        Signature signature = Signature.getInstance(string3, string4);
                        signature.initSign(privateKey);
                        signature.update(byArray);
                        byArray2 = signature.sign();
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                    PkException pkException = new PkException(generalSecurityException);
                    if (debug == null) throw pkException;
                    debug.text(0L, className, "writeRevoReq", pkException.getMessage());
                    throw pkException;
                }
                pKIMessage = new PKIMessage(pKIHeader2, PkCmpEventFormatter.getBodyType(pkRevoReqEvent), (Object)revReqContent, byArray2, certificateArray);
                pKIMessage.encode(outputStream);
                return;
            }
            pKIMessage = new PKIMessage(pKIHeader2, PkCmpEventFormatter.getBodyType(pkRevoReqEvent), (Object)revReqContent, null, certificateArray);
            try {
                PKIMessage pKIMessage2 = pKIMessage.protect(var13_22.getBytes());
                pKIMessage2.encode(outputStream);
                return;
            }
            catch (Exception exception) {
                PkException pkException = new PkException(exception);
                if (debug == null) throw pkException;
                debug.text(0L, className, "writeRevoReq", pkException.getMessage());
                throw pkException;
            }
        }
        if (pkAttrs.has("x509.info.validity.notBefore") || pkAttrs.has("x509.info.validity.notAfter")) {
            Date date5 = (Date)pkAttrs.getValue("x509.info.validity.notBefore", null);
            date = (Date)pkAttrs.getValue("x509.info.validity.notAfter", null);
            certTemplate.setValidity(new OptionalValidity(date5, date));
        }
        PkCmpEventFormatter.addToTempl(certTemplate, pkAttrs);
        BigInteger bigInteger = (BigInteger)pkAttrs.getValue("x509.info.serialNumber", null);
        date = !bl ? (Date)pkAttrs.getValue("revo.badSinceDate") : new Date(2L);
        Integer n = (Integer)pkAttrs.getValue("revo.reasonFlags", null);
        if (n == null) {
            reasonFlags = null;
        } else {
            void var14_34;
            int n3 = n;
            boolean[] blArray = new boolean[8];
            boolean bl6 = false;
            while (var14_34 < blArray.length) {
                blArray[var14_34] = false;
                ++var14_34;
            }
            if (n3 != 8) {
                blArray[n3] = true;
            } else {
                bl2 = true;
                blArray[0] = true;
            }
            reasonFlags = new ReasonFlags(blArray);
        }
        CRLExtensions cRLExtensions = (CRLExtensions)pkAttrs.getValue("revo.extensions", null);
        if (bl2) {
            CRLReasonCodeExtension cRLReasonCodeExtension = new CRLReasonCodeExtension(false, 8);
            if (cRLExtensions == null) {
                cRLExtensions = new CRLExtensions();
            }
            cRLExtensions.set("CRLReasonCode", (Object)cRLReasonCodeExtension);
        }
        RevDetails[] revDetailsArray = new RevDetails[]{new RevDetails(certTemplate, reasonFlags, date, cRLExtensions)};
        RevReqContent revReqContent = new RevReqContent(revDetailsArray);
        GeneralName generalName = new GeneralName((GeneralNameInterface)new X500Name(""));
        GeneralName generalName2 = new GeneralName((GeneralNameInterface)new X500Name(""));
        PKIHeader pKIHeader = new PKIHeader(BIG_ONE, generalName, generalName2, null, null, null, null, null, null, null, null, null);
        PKIMessage pKIMessage = new PKIMessage(pKIHeader, 11, (Object)revReqContent, null, null);
        if (debug != null) {
            debug.text(0L, className, "writeRevoReq", "bodyType {0}", (Object)new Integer(pKIMessage.getBodyType()));
        }
        pKIMessage.encode(outputStream);
    }

    @Override
    public void writeConfReq(PkConfReqEvent pkConfReqEvent, OutputStream outputStream) throws IOException {
        PKIMessage pKIMessage = (PKIMessage)pkConfReqEvent.getMsg();
        pKIMessage.encode(outputStream);
    }

    @Override
    public void writeConfRep(PkConfRepEvent pkConfRepEvent, OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.text(0L, className, "writeConfRep", "############ from writeConfRep....");
        }
        PKIMessage pKIMessage = (PKIMessage)pkConfRepEvent.getReq().getMsg();
        PKIHeader pKIHeader = pKIMessage.getHeader();
        BigInteger bigInteger = pKIHeader.getPvno();
        PkAttrs pkAttrs = pkConfRepEvent.getReq().getAttrs();
        PKIMessage pKIMessage2 = (PKIMessage)pkConfRepEvent.getMsg();
        if (bigInteger.equals(BIG_ONE)) {
            if (pKIMessage2 == null) {
                if (debug != null) {
                    debug.text(0L, className, "writeConfRep", "message is null");
                }
            } else {
                if (debug != null) {
                    debug.text(0L, className, "writeConfRep", "############ from writeConfRep..msg is {0}", (Object)pKIMessage2);
                }
                pKIMessage2.encode(outputStream);
            }
        } else if (bigInteger.equals(BIG_TWO)) {
            if (pKIMessage2 == null) {
                if (debug != null) {
                    debug.text(0L, className, "writeConfRep", "message is null. v2");
                }
                PKIMessage pKIMessage3 = new PKIMessage(pKIHeader, 19, null, null, null);
                try {
                    PKIMessage pKIMessage4 = null;
                    String string = (String)pkAttrs.getValue("x509.info.init_pwd");
                    pKIMessage4 = string != null ? pKIMessage3.protect(string.getBytes()) : pKIMessage3;
                    pKIMessage4.encode(outputStream);
                }
                catch (Exception exception) {
                    IOException iOException = new IOException(exception);
                    if (debug != null) {
                        debug.text(0L, className, "writeConfRep", iOException.getMessage());
                    }
                    throw iOException;
                }
            } else {
                if (debug != null) {
                    debug.text(0L, className, "writeConfRep", "############ from writeConfRep..msg is {0}", (Object)pKIMessage2);
                }
                pKIMessage2.encode(outputStream);
            }
        }
    }

    @Override
    public void writeRevoRep(PkRevoRepEvent pkRevoRepEvent, OutputStream outputStream) throws IOException {
        PKIMessage pKIMessage = (PKIMessage)pkRevoRepEvent.getReq().getMsg();
        PKIHeader pKIHeader = pKIMessage.getHeader();
        BigInteger bigInteger = pKIHeader.getPvno();
        PkAttrs pkAttrs = pkRevoRepEvent.getReq().getAttrs();
        PKIStatusInfo pKIStatusInfo = new PKIStatusInfo(0, null, null);
        RevRepContent revRepContent = new RevRepContent(new PKIStatusInfo[]{pKIStatusInfo}, null, null);
        if (bigInteger.equals(BIG_ONE)) {
            AlgorithmId algorithmId = this.generateProtectionAlg(PkEeFactory.getProvider());
            PKIHeader pKIHeader2 = new PKIHeader(pKIHeader.getPvno(), pKIHeader.getRecipient(), pKIHeader.getSender(), null, algorithmId, null, pKIHeader.getSenderKID(), pKIHeader.getTransactionID(), new Date().toString().getBytes(), pKIHeader.getSenderNonce(), null, null);
            PKIMessage pKIMessage2 = new PKIMessage(pKIHeader2, 12, (Object)revRepContent, null, null);
            if (debug != null) {
                debug.text(0L, className, "writeRevoRep", "writeRevoRep-header {0}", (Object)pKIHeader2);
            }
            try {
                PKIMessage pKIMessage3 = null;
                String string = (String)pkAttrs.getValue("x509.info.init_pwd");
                pKIMessage3 = string != null ? pKIMessage2.protect(string.getBytes()) : pKIMessage2;
                pKIMessage3.encode(outputStream);
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception);
                if (debug != null) {
                    debug.text(0L, className, "writeRevoRep", iOException.getMessage());
                }
                throw iOException;
            }
        } else if (bigInteger.equals(BIG_TWO)) {
            AlgorithmId algorithmId = this.generateProtectionAlg(PkEeFactory.getProvider());
            PKIHeader pKIHeader3 = new PKIHeader(pKIHeader.getPvno(), pKIHeader.getRecipient(), pKIHeader.getSender(), null, algorithmId, null, pKIHeader.getSenderKID(), pKIHeader.getTransactionID(), new Date().toString().getBytes(), pKIHeader.getSenderNonce(), null, null);
            PKIMessage pKIMessage4 = new PKIMessage(pKIHeader3, 12, (Object)revRepContent, null, null);
            if (debug != null) {
                debug.text(0L, className, "writeRevoRep", "writeRevoRep-header {0}", (Object)pKIHeader3);
            }
            try {
                PKIMessage pKIMessage5 = null;
                String string = (String)pkAttrs.getValue("x509.info.init_pwd");
                pKIMessage5 = string != null ? pKIMessage4.protect(string.getBytes()) : pKIMessage4;
                pKIMessage5.encode(outputStream);
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception);
                if (debug != null) {
                    debug.text(0L, className, "writeRevoRep", iOException.getMessage());
                }
                throw iOException;
            }
        } else if (debug != null) {
            debug.text(0L, className, "writeRevoRep", "CMP version should be 1 or 2");
        }
    }

    private static PkAttrs getAttrsFromCertReqMessages(CertReqMessages certReqMessages) throws IOException {
        CertReqMsg[] certReqMsgArray = certReqMessages.getCertReqMsgs();
        CertRequest certRequest = certReqMsgArray[0].getCertReq();
        BigInteger bigInteger = certRequest.getCertReqId();
        PkAttrs pkAttrs = PkCmpEventFormatter.getAttrsFromCertTemplate(certRequest.getCertTemplate());
        pkAttrs.add("cert.oper.certReqId", 2, bigInteger);
        return pkAttrs;
    }

    private static PkAttrs getAttrsFromRevReqContent(RevReqContent revReqContent) throws IOException {
        ReasonFlags reasonFlags;
        RevDetails[] revDetailsArray = revReqContent.getRevDetails();
        PkAttrs pkAttrs = PkCmpEventFormatter.getAttrsFromCertTemplate(revDetailsArray[0].getCertDetails());
        Date date = revDetailsArray[0].getBadSinceDate();
        String string = date.toString();
        String string2 = new Date(2L).toString();
        int n = string.compareTo(string2);
        if (string.compareTo(string2) == 0) {
            pkAttrs.add("FROM_BROWSER", 1, "yes");
            if (debug != null) {
                debug.text(0L, className, "getAttrsFromRevReqContent", "from getAttrsFromCertTemplate. year is 69");
            }
            date = new Date();
        } else if (debug != null) {
            debug.text(0L, className, "getAttrsFromRevReqContent", "badSince String is {0}", (Object)string);
            debug.text(0L, className, "getAttrsFromRevReqContent", "new Date(2)  String is {0}", (Object)new Date(2L).toString());
        }
        pkAttrs.add("revo.badSinceDate", 1, date);
        CRLExtensions cRLExtensions = revDetailsArray[0].getCrlEntryDetails();
        boolean bl = false;
        if (cRLExtensions != null) {
            pkAttrs.add("revo.extensions", 1, cRLExtensions);
            reasonFlags = cRLExtensions.get("CRLReasonCode");
            if (reasonFlags instanceof CRLReasonCodeExtension) {
                pkAttrs.add("revo.reasonFlags", 1, ((CRLReasonCodeExtension)reasonFlags).get("reason"));
                bl = true;
            }
        }
        if (!bl) {
            reasonFlags = revDetailsArray[0].getReason();
            int n2 = 0;
            if (reasonFlags != null && reasonFlags.getReasonFlags() != null) {
                boolean[] blArray = reasonFlags.getReasonFlags().toBooleanArray();
                n2 = 0;
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i]) continue;
                    n2 = i;
                    break;
                }
            }
            pkAttrs.add("revo.reasonFlags", 1, new Integer(n2));
        }
        return pkAttrs;
    }

    private static PkAttrs getAttrsFromRevReqContent(RevReqContentv2 revReqContentv2) throws IOException {
        RevDetailsv2[] revDetailsv2Array = revReqContentv2.getRevDetails();
        PkAttrs pkAttrs = PkCmpEventFormatter.getAttrsFromCertTemplate(revDetailsv2Array[0].getCertDetails());
        Date date = new Date();
        String string = date.toString();
        String string2 = new Date(2L).toString();
        int n = string.compareTo(string2);
        if (string.compareTo(string2) == 0) {
            pkAttrs.add("FROM_BROWSER", 1, "yes");
            if (debug != null) {
                debug.text(0L, className, "getAttrsFromRevReqContent", "from getAttrsFromCertTemplate. year is 69");
            }
            date = new Date();
        } else if (debug != null) {
            debug.text(0L, className, "getAttrsFromRevReqContent", "badSince String is {0}", (Object)string);
            debug.text(0L, className, "getAttrsFromRevReqContent", "new Date(2)  String is {0}", (Object)new Date(2L).toString());
        }
        pkAttrs.add("revo.badSinceDate", 1, date);
        CRLExtensions cRLExtensions = revDetailsv2Array[0].getCrlEntryDetails();
        boolean bl = false;
        if (cRLExtensions != null) {
            pkAttrs.add("revo.extensions", 1, cRLExtensions);
            Extension extension = cRLExtensions.get("CRLReasonCode");
            if (extension instanceof CRLReasonCodeExtension) {
                pkAttrs.add("revo.reasonFlags", 1, ((CRLReasonCodeExtension)extension).get("reason"));
                bl = true;
            }
        }
        return pkAttrs;
    }

    private static PkAttrs getAttrsFromCertTemplate(CertTemplate certTemplate) throws IOException {
        PkAttrs pkAttrs;
        block20: {
            if (debug != null) {
                debug.text(0L, className, "getAttrsFromCertTemplate", "########## from getAttrsFromCertTemplate.");
            }
            pkAttrs = new PkAttrs();
            BigInteger bigInteger = certTemplate.getVersion();
            if (bigInteger != null) {
                PkCmpEventFormatter.add(pkAttrs, "x509.info.version", new Integer(bigInteger.intValue()));
            }
            PkCmpEventFormatter.add(pkAttrs, "x509.info.serialNumber", certTemplate.getSerialNumber());
            PkCmpEventFormatter.add(pkAttrs, "x509.info.algorithmID", certTemplate.getSigningAlg());
            PkCmpEventFormatter.add(pkAttrs, "x509.info.issuer", certTemplate.getIssuer());
            OptionalValidity optionalValidity = certTemplate.getValidity();
            if (optionalValidity != null) {
                PkCmpEventFormatter.add(pkAttrs, "x509.info.validity.notBefore", optionalValidity.getNotBefore());
                PkCmpEventFormatter.add(pkAttrs, "x509.info.validity.notAfter", optionalValidity.getNotAfter());
            }
            PkCmpEventFormatter.add(pkAttrs, "x509.info.subject", certTemplate.getSubject());
            try {
                PkCmpEventFormatter.add(pkAttrs, "x509.info.key", certTemplate.getPublicKey());
            }
            catch (InvalidKeyException invalidKeyException) {
                if (debug == null) break block20;
                debug.exception(1L, className, "getAttrsFromCertTemplate", (Throwable)invalidKeyException);
            }
        }
        byte[] byArray = certTemplate.getIssuerUID();
        if (byArray != null) {
            PkCmpEventFormatter.add(pkAttrs, "x509.info.issuerID", new UniqueIdentity(byArray));
        }
        if ((byArray = certTemplate.getSubjectUID()) != null) {
            PkCmpEventFormatter.add(pkAttrs, "x509.info.subjectID", new UniqueIdentity(byArray));
        }
        CertificateExtensions certificateExtensions = null;
        try {
            certificateExtensions = certTemplate.getExtensions();
            if (debug != null) {
                debug.text(0L, className, "getAttrsFromCertTemplate", "######. ext is {0}", (Object)certificateExtensions);
            }
        }
        catch (Exception exception) {
            throw new IOException(PkNLSConstants.CMPEVENT_PROBLEM_GETTING_EXT);
        }
        if (certificateExtensions == null) {
            return pkAttrs;
        }
        for (Object e : certificateExtensions.entrySet()) {
            Class clazz;
            String string;
            Map.Entry entry;
            block21: {
                if (e instanceof CertificateExtensions) {
                    if (debug != null) {
                        debug.text(1L, className, "getAttrsFromCertTemplate", "##### ce ");
                    }
                    entry = (Map.Entry)e;
                    if (debug != null) {
                        debug.text(1L, className, "getAttrsFromCertTemplate", "###################### EXT {0}", entry.getKey());
                    }
                    PkCmpEventFormatter.add(pkAttrs, "x509.info.extensions." + entry.getKey(), entry.getValue());
                    continue;
                }
                if (!(e instanceof Extension)) continue;
                entry = (Extension)e;
                if (debug != null) {
                    debug.text(0L, className, "getAttrsFromCertTemplate", "##### e.getExtensionId {0}", (Object)entry.getExtensionId());
                }
                string = null;
                clazz = null;
                try {
                    string = OIDMap.getName((ObjectIdentifier)entry.getExtensionId());
                    clazz = OIDMap.getClass((ObjectIdentifier)entry.getExtensionId());
                }
                catch (Exception exception) {
                    if (debug == null) break block21;
                    debug.exception(4L, className, "getAttrsFromCertTemplate", (Throwable)exception);
                }
            }
            if (string == null) {
                if (!entry.getExtensionId().equals(TPKI_ENROLL_OID)) continue;
                pkAttrs.add("cert.oper.raEnrollment", 2, new Boolean(true));
                if (debug == null) continue;
                debug.text(1L, className, "getAttrsFromCertTemplate", "########## TPKI_RA_ENROLL");
                continue;
            }
            if (debug != null) {
                debug.text(1L, className, "getAttrsFromCertTemplate", "###################### name {0}", (Object)string);
                debug.text(1L, className, "getAttrsFromCertTemplate", "###################### class {0}", (Object)clazz);
            }
            PkCmpEventFormatter.add(pkAttrs, string, entry);
        }
        return pkAttrs;
    }

    private static void add(PkAttrs pkAttrs, String string, Object object) {
        pkAttrs.add(string, 1, object);
    }

    private X509CertImpl getCert(CertRepMessage certRepMessage, PrivateKey privateKey) throws PkException, IOException {
        Object object;
        Object object2;
        byte[] byArray;
        block19: {
            boolean bl = privateKey != null;
            CertResponse[] certResponseArray = certRepMessage.getResponse();
            PKIStatusInfo pKIStatusInfo = certResponseArray[0].getStatusInfo();
            switch (pKIStatusInfo.getStatus()) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new PkException(pKIStatusInfo.toString());
                }
            }
            CertOrEncCert certOrEncCert = certResponseArray[0].getCertifiedKeyPair().getCertOrEncCert();
            byArray = null;
            if (certOrEncCert.isCertificate()) {
                try {
                    byArray = certOrEncCert.getCertificate().getEncoded();
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    if (debug != null) {
                        debug.exception(4L, className, "getCert", (Throwable)certificateEncodingException);
                    }
                    break block19;
                }
            }
            try {
                if (privateKey != null) {
                    object2 = certOrEncCert.getCertOrEncCert();
                    object = object2.getSymmAlg();
                    byte[] byArray2 = object2.getEncSymmKey();
                    AlgorithmId algorithmId = object2.getKeyAlg();
                    byte[] byArray3 = object2.getEncValue();
                    if (debug != null) {
                        debug.text(1L, className, "getCert", "encValue = {0}", (Object)new Integer(byArray3.length));
                    }
                    Cipher cipher = Cipher.getInstance("RSA", PkEeFactory.getProvider());
                    cipher.init(2, privateKey);
                    byte[] byArray4 = cipher.doFinal(byArray2);
                    for (int i = 0; i < byArray4.length; ++i) {
                        if (debug == null) continue;
                        debug.text(1L, className, "getCert", "decSymmKey: {0}", (Object)new Byte(byArray4[i]));
                    }
                    Cipher cipher2 = Cipher.getInstance("DESEDE/CBC/PKCS5Padding", PkEeFactory.getProvider());
                    if (object.getAlgParameters() == null && debug != null) {
                        debug.text(0L, className, "getCert", "symmAlg = {0}", object);
                    }
                    IvParameterSpec ivParameterSpec = object.getAlgParameters().getParameterSpec(IvParameterSpec.class);
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, "DESede");
                    cipher2.init(2, (Key)secretKeySpec, ivParameterSpec);
                    if (debug != null) {
                        debug.text(1L, className, "getCert", "cipher1.size  {0}", (Object)new Integer(cipher2.getOutputSize(byArray3.length)));
                    }
                    byArray = cipher2.doFinal(byArray3);
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.exception(4L, className, "getCert", (Throwable)generalSecurityException);
                }
                throw new PkException(generalSecurityException);
            }
        }
        if (byArray != null) {
            try {
                object2 = CertificateFactory.getInstance("X509", PkEeFactory.getProvider());
                object = new ByteArrayInputStream(byArray);
                return (X509CertImpl)((CertificateFactory)object2).generateCertificate((InputStream)object);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new PkException(noSuchProviderException);
            }
            catch (CertificateException certificateException) {
                throw new PkException(certificateException);
            }
        }
        return null;
    }

    private static void addToTempl(CertTemplate certTemplate, PkAttrs pkAttrs) throws IOException {
        Comparable comparable;
        String string = (String)pkAttrs.getValue("cert.oper.CA_VENDOR", null);
        boolean bl = false;
        if (string != null) {
            bl = string.equalsIgnoreCase("Entrust");
        }
        Object object = pkAttrs.iterator();
        while (((PkAttrs.Iter)object).hasNext()) {
            comparable = ((PkAttrs.Iter)object).nextAttr();
            String string2 = comparable.getName();
            if (!comparable.isApplied() || !comparable.isApproved()) continue;
            Object object2 = comparable.getValue();
            if (string2.startsWith("x509.info.extensions.")) {
                PkCmpEventFormatter.addExtension(certTemplate, comparable);
                continue;
            }
            if (string2.equals("x509.info.version")) {
                certTemplate.setVersion(BigInteger.valueOf(((Integer)object2).intValue()));
                continue;
            }
            if (string2.equals("x509.info.serialNumber")) {
                certTemplate.setSerialNumber((BigInteger)object2);
                continue;
            }
            if (string2.equals("x509.info.algorithmID")) {
                if (debug != null) {
                    debug.text(0L, className, "addToTempl", "#################>>>>>>>>>>>>>>>>>> from addToTempl, algId {0}", (Object)((AlgorithmId)object2));
                }
                if (bl) continue;
                certTemplate.setSigningAlg((AlgorithmId)object2);
                continue;
            }
            if (string2.equals("x509.info.issuer")) {
                certTemplate.setIssuer((X500Name)object2);
                continue;
            }
            if (string2.equals("x509.info.subject")) {
                certTemplate.setSubject((X500Name)object2);
                continue;
            }
            if (string2.equals("x509.info.key")) {
                certTemplate.setPublicKey((PublicKey)object2);
                continue;
            }
            if (string2.equals("x509.info.certrevopublickey")) {
                certTemplate.setPublicKey((PublicKey)object2);
                continue;
            }
            if (string2.equals("x509.info.issuerID")) {
                certTemplate.setIssuerUID(new BitArray(((UniqueIdentity)object2).getId()).toByteArray());
                continue;
            }
            if (string2.equals("x509.info.subjectID")) {
                certTemplate.setSubjectUID(new BitArray(((UniqueIdentity)object2).getId()).toByteArray());
                continue;
            }
            if (string2.equals("x509.info.validity.notBefore")) {
                if (debug == null) continue;
                debug.text(1L, className, "addToTempl", "Unused attribute={0}", (Object)string2);
                continue;
            }
            if (string2.equals("x509.info.validity.notAfter")) {
                if (debug == null) continue;
                debug.text(1L, className, "addToTempl", "Unused attribute={0}", (Object)string2);
                continue;
            }
            if (string2.equals("revo.reasonFlags")) {
                if (debug == null) continue;
                debug.text(1L, className, "addToTempl", "Unused attribute={0}", (Object)string2);
                continue;
            }
            if (string2.equals("revo.badSinceDate")) continue;
            throw new PkIoException(PkNLSConstants.CMPEVENT_BAD_ATTR + string2);
        }
        if (pkAttrs.has("x509.info.validity.notBefore") || pkAttrs.has("x509.info.validity.notAfter")) {
            object = (Date)pkAttrs.getValue("x509.info.validity.notBefore", null);
            comparable = (Date)pkAttrs.getValue("x509.info.validity.notAfter", null);
            certTemplate.setValidity(new OptionalValidity((Date)object, (Date)comparable));
        }
    }

    private static void addExtension(CertTemplate certTemplate, PkAttr pkAttr) throws IOException {
        try {
            certTemplate.addExtension(new Extension[]{(Extension)pkAttr.getValue()});
        }
        catch (IOException iOException) {
            throw new PkIoException(PkNLSConstants.CMPEVENT_MODIFY_ATTR_FAIL + pkAttr.getName() + ":" + pkAttr.getValue(), iOException);
        }
    }

    private static int getBodyType(PkEvent pkEvent) {
        return types.get(pkEvent.getClass());
    }

    private boolean verifyPop(CertReqMessages certReqMessages) throws IOException, PkException {
        boolean bl = false;
        CertReqMsg[] certReqMsgArray = certReqMessages.getCertReqMsgs();
        CertRequest certRequest = certReqMsgArray[0].getCertReq();
        DerOutputStream derOutputStream = new DerOutputStream();
        certRequest.encode((OutputStream)derOutputStream);
        byte[] byArray = derOutputStream.toByteArray();
        POPOSigningKey pOPOSigningKey = (POPOSigningKey)certReqMsgArray[0].getPOP().getPOP();
        byte[] byArray2 = pOPOSigningKey.getSignature();
        try {
            Signature signature = Signature.getInstance("SHA1withDSA", PkEeFactory.getProvider());
            PublicKey publicKey = certRequest.getCertTemplate().getPublicKey();
            signature.initVerify(publicKey);
            signature.update(byArray);
            bl = signature.verify(byArray2);
        }
        catch (Exception exception) {
            if (exception instanceof PkException) {
                throw (PkException)exception;
            }
            throw new PkException(exception);
        }
        if (debug != null) {
            debug.text(1L, className, "verifyPop", "from verifyPOP. verified = {0}", (Object)new Boolean(bl));
        }
        return bl;
    }

    private AlgorithmId generateProtectionAlg(String string) {
        byte[] byArray = "this is a salt".getBytes();
        AlgorithmId algorithmId = new AlgorithmId(AlgorithmId.SHA_oid);
        int n = 1001;
        AlgorithmId algorithmId2 = new AlgorithmId(AlgorithmId.HmacSHA1_oid);
        PBMParameterSpec pBMParameterSpec = new PBMParameterSpec(byArray, algorithmId, n, algorithmId2);
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = AlgorithmParameters.getInstance("PasswordBasedMac", string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.text(1L, className, "generateProtectionAlg", noSuchAlgorithmException.getMessage());
            }
            System.out.println("ERROR : " + noSuchAlgorithmException.toString());
            System.exit(1);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.text(1L, className, "generateProtectionAlg", noSuchProviderException.getMessage());
            }
            System.out.println("ERROR : " + noSuchProviderException.toString());
            System.exit(1);
        }
        try {
            algorithmParameters.init((AlgorithmParameterSpec)pBMParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            System.out.println("ERROR : " + invalidParameterSpecException.toString());
            if (debug != null) {
                debug.text(1L, className, "generateProtectionAlg", invalidParameterSpecException.getMessage());
            }
            System.exit(1);
        }
        AlgorithmId algorithmId3 = null;
        try {
            algorithmId3 = new AlgorithmId(AlgorithmId.PasswordBasedMac_oid, algorithmParameters.getEncoded());
        }
        catch (IOException iOException) {
            System.out.println("ERROR : " + iOException.toString());
            if (debug != null) {
                debug.text(1L, className, "generateProtectionAlg", iOException.getMessage());
            }
            System.exit(1);
        }
        return algorithmId3;
    }

    static {
        types.put(PkCertReqEvent.class, new Integer(0));
        types.put(PkCertRepEvent.class, new Integer(1));
        types.put(PkInitReqEvent.class, new Integer(0));
        types.put(PkInitRepEvent.class, new Integer(1));
        types.put(PkSecnReqEvent.class, new Integer(2));
        types.put(PkSecnRepEvent.class, new Integer(3));
        types.put(PkKupdReqEvent.class, new Integer(7));
        types.put(PkKupdRepEvent.class, new Integer(8));
        types.put(PkKrecReqEvent.class, new Integer(9));
        types.put(PkKrecRepEvent.class, new Integer(10));
        types.put(PkRevoReqEvent.class, new Integer(11));
        types.put(PkRevoRepEvent.class, new Integer(12));
        types.put(PkXcerReqEvent.class, new Integer(13));
        types.put(PkXcerRepEvent.class, new Integer(14));
        types.put(PkGnrlReqEvent.class, new Integer(21));
        types.put(PkGnrlRepEvent.class, new Integer(22));
    }
}

