/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XMBean;

public class XMBeanInfo
extends JPanel {
    private static final Color lightYellow = new Color(255, 255, 128);
    private final int NAME_COLUMN = 0;
    private final int VALUE_COLUMN = 1;
    private final String[] columnNames = new String[]{Messages.NAME, Messages.VALUE};
    private JTable infoTable = new JTable();
    private JTable descTable = new JTable();
    private JPanel infoBorderPanel = new JPanel(new BorderLayout());
    private JPanel descBorderPanel = new JPanel(new BorderLayout());
    private static MBeanInfoTableCellRenderer renderer = new MBeanInfoTableCellRenderer();
    private static TableCellEditor editor = new MBeanInfoTableCellEditor(new JTextField());

    public XMBeanInfo() {
        super(new GridLayout(2, 1));
        Utilities.setAccessibleName(this.infoTable, Messages.MBEAN_INFO);
        Utilities.setAccessibleDescription(this.infoTable, Messages.MBEAN_INFO_DESCRIPTION);
        this.infoTable.setModel(new ReadOnlyDefaultTableModel());
        this.infoTable.setRowSelectionAllowed(false);
        this.infoTable.setColumnSelectionAllowed(false);
        this.infoTable.getTableHeader().setReorderingAllowed(false);
        ((DefaultTableModel)this.infoTable.getModel()).setColumnIdentifiers(this.columnNames);
        this.infoTable.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.infoTable.getColumnModel().getColumn(0).setMaxWidth(140);
        this.infoTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.infoTable.getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.infoTable.getColumnModel().getColumn(0).setCellEditor(editor);
        this.infoTable.getColumnModel().getColumn(1).setCellEditor(editor);
        this.infoTable.addKeyListener(new Utils.CopyKeyAdapter());
        this.infoTable.setAutoResizeMode(2);
        JScrollPane jScrollPane = new JScrollPane(this.infoTable);
        Utilities.setAccessibleName(jScrollPane, Messages.MBEAN_INFO);
        Utilities.setAccessibleDescription(jScrollPane, Messages.MBEAN_INFO_DESCRIPTION);
        Utilities.setAccessibleName(jScrollPane.getViewport(), Messages.MBEAN_INFO);
        Utilities.setAccessibleDescription(jScrollPane.getViewport(), Messages.MBEAN_INFO_DESCRIPTION);
        this.infoBorderPanel.setBorder(BorderFactory.createTitledBorder("MBeanInfoPlaceHolder"));
        this.infoBorderPanel.add(jScrollPane);
        Utilities.setAccessibleName(this.infoBorderPanel, Messages.MBEAN_INFO);
        Utilities.setAccessibleDescription(this.infoBorderPanel, Messages.MBEAN_INFO_DESCRIPTION);
        this.descTable.setModel(new ReadOnlyDefaultTableModel());
        Utilities.setAccessibleName(this.descTable, Messages.MBEAN_DESCRIPTOR);
        Utilities.setAccessibleDescription(this.descTable, Messages.MBEAN_DESCRIPTOR_DESCRIPTION);
        this.descTable.setRowSelectionAllowed(false);
        this.descTable.setColumnSelectionAllowed(false);
        this.descTable.getTableHeader().setReorderingAllowed(false);
        ((DefaultTableModel)this.descTable.getModel()).setColumnIdentifiers(this.columnNames);
        this.descTable.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.descTable.getColumnModel().getColumn(0).setMaxWidth(140);
        this.descTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.descTable.getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.descTable.getColumnModel().getColumn(0).setCellEditor(editor);
        this.descTable.getColumnModel().getColumn(1).setCellEditor(editor);
        this.descTable.addKeyListener(new Utils.CopyKeyAdapter());
        this.descTable.setAutoResizeMode(2);
        JScrollPane jScrollPane2 = new JScrollPane(this.descTable);
        Utilities.setAccessibleName(jScrollPane2, Messages.MBEAN_DESCRIPTOR);
        Utilities.setAccessibleDescription(jScrollPane2, Messages.MBEAN_DESCRIPTOR_DESCRIPTION);
        Utilities.setAccessibleName(jScrollPane2.getViewport(), Messages.MBEAN_DESCRIPTOR);
        Utilities.setAccessibleDescription(jScrollPane2.getViewport(), Messages.MBEAN_DESCRIPTOR_DESCRIPTION);
        this.descBorderPanel.setBorder(BorderFactory.createTitledBorder(Messages.DESCRIPTOR));
        this.descBorderPanel.add(jScrollPane2);
        Utilities.setAccessibleName(this.descBorderPanel, Messages.MBEAN_DESCRIPTOR);
        Utilities.setAccessibleDescription(this.descBorderPanel, Messages.MBEAN_DESCRIPTOR_DESCRIPTION);
        this.add(this.infoBorderPanel);
        this.add(this.descBorderPanel);
    }

    public void emptyInfoTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
    }

    public void emptyDescTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.descTable.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
    }

    private void addDescriptor(Descriptor descriptor, String string) {
        if (descriptor != null && descriptor.getFieldNames().length > 0) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.descTable.getModel();
            Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
            defaultTableModel.addRow(objectArray);
            for (String string2 : descriptor.getFieldNames()) {
                objectArray[0] = string2;
                Object object = descriptor.getFieldValue(string2);
                objectArray[1] = object instanceof boolean[] ? Arrays.toString((boolean[])object) : (object instanceof byte[] ? Arrays.toString((byte[])object) : (object instanceof char[] ? Arrays.toString((char[])object) : (object instanceof double[] ? Arrays.toString((double[])object) : (object instanceof float[] ? Arrays.toString((float[])object) : (object instanceof int[] ? Arrays.toString((int[])object) : (object instanceof long[] ? Arrays.toString((long[])object) : (object instanceof short[] ? Arrays.toString((short[])object) : (object instanceof Object[] ? Arrays.toString((Object[])object) : object))))))));
                defaultTableModel.addRow(objectArray);
            }
            defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
        }
    }

    public void addMBeanInfo(XMBean xMBean, MBeanInfo mBeanInfo) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Messages.MBEAN_INFO);
        String string = Messages.INFO + ":";
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.OBJECT_NAME;
        objectArray[1] = xMBean.getObjectName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.CLASS_NAME;
        objectArray[1] = mBeanInfo.getClassName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.DESCRIPTION;
        objectArray[1] = mBeanInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanInfo.getDescriptor(), string);
        int n = 0;
        for (MBeanConstructorInfo mBeanConstructorInfo : mBeanInfo.getConstructors()) {
            this.addMBeanConstructorInfo(mBeanConstructorInfo, Messages.CONSTRUCTOR + "-" + n + ":");
            int n2 = 0;
            for (MBeanParameterInfo mBeanParameterInfo : mBeanConstructorInfo.getSignature()) {
                this.addMBeanParameterInfo(mBeanParameterInfo, Messages.PARAMETER + "-" + n + "-" + n2 + ":");
                ++n2;
            }
            ++n;
        }
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    public void addMBeanAttributeInfo(MBeanAttributeInfo mBeanAttributeInfo) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Messages.MBEAN_ATTRIBUTE_INFO);
        String string = Messages.ATTRIBUTE + ":";
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.NAME;
        objectArray[1] = mBeanAttributeInfo.getName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.DESCRIPTION;
        objectArray[1] = mBeanAttributeInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.READABLE;
        objectArray[1] = mBeanAttributeInfo.isReadable();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.WRITABLE;
        objectArray[1] = mBeanAttributeInfo.isWritable();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.IS;
        objectArray[1] = mBeanAttributeInfo.isIs();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.TYPE;
        objectArray[1] = mBeanAttributeInfo.getType();
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanAttributeInfo.getDescriptor(), string);
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    public void addMBeanOperationInfo(MBeanOperationInfo mBeanOperationInfo) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Messages.MBEAN_OPERATION_INFO);
        String string = Messages.OPERATION + ":";
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.NAME;
        objectArray[1] = mBeanOperationInfo.getName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.DESCRIPTION;
        objectArray[1] = mBeanOperationInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.IMPACT;
        switch (mBeanOperationInfo.getImpact()) {
            case 0: {
                objectArray[1] = Messages.INFO_CAPITALIZED;
                break;
            }
            case 1: {
                objectArray[1] = Messages.ACTION_CAPITALIZED;
                break;
            }
            case 2: {
                objectArray[1] = Messages.ACTION_INFO_CAPITALIZED;
                break;
            }
            case 3: {
                objectArray[1] = Messages.UNKNOWN_CAPITALIZED;
            }
        }
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.RETURN_TYPE;
        objectArray[1] = mBeanOperationInfo.getReturnType();
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanOperationInfo.getDescriptor(), string);
        int n = 0;
        for (MBeanParameterInfo mBeanParameterInfo : mBeanOperationInfo.getSignature()) {
            this.addMBeanParameterInfo(mBeanParameterInfo, Messages.PARAMETER + "-" + n++ + ":");
        }
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    public void addMBeanNotificationInfo(MBeanNotificationInfo mBeanNotificationInfo) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Messages.MBEAN_NOTIFICATION_INFO);
        String string = Messages.NOTIFICATION + ":";
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.NAME;
        objectArray[1] = mBeanNotificationInfo.getName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.DESCRIPTION;
        objectArray[1] = mBeanNotificationInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.NOTIF_TYPES;
        objectArray[1] = Arrays.toString(mBeanNotificationInfo.getNotifTypes());
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanNotificationInfo.getDescriptor(), string);
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    private void addMBeanConstructorInfo(MBeanConstructorInfo mBeanConstructorInfo, String string) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.NAME;
        objectArray[1] = mBeanConstructorInfo.getName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.DESCRIPTION;
        objectArray[1] = mBeanConstructorInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanConstructorInfo.getDescriptor(), string);
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    private void addMBeanParameterInfo(MBeanParameterInfo mBeanParameterInfo, String string) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.NAME;
        objectArray[1] = mBeanParameterInfo.getName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.DESCRIPTION;
        objectArray[1] = mBeanParameterInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Messages.TYPE;
        objectArray[1] = mBeanParameterInfo.getType();
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanParameterInfo.getDescriptor(), string);
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    private static class MBeanInfoTableCellEditor
    extends Utils.ReadOnlyTableCellEditor {
        public MBeanInfoTableCellEditor(JTextField jTextField) {
            super(jTextField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (object instanceof TableRowDivider) {
                JLabel jLabel = new JLabel(object.toString());
                jLabel.setBackground(Utilities.ensureContrast(lightYellow, jLabel.getForeground()));
                jLabel.setOpaque(true);
                return jLabel;
            }
            return component;
        }
    }

    private static class MBeanInfoTableCellRenderer
    extends DefaultTableCellRenderer {
        private MBeanInfoTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof TableRowDivider) {
                JLabel jLabel = new JLabel(object.toString());
                jLabel.setBackground(Utilities.ensureContrast(lightYellow, jLabel.getForeground()));
                jLabel.setOpaque(true);
                return jLabel;
            }
            return component;
        }
    }

    private static class TableRowDivider {
        private String tableRowDividerText;

        public TableRowDivider(String string) {
            this.tableRowDividerText = string;
        }

        public String toString() {
            return this.tableRowDividerText;
        }
    }

    private static class ReadOnlyDefaultTableModel
    extends DefaultTableModel {
        private ReadOnlyDefaultTableModel() {
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

