/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.misc.BASE64Decoder;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class X509Factory
extends CertificateFactorySpi {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static int defaultExpectedLineLength = 80;
    private String prov = null;
    private static char[] endBoundary = new char[]{'-', '-', '-', '-', '-', 'E', 'N', 'D'};
    private Iterator supported_encodings;
    protected static final String pkcs7String = "PKCS7";
    protected static final String pkipString = "PkiPath";
    protected static final String x509String = "X.509";
    private ArrayList supported_encodings_vector = new ArrayList(2);
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.X509Factory";

    public X509Factory() {
        this.supported_encodings_vector.add(pkipString);
        this.supported_encodings_vector.add(pkcs7String);
        this.supported_encodings = Collections.unmodifiableList(this.supported_encodings_vector).iterator();
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream is) throws CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateCertificate", is);
        }
        if (is == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateCertificate", "Missing input stream");
            }
            throw new CertificateException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            if (this.isBase64(is)) {
                byte[] data = this.base64_to_binary(is);
                X509CertImpl result = new X509CertImpl(data);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertificate1", result);
                }
                return result;
            }
            X509CertImpl result = new X509CertImpl(is);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertificate2", result);
            }
            return result;
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCertificate", ioe);
            }
            throw new CertificateException(ioe.getMessage());
        }
    }

    public Collection engineGenerateCertificates(InputStream is) throws CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateCertificates", is);
        }
        if (is == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateCertificates", "Missing input stream");
            }
            throw new CertificateException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            if (this.isBase64(is)) {
                byte[] data = this.base64_to_binary(is);
                Collection result = this.parseX509orPKCS7Cert(new ByteArrayInputStream(data));
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertificates", result);
                }
                return result;
            }
            Collection result = this.parseX509orPKCS7Cert(is);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertificates", result);
            }
            return result;
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCertificates", ioe);
            }
            throw new CertificateException(ioe.getMessage());
        }
    }

    @Override
    public CRL engineGenerateCRL(InputStream is) throws CRLException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateCRL", is);
        }
        if (is == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateCRL", "Missing input stream");
            }
            throw new CRLException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            if (this.isBase64(is)) {
                byte[] data = this.base64_to_binary(is);
                X509CRLImpl result = new X509CRLImpl(data);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCRL", result);
                }
                return result;
            }
            X509CRLImpl result = new X509CRLImpl(is);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCRL", result);
            }
            return result;
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCRL", ioe);
            }
            throw new CRLException(ioe.getMessage());
        }
    }

    public Collection engineGenerateCRLs(InputStream is) throws CRLException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateCRLs", is);
        }
        if (is == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateCRLs", "Missing input stream");
            }
            throw new CRLException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            if (this.isBase64(is)) {
                byte[] data = this.base64_to_binary(is);
                Collection result = this.parseX509orPKCS7CRL(new ByteArrayInputStream(data));
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCRLs", result);
                }
                return result;
            }
            Collection result = this.parseX509orPKCS7CRL(is);
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateCRLs", result);
            }
            return result;
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateCRLs", ioe);
            }
            throw new CRLException(ioe.getMessage());
        }
    }

    private Collection parseX509orPKCS7Cert(InputStream is) throws CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "parseX509orPKCS7Cert", is);
        }
        try {
            is.mark(is.available());
            X509CertImpl cert = new X509CertImpl(is);
            List<X509Certificate> result = Arrays.asList(cert);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "parseX509orPKCS7Cert", result);
            }
            return result;
        }
        catch (CertificateException e) {
            try {
                is.reset();
                byte[] data = new byte[is.available()];
                is.read(data);
                SignedData pkcs7data = new SignedData(data);
                X509Certificate[] certs = (X509Certificate[])pkcs7data.getCertificates();
                if (certs != null) {
                    List<X509Certificate> result = Arrays.asList(certs);
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "parseX509orPKCS7Cert", result);
                    }
                    return result;
                }
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "parseX509orPKCS7Cert", new ArrayList(0));
                }
                return new ArrayList(0);
            }
            catch (IOException ioe) {
                if (debug != null) {
                    debug.exception(8192L, className, "parseX509orPKCS7Cert", ioe);
                }
                throw new CertificateException(ioe.getMessage());
            }
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(8192L, className, "parseX509orPKCS7Cert", ioe);
            }
            throw new CertificateException(ioe.getMessage());
        }
    }

    private Collection parseX509orPKCS7CRL(InputStream is) throws CRLException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "parseX509orPKCS7CRL", is);
        }
        try {
            is.mark(is.available());
            X509CRLImpl crl = new X509CRLImpl(is);
            List<X509CRL> result = Arrays.asList(crl);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "parseX509orPKCS7CRL", result);
            }
            return result;
        }
        catch (CRLException e) {
            try {
                is.reset();
                byte[] data = new byte[is.available()];
                is.read(data);
                SignedData pkcs7data = new SignedData(data);
                X509CRL[] crls = (X509CRL[])pkcs7data.getCRLs();
                if (crls != null) {
                    List<X509CRL> result = Arrays.asList(crls);
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "parseX509orPKCS7CRL", result);
                    }
                    return result;
                }
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "parseX509orPKCS7CRL", new ArrayList(0));
                }
                return new ArrayList(0);
            }
            catch (IOException ioe) {
                if (debug != null) {
                    debug.exception(8192L, className, "parseX509orPKCS7CRL CRLException", ioe);
                }
                throw new CRLException(ioe.getMessage());
            }
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(8192L, className, "parseX509orPKCS7CRL", ioe);
            }
            throw new CRLException(ioe.getMessage());
        }
    }

    private byte[] base64_to_binary(InputStream is) throws IOException {
        InputStreamReader isr;
        block11: {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "base64_to_binary", is);
            }
            long len = 0L;
            is.mark(is.available());
            BufferedInputStream bufin = new BufferedInputStream(is);
            isr = null;
            try {
                if (this.getBase64Codepage(is).equalsIgnoreCase("8859_1")) {
                    isr = new InputStreamReader((InputStream)bufin, "8859_1");
                    break block11;
                }
                if (this.getBase64Codepage(is).equalsIgnoreCase("IBM-1047")) {
                    isr = new InputStreamReader((InputStream)bufin, "IBM-1047");
                    break block11;
                }
                throw new IOException("Unsupported codepage for encoding.");
            }
            catch (UnsupportedEncodingException e) {
                isr = new InputStreamReader(bufin);
            }
        }
        BufferedReader br = new BufferedReader(isr);
        String temp = this.readLine(br);
        if (temp == null || !temp.startsWith("-----BEGIN")) {
            if (debug != null) {
                debug.text(8192L, className, "base64_to_binary", "Unsupported encoding");
            }
            throw new IOException("Unsupported encoding");
        }
        len += (long)temp.length();
        StringBuffer strBuf = new StringBuffer();
        while ((temp = this.readLine(br)) != null && !temp.startsWith("-----END")) {
            strBuf.append(temp);
        }
        if (temp == null) {
            if (debug != null) {
                debug.text(8192L, className, "base64_to_binary", "Unsupported encoding");
            }
            throw new IOException("Unsupported encoding");
        }
        len += (long)temp.length();
        is.reset();
        is.skip(len += (long)strBuf.length());
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] result = decoder.decodeBuffer(strBuf.toString());
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "base64_to_binary", result);
        }
        return result;
    }

    private byte[] getTotalBytes(InputStream is) throws IOException {
        int n;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "getTotalBytes", is);
        }
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        baos.reset();
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, n);
        }
        byte[] result = baos.toByteArray();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "getTotalBytes", result);
        }
        return result;
    }

    private boolean isBase64(InputStream is) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "isBase64", is);
        }
        if (is.available() >= 10) {
            is.mark(10);
            int c1 = is.read();
            int c2 = is.read();
            int c3 = is.read();
            int c4 = is.read();
            int c5 = is.read();
            int c6 = is.read();
            int c7 = is.read();
            int c8 = is.read();
            int c9 = is.read();
            int c10 = is.read();
            is.reset();
            if (c1 == 45 && c2 == 45 && c3 == 45 && c4 == 45 && c5 == 45 && c6 == 66 && c7 == 69 && c8 == 71 && c9 == 73 && c10 == 78) {
                if (debug != null) {
                    debug.text(8192L, className, "isBase64", "ASCII Encoding detected.");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "isBase64", true);
                }
                return true;
            }
            if (c1 == 96 && c2 == 96 && c3 == 96 && c4 == 96 && c5 == 96 && c6 == 194 && c7 == 197 && c8 == 199 && c9 == 201 && c10 == 213) {
                if (debug != null) {
                    debug.text(8192L, className, "isBase64", "EBCDIC Encoding detected.");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "isBase64", true);
                }
                return true;
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "isBase64", false);
            }
            return false;
        }
        IOException ioe = new IOException("Cannot determine encoding format.");
        if (debug != null) {
            debug.text(8192L, className, "isBase64", "Unknown Encoding.");
            debug.exception(8192L, className, "isBase64", ioe);
        }
        throw ioe;
    }

    private String getBase64Codepage(InputStream is) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "getBase64Codepage", is);
        }
        if (is.available() >= 1) {
            is.mark(1);
            int c1 = is.read();
            is.reset();
            if (c1 == 45) {
                if (debug != null) {
                    debug.text(8192L, className, "getBase64Codepage", "ASCII Encoding detected.");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "getBase64Codepage", true);
                }
                return "8859_1";
            }
            if (c1 == 96) {
                if (debug != null) {
                    debug.text(8192L, className, "getBase64Codepage", "EBCDIC Encoding detected.");
                    debug.exit(Debug.TYPE_FINE, (Object)className, "getBase64Codepage", true);
                }
                return "IBM-1047";
            }
            IOException ioe = new IOException("Unknown Encoding.");
            if (debug != null) {
                debug.text(8192L, className, "getBase64Codepage", "Unknown Encoding.");
                debug.exception(8192L, className, "getBase64Codepage", ioe);
            }
            throw ioe;
        }
        IOException ioe = new IOException("Cannot determine encoding format.");
        if (debug != null) {
            debug.text(8192L, className, "getBase64Codepage", "Cannot determine encoding format.");
            debug.exception(8192L, className, "getBase64Codepage", ioe);
        }
        throw ioe;
    }

    private String readLine(BufferedReader br) throws IOException {
        int c;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINER, (Object)className, "readLine", br);
        }
        int i = 0;
        boolean isMatch = true;
        boolean matched = false;
        StringBuffer sb = new StringBuffer(defaultExpectedLineLength);
        do {
            c = br.read();
            if (isMatch && i < endBoundary.length) {
                boolean bl = isMatch = (char)c == endBoundary[i++];
            }
            if (!matched) {
                matched = isMatch && i == endBoundary.length;
            }
            sb.append((char)c);
        } while (c != -1 && c != 10 && c != 13);
        if (!matched && c == -1) {
            return null;
        }
        if (c == 13) {
            br.mark(1);
            int c2 = br.read();
            if (c2 == 10) {
                sb.append((char)c);
            } else {
                br.reset();
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINER, (Object)className, "readLine ", sb.toString());
        }
        return sb.toString();
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath ", inStream);
        }
        if (inStream == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath ", "Input Stream is null");
            }
            throw new CertificateException("input stream is null");
        }
        Class<?> certPathImplCls = null;
        Constructor<?> constructor = null;
        try {
            byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(inStream));
            ByteArrayInputStream bais = new ByteArrayInputStream(totalBytes);
            if (this.isBase64(bais)) {
                totalBytes = this.base64_to_binary(bais);
            }
            DerInputStream dis = new DerInputStream(totalBytes);
            DerValue[] seq = dis.getSequence(3);
            Object[] params = new Object[2];
            try {
                certPathImplCls = Class.forName("com.ibm.security.cert.CertPathImpl");
                if (certPathImplCls == null) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath1 ", null);
                    }
                    return null;
                }
                Class[] ctrParams = new Class[]{String.class, List.class};
                constructor = certPathImplCls.getDeclaredConstructor(ctrParams);
                if (constructor == null) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath2 ", null);
                    }
                    return null;
                }
                constructor.setAccessible(true);
            }
            catch (Exception ee) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath3 ", null);
                }
                return null;
            }
            if (seq.length == 0) {
                params[0] = x509String;
                params[1] = Collections.EMPTY_LIST;
                CertPath cp = null;
                try {
                    cp = (CertPath)constructor.newInstance(params);
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath4 ", cp);
                    }
                    return cp;
                }
                catch (InstantiationException ie) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath", ie);
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath5 ", null);
                    }
                    return null;
                }
                catch (IllegalAccessException ie) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath", ie);
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath6 ", null);
                    }
                    return null;
                }
                catch (IllegalArgumentException ie) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath", ie);
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath7 ", null);
                    }
                    return null;
                }
                catch (InvocationTargetException ee) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath", ee);
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath8 ", null);
                    }
                    return null;
                }
            }
            ArrayList<Certificate> certList = new ArrayList<Certificate>(seq.length);
            for (int i = seq.length - 1; i >= 0; --i) {
                ByteArrayInputStream bis = new ByteArrayInputStream(seq[i].toByteArray());
                certList.add(this.engineGenerateCertificate(bis));
                bis.close();
            }
            params[0] = x509String;
            params[1] = Collections.unmodifiableList(certList);
            CertPath cp = null;
            try {
                cp = (CertPath)constructor.newInstance(params);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath9 ", cp);
                }
                return cp;
            }
            catch (Exception ee) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath", ee);
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath10 ", null);
                }
                return null;
            }
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath", ioe);
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath", "IOException parsing PkiPath data: " + ioe);
            }
            throw new CertificateException("IOException parsing PkiPath data: " + ioe);
        }
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        CertPath certPath = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGenerateCertPath ", inStream, encoding);
        }
        if (encoding.equals(pkcs7String)) {
            Collection certCollection = this.engineGenerateCertificates(inStream);
            LinkedList<X509Certificate> myList = new LinkedList<X509Certificate>();
            for (X509Certificate thisCert : certCollection) {
                myList.add(thisCert);
            }
            certPath = this.engineGenerateCertPath(myList);
        } else if (encoding.equals(pkipString)) {
            certPath = this.engineGenerateCertPath(inStream);
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath ", "Encoding: " + encoding + " not valid.");
            }
            throw new CertificateException("Encoding: " + encoding + " not valid.");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath ", certPath);
        }
        return certPath;
    }

    public CertPath engineGenerateCertPath(List certificates) throws CertificateException {
        Object[] params;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath ", certificates);
        }
        LinkedList<X509Certificate> certPathList = new LinkedList<X509Certificate>();
        X509Certificate[] certs = new X509Certificate[certificates.size()];
        boolean match = false;
        boolean matchCount = false;
        int numberOfCertificates = certificates.size();
        boolean numberOfCertificatesAdded = false;
        boolean ordered = false;
        try {
            certificates.toArray(certs);
        }
        catch (ArrayStoreException asex) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath", asex);
                debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath", "Not X.509 certificates");
            }
            throw new CertificateException("Not X.509 certificates");
        }
        for (int i = 0; i < certs.length; ++i) {
            certPathList.add(certs[i]);
        }
        Class<?> certPathImplCls = null;
        Constructor<?> constructor = null;
        try {
            certPathImplCls = Class.forName("com.ibm.security.cert.CertPathImpl");
            if (certPathImplCls == null) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath1", null);
                }
                return null;
            }
            params = new Class[]{String.class, List.class};
            constructor = certPathImplCls.getDeclaredConstructor((Class<?>[])params);
            constructor.setAccessible(true);
        }
        catch (Exception ee) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath", ee);
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath2", null);
            }
            return null;
        }
        params = new Object[]{x509String, certPathList};
        CertPath cp = null;
        try {
            cp = (CertPath)constructor.newInstance(params);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath", cp);
            }
            return cp;
        }
        catch (Exception ee) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateCertPath", ee);
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath4", null);
            }
            return null;
        }
    }

    public Iterator engineGetCertPathEncodings() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGenerateCertPath");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateCertPath", this.supported_encodings);
        }
        return this.supported_encodings;
    }
}

