/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.TR31OptionalDataBlock;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.security.InvalidParameterException;

public class TR31KeyBlock {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.TR31KeyBlock";
    private HIKM hikm = new HIKM();
    private byte[] keyBlock = null;
    private String blockVersion = null;
    private int keyBlockLength = -1;
    private String keyUsage = null;
    private String keyAlgorithm = null;
    private String keyMode = null;
    private String keyVersion = null;
    private String keyExportablility = null;
    private int numOptDataBlocks = 0;
    private String[] optDataBlockIDs = null;
    private int[] optDataBlockLengths = null;
    private TR31OptionalDataBlock[] optDataBlocks = null;

    public TR31KeyBlock(byte[] TR31_KeyBlockBytes) {
        HexDumpEncoder encoder = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "TR31KeyBlock");
            encoder = new HexDumpEncoder();
        }
        if (null == TR31_KeyBlockBytes || 0 == TR31_KeyBlockBytes.length) {
            InvalidParameterException ipe = new InvalidParameterException("The input TR31_KeyBlockBytes must not be empty");
            if (debug != null) {
                debug.exception(Debug.TYPE_FINER, className, "TR31KeyBlock", ipe);
            }
            throw ipe;
        }
        int givenKeyBlock_Length = TR31_KeyBlockBytes.length;
        if (16 > givenKeyBlock_Length || 9992 < givenKeyBlock_Length) {
            InvalidParameterException ipe = new InvalidParameterException("The input TR31_KeyBlockBytes is " + givenKeyBlock_Length + " bytes. It must not be shorter than 16 bytes or longer than 9992 bytes");
            if (debug != null) {
                debug.exception(Debug.TYPE_FINER, className, "TR31KeyBlock", ipe);
            }
            throw ipe;
        }
        if (!HardwareProfile.getIsHCR7790OrLaterPresent()) {
            RuntimeException e = new RuntimeException("System Error: TR-31 KeyBlock parsing is not supported before HCR7790.");
            if (debug != null) {
                debug.exception(Debug.TYPE_FINER, className, "TR31KeyBlock", e);
            }
            throw e;
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger TR31_keyblock_length = new hikmNativeInteger(givenKeyBlock_Length);
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(0);
        byte[] ruleArray = new byte[]{};
        byte[] blk_version = new byte[1];
        hikmNativeInteger blk_length = new hikmNativeInteger(0);
        byte[] key_usage = new byte[2];
        byte[] key_algorithm = new byte[1];
        byte[] key_mode = new byte[1];
        byte[] key_version = new byte[2];
        byte[] key_exportability = new byte[1];
        hikmNativeInteger num_data_blocks = new hikmNativeInteger(0);
        if (null != debug) {
            String ruleArrayString = "NULL";
            if (null != ruleArray) {
                ruleArrayString = encoder.encodeBuffer(ruleArray);
            }
            String tr31KeyBlockString = encoder.encodeBuffer(TR31_KeyBlockBytes);
            String parmsReport = "\nTR31KeyBlock: CSNBT31P INPUT PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    ruleArrayCnt   : " + ruleArrayCount.getValue() + "\n    ruleArray      : \n" + ruleArrayString + "\n    TR31KeyBlockLen: " + TR31_keyblock_length.getValue() + "\n    TR31KeyBlock   : \n" + tr31KeyBlockString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "TR31KeyBlock", parmsReport);
        }
        try {
            this.hikm.CSNBT31PJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, TR31_keyblock_length, TR31_KeyBlockBytes, blk_version, blk_length, key_usage, key_algorithm, key_mode, key_version, key_exportability, num_data_blocks);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "TR31KeyBlock", e);
            }
            throw new RuntimeException("Hardware error from call CSNBT31P " + e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "TR31KeyBlock", "CSNBT31P: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        if (null != debug) {
            String exitDataString = "NULL";
            if (null != exitData) {
                exitDataString = encoder.encodeBuffer(exitData);
            }
            String blk_versionString = "NULL";
            if (null != blk_version) {
                blk_versionString = encoder.encodeBuffer(blk_version);
            }
            String key_usageString = "NULL";
            if (null != key_usage) {
                key_usageString = encoder.encodeBuffer(key_usage);
            }
            String key_algorithmString = "NULL";
            if (null != key_algorithm) {
                key_algorithmString = encoder.encodeBuffer(key_algorithm);
            }
            String key_modeString = "NULL";
            if (null != key_mode) {
                key_modeString = encoder.encodeBuffer(key_mode);
            }
            String key_versionString = "NULL";
            if (null != key_version) {
                key_versionString = encoder.encodeBuffer(key_version);
            }
            String key_exportabilityString = "NULL";
            if (null != key_exportability) {
                key_exportabilityString = encoder.encodeBuffer(key_exportability);
            }
            String parmsReport = "\nTR31KeyBlock: CSNBT31P RETURN PARAMETERS \n    returnCode      : " + returnCode.getValue() + "\n    reasonCode      : " + reasonCode.getValue() + "\n    exitDataLen     : " + exitDataLength.getValue() + "\n    exitData        : " + exitDataString + "\n    blockVersion    : " + blk_versionString + "\n    blockLength     : " + blk_length.getValue() + "\n    keyUsage        : " + key_usageString + "\n    keyAlgorithm    : " + key_algorithmString + "\n    keyMode         : " + key_modeString + "\n    keyVersion      : " + key_versionString + "\n    keyExportability: " + key_exportabilityString + "\n    NumOptDataBlks  : " + num_data_blocks.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "TR31KeyBlock", parmsReport);
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNBT31P", "Hardware error from call CSNBT31P returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "TR31KeyBlock", re);
                debug.exit(8192L, className, "TR31KeyBlock");
            }
            throw re;
        }
        this.blockVersion = PlatformUtilities.getString(blk_version);
        this.keyBlockLength = blk_length.getValue();
        this.keyUsage = PlatformUtilities.getString(key_usage);
        this.keyAlgorithm = PlatformUtilities.getString(key_algorithm);
        this.keyMode = PlatformUtilities.getString(key_mode);
        this.keyVersion = PlatformUtilities.getString(key_version);
        this.keyExportablility = PlatformUtilities.getString(key_exportability);
        this.numOptDataBlocks = num_data_blocks.getValue();
        this.keyBlock = new byte[this.keyBlockLength];
        for (int kbIdx = 0; kbIdx < this.keyBlockLength; ++kbIdx) {
            this.keyBlock[kbIdx] = TR31_KeyBlockBytes[kbIdx];
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "TR31KeyBlock");
        }
    }

    public String getKeyBlockVersion() {
        return this.blockVersion;
    }

    public int getKeyBlockLength() {
        return this.keyBlockLength;
    }

    public String getKeyUsage() {
        return this.keyUsage;
    }

    public String getKeyUsageAsString() {
        if ("D0".equals(this.keyUsage)) {
            return "DataEncryptionKey";
        }
        if ("K0".equals(this.keyUsage)) {
            return "KeyEcryptingKey";
        }
        return "UnrecognizedKeyUsage";
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public String getKeyAlgorithmAsString() {
        if ("D".equals(this.keyAlgorithm)) {
            return "Single-DES";
        }
        if ("T".equals(this.keyAlgorithm)) {
            return "Triple-DES";
        }
        return "UnsupportedAlgorithm";
    }

    public String getKeyMode() {
        return this.keyMode;
    }

    public String getKeyModeAsString() {
        if ("B".equals(this.keyMode)) {
            return "EncryptDecrypt";
        }
        if ("E".equals(this.keyMode)) {
            return "Exporter";
        }
        if ("D".equals(this.keyMode)) {
            return "Importer";
        }
        return "UnrecognizedKeyMode";
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public String getKeyExportability() {
        return this.keyExportablility;
    }

    public String getKeyExportabilityAsString() {
        if ("N".equals(this.keyExportablility)) {
            return "Not exportable";
        }
        if ("E".equals(this.keyExportablility)) {
            return "Exportable under trusted key";
        }
        if ("S".equals(this.keyExportablility)) {
            return "Exportable under any key";
        }
        return "UnrecognizedKeyExportability";
    }

    public int getNumOptDataBlocks() {
        return this.numOptDataBlocks;
    }

    public TR31OptionalDataBlock[] getOptDataBlocks() {
        if (0 == this.numOptDataBlocks) {
            return new TR31OptionalDataBlock[0];
        }
        this.optDataBlocks = new TR31OptionalDataBlock[this.numOptDataBlocks];
        this.optDataBlockIDs = new String[this.numOptDataBlocks];
        this.optDataBlockLengths = new int[this.numOptDataBlocks];
        this.getOptDataInfo();
        int idx = -1;
        try {
            for (idx = 0; idx < this.numOptDataBlocks; ++idx) {
                this.optDataBlocks[idx] = this.getOptDataBlock(this.optDataBlockIDs[idx], this.optDataBlockLengths[idx]);
            }
        }
        catch (Exception ex) {
            RuntimeException re = new RuntimeException("Exception extracting OptionalDataBlock # " + idx + ", ID = " + this.optDataBlockIDs[idx] + ", length = " + this.optDataBlockLengths[idx], ex);
            if (debug != null) {
                debug.exception(Debug.TYPE_FINER, className, "getOptDataBlocks", re);
            }
            throw re;
        }
        TR31OptionalDataBlock[] retValue = new TR31OptionalDataBlock[this.numOptDataBlocks];
        for (int vIdx = 0; vIdx < this.numOptDataBlocks; ++vIdx) {
            TR31OptionalDataBlock val;
            retValue[vIdx] = val = new TR31OptionalDataBlock(this.optDataBlocks[vIdx].getOptDataID(), this.optDataBlocks[vIdx].getOptData());
        }
        return retValue;
    }

    private int getOptDataInfo() {
        HexDumpEncoder encoder = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getOptDataInfo");
            encoder = new HexDumpEncoder();
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger keyblock_length = new hikmNativeInteger(this.keyBlockLength);
        hikmNativeInteger num_dataBlocks = new hikmNativeInteger(this.numOptDataBlocks);
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
        byte[] ruleArray = PlatformUtilities.getBytesPlatform("INFO    ");
        byte[][] block_IDs = new byte[this.numOptDataBlocks][];
        for (int blIdx = 0; blIdx < block_IDs.length; ++blIdx) {
            block_IDs[blIdx] = new byte[2];
            block_IDs[blIdx][0] = 0;
            block_IDs[blIdx][1] = 0;
        }
        char[] block_lens = new char[this.numOptDataBlocks];
        for (int blIdx = 0; blIdx < this.numOptDataBlocks; ++blIdx) {
            block_lens[blIdx] = '\u0000';
        }
        byte[] opt_block_ID = new byte[]{0, 0};
        hikmNativeInteger opt_block_len = new hikmNativeInteger(0);
        byte[] opt_block_data = new byte[]{};
        if (null != debug) {
            String ruleArrayString = encoder.encodeBuffer(ruleArray);
            String tr31KeyBlockString = encoder.encodeBuffer(this.keyBlock);
            String optBlockInfoString = "NULL";
            if (0 < this.numOptDataBlocks) {
                StringBuilder sb;
                block24: {
                    sb = new StringBuilder();
                    int biIdx = -1;
                    try {
                        for (biIdx = 0; biIdx < this.numOptDataBlocks; ++biIdx) {
                            byte[] bID = new byte[]{block_IDs[biIdx][0], block_IDs[biIdx][1]};
                            sb.append("\n    ");
                            sb.append("BlkID: ");
                            sb.append(PlatformUtilities.getString(bID));
                            sb.append("  BlkLen: ");
                            sb.append(block_lens[biIdx] + "");
                        }
                    }
                    catch (Exception ex) {
                        if (debug == null) break block24;
                        RuntimeException re = new RuntimeException("Exception caught while tracing ID and length for optional block # " + biIdx, ex);
                        debug.exception(Debug.TYPE_PUBLIC, className, "getOptDataInfo", re);
                    }
                }
                optBlockInfoString = sb.toString();
            }
            String parmsReport = "\nTR31KeyBlock: CSNBT31R INPUT PARAMETERS \n    returnCode      : " + returnCode.getValue() + "\n    reasonCode      : " + reasonCode.getValue() + "\n    ruleArrayCnt    : " + ruleArrayCount.getValue() + "\n    ruleArray       : \n" + ruleArrayString + "\n    NumOptDataBlks  : " + num_dataBlocks.getValue() + "\n    keyblock_length : " + keyblock_length.getValue() + "\n    keyBlock        : \n" + tr31KeyBlockString + "\n    optDataBlockInfo: " + optBlockInfoString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "getOptDataInfo", parmsReport);
        }
        try {
            this.hikm.CSNBT31RJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, keyblock_length, this.keyBlock, opt_block_ID, num_dataBlocks, block_IDs, block_lens, opt_block_len, opt_block_data);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getOptDataInfo", e);
            }
            throw new RuntimeException("Hardware error from call CSNBT31R " + e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "getOptDataInfo", "CSNBT31R: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        if (null != debug) {
            StringBuilder sb;
            String optBlockInfoString;
            String exitDataString;
            block25: {
                exitDataString = "NULL";
                if (null != exitData) {
                    exitDataString = encoder.encodeBuffer(exitData);
                }
                optBlockInfoString = "";
                sb = new StringBuilder();
                int biIdx = -1;
                try {
                    for (biIdx = 0; biIdx < this.numOptDataBlocks; ++biIdx) {
                        byte[] bID = new byte[]{block_IDs[biIdx][0], block_IDs[biIdx][1]};
                        sb.append("\n    ");
                        sb.append("BlkID: ");
                        sb.append(PlatformUtilities.getString(bID));
                        sb.append("  BlkLen: ");
                        sb.append(block_lens[biIdx] + "");
                    }
                }
                catch (Exception ex) {
                    if (debug == null) break block25;
                    RuntimeException re = new RuntimeException("Exception caught while tracing ID and length for optional block # " + biIdx, ex);
                    debug.exception(Debug.TYPE_PUBLIC, className, "getOptDataInfo", re);
                }
            }
            optBlockInfoString = sb.toString();
            String parmsReport = "\nTR31KeyBlock: CSNBT31R RETURN PARAMETERS \n    returnCode      : " + returnCode.getValue() + "\n    reasonCode      : " + reasonCode.getValue() + "\n    exitDataLen     : " + exitDataLength.getValue() + "\n    exitData        : " + exitDataString + "\n    NumOptDataBlks  : " + num_dataBlocks.getValue() + "\n    optDataBlockInfo: " + optBlockInfoString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "getOptDataInfo", parmsReport);
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNBT31R", "Hardware error from call CSNBT31R returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "getOptDataInfo", re);
                debug.exit(8192L, className, "getOptDataInfo");
            }
            throw re;
        }
        this.optDataBlockIDs = new String[this.numOptDataBlocks];
        this.optDataBlockLengths = new int[this.numOptDataBlocks];
        int idx = -1;
        try {
            for (idx = 0; idx < this.numOptDataBlocks; ++idx) {
                this.optDataBlockIDs[idx] = PlatformUtilities.getString(block_IDs[idx]);
                this.optDataBlockLengths[idx] = block_lens[idx];
            }
        }
        catch (Exception ex) {
            RuntimeException re = new RuntimeException("Exception retrieving info for OptionalDataBlock # " + idx + " from values returned from successful CSNBT31R call.", ex);
            if (debug != null) {
                debug.exception(Debug.TYPE_FINER, className, "getOptDataInfo", re);
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "getOptDataInfo");
        }
        return this.numOptDataBlocks;
    }

    private TR31OptionalDataBlock getOptDataBlock(String optBlkID, int optBlkLen) {
        HexDumpEncoder encoder = null;
        TR31OptionalDataBlock result = null;
        if (4 == optBlkLen) {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, "getOptDataBlock(1)", optBlkID, optBlkLen);
            }
            result = new TR31OptionalDataBlock(optBlkID, "");
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getOptDataBlock(1)", result);
            }
            return result;
        }
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getOptDataBlock(2)", optBlkID, optBlkLen);
            encoder = new HexDumpEncoder();
        }
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger keyblock_length = new hikmNativeInteger(this.keyBlockLength);
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
        byte[] ruleArray = PlatformUtilities.getBytesPlatform("DATA    ");
        hikmNativeInteger opt_block_len = new hikmNativeInteger(optBlkLen * 4);
        byte[] opt_block_data = new byte[optBlkLen * 4];
        byte[] opt_block_ID = PlatformUtilities.getBytesPlatform(optBlkID);
        byte[][] block_IDs = new byte[0][0];
        char[] block_lens = new char[]{};
        hikmNativeInteger num_dataBlocks = new hikmNativeInteger(0);
        if (null != debug) {
            String ruleArrayString = encoder.encodeBuffer(ruleArray);
            String tr31KeyBlockString = encoder.encodeBuffer(this.keyBlock);
            String optBlockIDString = encoder.encodeBuffer(opt_block_ID);
            String parmsReport = "\nTR31KeyBlock: CSNBT31R INPUT PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    ruleArrayCnt   : " + ruleArrayCount.getValue() + "\n    ruleArray      : \n" + ruleArrayString + "\n    keyblock_length: " + keyblock_length.getValue() + "\n    keyBlock       : \n" + tr31KeyBlockString + "\n    optblk_data_len: " + opt_block_len.getValue() + "\n    optBlock_ID    : " + optBlockIDString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "getOptDataBlock", parmsReport);
        }
        try {
            this.hikm.CSNBT31RJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, keyblock_length, this.keyBlock, opt_block_ID, num_dataBlocks, block_IDs, block_lens, opt_block_len, opt_block_data);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getOptDataInfo", e);
            }
            throw new RuntimeException("Hardware error from call CSNBT31R " + e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "getOptDataBlock", "CSNBT31R: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        if (null != debug) {
            String optBlockIDString = encoder.encodeBuffer(opt_block_ID);
            String optBlockDataString = encoder.encodeBuffer(opt_block_data);
            String parmsReport = "\nTR31KeyBlock: CSNBT31R RETURN PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    optblock_length: " + keyblock_length.getValue() + "\n    optBlock_ID    : " + optBlockIDString + "\n    optblk_data_len: " + opt_block_len.getValue() + "\n    optBlock_data  : \n" + optBlockDataString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "getOptDataBlock", parmsReport);
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNBT31R", "Hardware error from call CSNBT31R returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "getOptDataBlock", re);
                debug.exit(8192L, className, "getOptDataBlock");
            }
            throw re;
        }
        int trimmedLen = opt_block_len.getValue();
        byte[] trimmed_opt_block_data = new byte[trimmedLen];
        for (int tri = 0; tri < trimmedLen; ++tri) {
            trimmed_opt_block_data[tri] = opt_block_data[tri];
        }
        result = new TR31OptionalDataBlock(PlatformUtilities.getString(opt_block_ID), PlatformUtilities.getString(trimmed_opt_block_data));
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "getOptDataBlock(2)");
        }
        return result;
    }

    public String toString() {
        if (0 < this.numOptDataBlocks && null == this.optDataBlocks) {
            this.getOptDataBlocks();
        }
        String lineSeparator = "\n";
        String indent = "    ";
        StringBuilder sb = 0 < this.numOptDataBlocks ? new StringBuilder(1024) : new StringBuilder(512);
        sb.append("TR31KeyBlock: ");
        sb.append(lineSeparator);
        sb.append(indent);
        sb.append("keyBlockVersion:   ");
        sb.append(this.getKeyBlockVersion());
        sb.append(lineSeparator);
        sb.append(indent);
        sb.append("keyBlockLength:    ");
        sb.append(this.getKeyBlockLength());
        sb.append(lineSeparator);
        sb.append(indent);
        sb.append("keyUsage:          ");
        sb.append(this.getKeyUsage());
        sb.append(" ( ");
        sb.append(this.getKeyUsageAsString());
        sb.append(" )");
        sb.append(lineSeparator);
        sb.append(indent);
        sb.append("keyAlgorithm:      ");
        sb.append(this.getKeyAlgorithm());
        sb.append("  ( ");
        sb.append(this.getKeyAlgorithmAsString());
        sb.append(" )");
        sb.append(lineSeparator);
        sb.append(indent);
        sb.append("keyMode:           ");
        sb.append(this.getKeyMode());
        sb.append("  ( ");
        sb.append(this.getKeyModeAsString());
        sb.append(" )");
        sb.append(lineSeparator);
        sb.append(indent);
        sb.append("keyVersion:        ");
        sb.append(this.getKeyVersion());
        sb.append(lineSeparator);
        sb.append(indent);
        sb.append("keyExportablility: ");
        sb.append(this.getKeyExportability());
        sb.append("  ( ");
        sb.append(this.getKeyExportabilityAsString());
        sb.append(" )");
        sb.append(lineSeparator);
        sb.append(indent);
        sb.append("numOptDataBlocks:     ");
        sb.append(this.getNumOptDataBlocks());
        for (int idx = 0; idx < this.numOptDataBlocks; ++idx) {
            sb.append(lineSeparator);
            sb.append(this.optDataBlocks[idx].toString(2));
        }
        return sb.toString();
    }
}

