/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.CCAAlgorithmParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyConstants;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.CipherSpi;

abstract class SymmetricKeyWrap
extends CipherSpi {
    static final SymmetricKeyConstants.KeyType DEFAULT_UNWRAP_KEY_TYPE = SymmetricKeyConstants.KeyType.CKDS;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.SymmetricKeyWrap";

    SymmetricKeyWrap() {
    }

    @Override
    protected void engineSetMode(String mode) {
        UnsupportedOperationException uoe = new UnsupportedOperationException("This cipher does not support setting cipher modes");
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSetMode");
            debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", uoe);
            debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
        }
        throw uoe;
    }

    @Override
    protected void engineSetPadding(String paddingScheme) {
        UnsupportedOperationException uoe = new UnsupportedOperationException("This cipher does not support setting the padding mechanism");
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSetPadding");
            debug.exception(Debug.TYPE_PUBLIC, className, "engineSetPadding", uoe);
            debug.exit(Debug.TYPE_FINE, className, "engineSetPadding");
        }
        throw uoe;
    }

    @Override
    protected byte[] engineGetIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetIV");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetIV", null);
        }
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetParameters");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameters", null);
        }
        return null;
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        UnsupportedOperationException uoe = new UnsupportedOperationException("This cipher does not support the update operation");
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineUpdate");
            debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", uoe);
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
        throw uoe;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        UnsupportedOperationException uoe = new UnsupportedOperationException("This cipher does not support the update operation");
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineUpdate");
            debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", uoe);
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
        throw uoe;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) {
        UnsupportedOperationException uoe = new UnsupportedOperationException("This cipher does not support the doFinal operation");
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineDoFinal");
            debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", uoe);
            debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
        }
        throw uoe;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        UnsupportedOperationException uoe = new UnsupportedOperationException("This cipher does not support the doFinal operation");
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineDoFinal");
            debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", uoe);
            debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
        }
        throw uoe;
    }

    static void checkEngineInitParameters(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(8192L, className, "checkEngineInitParameters");
        }
        if (random != null) {
            InvalidParameterException ipe = new InvalidParameterException("It is not valid to specify a source of randomness for wrapping and unwrapping hardware keys");
            if (debug != null) {
                debug.exception(8192L, className, "checkEngineInitParameters", ipe);
                debug.exit(8192L, className, "checkEngineInitParameters");
            }
            throw ipe;
        }
        if (opmode == 1 || opmode == 2) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("This cipher does not support ENCRYPT_MODE or DECRYPT_MODE");
            if (debug != null) {
                debug.exception(8192L, className, "checkEngineInitParameters", uoe);
                debug.exit(8192L, className, "checkEngineInitParameters");
            }
            throw uoe;
        }
        if (opmode != 3 && opmode != 4) {
            InvalidParameterException ipe = new InvalidParameterException("The specified operation mode is not supported: " + opmode);
            if (debug != null) {
                debug.exception(8192L, className, "checkEngineInitParameters", ipe);
                debug.exit(8192L, className, "checkEngineInitParameters");
            }
            throw ipe;
        }
        if (key == null) {
            NullPointerException npe = new NullPointerException("Key is null");
            if (debug != null) {
                debug.exception(8192L, className, "checkEngineInitParameters", npe);
                debug.exit(8192L, className, "checkEngineInitParameters");
            }
            throw npe;
        }
        if (key.getFormat().equals("RAW")) {
            InvalidKeyException ike = new InvalidKeyException("Key must be a SECURE_INTERNAL_TOKEN or CKDS hardware key");
            if (debug != null) {
                debug.exception(8192L, className, "checkEngineInitParameters", ike);
                debug.exit(8192L, className, "checkEngineInitParameters");
            }
            throw ike;
        }
        if (params == null) {
            if (debug != null) {
                debug.exit(8192L, className, "checkEngineInitParameters");
            }
            return;
        }
        if (opmode == 3) {
            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Algorithm parameter specification not supported in WRAP_MODE");
            if (debug != null) {
                debug.exception(8192L, className, "checkEngineInitParameters", iape);
                debug.exit(8192L, className, "checkEngineInitParameters");
            }
            throw iape;
        }
        if (params instanceof CCAAlgorithmParameterSpec) {
            CCAAlgorithmParameterSpec spec = (CCAAlgorithmParameterSpec)params;
            byte hwType = spec.getHwType();
            if (SymmetricKeyConstants.KeyType.valueOfOrDefault(hwType, null) == SymmetricKeyConstants.KeyType.CLEAR) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("This cipher does not support unwrapping to a CLEAR key");
                if (debug != null) {
                    debug.exception(8192L, className, "checkEngineInitParameters", iape);
                    debug.exit(8192L, className, "checkEngineInitParameters");
                }
                throw iape;
            }
        } else {
            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Not a supported algorithm parameter specification");
            if (debug != null) {
                debug.exception(8192L, className, "checkEngineInitParameters", iape);
                debug.exit(8192L, className, "checkEngineInitParameters");
            }
            throw iape;
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkEngineInitParameters");
        }
    }

    static enum CipherState {
        UNINITIALIZED,
        WRAP,
        UNWRAP;

    }
}

