/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public final class SymmetricKeyConstants {
    static final int MAX_CKDS_LABEL_LENGTH = 64;
    static final int MAX_TR31_LENGTH = 9992;

    private SymmetricKeyConstants() {
        throw new UnsupportedOperationException("Class is not instantiable");
    }

    public static enum KeyUsage {
        OP_DATA,
        OP_CIPHER,
        OP_IMPORTER,
        OP_EXPORTER,
        OPEX_EXPORTER_IMPORTER,
        OPEX_IMPORTER_EXPORTER;


        static final Set<KeyUsage> singleKeys() {
            return Collections.unmodifiableSet(EnumSet.of(OP_DATA, OP_CIPHER, OP_IMPORTER, OP_EXPORTER));
        }
    }

    public static enum KeyType {
        CLEAR,
        PROTECTED,
        SECURE_INTERNAL_TOKEN,
        CKDS;


        static final KeyType valueOfOrDefault(byte hardwareType, KeyType defaultValue) {
            switch (hardwareType) {
                case 0: {
                    return CKDS;
                }
                case 1: {
                    return PROTECTED;
                }
                case 3: {
                    return SECURE_INTERNAL_TOKEN;
                }
                case 2: {
                    return CLEAR;
                }
            }
            return defaultValue;
        }
    }

    static enum DESDataSkeleton {
        KEYLN8_WRAP_ECB(new byte[]{1, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 64, 0}),
        KEYLN8_WRAP_CBC(new byte[]{1, 0, 0, 0, 0, 0, 64, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 64, 32}),
        KEYLN16_WRAP_ECB(new byte[]{1, 0, 0, 0, 1, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 2, 0, 64, 16}),
        KEYLN16_WRAP_CBC(new byte[]{1, 0, 0, 0, 1, 0, 64, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 2, 0, 64, 48}),
        KEYLN24_WRAP_ECB(new byte[]{1, 0, 0, 0, 1, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 2, 0, 64, 32}),
        KEYLN24_WRAP_CBC(new byte[]{1, 0, 0, 0, 1, 0, 64, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 2, 0, 64, 64});

        private final byte[] token;

        private DESDataSkeleton(byte[] token) {
            this.token = token;
        }

        byte[] token() {
            return (byte[])this.token.clone();
        }
    }
}

