/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandomSpi;

public final class SecureRandomWithCache
extends SecureRandomSpi {
    private static final long serialVersionUID = 1L;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.SecureRandomWithCache";
    private final transient hikmNativeInteger returnCode = new hikmNativeInteger(0);
    private final transient hikmNativeInteger reasonCode = new hikmNativeInteger(0);
    private final transient hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
    private final byte[] exitData = new byte[0];
    private final transient hikmNativeInteger ruleArrayCount = new hikmNativeInteger(1);
    private byte[] ruleArray;
    private final transient hikmNativeInteger reservedLen = new hikmNativeInteger(0);
    private final byte[] reserved = new byte[0];
    private static final transient HIKM MYHIKM = new HIKM();
    private static final HardwareProfile HWPROFILE = new HardwareProfile();
    private transient ByteBuffer cache;
    private static final int DEF_CACHE_SIZE = 14400;
    private final transient HexDumpEncoder encoder = new HexDumpEncoder();
    private final int maxAvailChunkSize = HWPROFILE.getIs4096RNGLSupported() ? 8192 : 8;
    private final byte[] randomData = new byte[this.maxAvailChunkSize];

    public SecureRandomWithCache() {
        int cSize;
        String methodName = "SecureRandomWithCache";
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "SecureRandomWithCache");
        }
        String env = System.getProperty("ibm.hwrandom.cachesize");
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "SecureRandomWithCache", "Value of ibm.hwrandom.cachesize: " + env);
        }
        int convertSize = 0;
        try {
            if (env != null) {
                convertSize = new Integer(env);
            }
        }
        catch (NumberFormatException e) {
            InternalError exception = new InternalError("Unable to convert ibm.hwrandom.cachesize value of " + env + " to a numeric value." + e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "SecureRandomWithCache", exception);
                debug.exit(Debug.TYPE_FINE, className, "SecureRandomWithCache");
            }
            throw exception;
        }
        int n = cSize = env == null ? 14400 : convertSize;
        if (cSize <= 0) {
            InternalError exception = new InternalError("Value of ibm.hwrandom.cachesize must be greater than 0.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "SecureRandomWithCache", exception);
                debug.exit(Debug.TYPE_FINE, className, "SecureRandomWithCache");
            }
            throw exception;
        }
        this.cache = ByteBuffer.allocateDirect(cSize);
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "SecureRandomWithCache", "Allocated secure random cache using size: " + cSize);
        }
        this.cache.position(cSize);
        this.cache.limit(cSize);
        this.ruleArray = PlatformUtilities.getBytesPlatform("RANDOM  ");
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "SecureRandomWithCache");
        }
    }

    public SecureRandomWithCache(byte[] seed) {
        this();
    }

    @Override
    public synchronized void engineSetSeed(byte[] seed) {
        String methodName = "engineSetSeed";
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetSeed", (Object)seed);
            debug.text(Debug.TYPE_PUBLIC, className, "engineSetSeed", "Method engineSetSeed is a no-op when using the IBMJCECCA provider");
            debug.exit(Debug.TYPE_FINE, className, "engineSetSeed");
        }
    }

    @Override
    public synchronized void engineNextBytes(byte[] bytes) throws InternalError, BufferUnderflowException {
        String methodName = "engineNextBytes";
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineNextBytes", bytes == null ? "null" : Integer.valueOf(bytes.length), bytes);
        }
        if (bytes == null) {
            InternalError exception = new InternalError("Buffer passed to SecureRandom cannot be null.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineNextBytes", exception);
                debug.exit(Debug.TYPE_FINE, className, "engineNextBytes");
            }
            throw exception;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineNextBytes", "Cache Status *** Bytes Remaining=" + this.cache.remaining() + ", Bytes Requested=" + bytes.length + ", Position=" + this.cache.position() + " ***");
        }
        if (this.cache.remaining() >= bytes.length) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineNextBytes", "Return bytes from the cache of the requested length: " + bytes.length);
            }
            this.cache.get(bytes);
        } else if (this.cache.limit() < bytes.length) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineNextBytes", "We asked for a piece of random data that is larger then the current cache size. Simply fetch these randoms from ICSF. ");
            }
            ByteBuffer largerFetch = ByteBuffer.allocateDirect(bytes.length);
            this.getBytes(largerFetch);
            largerFetch.get(bytes);
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineNextBytes", "We do not have enough bytes in the cache to return. Fill the cache and call this method again.");
            }
            int lengthFetch = this.cache.capacity() - this.cache.remaining();
            this.cache.position(0);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineNextBytes", "Fetching " + lengthFetch + " bytes to place in the cache.");
            }
            this.getBytes(this.cache, lengthFetch);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineNextBytes", "Cache filled.");
            }
            this.engineNextBytes(bytes);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineNextBytes", bytes.length);
        }
    }

    private void getBytes(ByteBuffer bytes) throws InternalError, RuntimeException {
        this.getBytes(bytes, bytes.capacity());
    }

    private void getBytes(ByteBuffer bytes, int lengthFetch) throws InternalError, RuntimeException {
        InternalError exception;
        String methodName = "getBytes";
        if (debug != null) {
            Object[] parms = new Object[]{bytes == null ? "null" : Integer.valueOf(bytes.capacity()), lengthFetch};
            debug.entry(Debug.TYPE_FINE, (Object)className, "getBytes", parms);
        }
        if (bytes == null) {
            exception = new InternalError("ByteBuffer passed to getBytes cannot be null.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getBytes", exception);
                debug.exit(Debug.TYPE_FINE, className, "getBytes");
            }
            throw exception;
        }
        if (bytes.position() != 0) {
            exception = new InternalError("ByteBuffer passed to getBytes must be at position 0.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getBytes", exception);
                debug.exit(Debug.TYPE_FINE, className, "getBytes");
            }
            throw exception;
        }
        if (lengthFetch > bytes.capacity()) {
            exception = new InternalError("ByteBuffer capacity passed to getBytes is too small.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getBytes", exception);
                debug.exit(Debug.TYPE_FINE, className, "getBytes");
            }
            throw exception;
        }
        int chunks = lengthFetch / this.maxAvailChunkSize;
        if (lengthFetch % this.maxAvailChunkSize > 0) {
            ++chunks;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "getBytes", "The number of RNG or RNGL calls needed: " + chunks);
        }
        int bytesNeeded = lengthFetch;
        hikmNativeInteger randNumLength = new hikmNativeInteger(0);
        for (int i = 0; i < chunks; ++i) {
            if (bytesNeeded >= this.maxAvailChunkSize) {
                randNumLength.setValue(this.maxAvailChunkSize);
            } else {
                randNumLength.setValue(bytesNeeded);
            }
            if (this.maxAvailChunkSize == 8192) {
                try {
                    if (null != debug) {
                        this.traceRNGL("INPUT", "getBytes", this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, this.ruleArrayCount, this.ruleArray, this.reservedLen, this.reserved, randNumLength, this.randomData);
                    }
                    MYHIKM.CSNBRNGLJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, this.ruleArrayCount, this.ruleArray, this.reservedLen, this.reserved, randNumLength, this.randomData);
                    if (null != debug) {
                        this.traceRNGL("RETURN", "getBytes", this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, this.ruleArrayCount, this.ruleArray, this.reservedLen, this.reserved, randNumLength, this.randomData);
                    }
                }
                catch (IllegalArgumentException e) {
                    RuntimeException exception2 = new RuntimeException("Hardware error from call CSNBRNGL", e);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "getBytes", exception2);
                        debug.exit(Debug.TYPE_FINE, className, "getBytes");
                    }
                    throw exception2;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "methodName", "CSNBRNGL: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
                }
                if (this.returnCode.getValue() != 0) {
                    JCECCARuntimeException exception3 = new JCECCARuntimeException(1, "CSNBRNGL", "Hardware error from call CSNBRNGL returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "getBytes", "Hardware error from call CSNBRNGL returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue());
                        debug.exception(Debug.TYPE_PUBLIC, className, "getBytes", exception3);
                        debug.exit(Debug.TYPE_FINE, className, "getBytes");
                    }
                    throw exception3;
                }
            } else {
                try {
                    if (null != debug) {
                        this.traceRNG("INPUT", "getBytes", this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, this.ruleArray, this.randomData);
                    }
                    MYHIKM.CSNBRNGJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, this.ruleArray, this.randomData);
                    if (null != debug) {
                        this.traceRNG("RETURN", "getBytes", this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, this.ruleArray, this.randomData);
                    }
                }
                catch (IllegalArgumentException e) {
                    RuntimeException exception4 = new RuntimeException("Hardware error from call CSNBRNG", e);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "getBytes", exception4);
                        debug.exit(Debug.TYPE_FINE, className, "getBytes");
                    }
                    throw exception4;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "methodName", "CSNBRNG: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
                }
                if (this.returnCode.getValue() != 0) {
                    JCECCARuntimeException exception5 = new JCECCARuntimeException(1, "CSNBRNG", "Hardware error from call CSNBRNG returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "getBytes", "Hardware error from call CSNBRNG returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue());
                        debug.exception(Debug.TYPE_PUBLIC, className, "getBytes", exception5);
                        debug.exit(Debug.TYPE_FINE, className, "getBytes");
                    }
                    throw exception5;
                }
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getBytes", "Putting " + randNumLength.getValue() + " bytes into the cache at position " + bytes.position() + ".");
            }
            bytes.put(this.randomData, 0, randNumLength.getValue());
            bytesNeeded -= randNumLength.getValue();
        }
        int bytesFilled = bytes.position();
        bytes.position(0);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "getBytes", bytesFilled);
        }
    }

    @Override
    public byte[] engineGenerateSeed(int numBytes) throws UnsupportedOperationException {
        String methodName = "engineGenerateSeed";
        UnsupportedOperationException exception = new UnsupportedOperationException("Hardware error, function engineGenerateSeed has no meaning in hardware");
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSeed", numBytes);
            debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSeed", exception);
            debug.exit(Debug.TYPE_FINE, className, "engineGenerateSeed");
        }
        throw exception;
    }

    private void traceRNGL(String IOState, String methodName, hikmNativeInteger returnCode, hikmNativeInteger reasonCode, hikmNativeInteger exitDataLength, byte[] exitData, hikmNativeInteger ruleArrayCount, byte[] ruleArray, hikmNativeInteger reservedLen, byte[] reservedData, hikmNativeInteger randNumLength, byte[] randomData) {
        byte[] newRandomData = new byte[randNumLength.getValue()];
        System.arraycopy(randomData, 0, newRandomData, 0, randNumLength.getValue());
        String exitDataString = "\n" + this.encoder.encodeBuffer(exitData);
        String ruleArrayString = "\n" + this.encoder.encodeBuffer(ruleArray);
        String reservedDataString = "\n" + this.encoder.encodeBuffer(reservedData);
        String randomDataString = "\n" + this.encoder.encodeBuffer(newRandomData);
        String parmsReport = "\nSecureRandomWithCache: CSNBRNGL " + IOState + " PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    exitDataLen    : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArrayCount : " + ruleArrayCount.getValue() + "\n    ruleArray      : " + ruleArrayString + "\n    reservedLen    : " + reservedLen.getValue() + "\n    reserved       : " + reservedDataString + "\n    randomNumLen   : " + randNumLength.getValue() + "\n    random         : " + randomDataString + "\n";
        debug.text(Debug.TYPE_FINEST, className, methodName, parmsReport);
    }

    private void traceRNG(String IOState, String methodName, hikmNativeInteger returnCode, hikmNativeInteger reasonCode, hikmNativeInteger exitDataLength, byte[] exitData, byte[] ruleArray, byte[] randomData) {
        String exitDataString = "\n" + this.encoder.encodeBuffer(exitData);
        String ruleArrayString = "\n" + this.encoder.encodeBuffer(ruleArray);
        String randomDataString = "\n" + this.encoder.encodeBuffer(randomData);
        String parmsReport = "\nSecureRandomWithCache: CSNBRNG " + IOState + " PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    exitDataLen    : " + exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArray      : " + ruleArrayString + "\n    random         : " + randomDataString + "\n";
        debug.text(Debug.TYPE_FINEST, className, methodName, parmsReport);
    }
}

