/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.security.SecureRandomSpi;

public final class SecureRandomGSK
extends SecureRandomSpi {
    static final long serialVersionUID = 3710442104357176287L;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.SecureRandomGSK";
    private hikmNativeInteger returnCode = new hikmNativeInteger(0);
    private hikmNativeInteger reasonCode = new hikmNativeInteger(0);
    private HIKM hikm;

    public SecureRandomGSK() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "SecureRandomGSK");
        }
        this.hikm = new HIKM();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "SecureRandomGSK");
        }
    }

    public SecureRandomGSK(byte[] seed) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "SecureRandomGSK", (Object)seed);
        }
        this.hikm = new HIKM();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "SecureRandomGSK");
        }
    }

    @Override
    public synchronized void engineSetSeed(byte[] seed) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetSeed", (Object)seed);
            debug.text(Debug.TYPE_PUBLIC, className, "engineSetSeed", "Method engineSetSeed is a no-op when using the IBMJCECCA provider");
            debug.exit(Debug.TYPE_FINE, className, "engineSetSeed");
        }
    }

    @Override
    public synchronized void engineNextBytes(byte[] bytes) throws InternalError, RuntimeException {
        String parmsReport;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineNextBytes", (Object)bytes);
        }
        HIKM hikm = new HIKM();
        hikmNativeInteger length = new hikmNativeInteger(bytes.length);
        if (debug != null) {
            parmsReport = "\nSecureRandomGSK: RANDOMGSK INPUT PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    length   : " + length.getValue() + "\n    bytes   : XXXX\n";
            debug.text(Debug.TYPE_FINEST, className, "engineNextBytes", parmsReport);
        }
        hikm.RANDOMGSK(this.returnCode, this.reasonCode, length, bytes);
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "engineNextBytes", "RANDOMGSK: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
        }
        if (debug != null) {
            parmsReport = "\nSecureRandomGSK: RANDOMGSK RETURN PARAMETERS: \n    returnCode    : " + this.returnCode.getValue() + "\n    reasonCode    : " + this.reasonCode.getValue() + "\n    length   : " + length.getValue() + "\n    bytes   : XXXX\n";
            debug.text(Debug.TYPE_FINEST, className, "engineNextBytes", parmsReport);
        }
        if (this.returnCode.getValue() != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineNextBytes", "Error from call RANDOMGSK returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue());
            }
            throw new JCECCARuntimeException(1, "RANDOMGSK", "Error from call RANDOMGSK returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineNextBytes", bytes);
        }
    }

    @Override
    public byte[] engineGenerateSeed(int numBytes) throws UnsupportedOperationException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSeed", new Integer(numBytes));
            debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSeed", "function engineGenerateSeed has no meaning in hardware");
            debug.exit(Debug.TYPE_FINE, className, "engineGenerateSeed");
        }
        throw new UnsupportedOperationException("Hardware error, function engineGenerateSeed has no meaning in hardware");
    }
}

