/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.security.SecureRandomSpi;

public final class SecureRandom
extends SecureRandomSpi {
    static final long serialVersionUID = 3710442104357176287L;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.SecureRandom";
    private byte[] temp;
    private hikmNativeInteger returnCode = new hikmNativeInteger(0);
    private hikmNativeInteger reasonCode = new hikmNativeInteger(0);
    private byte[] exitData = new byte[4];
    private hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
    byte[] ruleArray = null;
    private HIKM hikm;

    public SecureRandom() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "SecureRandom");
        }
        this.hikm = new HIKM();
        this.ruleArray = PlatformUtilities.getBytesPlatform("RANDOM  ");
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "SecureRandom");
        }
    }

    public SecureRandom(byte[] seed) {
        this();
    }

    @Override
    public synchronized void engineSetSeed(byte[] seed) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetSeed", (Object)seed);
            debug.text(Debug.TYPE_PUBLIC, className, "engineSetSeed", "Method engineSetSeed is a no-op when using the IBMJCECCA provider");
            debug.exit(Debug.TYPE_FINE, className, "engineSetSeed");
        }
    }

    @Override
    public synchronized void engineNextBytes(byte[] bytes) throws InternalError, RuntimeException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineNextBytes", bytes == null ? "null" : Integer.valueOf(bytes.length), bytes);
        }
        if (bytes == null) {
            throw new InternalError("Buffer passed to SecureRandom cannot be null");
        }
        boolean RandomLongAvail = HardwareProfile.getIs4096RNGLSupported();
        int maxAvailChunkSize = 0;
        maxAvailChunkSize = RandomLongAvail ? 8192 : 8;
        int chunks = bytes.length / maxAvailChunkSize;
        if (bytes.length % maxAvailChunkSize > 0) {
            ++chunks;
        }
        this.temp = new byte[chunks * maxAvailChunkSize];
        byte[] random_data = new byte[maxAvailChunkSize];
        int bytes_needed = bytes.length;
        for (int i = 0; i < chunks; ++i) {
            if (RandomLongAvail) {
                try {
                    String parmsReport;
                    String exitDataString;
                    HexDumpEncoder encoder;
                    hikmNativeInteger random_number_length = null;
                    if (bytes_needed >= maxAvailChunkSize) {
                        random_number_length = new hikmNativeInteger(maxAvailChunkSize);
                    } else {
                        random_data = new byte[bytes_needed];
                        random_number_length = new hikmNativeInteger(bytes_needed);
                    }
                    if (null != debug) {
                        encoder = new HexDumpEncoder();
                        exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                        String ruleArrayString = "\n" + encoder.encodeBuffer(this.ruleArray);
                        parmsReport = "\nSecureRandom: CSNBRNGL INPUT PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    ruleArrayCount : 1\n    ruleArray      : " + ruleArrayString + "\n    randomNumLen   : " + random_number_length.getValue() + "\n";
                        debug.text(Debug.TYPE_FINEST, className, "engineNextBytes", parmsReport);
                    }
                    this.hikm.CSNBRNGLJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, new hikmNativeInteger(1), this.ruleArray, new hikmNativeInteger(0), new byte[0], random_number_length, random_data);
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "engineNextBytes", "CSNBRNGL: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
                    }
                    if (null != debug) {
                        encoder = new HexDumpEncoder();
                        exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                        String randomDataString = "\n" + encoder.encodeBuffer(random_data);
                        parmsReport = "\nSecureRandom: CSNBRNGL RETURN PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    randomNumLen   : " + random_number_length.getValue() + "\n    random         : " + randomDataString + "\n";
                        debug.text(Debug.TYPE_FINEST, className, "engineNextBytes", parmsReport);
                    }
                    bytes_needed -= random_number_length.getValue();
                }
                catch (IllegalArgumentException e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineNextBytes", e);
                    }
                    throw new RuntimeException("Hardware error from call CSNBRNGL " + e);
                }
                if (this.returnCode.getValue() != 0) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineNextBytes", "Hardware error from call CSNBRNGL returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue());
                    }
                    throw new JCECCARuntimeException(1, "CSNBRNGL", "Hardware error from call CSNBRNGL returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                }
            } else {
                try {
                    String parmsReport;
                    String exitDataString;
                    HexDumpEncoder encoder;
                    if (null != debug) {
                        encoder = new HexDumpEncoder();
                        exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                        String ruleArrayString = "\n" + encoder.encodeBuffer(this.ruleArray);
                        parmsReport = "\nSecureRandom: CSNBRNG INPUT PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    form           : " + ruleArrayString + "\n";
                        debug.text(Debug.TYPE_FINEST, className, "engineNextBytes", parmsReport);
                    }
                    this.hikm.CSNBRNGJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, this.ruleArray, random_data);
                    if (debug != null) {
                        debug.text(Debug.TYPE_FINE, className, "engineNextBytes", "CSNBRNG: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
                    }
                    if (null != debug) {
                        encoder = new HexDumpEncoder();
                        exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
                        String randomDataString = "\n" + encoder.encodeBuffer(random_data);
                        parmsReport = "\nSecureRandom: CSNBRNG RETURN PARAMETERS \n    returnCode     : " + this.returnCode.getValue() + "\n    reasonCode     : " + this.reasonCode.getValue() + "\n    exitDataLen    : " + this.exitDataLength.getValue() + "\n    exitData       : " + exitDataString + "\n    random         : " + randomDataString + "\n";
                        debug.text(Debug.TYPE_FINEST, className, "engineNextBytes", parmsReport);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineNextBytes", e);
                    }
                    throw new RuntimeException("Hardware error from call CSNBRNG " + e);
                }
                if (this.returnCode.getValue() != 0) {
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineNextBytes", "Hardware error from call CSNBRNG returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue());
                    }
                    throw new JCECCARuntimeException(1, "CSNBRNG", "Hardware error from call CSNBRNG returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
                }
            }
            System.arraycopy(random_data, 0, this.temp, i * maxAvailChunkSize, random_data.length);
        }
        System.arraycopy(this.temp, 0, bytes, 0, bytes.length);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineNextBytes", bytes.length);
        }
    }

    @Override
    public byte[] engineGenerateSeed(int numBytes) throws UnsupportedOperationException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "engineGenerateSeed", new Integer(numBytes));
            debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSeed", "function engineGenerateSeed has no meaning in hardware");
        }
        throw new UnsupportedOperationException("Hardware error, function engineGenerateSeed has no meaning in hardware");
    }
}

