/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyFactory;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import javax.security.auth.DestroyFailedException;

public final class RSAPrivateHWKey
extends PrivateKeyInfo
implements RSAPrivateCrtKey,
Serializable {
    static final long serialVersionUID = 4391380867216055006L;
    private boolean hasBeenDestroyed = false;
    private byte[] keyLabel;
    private byte[] externalKeyToken = null;
    private RSAKeyHWAttributes keyAttribs = null;
    private RSAUtil.KeyType rsaPssKeyType = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey";

    @Deprecated
    public RSAPrivateHWKey(byte[] keyToken, RSAKeyHWAttributes attribs) throws InvalidKeyException {
        this((AlgorithmId)new AlgIdRSA(), keyToken, attribs);
    }

    RSAPrivateHWKey(AlgorithmId algId, byte[] keyToken, RSAKeyHWAttributes attribs) throws InvalidKeyException {
        this.keyLabel = (byte[])keyToken.clone();
        this.keyAttribs = new RSAKeyHWAttributes(attribs.getKeyType(), attribs.getKeyUsage());
        this.rsaPssKeyType = algId != null && algId.getOID().equals(AlgorithmId.RSAPSS_oid) ? RSAUtil.KeyType.PSS : RSAUtil.KeyType.RSA;
        this.algid = new AlgIdRSA();
        try {
            DerValue[] value = new DerValue[]{new DerValue(4, this.keyLabel)};
            DerOutputStream out = new DerOutputStream();
            out.putSequence(value);
            this.key = out.toByteArray();
            this.encode();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "RSAPrivateHWKey", e);
            }
            throw new InvalidKeyException("could not DER encode: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "RSAPrivateHWKey");
        }
    }

    RSAPrivateHWKey(byte[] keyToken, byte[] externalKeyToken, RSAKeyHWAttributes attribs) throws InvalidKeyException {
        this((AlgorithmId)new AlgIdRSA(), keyToken, externalKeyToken, attribs);
    }

    RSAPrivateHWKey(AlgorithmId algId, byte[] keyToken, byte[] externalKeyToken, RSAKeyHWAttributes attribs) throws InvalidKeyException {
        this.keyLabel = (byte[])keyToken.clone();
        if (externalKeyToken != null) {
            this.externalKeyToken = (byte[])externalKeyToken.clone();
        }
        this.keyAttribs = new RSAKeyHWAttributes(attribs.getKeyType(), attribs.getKeyUsage());
        this.rsaPssKeyType = algId != null && algId.getOID().equals(AlgorithmId.RSAPSS_oid) ? RSAUtil.KeyType.PSS : RSAUtil.KeyType.RSA;
        this.algid = new AlgIdRSA();
        try {
            DerValue[] value = new DerValue[]{new DerValue(4, this.keyLabel)};
            DerOutputStream out = new DerOutputStream();
            out.putSequence(value);
            this.key = out.toByteArray();
            this.encode();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "RSAPrivateHWKey", e);
            }
            throw new InvalidKeyException("could not DER encode: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "RSAPrivateHWKey");
        }
    }

    protected RSAPrivateHWKey(byte[] encoded) throws InvalidKeyException {
        this(encoded, false);
    }

    protected RSAPrivateHWKey(byte[] encoded, boolean decodePSS) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "RSAPrivateHWKey", (Object)encoded);
        }
        try {
            Object rsaKeySpec = null;
            DerInputStream PKCS8InStream = new DerInputStream(encoded);
            DerValue[] PKCS8Sequence = PKCS8InStream.getSequence(encoded.length);
            this.algid = AlgorithmId.parse((DerValue)PKCS8Sequence[1]);
            this.rsaPssKeyType = decodePSS || this.algid != null && this.algid.getOID().equals(AlgorithmId.RSAPSS_oid) ? RSAUtil.KeyType.PSS : RSAUtil.KeyType.RSA;
            this.algid = new AlgIdRSA();
            byte[] encodedPrivKey = PKCS8Sequence[2].getOctetString();
            DerInputStream encodedPrivKeyInStream = new DerInputStream(encodedPrivKey);
            DerValue[] privateKeySequence = encodedPrivKeyInStream.getSequence(encodedPrivKey.length);
            int valuesInRSAPrivCrtKeySeq = 9;
            int valuesInRSAPrivKeySeq = 2;
            RSAPrivateHWKey migKey = null;
            if (privateKeySequence.length == valuesInRSAPrivCrtKeySeq) {
                RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(privateKeySequence[1].getInteger(), privateKeySequence[2].getInteger(), privateKeySequence[3].getInteger(), privateKeySequence[4].getInteger(), privateKeySequence[5].getInteger(), privateKeySequence[6].getInteger(), privateKeySequence[7].getInteger(), privateKeySequence[8].getInteger());
                RSAKeyFactory x = new RSAKeyFactory(this.rsaPssKeyType);
                migKey = (RSAPrivateHWKey)x.engineGeneratePrivate(spec);
            } else if (privateKeySequence.length == valuesInRSAPrivKeySeq) {
                RSAPrivateKeySpec spec = new RSAPrivateKeySpec(privateKeySequence[0].getInteger(), privateKeySequence[1].getInteger());
                RSAKeyFactory x = new RSAKeyFactory(this.rsaPssKeyType);
                migKey = (RSAPrivateHWKey)x.engineGeneratePrivate(spec);
            } else {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "RSAPrivateHWKey", "Bad RSA private key sequence length - " + privateKeySequence.length);
                }
                throw new InvalidKeyException("Bad RSA private key encoding");
            }
            this.keyLabel = migKey.getToken();
            this.externalKeyToken = migKey.getExternalKeyToken();
            this.keyAttribs = new RSAKeyHWAttributes(migKey.getType(), migKey.getUsage());
            this.key = migKey.getKeyBytes();
        }
        catch (IOException ioex) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "RSAPrivateHWKey", ioex);
            }
            throw new InvalidKeyException("Bad RSA private key encoding");
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "RSAPrivateHWKey", ex);
            }
            throw new InvalidKeyException("Internal error converting RSA software private key to IBMJCECCA", ex);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "RSAPrivateHWKey");
        }
    }

    @Override
    public String getFormat() {
        String result = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFormat");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getFormat", ise);
            }
            throw ise;
        }
        switch (this.getType()) {
            case 0: {
                result = "PKDSLabel";
                break;
            }
            case 1: {
                result = "RETAIN";
                break;
            }
            case 2: {
                result = "ICSFToken";
                break;
            }
            default: {
                result = "UNKNOWN";
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFormat", result);
        }
        return result;
    }

    @Override
    public byte[] getEncoded() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEncoded");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getEncoded", ise);
            }
            throw ise;
        }
        byte[] result = this.getToken();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", result);
        }
        return result;
    }

    public byte[] getToken() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getLabel");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getLabel", ise);
            }
            throw ise;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabel", this.keyLabel);
        }
        if (this.keyLabel != null) {
            return (byte[])this.keyLabel.clone();
        }
        return null;
    }

    public String getLabelString() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getLabelString");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getLabelString", ise);
            }
            throw ise;
        }
        if (this.getType() != 0) {
            InvalidKeyException ike = new InvalidKeyException("Key must be of type KeyHWAttributeValues.PKDS.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getLabelString", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "getLabelString");
            }
            throw ike;
        }
        String returnLabel = new String(this.keyLabel, PlatformUtilities.CHARSET_ISO_8859_1);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabelString", returnLabel);
        }
        return returnLabel;
    }

    public byte[] getExternalKeyToken() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getExternalKeyToken");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getExternalKeyToken", ise);
            }
            throw ise;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getExternalKeyToken", this.externalKeyToken);
        }
        if (this.externalKeyToken != null) {
            return (byte[])this.externalKeyToken.clone();
        }
        return null;
    }

    public byte getType() {
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getType", ise);
            }
            throw ise;
        }
        return this.keyAttribs.getKeyType();
    }

    public byte getUsage() {
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getUsage", ise);
            }
            throw ise;
        }
        return this.keyAttribs.getKeyUsage();
    }

    @Override
    public BigInteger getModulus() throws UnsupportedOperationException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getModulus");
            debug.text(Debug.TYPE_PUBLIC, className, "getModulus", "Function getModulus has no meaning in hardware");
        }
        throw new UnsupportedOperationException("Hardware error, function getModulus has no meaning in hardware");
    }

    @Override
    public BigInteger getPrivateExponent() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getPrivateExponent");
            debug.text(Debug.TYPE_PUBLIC, className, "getPrivateExponent", "Function getPrivateExponent has no meaning in hardware");
        }
        throw new UnsupportedOperationException("Hardware error, function getPrivateExponent has no meaning in hardware");
    }

    @Override
    public BigInteger getPublicExponent() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getPublicExponent");
            debug.text(Debug.TYPE_PUBLIC, className, "getPublicExponent", "Function getPublicExponent has no meaning in hardware");
        }
        throw new UnsupportedOperationException("Hardware error, function getPublicExponent has no meaning in hardware");
    }

    @Override
    public BigInteger getPrimeP() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getPrimeP");
            debug.text(Debug.TYPE_PUBLIC, className, "getPrimeP", "Function getPrimeP has no meaning in hardware");
        }
        throw new UnsupportedOperationException("Hardware error, function getPrimeP has no meaning in hardware");
    }

    @Override
    public BigInteger getPrimeQ() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getPrimeQ");
            debug.text(Debug.TYPE_PUBLIC, className, "getPrimeQ", "function getPrimeQ has no meaning in hardware");
        }
        throw new UnsupportedOperationException("Hardware error, function getPrimeQ has no meaning in hardware");
    }

    @Override
    public BigInteger getPrimeExponentP() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getPrimeExponentP");
            debug.text(Debug.TYPE_PUBLIC, className, "getPrimeExponentP", "function getPrimeExponentP has no meaning in hardware");
        }
        throw new UnsupportedOperationException("Hardware error, function getPrimeExponentP has no meaning in hardware");
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getPrimeExponentQ");
            debug.text(Debug.TYPE_PUBLIC, className, "getPrimeExponentQ", "function getPrimeExponentQ has no meaning in hardware");
        }
        throw new UnsupportedOperationException("Hardware error, function getPrimeExponentQ has no meaning in hardware");
    }

    @Override
    public BigInteger getCrtCoefficient() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getCrtCoefficient");
            debug.text(Debug.TYPE_PUBLIC, className, "getCrtCoefficient", "function getCrtCoefficient has no meaning in hardware");
        }
        throw new UnsupportedOperationException("Hardware error, function getCrtCoefficient has no meaning in hardware");
    }

    public String toString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "toString");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "toString", ise);
            }
            throw ise;
        }
        String prov = null;
        prov = Security.getProvider("IBMJCECCA") == null && Security.getProvider("IBMJCE4758") == null ? new String("IBMJCA4758") : new String("IBMJCECCA");
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "toString");
        }
        HexDumpEncoder encoder = new HexDumpEncoder();
        String hexStringKeyLabel = encoder.encodeBuffer(this.keyLabel);
        return prov + " RSA Private Key:\n" + hexStringKeyLabel + "\n";
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        if (this.rsaPssKeyType == RSAUtil.KeyType.PSS) {
            return PSSParameterSpec.DEFAULT;
        }
        return null;
    }

    protected void parseKeyBits() throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "parseKeyBits", ise);
            }
            throw ise;
        }
        try {
            DerValue in = new DerValue(this.key);
            this.keyLabel = in.getData().getOctetString();
            if (in.getData().available() != 0) {
                throw new IOException("Invalid RSAPrivateHWKey encoding, data overrun");
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "parseKeyBits", e);
            }
            throw new IOException(e.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
    }

    public void deletePKDSEntry() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
        }
        if (this.isDestroyed()) {
            IllegalStateException ise = new IllegalStateException("destroy() has been called in this key object.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "deletePKDSEntry", ise);
            }
            throw ise;
        }
        if (this.getType() != 0) {
            InvalidKeyException newException = new InvalidKeyException("Error attempting to delete non-PKDS key from PKDS");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "deletePKDSEntry", newException);
                debug.exit(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
            }
            throw newException;
        }
        byte[] pkdsLabel = this.getToken();
        if (pkdsLabel.length > 64) {
            RuntimeException newException = new RuntimeException("Invalid label length for PKDS key object");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "deletePKDSEntry", newException);
                debug.exit(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
            }
            throw newException;
        }
        KeyPairUtils.deletePKDSEntry(pkdsLabel);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "deletePKDSEntry");
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        int idx;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "destroy");
        }
        if (null != this.keyLabel) {
            for (idx = 0; idx < this.keyLabel.length; ++idx) {
                this.keyLabel[idx] = 0;
            }
            this.keyLabel = null;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "destroy", "keyLabel has been zeroed out and set to null.");
            }
        }
        if (null != this.externalKeyToken) {
            for (idx = 0; idx < this.externalKeyToken.length; ++idx) {
                this.externalKeyToken[idx] = 0;
            }
            this.externalKeyToken = null;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "destroy", "externalKeyToken has been zeroed out and set to null.");
            }
        }
        this.hasBeenDestroyed = true;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "destroy");
        }
    }

    @Override
    public boolean isDestroyed() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "destroy", "" + this.hasBeenDestroyed);
        }
        return this.hasBeenDestroyed;
    }
}

