/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Crypto;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.PSSParameters;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.RSAPublicKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Arrays;
import java.util.Hashtable;

public final class RSAPSSSignature
extends SignatureSpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RSAPSSSignature";
    private static final Hashtable<String, Integer> DIGEST_LENGTHS = new Hashtable();
    private RSAPrivateKey privateKey;
    private java.security.interfaces.RSAPublicKey publicKey;
    private byte[] privKeyLabel;
    private byte[] privExtKeyToken;
    private byte[] cachePrivKeyToken;
    private byte[] pubKeyToken;
    private MessageDigest dataSHA;
    private PSSParameterSpec pssParameterSpec = null;
    private String oid = "1.2.840.113549.1.1.10";
    private String msgDigestName = null;
    private int saltlen = 20;
    private int trailerField = 1;
    private String mgfName = "MGF1";
    private String mgf1SpecAlgo = null;
    private KeyFactory pssKeyFactory = null;

    public RSAPSSSignature() {
        this.rsaPssSignature(new PSSParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, 20, 1));
    }

    RSAPSSSignature(PSSParameterSpec pssParameterSpec) {
        this.rsaPssSignature(pssParameterSpec);
    }

    RSAPSSSignature(String digestAlgo) {
        switch (digestAlgo) {
            case "SHA-1": {
                this.pssParameterSpec = new PSSParameterSpec(digestAlgo, "MGF1", MGF1ParameterSpec.SHA1, 20, 1);
                break;
            }
            case "SHA-224": {
                this.pssParameterSpec = new PSSParameterSpec(digestAlgo, "MGF1", MGF1ParameterSpec.SHA224, 28, 1);
                break;
            }
            case "SHA-256": {
                this.pssParameterSpec = new PSSParameterSpec(digestAlgo, "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
                break;
            }
            case "SHA-384": {
                this.pssParameterSpec = new PSSParameterSpec(digestAlgo, "MGF1", MGF1ParameterSpec.SHA384, 48, 1);
                break;
            }
            case "SHA-512": {
                this.pssParameterSpec = new PSSParameterSpec(digestAlgo, "MGF1", MGF1ParameterSpec.SHA512, 0, 1);
                break;
            }
            default: {
                this.pssParameterSpec = new PSSParameterSpec(digestAlgo, "MGF1", MGF1ParameterSpec.SHA1, 20, 1);
            }
        }
        this.rsaPssSignature(this.pssParameterSpec);
    }

    private void rsaPssSignature(PSSParameterSpec pssParameterSpec) {
        if (debug != null) {
            Object[] parms = new Object[]{pssParameterSpec};
            debug.entry(Debug.TYPE_FINE, (Object)className, "rsaPssSignature", parms);
        }
        try {
            this.pssKeyFactory = KeyFactory.getInstance("RSASSA-PSS", "IBMJCECCA");
            this.engineSetParameter(pssParameterSpec);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "rsaPssSignature");
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInitSign", privateKey);
        }
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Key is not an RSAPrivateKey");
        }
        this.checkKeyIsValid((RSAPrivateKey)privateKey);
        if (privateKey instanceof RSAPrivateHWKey) {
            try {
                RSAPrivateHWKey migKey = (RSAPrivateHWKey)privateKey;
                if (!(migKey.getParams() instanceof PSSParameterSpec) && !((migKey = (RSAPrivateHWKey)this.pssKeyFactory.generatePrivate(this.pssKeyFactory.getKeySpec(migKey, RSAPrivateCrtKeySpec.class))).getParams() instanceof PSSParameterSpec)) {
                    throw new InvalidKeyException("Key is not RSASSA-PSS compatible");
                }
                this.privKeyLabel = migKey.getToken();
                this.privExtKeyToken = migKey.getExternalKeyToken();
                this.cachePrivKeyToken = null;
                this.dataSHA.reset();
            }
            catch (Exception e) {
                InvalidKeyException ike = new InvalidKeyException(e.getMessage(), e);
                throw ike;
            }
        } else if (privateKey instanceof RSAPrivateKey) {
            try {
                RSAPrivateHWKey migKey = new RSAPrivateHWKey(privateKey.getEncoded(), true);
                if (!(migKey.getParams() instanceof PSSParameterSpec)) {
                    throw new InvalidKeyException("Key is not RSASSA-PSS compatible");
                }
                this.privKeyLabel = migKey.getToken();
                this.cachePrivKeyToken = null;
                this.dataSHA.reset();
            }
            catch (Exception e) {
                InvalidKeyException ike = new InvalidKeyException(e.getMessage(), e);
                throw ike;
            }
        } else {
            InvalidKeyException ike = new InvalidKeyException("Not a RSA private key: " + privateKey);
            throw ike;
        }
        this.privateKey = (RSAPrivateKey)privateKey;
        this.publicKey = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInitSign");
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInitVerify", publicKey);
        }
        if (!(publicKey instanceof java.security.interfaces.RSAPublicKey)) {
            throw new InvalidKeyException("Key is not an RSAPublicKey");
        }
        this.checkKeyIsValid((java.security.interfaces.RSAPublicKey)publicKey);
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey pub = (RSAPublicKey)publicKey;
            this.pubKeyToken = pub.getToken();
            this.dataSHA.reset();
        } else if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            RSAPublicKey migKey = new RSAPublicKey(publicKey.getEncoded());
            this.pubKeyToken = migKey.getToken();
            this.dataSHA.reset();
        } else {
            throw new InvalidKeyException("not a RSA public key: " + publicKey);
        }
        this.privateKey = null;
        this.publicKey = (java.security.interfaces.RSAPublicKey)publicKey;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInitVerify");
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", b);
        }
        this.ensureInit();
        this.dataSHA.update(b);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) throws SignatureException {
        if (debug != null) {
            Object[] parms = new Object[]{data, off, len};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        this.ensureInit();
        this.dataSHA.update(data, off, len);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSign");
        }
        byte[] digest = this.dataSHA.digest();
        byte[] saltLenArray = new byte[]{(byte)(this.saltlen >>> 24), (byte)(this.saltlen >>> 16), (byte)(this.saltlen >>> 8), (byte)this.saltlen};
        byte[] messageDigest = new byte[digest.length + 4];
        System.arraycopy(saltLenArray, 0, messageDigest, 0, 4);
        System.arraycopy(digest, 0, messageDigest, 4, digest.length);
        Crypto crypto = new Crypto();
        byte[] result = null;
        try {
            result = this.cachePrivKeyToken != null ? crypto.sign(this.cachePrivKeyToken, messageDigest, 0, messageDigest.length, Crypto.Algorithm.RSAPSS, true, this.oid) : crypto.sign(this.privKeyLabel, messageDigest, 0, messageDigest.length, Crypto.Algorithm.RSAPSS, true, this.oid);
        }
        catch (JCECCARuntimeException e) {
            if (e.getReturnCode() == 8 && e.getReasonCode() == 48 && this.privExtKeyToken != null && this.privKeyLabel.length > 64) {
                KeyPairUtils util = new KeyPairUtils();
                this.cachePrivKeyToken = util.importExternalToken(this.privExtKeyToken, KeyPairUtils.KeyPairAlgorithm.RSA);
                result = crypto.sign(this.cachePrivKeyToken, messageDigest, 0, messageDigest.length, Crypto.Algorithm.RSAPSS, true, this.oid);
            }
            throw new SignatureException(e.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineSign", result);
        }
        return result;
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineVerify", (Object)signature);
        }
        byte[] digest = this.dataSHA.digest();
        byte[] saltLenArray = new byte[]{(byte)(this.saltlen >>> 24), (byte)(this.saltlen >>> 16), (byte)(this.saltlen >>> 8), (byte)this.saltlen};
        byte[] messageDigest = new byte[digest.length + 4];
        System.arraycopy(saltLenArray, 0, messageDigest, 0, 4);
        System.arraycopy(digest, 0, messageDigest, 4, digest.length);
        Crypto crypto = new Crypto();
        boolean result = crypto.verify(this.pubKeyToken, messageDigest, 0, messageDigest.length, signature, 0, signature.length, Crypto.Algorithm.RSAPSS, true, this.oid);
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineVerify", "PublicToken " + this.pubKeyToken.toString());
            debug.text(Debug.TYPE_PUBLIC, className, "engineVerify", "PublicToken length" + this.pubKeyToken.length);
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineVerify", result);
        }
        return result;
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineSetParameter", param, value);
            debug.text(Debug.TYPE_PUBLIC, className, "engineSetParameter", "engineSetParameter has no meaning in hardware");
        }
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetParameter", param);
            debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameter", "engineGetParameter has no meaning in hardware");
        }
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        String mgfMessageDigest;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetParameter", params);
        }
        if (!(params instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.pssParameterSpec = this.validateSigParams(params);
        MGF1ParameterSpec mgf1ParamSpec = (MGF1ParameterSpec)this.pssParameterSpec.getMGFParameters();
        String messageDigest = this.pssParameterSpec.getDigestAlgorithm();
        if (messageDigest != null && mgf1ParamSpec != null && (mgfMessageDigest = mgf1ParamSpec.getDigestAlgorithm()) != null) {
            boolean throwException = true;
            if (messageDigest.equalsIgnoreCase("SHA1") || messageDigest.equalsIgnoreCase("SHA-1") || messageDigest.equalsIgnoreCase("SHA")) {
                if (mgfMessageDigest.equalsIgnoreCase("SHA1") || mgfMessageDigest.equalsIgnoreCase("SHA-1") || mgfMessageDigest.equalsIgnoreCase("SHA")) {
                    throwException = false;
                }
            } else if (messageDigest.equalsIgnoreCase("SHA224") || messageDigest.equalsIgnoreCase("SHA-224")) {
                if (mgfMessageDigest.equalsIgnoreCase("SHA224") || mgfMessageDigest.equalsIgnoreCase("SHA-224")) {
                    throwException = false;
                }
            } else if (messageDigest.equalsIgnoreCase("SHA256") || messageDigest.equalsIgnoreCase("SHA-256") || messageDigest.equalsIgnoreCase("SHA2")) {
                if (mgfMessageDigest.equalsIgnoreCase("SHA256") || mgfMessageDigest.equalsIgnoreCase("SHA-256") || mgfMessageDigest.equalsIgnoreCase("SHA2")) {
                    throwException = false;
                }
            } else if (messageDigest.equalsIgnoreCase("SHA384") || messageDigest.equalsIgnoreCase("SHA-384") || messageDigest.equalsIgnoreCase("SHA3")) {
                if (mgfMessageDigest.equalsIgnoreCase("SHA384") || mgfMessageDigest.equalsIgnoreCase("SHA-384") || mgfMessageDigest.equalsIgnoreCase("SHA3")) {
                    throwException = false;
                }
            } else if (messageDigest.equalsIgnoreCase("SHA512") || messageDigest.equalsIgnoreCase("SHA-512") || messageDigest.equalsIgnoreCase("SHA5")) {
                if (mgfMessageDigest.equalsIgnoreCase("SHA512") || mgfMessageDigest.equalsIgnoreCase("SHA-512") || mgfMessageDigest.equalsIgnoreCase("SHA5")) {
                    throwException = false;
                }
            } else if (messageDigest.equalsIgnoreCase("SHA512/224") || messageDigest.equalsIgnoreCase("SHA-512/224")) {
                if (mgfMessageDigest.equalsIgnoreCase("SHA512/224") || mgfMessageDigest.equalsIgnoreCase("SHA-512/224")) {
                    throwException = false;
                }
            } else if ((messageDigest.equalsIgnoreCase("SHA512/256") || messageDigest.equalsIgnoreCase("SHA-512/256")) && (mgfMessageDigest.equalsIgnoreCase("SHA512/256") || mgfMessageDigest.equalsIgnoreCase("SHA-512/256"))) {
                throwException = false;
            }
            if (throwException) {
                throw new InvalidAlgorithmParameterException("The message digest within the PSSParameterSpec does not match the MGF message digest.");
            }
        }
        this.msgDigestName = this.pssParameterSpec.getDigestAlgorithm();
        this.saltlen = this.pssParameterSpec.getSaltLength();
        this.trailerField = this.pssParameterSpec.getTrailerField();
        this.mgfName = this.pssParameterSpec.getMGFAlgorithm();
        this.mgf1SpecAlgo = mgf1ParamSpec.getDigestAlgorithm();
        try {
            this.dataSHA = Security.getProvider("IBMJCECCA") == null ? (Security.getProvider("IBMJCE4758") == null ? MessageDigest.getInstance(this.msgDigestName, "IBMJCA4758") : MessageDigest.getInstance(this.msgDigestName, "IBMJCE4758")) : MessageDigest.getInstance(this.msgDigestName, "IBMJCECCA");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new InvalidAlgorithmParameterException(e);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineSetParameter");
        }
    }

    @Override
    protected AlgorithmParameters engineGetParameters() throws InvalidParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetParameters");
        }
        AlgorithmParameters params = null;
        if (this.pssParameterSpec == null) {
            return null;
        }
        try {
            params = AlgorithmParameters.getInstance("RSASSA-PSS", "IBMJCECCA");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ProviderException(e);
        }
        try {
            params.init(this.pssParameterSpec);
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("PSSParameterSpec not supported " + ipse.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameters", params);
        }
        return params;
    }

    private PSSParameterSpec validateSigParams(AlgorithmParameterSpec p) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "validateSigParams", p);
        }
        if (p == null) {
            throw new InvalidAlgorithmParameterException("Parameters cannot be null");
        }
        if (!(p instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameters must be type PSSParameterSpec");
        }
        PSSParameterSpec params = (PSSParameterSpec)p;
        if (params == this.pssParameterSpec) {
            return params;
        }
        Key key = null;
        key = this.privateKey == null ? this.publicKey : this.privateKey;
        if (!(key == null || key instanceof RSAPrivateHWKey || key instanceof RSAPublicKey || RSAPSSSignature.isCompatible(key.getParams(), params))) {
            throw new InvalidAlgorithmParameterException("Signature parameters does not match key parameters");
        }
        if (!params.getMGFAlgorithm().equalsIgnoreCase("MGF1")) {
            throw new InvalidAlgorithmParameterException("Only supports MGF1");
        }
        if (params.getTrailerField() != 1) {
            throw new InvalidAlgorithmParameterException("Only supports TrailerFieldBC(1)");
        }
        String digestAlgo = params.getDigestAlgorithm();
        Integer hLen = DIGEST_LENGTHS.get(digestAlgo);
        if (hLen == null) {
            throw new InvalidAlgorithmParameterException("Unsupported digest algo: " + digestAlgo);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "validateSigParams", params);
        }
        return params;
    }

    private void ensureInit() throws SignatureException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "ensureInit");
        }
        Key key = null;
        key = this.privateKey == null ? this.publicKey : this.privateKey;
        if (key == null) {
            throw new SignatureException("Missing key");
        }
        if (this.pssParameterSpec == null) {
            throw new SignatureException("Parameters required for RSASSA-PSS signatures");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "ensureInit");
        }
    }

    private void checkKeyIsValid(RSAKey rsaKey) throws InvalidKeyException {
        Integer hLen;
        if (rsaKey instanceof RSAPrivateHWKey || rsaKey instanceof RSAPublicKey) {
            return;
        }
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "checkKeyIsValid", rsaKey);
        }
        if (!RSAPSSSignature.isCompatible(rsaKey.getParams(), this.pssParameterSpec)) {
            throw new InvalidKeyException("Key contains incompatible PSS parameter values");
        }
        if (this.pssParameterSpec != null && (hLen = DIGEST_LENGTHS.get(this.pssParameterSpec.getDigestAlgorithm())) == null) {
            throw new InvalidKeyException("Unsupported digest algo: " + this.pssParameterSpec.getDigestAlgorithm());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "checkKeyIsValid");
        }
    }

    private static boolean isCompatible(AlgorithmParameterSpec keyParams, PSSParameterSpec sigParams) {
        if (debug != null) {
            Object[] parms = new Object[]{keyParams, sigParams};
            debug.entry(Debug.TYPE_FINE, (Object)className, "isCompatible", parms);
        }
        if (keyParams == null) {
            return true;
        }
        if (!(keyParams instanceof PSSParameterSpec)) {
            return false;
        }
        if (sigParams == null) {
            return true;
        }
        PSSParameterSpec pssKeyParams = (PSSParameterSpec)keyParams;
        if (pssKeyParams.getSaltLength() > sigParams.getSaltLength()) {
            return false;
        }
        PSSParameterSpec keyParams2 = new PSSParameterSpec(pssKeyParams.getDigestAlgorithm(), pssKeyParams.getMGFAlgorithm(), pssKeyParams.getMGFParameters(), sigParams.getSaltLength(), pssKeyParams.getTrailerField());
        PSSParameters ap = new PSSParameters();
        try {
            ap.engineInit(keyParams2);
            byte[] encoded = ap.engineGetEncoded();
            ap.engineInit(sigParams);
            byte[] encoded2 = ap.engineGetEncoded();
            boolean result = Arrays.equals(encoded, encoded2);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "isCompatible", result);
            }
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        DIGEST_LENGTHS.put("SHA-1", 20);
        DIGEST_LENGTHS.put("SHA", 20);
        DIGEST_LENGTHS.put("SHA1", 20);
        DIGEST_LENGTHS.put("SHA-224", 28);
        DIGEST_LENGTHS.put("SHA224", 28);
        DIGEST_LENGTHS.put("SHA-256", 32);
        DIGEST_LENGTHS.put("SHA256", 32);
        DIGEST_LENGTHS.put("SHA-384", 48);
        DIGEST_LENGTHS.put("SHA384", 48);
        DIGEST_LENGTHS.put("SHA-512", 64);
        DIGEST_LENGTHS.put("SHA512", 64);
        DIGEST_LENGTHS.put("MD5", 16);
        DIGEST_LENGTHS.put("SHA-512/224", 28);
        DIGEST_LENGTHS.put("SHA512/224", 28);
        DIGEST_LENGTHS.put("SHA-512/256", 32);
        DIGEST_LENGTHS.put("SHA512/256", 32);
    }
}

