/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyParameterSpec;
import com.ibm.security.rsa.RSAUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class RSAKeyPairGenerator
extends KeyPairGenerator {
    private int modlen = 1024;
    SecureRandom random = null;
    private RSAKeyHWAttributes keyAttribs = null;
    private byte[] keyLabel;
    private boolean support4096 = false;
    private int maxModulusLength = 2048;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.RSAKeyPairGenerator";
    private KeyPairUtils.KeyPairAlgorithm keyPairAlgorithm;

    public RSAKeyPairGenerator() {
        this(RSAUtil.KeyType.RSA);
    }

    public RSAKeyPairGenerator(RSAUtil.KeyType type) {
        super(type.keyAlgo());
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "RSAKeyPairGenerator");
        }
        this.support4096 = HardwareProfile.getIs4096RNGLSupported();
        if (this.support4096) {
            this.maxModulusLength = 4096;
        }
        this.keyPairAlgorithm = type == RSAUtil.KeyType.PSS ? KeyPairUtils.KeyPairAlgorithm.RSAPSS : KeyPairUtils.KeyPairAlgorithm.RSA;
        if (debug != null) {
            String info = new String(HardwareProfile.getICSFlevel() + ": 4096RNGLSupported = " + this.support4096);
            debug.exit(Debug.TYPE_FINE, (Object)className, "RSAKeyPairGenerator", info);
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "initialize", params, random);
        }
        if (!(params instanceof RSAKeyParameterSpec)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initialize", "Invalid AlgorithmParameterSpec. RSAKeyParameterSpec expected");
            }
            throw new InvalidAlgorithmParameterException("Invalid AlgorithmParameterSpec. RSAKeyParameterSpec expected.");
        }
        this.keyAttribs = ((RSAKeyParameterSpec)params).getAttributes();
        this.modlen = ((RSAKeyParameterSpec)params).getKeySize();
        if (this.modlen < 512) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initialize", "Modulus size must be at least 512");
            }
            throw new InvalidParameterException("Modulus size must be at least 512");
        }
        if (this.modlen > this.maxModulusLength) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initialize", "Modulus size cannot exceed " + this.maxModulusLength);
            }
            throw new IllegalArgumentException("Modulus size cannot exceed " + this.maxModulusLength);
        }
        if (this.modlen % 8 != 0) {
            throw new InvalidAlgorithmParameterException("Modulus size must be multiple of 8");
        }
        String myLabel = ((RSAKeyParameterSpec)params).getLabelString();
        this.keyLabel = (byte[])(myLabel != null ? myLabel.getBytes(PlatformUtilities.CHARSET_ISO_8859_1) : null);
        this.random = random;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "initialize");
        }
    }

    @Override
    public void initialize(int strength, SecureRandom random) throws InvalidParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "initialize", strength, random);
        }
        if (strength < 512) {
            throw new InvalidParameterException("Modulus size must be at least 512");
        }
        if (strength > this.maxModulusLength) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initialize", "Modulus size cannot exceed " + this.maxModulusLength);
            }
            throw new InvalidParameterException("Modulus size for hardware key generation cannot exceed " + this.maxModulusLength);
        }
        if (strength % 8 != 0) {
            throw new InvalidParameterException("Modulus size must be multiple of 8");
        }
        this.keyAttribs = new RSAKeyHWAttributes(2, 4);
        this.modlen = strength;
        this.keyLabel = null;
        this.random = random;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "initialize");
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "generateKeyPair");
        }
        KeyPairUtils util = new KeyPairUtils();
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (this.keyAttribs == null) {
            this.keyAttribs = new RSAKeyHWAttributes(2, 4);
        }
        util.initializeRSA(this.modlen, this.random, this.keyAttribs, this.keyLabel, this.keyPairAlgorithm);
        byte[] token = util.generateToken(null);
        byte[] label = util.generateKeysFromSkeletonToken(token);
        KeyPair result = util.generateKeyPairFromInternalToken(label);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "generateKeyPair", result);
        }
        return result;
    }

    public static final class PSS
    extends RSAKeyPairGenerator {
        public PSS() {
            super(RSAUtil.KeyType.PSS);
        }
    }
}

